<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" indent="yes"/>


<!--  screen.xsl  Display Reflection Screen as HTML -->



<xsl:template match="/">
	<HTML>
		<HEAD>
 			<TITLE>Reflection Terminal Screen</TITLE>
		</HEAD>
		<BODY>
			<P><H2>Reflection Terminal Screen</H2></P>
			<P/>
			<xsl:apply-templates/>
		</BODY>
	</HTML>
</xsl:template>


 

<xsl:template match="SCREEN" >
	<xsl:variable name = "statuslines" select = "count(STATUS_LINE)"/>
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(TEXT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(TEXT)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "(/REFLECTION_SETTINGS/TYPE/@mode = 'All' and /REFLECTION_SETTINGS/TYPE = 'SETTINGS')
					and (count(/REFLECTION_SETTINGS/SCREEN/TEXT) &gt; 0)">
		<!--    -->
	</xsl:if>


	<xsl:if test="(count(TEXT) + count(STATUS_LINE)) &gt; 0">
	   	<PRE>
		<xsl:apply-templates select="TEXT"/>
		<xsl:if test = "$statuslines &gt; 0">
			<xsl:call-template name = "lineBreak"/>
			<xsl:if test = "count(TEXT) &gt; 0">
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>
			<xsl:choose>
				<xsl:when test = "$statuslines &lt; 2">
					<I><xsl:text>Status Line</xsl:text></I>
				</xsl:when>
				<xsl:otherwise>
					<I><xsl:text>Status Lines</xsl:text></I>
				</xsl:otherwise>
			</xsl:choose>
			<BR/>
		</xsl:if>
		<xsl:apply-templates select="STATUS_LINE"/>
		</PRE>
	</xsl:if>
</xsl:template>

<xsl:template match="TEXT" >

	<xsl:if test="count(OFFSCREEN) = 0">
		<!--   only handle lines of display memory that are displayed on the screen    -->

		<xsl:variable name = "current_line">
			<xsl:value-of select="@row"/>
		</xsl:variable>
	
		<xsl:variable name = "next_line">
			<xsl:value-of select="following-sibling::node()/@row"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="count(INVERSE) > 0">
<!--
				<SPAN style="background-color:black; color:white">
		 			<xsl:value-of select="DATA"/>
				</SPAN>
-->
				<xsl:value-of select="DATA"/>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="DATA"/>	
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="$next_line > $current_line ">
			<xsl:call-template name  = "BLANK_ROWS">
				<xsl:with-param name = "current_row"><xsl:value-of select="$current_line"/></xsl:with-param>
				<xsl:with-param name = "next_row"><xsl:value-of select="$next_line"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:if>
</xsl:template>

<xsl:template name="BLANK_ROWS" >

	<xsl:param name = "current_row"/>
	<xsl:param name = "next_row"/>

	<xsl:if test="$current_row &lt; $next_row">
		<!--      output line break         -->
		<BR/>
		<xsl:call-template name = "BLANK_ROWS">
			<xsl:with-param name = "current_row"><xsl:value-of select="$current_row + 1"/></xsl:with-param>
			<xsl:with-param name = "next_row"><xsl:value-of select="$next_row"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template match="STATUS_LINE">
	<xsl:value-of select = "."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>



<xsl:template match="text()|@*"/>


</xsl:stylesheet>

