<?xml version="1.0"?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!--
<xsl:output method="text" indent="no" standalone = "yes" encoding = "iso-8859-1"/>
-->
<xsl:output method="text" indent="no" standalone = "yes" encoding = "UTF-16"/>


<!--  text.xsl  Write Changed Settings to Text File  -->



<xsl:variable name="colorNames">
	<COLOR value = "0x00ffff" 	name = "Aqua"/>
	<COLOR value = "0xf0ffff" 	name = "Azure"/>
	<COLOR value = "0xf5f5dc" 	name = "Beige"/>
	<COLOR value = "0x0" 		name = "Black"/>
	<COLOR value = "0x0000ff"	name = "Blue"/>
	<COLOR value = "0xa52a2a" 	name = "Brown"/>
	<COLOR value = "0x7fff00" 	name = "Chartreuse"/>
	<COLOR value = "0xff7f50" 	name = "Coral"/>
	<COLOR value = "0xdc143c" 	name = "Crimson"/>
	<COLOR value = "0x00ffff" 	name = "Cyan"/>
	<COLOR value = "0x00008b" 	name = "Darkblue"/>
	<COLOR value = "0x006400" 	name = "Darkgreen"/>
	<COLOR value = "0xa9a9a9" 	name = "Darkgrey"/>
	<COLOR value = "0x8b008b" 	name = "Darkmagenta"/>
	<COLOR value = "0x8b0000" 	name = "Darkred"/>
	<COLOR value = "0x9400d3" 	name = "Darkviolet"/>
	<COLOR value = "0x808000" 	name = "Darkyellow"/>
	<COLOR value = "0xff00ff" 	name = "Fuchsia"/>
	<COLOR value = "0x808080" 	name = "Gray"/>
	<COLOR value = "0x008000" 	name = "Green"/>
	<COLOR value = "0xfffff0" 	name = "Ivory"/>
	<COLOR value = "0xadd8e6" 	name = "Lightblue"/>
	<COLOR value = "0x00ff00" 	name = "Lime"/>
	<COLOR value = "0x32cd32" 	name = "Limegreen"/>
	<COLOR value = "0x800000" 	name = "Maroon"/>
	<COLOR value = "0x191970" 	name = "Midnightblue"/>
	<COLOR value = "0x000080"	name = "Navy"/>
	<COLOR value = "0x808000" 	name = "Olive"/>
	<COLOR value = "0xffa500" 	name = "Orange"/>
	<COLOR value = "0x800080" 	name = "Purple"/>
	<COLOR value = "0xff0000" 	name = "Red"/>
	<COLOR value = "0xc0c0c0" 	name = "Silver"/>
	<COLOR value = "0xd2b48c" 	name = "Tan"/>
	<COLOR value = "0x008080" 	name = "Teal"/>
	<COLOR value = "0x40e0d0" 	name = "Turquoise"/>
	<COLOR value = "0xee82ee" 	name = "Violet"/>
	<COLOR value = "0xffffff" 	name = "White"/>
	<COLOR value = "0xffff00" 	name = "Yellow"/>
	<COLOR value = "0x6e6e6e" 	name = "ReflectionGrey"/>
 </xsl:variable>









<xsl:template match="/">
	<xsl:variable name = "exportMode">
		<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
	</xsl:variable>
	<xsl:variable name = "XMLversion">
		<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
	</xsl:variable>

	<xsl:if test = "$XMLversion &gt; '1'">
		<!-- this transform requires exported XML version 2 or greater -->
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>Reflection </xsl:text>
		<xsl:if test = "($exportMode = 'Changed') or ($exportMode = 'Filtered')">
			<xsl:value-of select = "$exportMode"/>
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:text>Settings</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates/>
	</xsl:if>

	<xsl:if test = "$XMLversion = '1'">
		<xsl:call-template name = "creator"/>
		<xsl:call-template name = "OldSourceXML"/>
	</xsl:if>
</xsl:template>


<xsl:template match="CREATOR" name = "creator">
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@product"/> 
	<xsl:text> version </xsl:text> 
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@version"/> 
	<xsl:text> build </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/CREATOR/@build"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>XML settings format </xsl:text>
	<xsl:value-of select = "/REFLECTION_SETTINGS/@version"/>
	<xsl:text>   (</xsl:text>
	<xsl:value-of select = "/REFLECTION_SETTINGS/TYPE/@mode"/>
	<xsl:text> </xsl:text>
	<xsl:value-of select="/REFLECTION_SETTINGS/TYPE"/>
	<xsl:text>)</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template match="PROPERTIES" >
	<xsl:variable name = "count">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="$count > 0">
			<xsl:value-of select="COUNT"/> 
			<xsl:if test = "/REFLECTION_SETTINGS/TYPE[@mode = 'Changed']">
				<xsl:text> Changed</xsl:text>
			</xsl:if>
			<xsl:text> Propert</xsl:text>
			<xsl:choose>
				<xsl:when test="$count > 1">
					<xsl:text>ies</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>y</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>PROPERTY</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="37"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>VALUE</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:text>________</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="37"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>_____</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="PROPERTY">
			<xsl:sort select="@name"/>
			</xsl:apply-templates>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>All Properties are at defaults</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROPERTY">
	<xsl:variable name = "namelgth">
		<xsl:value-of select="string-length(@name)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$namelgth &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$namelgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:value-of select="@name"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
  	<xsl:call-template name="PROPERTY_TYPE"/>
</xsl:template>

<xsl:template name="PROPERTY_TYPE">
	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<xsl:value-of select="BOOLEAN"/>
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<xsl:value-of select="INTEGER"/>
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<xsl:value-of select="ENUMERATION"/>
		</xsl:when>
		<xsl:when test = "count(CHARACTER) &gt; 0">
			<xsl:choose>
			   <xsl:when test = "count(CHARACTER/@ctrl) &gt; 0">
					<xsl:value-of select="CHARACTER/@ctrl"/>
			   </xsl:when>
				<xsl:when test = "CHARACTER=''">
					<xsl:text>(not set)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="CHARACTER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
			<xsl:choose>
				<xsl:when test = "STRING=''">
					<xsl:text>(empty string)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="STRING"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:when test = "count(FOLDER) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FOLDER=''">
					<xsl:text>(empty folder name)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FOLDER"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test = "count(FILE) &gt; 0">
			<xsl:choose>
				<xsl:when test = "FILE=''">
					<xsl:text>(empty filename)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="FILE"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>

		<xsl:otherwise>
			<xsl:text>unknown type</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template match="CONNECTION" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(CONNECTION_SETTING)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "namelgth">
		<xsl:value-of select="string-length(@name)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$namelgth &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$namelgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="$count > 0">
			<xsl:value-of select="$count"/> 
			<xsl:if test = "/REFLECTION_SETTINGS/TYPE[@mode = 'Changed']">
				<xsl:text> Changed</xsl:text>
			</xsl:if>
			<xsl:text> Connection Setting</xsl:text>
			<xsl:if  test="$count > 1">
				<xsl:text>s</xsl:text>
			</xsl:if>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>CONNECTION SETTING</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="27"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>VALUE</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:text>__________________</xsl:text>
			<xsl:call-template name = "Spaces">
				<xsl:with-param name = "count"><xsl:value-of select="27"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>_____</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="CONNECTION_SETTING">
				<xsl:sort select="@name"/>
			</xsl:apply-templates>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>All Connection Settings are at defaults</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if  test="$count > 0">
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="CONNECTION_SETTING">
	<xsl:variable name = "namelgth">
		<xsl:value-of select="string-length(@name)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$namelgth &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$namelgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:value-of select="@name"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:call-template name="PROPERTY_TYPE"/>
</xsl:template>


<xsl:template match="KEYMAP" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0	</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="$count = 0">
	   		<xsl:text>Default Key Map</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="COUNT"/><xsl:text> Key Mapping</xsl:text>
			<xsl:if  test="$count > 1">
				<xsl:text>s</xsl:text>
			</xsl:if>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>KEYSTROKE                                    MAPPING</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>_________                                    _______</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="KEY_MAPPING"/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="KEY_MAPPING">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "keystrokeLen">
		<xsl:value-of select="string-length(KEYSTROKE)"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$keystrokeLen &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$keystrokeLen"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="KEYSTROKE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="MOUSEMAP" >
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0	</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="$count = 0">
			<xsl:call-template name = "lineBreak"/>
	   		<xsl:text>Default Mouse Map</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "lineBreak"/>
			<xsl:value-of select="COUNT"/><xsl:text> Mouse Mapping</xsl:text>
			<xsl:if  test="$count > 1">
				<xsl:text>s</xsl:text>
			</xsl:if>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>MOUSESTROKE                                  MAPPING</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>___________                                  _______</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="MOUSE_MAPPING"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="MOUSE_MAPPING">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_MAPPING) &gt; 0">
				<xsl:value-of select="LOC_MAPPING"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MAPPING"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "keystrokeLen">
		<xsl:value-of select="string-length(MOUSECHORD)"/>
	</xsl:variable>

	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$keystrokeLen &gt; 45">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="45-$keystrokeLen"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="MOUSECHORD"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "lineBreak"/>

</xsl:template>



<xsl:template match="EVENTS">
  	<xsl:variable name = "eventCount">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if test="count(DEFAULTS) = 1">
   		<xsl:text>Events are at Defaults</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>

	<xsl:if test="count(COUNT) = 1">
		<xsl:choose>
			<xsl:when test="$eventCount > 0">
				<xsl:if test="count(DEFAULTS) = 0">
					<xsl:call-template name = "lineBreak"/>
			    </xsl:if>
				<xsl:if test="$eventCount = 1">
					<xsl:value-of select="COUNT"/><xsl:text> Event</xsl:text>
				</xsl:if>
				<xsl:if test="$eventCount > 1">
					<xsl:value-of select="COUNT"/><xsl:text> Events</xsl:text>
		  		</xsl:if>
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "lineBreak"/>

				<xsl:text>EVENT	</xsl:text>
				<xsl:call-template name = "Spaces">
					<xsl:with-param name = "count"><xsl:value-of select="30"/></xsl:with-param>
				</xsl:call-template>

				<xsl:text>TYPE </xsl:text>
				<xsl:call-template name = "Spaces">
					<xsl:with-param name = "count"><xsl:value-of select="5"/></xsl:with-param>
				</xsl:call-template>

				<xsl:text>DEFAULT</xsl:text>
				<xsl:call-template name = "Spaces">
					<xsl:with-param name = "count"><xsl:value-of select="2"/></xsl:with-param>
				</xsl:call-template>

				<xsl:text>ENABLED</xsl:text>
				<xsl:call-template name = "Spaces">
					<xsl:with-param name = "count"><xsl:value-of select="2"/></xsl:with-param>
				</xsl:call-template>

				<xsl:text>ACTION</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:text>_____	                            ________    _______  _______  ______</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "lineBreak"/>

				<xsl:apply-templates select="EVENT"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>There are no Events defined</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "lineBreak"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template match="EVENT">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="EVENT_TYPE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="5"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="COMMAND_TYPE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="5"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="DEFAULT_EVENT"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="5"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="EVENT_ENABLED"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="5"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="MENUS/MAIN_MENU" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	
	<xsl:text>Main Menu</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
</xsl:template>

<xsl:template match="MENUS/CONTEXT_MENU" >
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Context Menu</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
</xsl:template>

<xsl:template match="POPUP">
	<xsl:if test = "count(ancestor::node()) = '4'">
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>

	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "count(ancestor::node()) - 4"/>
	</xsl:call-template>

	<xsl:value-of select="@name"/>
	<xsl:call-template name = "lineBreak"/>
 	<xsl:apply-templates select="POPUP|ITEM|SEPARATOR"/>
</xsl:template>


<xsl:template match="ITEM">
	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "count(ancestor::node()) - 4"/>
	</xsl:call-template>

	<xsl:value-of select="@menu_item"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="SEPARATOR">
	<xsl:call-template name = "tabs">
		<xsl:with-param name = "tabcount" select = "count(ancestor::node()) - 4"/>
	</xsl:call-template>
	<xsl:text>--------------</xsl:text>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>




<xsl:template match="TABS">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if test = "$count &gt; 0">
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
			<xsl:text>Default Tabstops</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>Tabstops</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="TABSTOPS"/>
			<xsl:apply-templates select="HP_VTMODE_TABSTOPS"/>
			<xsl:apply-templates select="HP_HPMODE_TABSTOPS"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TABSTOPS" >
  	<xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<xsl:text>No tabs set</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="HP_VTMODE_TABSTOPS" >
	<xsl:text>VT Mode Tab Stops</xsl:text>
	<xsl:call-template name = "lineBreak"/>
  	<xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<xsl:text>No tabs set</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="HP_HPMODE_TABSTOPS" >
	<xsl:text>HP Mode Tab Stops</xsl:text>
	<xsl:call-template name = "lineBreak"/>
 	<xsl:choose>
		<xsl:when test="count(TAB|TABSTOP_LIST|TABS_EVERY_N) = 0">
		   	<xsl:text>No tabs set</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="TAB|TABSTOP_LIST|TABS_EVERY_N"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="TAB">
	<xsl:text>Tab stop in column </xsl:text>
	<xsl:value-of select="."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="TABSTOP_LIST">
	<xsl:text>Tab stops in columns </xsl:text>
	<xsl:value-of select="."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="TABS_EVERY_N">
	<xsl:text>Tabs every </xsl:text>
	<xsl:value-of select="."/>
	<xsl:text> columns</xsl:text>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="WINDOW">
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
			<xsl:text>Default Window Size and Position</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Terminal Window</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			 <xsl:text>State               </xsl:text>
			 <xsl:text>Position             </xsl:text>
			 <xsl:text>Size</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="WINDOW_STATE"/>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="WINDOW_STATE">
	    <xsl:value-of select="."/>
		<xsl:text>        </xsl:text>
		<xsl:text>(</xsl:text>
		<xsl:value-of select="../WP_LEFT_X"/>
		<xsl:text>,</xsl:text>
		<xsl:value-of select="../WP_LEFT_Y"/>
		<xsl:text>) x (</xsl:text>
		<xsl:value-of select="../WP_RIGHT_X"/>
		<xsl:text>,</xsl:text>
		<xsl:value-of select="../WP_RIGHT_Y"/>
		<xsl:text>)</xsl:text>
	    <xsl:text>     </xsl:text>
		<xsl:value-of select="../WP_RIGHT_X - ../WP_LEFT_X"/>
	    <xsl:text> x </xsl:text>
		<xsl:value-of select="../WP_RIGHT_Y - ../WP_LEFT_Y"/>
</xsl:template>


<xsl:template match="COLORS">
	<xsl:call-template name = "lineBreak"/>

	<xsl:choose>
		<xsl:when test="count(COLOR_PALETTE) = 0">
			<xsl:text>Colors are at Defaults</xsl:text>
			<xsl:call-template name = "lineBreak"/>
	    </xsl:when>
   		<xsl:otherwise>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>Colors</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="COLOR_PALETTE"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="COLOR_ATTRIBUTES"/>
			<xsl:apply-templates select="COLOR_OPTIONS"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="COLOR_PALETTE">
	<xsl:call-template name = "lineBreak"/>
	
	<xsl:text>Color Palette</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Index     Color          Color Name</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>_____     _____          __________</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:apply-templates select="COLOR"/>
</xsl:template>

<xsl:template match="COLOR">
	<xsl:variable name = "colors" select = "$colorNames"/>
	<xsl:variable name = "index"  select = "@index"/>
	<xsl:variable name = "numcolorlgth">
		<xsl:value-of select="string-length(current())"/>
	</xsl:variable>
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test="$numcolorlgth &gt; 15">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="15-$numcolorlgth"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "$index &lt; 10">
		<xsl:text> </xsl:text>
	</xsl:if>
	<xsl:value-of select="@index"/>
	<xsl:text>        </xsl:text>
	<xsl:value-of select="."/>

	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>

	<xsl:variable name = "colorname" select = "$colors/COLOR[@value = current()]/@name"/>
	<xsl:value-of select = "$colorname"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="BACKGROUND/COLOR">
	<xsl:variable name = "colors" select = "$colorNames"/>
	<xsl:variable name = "colorname" select = "$colors/COLOR[@value = current()]/@colorName"/>
	<xsl:value-of select = "$colorname"/>
</xsl:template>

<xsl:template match="FOREGROUND/COLOR">
	<xsl:variable name = "colors" select = "$colorNames"/>
	<xsl:variable name = "colorname" select = "$colors/COLOR[@value = current()]/@colorName"/>
	<xsl:value-of select = "$colorname"/>
</xsl:template>

<xsl:template match="COLOR_OPTIONS">
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Color Options</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>OPTION               VALUE</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>______               _____</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
 	<xsl:apply-templates select="COLOR_OPTION"/>
</xsl:template>


<xsl:template match="COLOR_OPTION">
	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test = "string-length(current()/@name) &gt; 22">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="22 - string-length(current()/@name)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="@name"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>
	<xsl:value-of select="BOOLEAN"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="COLOR_ATTRIBUTES">
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Color Attributes</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="50"/></xsl:with-param>
	</xsl:call-template>
	<xsl:text>Background           Foreground</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Attributes</xsl:text>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="38"/></xsl:with-param>
	</xsl:call-template>
	<xsl:text>Index    Color       Index    Color</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>__________</xsl:text>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="38"/></xsl:with-param>
	</xsl:call-template>
	<xsl:text>_______________      ______________</xsl:text>
	<xsl:call-template name = "lineBreak"/>
 	<xsl:call-template name = "lineBreak"/>

	<xsl:apply-templates select="COLOR_ATTRIBUTE"/>
</xsl:template>



<xsl:template match="COLOR_ATTRIBUTE">
	<xsl:variable name = "colors" select = "$colorNames"/>
	<xsl:variable name = "colorname" select = "$colors/COLOR[@value = current()/BACKGROUND/COLOR]/@name"/>
	<xsl:variable name = "bcolor">
		<xsl:choose>
			<xsl:when test = "$colorname">
				<xsl:value-of select="$colorname"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="BACKGROUND/COLOR"/>
			</xsl:otherwise>
		</xsl:choose>
	 </xsl:variable>

	<xsl:variable name = "padding">
		<xsl:choose>
			<xsl:when test = "string-length(current()/@name) &gt; 48">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="48 - string-length(current()/@name)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "spacing">
		<xsl:choose>
			<xsl:when test = "string-length($bcolor) &gt; 16">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="16 - string-length($bcolor)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="@name"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$padding"/></xsl:with-param>
	</xsl:call-template>

	<xsl:choose>
		<xsl:when test = "count(BACKGROUND/COLOR/@index)=0">
			<xsl:text>  </xsl:text>
			<xsl:apply-templates select="BACKGROUND/COLOR"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name = "index"  select = "BACKGROUND/COLOR/@index"/>
			<xsl:if test = "$index &lt; 10">
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:value-of select="$index"/>
		</xsl:otherwise>
	</xsl:choose>

 	<xsl:text>   </xsl:text>

	<xsl:choose>
		<xsl:when test = "$bcolor">
			<td align="center"><xsl:value-of select="$bcolor"/></td>
		</xsl:when>
		<xsl:otherwise>
			<td align="center"><xsl:value-of select="BACKGROUND/COLOR"/></td>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count"><xsl:value-of select="$spacing"/></xsl:with-param>
	</xsl:call-template>

	<xsl:choose>
		<xsl:when test = "count(FOREGROUND/COLOR/@index)=0">
			<xsl:text>  </xsl:text>
			<xsl:apply-templates select="FOREGROUND/COLOR"/>	
		</xsl:when>
		<xsl:otherwise>
		<xsl:variable name = "index"  select = "FOREGROUND/COLOR/@index"/>
			<xsl:if test = "$index &lt; 10">
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:value-of select="$index"/>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>   </xsl:text>

	<xsl:variable name = "fgcolor" select = "$colors/COLOR[@value = current()/FOREGROUND/COLOR]/@name"/>
	<xsl:choose>
		<xsl:when test = "$fgcolor">
			<td align="center"><xsl:value-of select="$fgcolor"/></td>
		</xsl:when>
		<xsl:otherwise>
			<td align="center"><xsl:value-of select="FOREGROUND/COLOR"/></td>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:call-template name = "lineBreak"/>
</xsl:template>


 
<xsl:template match="DISABLED" >
	<xsl:variable name = "cmd_count">
		<xsl:value-of select="DISABLED_COMMANDS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "set_count">
		<xsl:value-of select="DISABLED_SETTINGS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "feat_count">
		<xsl:value-of select="DISABLED_FEATURES/COUNT"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
	   		<xsl:text>Nothing Disabled</xsl:text>
			<xsl:call-template name = "lineBreak"/>

		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Disabled List</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>Disabled Commands </xsl:text><xsl:value-of select="DISABLED_COMMANDS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="DISABLED_COMMANDS"/>
			<xsl:text>Disabled Settings </xsl:text><xsl:value-of select="DISABLED_SETTINGS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>

			<xsl:apply-templates select="DISABLED_SETTINGS"/>
			<xsl:text>Disabled Features </xsl:text><xsl:value-of select="DISABLED_FEATURES/COUNT"/>

			<xsl:apply-templates select="DISABLED_FEATURES"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="DISABLED_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="DISABLED_COMMAND">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="DISABLED_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="DISABLED_SETTING">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="DISABLED_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="DISABLED_FEATURE">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>


<xsl:template match="PROFILED" >

	<xsl:variable name = "cmd_count">
		<xsl:value-of select="PROFILED_COMMANDS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "set_count">
		<xsl:value-of select="PROFILED_SETTINGS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "feat_count">
		<xsl:value-of select="PROFILED_FEATURES/COUNT"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
	   		<xsl:text>Nothing Profiled</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Profiled List</xsl:text>
			<xsl:text>Profiled Commands </xsl:text><xsl:value-of select="PROFILED_COMMANDS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="PROFILED_COMMANDS"/>

			<xsl:text>Profiled Settings </xsl:text><xsl:value-of select="PROFILED_SETTINGS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="PROFILED_SETTINGS"/>

			<xsl:text>Profiled Features </xsl:text><xsl:value-of select="PROFILED_FEATURES/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="PROFILED_FEATURES"/>

			<xsl:text>Profiled Files </xsl:text><xsl:value-of select="PROFILED_FILES/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="PROFILED_FILES"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PROFILED_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="PROFILED_COMMAND">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="PROFILED_SETTING">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="PROFILED_FEATURE">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="PROFILED_FILES">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:text>Site Default Settings - </xsl:text>
		<xsl:value-of select="SITE_DEFAULT_SETTINGS"/>
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>Prior Version Settings Script - </xsl:text>
		<xsl:value-of select="PRIOR_VERSION_SCRIPT"/>
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>Current Version Settings Script - </xsl:text>
		<xsl:value-of select="CURRENT_VERSION_SCRIPT"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>


<xsl:template match="GROUP_POLICIES" >

	<xsl:variable name = "cmd_count">
		<xsl:value-of select="POLICY_COMMANDS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "set_count">
		<xsl:value-of select="POLICY_SETTINGS/COUNT"/>
	</xsl:variable>
	<xsl:variable name = "feat_count">
		<xsl:value-of select="POLICY_FEATURES/COUNT"/>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
	   		<xsl:text>Nothing Set by Group Policies</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Group Policy List</xsl:text>
			<xsl:call-template name = "lineBreak"/>
<!--
			<xsl:text>Commands </xsl:text><xsl:value-of select="POLICY_COMMANDS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="POLICY_COMMANDS"/>
-->
			<xsl:text>Settings </xsl:text><xsl:value-of select="POLICY_SETTINGS/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="POLICY_SETTINGS"/>

			<xsl:text>Features </xsl:text><xsl:value-of select="POLICY_FEATURES/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="POLICY_FEATURES"/>

<!--
			<xsl:text>Profiled Files </xsl:text><xsl:value-of select="POLICY_FILES/COUNT"/>
			<xsl:call-template name = "lineBreak"/>
			<xsl:apply-templates select="POLICY_FILES"/>
-->
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="POLICY_COMMANDS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="POLICY_COMMAND">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="POLICY_SETTINGS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="POLICY_SETTING">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="POLICY_FEATURES">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="POLICY_FEATURE">
			<xsl:value-of select="."/>
			<xsl:call-template name = "lineBreak"/>
		</xsl:for-each>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>

<xsl:template match="POLICY_FILES">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:text>Site Default Settings - </xsl:text>
		<xsl:value-of select="SITE_DEFAULT_SETTINGS"/>
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>Prior Version Settings Script - </xsl:text>
		<xsl:value-of select="PRIOR_VERSION_SCRIPT"/>
		<xsl:call-template name = "lineBreak"/>

		<xsl:text>Current Version Settings Script - </xsl:text>
		<xsl:value-of select="CURRENT_VERSION_SCRIPT"/>
		<xsl:call-template name = "lineBreak"/>
	</xsl:if>
</xsl:template>


<xsl:template match="HOTSPOTS">
	<xsl:variable name = "spotCount">
		<xsl:value-of select="COUNT"/>
	</xsl:variable>
  
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if test="count(DEFAULTS) = 1">
		<P/><I>Hotspots are at Defaults</I>
	</xsl:if>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:if test="count(COUNT) = 1">
		<xsl:choose>
			<xsl:when test="$spotCount > 0">
				<xsl:value-of select="COUNT"/><xsl:text> Hotspot</xsl:text>
				<xsl:if test="$spotCount > 1">
					<xsl:text>s</xsl:text>
		  		</xsl:if>
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "lineBreak"/>

				<xsl:text>Hotspots Enabled     Hotspots Visible          Mousechord</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:text>________________     ________________     _____________________</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:apply-templates select="HOTSPOT_SETTINGS"/>
				<xsl:call-template name = "lineBreak"/>

				<xsl:text>Text             Type           Action                  Match                     Row   Column</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:text>____             ____           _______                 ______                    ___   ______</xsl:text>
				<xsl:call-template name = "lineBreak"/>
				<xsl:call-template name = "lineBreak"/>
				<xsl:apply-templates select="HOTSPOT"/>
				<xsl:call-template name = "lineBreak"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>There are no Hotspots defined</xsl:text>
				<xsl:call-template name = "lineBreak"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template match="HOTSPOT_SETTINGS">
	<xsl:text>       </xsl:text>
	<xsl:value-of select="HOTSPOTS_ENABLED"/>
	<xsl:text>                   </xsl:text>
	<xsl:value-of select="HOTSPOTS_VISIBLE"/>
	<xsl:text>           </xsl:text>
	<xsl:value-of select="MOUSECHORD"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>

<xsl:template match="HOTSPOT">
	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="HOTSPOT_TEXT"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="17 - string-length(current()/HOTSPOT_TEXT)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:value-of select="COMMAND_TYPE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="14 - string-length(current()/COMMAND_TYPE)"/>
		</xsl:with-param>
	</xsl:call-template>
	
	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="25 - string-length($mapping)"/>
		</xsl:with-param>
	</xsl:call-template>
		
	<xsl:if test="self::node()[MATCH_CASE='Yes']">
		<xsl:text>Case</xsl:text>
		<xsl:choose>
			<xsl:when test="MATCH_WHOLE_WORD='Yes'">
				<xsl:text>,</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="MATCH_TIL_WHITESPACE='Yes'">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>

	<xsl:if test="self::node()[MATCH_WHOLE_WORD='Yes']">
		<xsl:text>Word</xsl:text>
		<xsl:if test="MATCH_TIL_WHITESPACE='Yes'">
			<xsl:text>,</xsl:text>
		</xsl:if>
	</xsl:if>

	<xsl:if test="self::node()[MATCH_TIL_WHITESPACE='Yes']">
		<xsl:text>Until whitespace</xsl:text>
	</xsl:if>

	<xsl:variable name = "lgth">
		<xsl:choose>
			<xsl:when test = "self::node()[MATCH_CASE='Yes']       and
							  self::node()[MATCH_WHOLE_WORD='Yes'] and
							  self::node()[MATCH_TIL_WHITESPACE='Yes']">1</xsl:when>

			<xsl:when test = "(self::node()[MATCH_CASE='Yes']       or
							  self::node()[MATCH_WHOLE_WORD='Yes']) and
							  self::node()[MATCH_TIL_WHITESPACE='Yes']">6</xsl:when>

			<xsl:when test = "self::node()[MATCH_CASE='Yes']       and
							  self::node()[MATCH_WHOLE_WORD='Yes'] and
							  not(self::node()[MATCH_TIL_WHITESPACE='Yes'])">17</xsl:when>

			<xsl:when test = "(self::node()[MATCH_CASE='Yes']       or
							  self::node()[MATCH_WHOLE_WORD='Yes']) and
							  not(self::node()[MATCH_TIL_WHITESPACE='Yes'])">20</xsl:when>

			<xsl:when test = "(not(self::node()[MATCH_CASE='Yes'])       and
							  not(self::node()[MATCH_WHOLE_WORD='Yes'])) and
							  self::node()[MATCH_TIL_WHITESPACE='Yes']">8</xsl:when>
			<xsl:otherwise>26</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="$lgth+1"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:if test="self::node()[ANY_ROW]">
		<xsl:text> Any </xsl:text>
	</xsl:if>
	<xsl:if test="self::node()[ROW]">
		<xsl:value-of select="ROW"/>
		<xsl:text>      </xsl:text>
	</xsl:if>
	<xsl:if test="self::node()[ANY_COLUMN]">
		<xsl:text>  Any </xsl:text>
	</xsl:if>
	<xsl:if test="self::node()[COLUMN]">
		<xsl:value-of select="COLUMN"/>
		<xsl:text>  </xsl:text>
	</xsl:if>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="SCREEN">
	<xsl:variable name = "lines" select = "count(./STATUS_LINE)"/>
	<xsl:if test = "$lines &gt; 0">
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
   		<xsl:text>Status Line</xsl:text>
		<xsl:if test = "$lines &gt; 1">
	   		<xsl:text>s</xsl:text>
		</xsl:if>
		<xsl:call-template name = "lineBreak"/>
		<xsl:call-template name = "lineBreak"/>
		<xsl:apply-templates select="STATUS_LINE"/>
	</xsl:if>
</xsl:template>



<xsl:template match="STATUS_LINE">
	<xsl:value-of select = "."/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template match="FUNCTION_KEYS">
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULT) &gt; 0">
	   		<xsl:text>Default Function Keys</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="HP_USER_FUNCTION_KEYS"/>
		 </xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="HP_USER_FUNCTION_KEYS">
	<xsl:if test = "COUNT &gt; 0">
		<xsl:text>Function Keys </xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>Key   Attribute          Label          Definition</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:text>___   _________     _________________   ___________</xsl:text>
		<xsl:call-template name = "lineBreak"/>
		<xsl:for-each select="HP_USER_KEY">
		  	<xsl:call-template name="HP_USER_KEY"/>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template name="HP_USER_KEY">
	<xsl:variable name = "keynum">
		<xsl:value-of select="@keynumber"/>
	</xsl:variable>

	<xsl:if test = "$keynum &lt; 10">
		<xsl:text> </xsl:text>
	</xsl:if>
	<xsl:value-of select="$keynum"/>
	<xsl:text>    </xsl:text>

	<xsl:value-of select="FKEY_ATTRIBUTE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="17 - string-length(current()/FKEY_ATTRIBUTE)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:value-of select="LABEL"/>
	<xsl:text>   </xsl:text>

	<xsl:variable name = "def">
		<xsl:value-of select="DEFINITION"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="string-length($def)=5 and starts-with($def,'#027')">
			<xsl:value-of select="translate($def,'#027;','ESC')"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="READABLE_DEFINITION"/>
		 </xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>




<xsl:template match="TOOLBARS">
	<xsl:variable name = "count">
		<xsl:choose>
			<xsl:when test = "not(COUNT)">0</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="COUNT"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test="count(DEFAULTS) = 1">
			<xsl:text>Default Toolbars</xsl:text>
			<xsl:call-template name = "lineBreak"/>
		</xsl:when>

		<xsl:when test="count(COUNT) = 1">
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>Toolbars (</xsl:text>
			<xsl:value-of select="COUNT"/>
			<xsl:text>)</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>Toolbar          Location  Visible  Anchored  Color  Buttons  Tooltips  Labels</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>_______          ________  _______  ________  _____  _______  ________  ______</xsl:text>
			<xsl:call-template name = "lineBreak"/>

			<xsl:for-each select="TOOLBAR">
			  	<xsl:call-template name="TOOLBAR_SUMMARY"/>
			</xsl:for-each>
			<xsl:call-template name = "lineBreak"/>

			<xsl:for-each select="TOOLBAR">
				<xsl:call-template name="TOOLBAR_BUTTONS"/>
			</xsl:for-each>
			<xsl:if test = "$count &gt; 0">
				<xsl:call-template name = "lineBreak"/>
			</xsl:if>
		</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="TOOLBAR_SUMMARY">
	<xsl:variable name = "name">
		<xsl:value-of select="@name"/>
	</xsl:variable>
	<xsl:value-of select="$name"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="17 - string-length($name)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:value-of select="LOCATION"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="11 - string-length(current()/LOCATION)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:value-of select="VISIBLE"/>
	<xsl:text>       </xsl:text>
	<xsl:if test = "VISIBLE = 'No' ">
		<xsl:text> </xsl:text>
	</xsl:if>

	<xsl:value-of select="ANCHORED"/>
	<xsl:text>      </xsl:text>
	<xsl:if test = "ANCHORED = 'No' ">
		<xsl:text> </xsl:text>
	</xsl:if>

	<xsl:value-of select="COLOR_BUTTONS"/>
	<xsl:text>      </xsl:text>
	<xsl:if test = "COLOR_BUTTONS = 'No' ">
		<xsl:text> </xsl:text>
	</xsl:if>

	<xsl:value-of select="LARGE_BUTTONS"/>
	<xsl:text>      </xsl:text>
	<xsl:if test = "LARGE_BUTTONS = 'No' ">
		<xsl:text> </xsl:text>
	</xsl:if>

	<xsl:value-of select="SHOW_TOOLTIPS"/>
	<xsl:text>      </xsl:text>
	<xsl:if test = "SHOW_TOOLTIPS = 'No' ">
		<xsl:text> </xsl:text>
	</xsl:if>

	<xsl:value-of select="SHOW_LABELS"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name="TOOLBAR_BUTTONS">
	<xsl:variable name = "labels" select= "count(BUTTONS/BUTTON/BUTTON_LABEL) &gt; 0"/>

	<xsl:call-template name = "lineBreak"/>
	<xsl:value-of select="@name"/>
	<xsl:text> Toolbar</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>Buttons</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:choose>
		<xsl:when test = "$labels &gt; 0">
			<xsl:text>Number   Command Type            Action                            Label                              Tooltip</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>______   ____________            ______                            _____                              _______</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Number   Command Type            Action                            Tooltip</xsl:text>
			<xsl:call-template name = "lineBreak"/>
			<xsl:text>______   ____________            ______                            _______</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name = "lineBreak"/>
	<xsl:for-each select="BUTTONS/BUTTON">
	  	<xsl:call-template name="TOOLBAR_BUTTON">
			<xsl:with-param name = "labels" select = "$labels"/>
		</xsl:call-template>
	</xsl:for-each>
</xsl:template>


<xsl:template name="TOOLBAR_BUTTON">
	<xsl:param name = "labels" select = "0"/>

	<xsl:variable name = "mapping">
		<xsl:choose>
			<xsl:when test="count(LOC_ACTION) &gt; 0">
				<xsl:value-of select="LOC_ACTION"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="ACTION"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "btnnum">
		<xsl:value-of select="@number"/>
	</xsl:variable>

	<xsl:if test = "$btnnum &lt; '10'">
		<xsl:text> </xsl:text>
	</xsl:if>
	<xsl:value-of select="$btnnum"/>

	<xsl:text>       </xsl:text>
	<xsl:value-of select="COMMAND_TYPE"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="24 - string-length(current()/COMMAND_TYPE)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:value-of select="$mapping"/>
	<xsl:call-template name = "Spaces">
		<xsl:with-param name = "count">
			<xsl:value-of select="34 - string-length($mapping)"/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:if test = "$labels &gt; 0">
		<xsl:value-of select="BUTTON_LABEL"/>
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select="35 - string-length(current()/BUTTON_LABEL)"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<xsl:value-of select="BUTTON_TOOLTIP"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>




<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template name = "tab">
	<xsl:text>&#9;</xsl:text>	
</xsl:template>



<xsl:template name = "tabs">
	<xsl:param name = "tabcount"/>

	<xsl:if test = "$tabcount &gt; 0">
		<xsl:text>&#9;</xsl:text>	
		<xsl:call-template name = "tabs">
			<xsl:with-param name = "tabcount">
				<xsl:value-of select = "$tabcount - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:template name = "Spaces">
	<xsl:param name = "count"/>

	<xsl:if test = "$count &gt; 0">
		<xsl:text> </xsl:text>	
		<xsl:call-template name = "Spaces">
			<xsl:with-param name = "count">
				<xsl:value-of select = "$count - 1"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>



<xsl:template name = "OldSourceXML">
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>TransformFailed</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>This transform requires version 2.0 or greater exported Reflection Settings.</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>As created by Reflection 10.0 or later.</xsl:text>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>



<xsl:template match="text()|@*"/>

</xsl:stylesheet>