<?xml version="1.0"?>
<!--
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
-->
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">




<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes"/>


<!--  vb.xsl   Convert changed Reflection settings to VBA command script  -->



<xsl:variable name = "transformVersion" select = "1.0"/>



<xsl:variable name="colorNames">
	<COLOR value = "0x00ffff" 	name = "rcCyan"/>
	<COLOR value = "0xf0ffff" 	name = "rcCyan"/>
	<COLOR value = "0xf5f5dc" 	name = "rcDkYellow"/>
	<COLOR value = "0x0" 		name = "rcBlack"/>
	<COLOR value = "0x0000ff"	name = "rcBlue"/>
	<COLOR value = "0xa52a2a" 	name = "rcDKYellow"/>
	<COLOR value = "0x7fff00" 	name = "Chartreuse"/>
	<COLOR value = "0xff7f50" 	name = "rcCyan"/>
	<COLOR value = "0xdc143c" 	name = "rcRed"/>
	<COLOR value = "0x00ffff" 	name = "rcCyan"/>
	<COLOR value = "0x00008b" 	name = "rcDkBlue"/>
	<COLOR value = "0x006400" 	name = "rcDkGreen"/>
	<COLOR value = "0xa9a9a9" 	name = "rcDkGrey"/>
	<COLOR value = "0x8b008b" 	name = "rcDkMagenta"/>
	<COLOR value = "0x8b0000" 	name = "rcDkRed"/>
	<COLOR value = "0x9400d3" 	name = "rcDkMagenta"/>
	<COLOR value = "0x808000" 	name = "rcDkYellow"/>
	<COLOR value = "0xff00ff" 	name = "rcMagenta"/>
	<COLOR value = "0x808080" 	name = "rcGray"/>
	<COLOR value = "0x008000" 	name = "rcGreen"/>
	<COLOR value = "0xfffff0" 	name = "rcWhite"/>
	<COLOR value = "0xadd8e6" 	name = "rcBlue"/>
	<COLOR value = "0x00ff00" 	name = "rcGreen"/>
	<COLOR value = "0x32cd32" 	name = "rcGreen"/>
	<COLOR value = "0x800000" 	name = "rcMagenta"/>
	<COLOR value = "0x191970" 	name = "rcDkBlue"/>
	<COLOR value = "0x808000" 	name = "rcDkYellow"/>
	<COLOR value = "0xffa500" 	name = "rcYellow"/>
	<COLOR value = "0x800080" 	name = "rcDkMagenta"/>
	<COLOR value = "0xff0000" 	name = "rcRed"/>
	<COLOR value = "0xc0c0c0" 	name = "rcGrey"/>
	<COLOR value = "0xd2b48c" 	name = "rcDkYellow"/>
	<COLOR value = "0x008080" 	name = "rcCyan"/>
	<COLOR value = "0x40e0d0" 	name = "rcMagenta"/>
	<COLOR value = "0xee82ee" 	name = "rcDkMagenta"/>
	<COLOR value = "0xffffff" 	name = "rcWhite"/>
	<COLOR value = "0xffff00" 	name = "rcYellow"/>
	<COLOR value = "0x6e6e6e" 	name = "rcGrey"/>
 </xsl:variable>


<xsl:variable name="HPColorAttributes">
	<ATTRIB name = "Normal"										setname = "rcPlainAttribute"/>
	<ATTRIB name = "Blink"										setname = "rcBlinkAttribute"/>
	<ATTRIB name = "Inverse"									setname = "rcInverseAttribute"/>
	<ATTRIB name = "Underline"									setname = "rcUnderlineAttribute"/>
	<ATTRIB name = "Halfbright|Bold"							setname = "rcHalfbrightAttribute"/>
	<ATTRIB name = "Inverse Blink"								setname = "rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Underline Blink"							setname = "rcUnderlineAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Underline Inverse"							setname = "rcUnderlineAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Underline Inverse Blink"					setname = "rcUnderlineAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Blink" 						setname = "rcHalfbrightAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Inverse"					setname = "rcHalfbrightAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Halfbright|Bold Inverse Blink"				setname = "rcHalfbrightAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline" 					setname = "rcHalfbrightAttribute+rcUnderlineAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Blink"			setname = "rcHalfbrightAttribute+rcUnderlineAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Inverse"			setname = "rcHalfbrightAttribute+rcUnderlineAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Inverse Blink"	setname = "rcHalfbrightAttribute+rcUnderlineAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Function Keys"								setname = "rcFunctionKeys"/>
	<ATTRIB name = "Hotspots"									setname = "rcHotspotAttribute"/>
	<ATTRIB name = "Color Cursor"								setname = "rcCursorAttribute"/>
</xsl:variable>



<xsl:variable name="VTColorAttributes">
	<ATTRIB name = "Normal"										setname = "rcPlainAttribute"/>
	<ATTRIB name = "Blink"										setname = "rcBlinkAttribute"/>
	<ATTRIB name = "Inverse"									setname = "rcInverseAttribute"/>
	<ATTRIB name = "Underline"									setname = "rcUnderlineAttribute"/>
	<ATTRIB name = "Halfbright|Bold"							setname = "rcBoldAttribute"/>
	<ATTRIB name = "Inverse Blink"								setname = "rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Underline Blink"							setname = "rcUnderlineAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Underline Inverse"							setname = "rcUnderlineAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Underline Inverse Blink"					setname = "rcUnderlineAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Blink" 						setname = "rcBoldAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Inverse"					setname = "rcBoldAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Halfbright|Bold Inverse Blink"				setname = "rcBoldAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline" 					setname = "rcBoldAttribute+rcUnderlineAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Blink"			setname = "rcBoldAttribute+rcUnderlineAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Inverse"			setname = "rcBoldAttribute+rcUnderlineAttribute+rcInverseAttribute"/>
	<ATTRIB name = "Halfbright|Bold Underline Inverse Blink"	setname = "rcBoldAttribute+rcUnderlineAttribute+rcInverseAttribute+rcBlinkAttribute"/>
	<ATTRIB name = "Hotspots"									setname = "rcHotspotAttribute"/>
	<ATTRIB name = "Color Cursor"								setname = "rcFCursorAttribute"/>
</xsl:variable>



<xsl:variable name = "emulator">
	<xsl:value-of select = "/REFLECTION_SETTINGS/CREATOR/@type"/>
</xsl:variable>

<xsl:variable name = "product">
	<xsl:choose>
		<xsl:when test = "($emulator = 1)">HP</xsl:when>
		<xsl:otherwise>VT</xsl:otherwise>			
	</xsl:choose>
</xsl:variable>



<xsl:variable name = "hpColorAttributes"  select = "msxsl:node-set($HPColorAttributes)"/>
<xsl:variable name = "vtColorAttributes"  select = "msxsl:node-set($VTColorAttributes)"/>




<xsl:template match="/">
Sub SetProperties()

  'Configure Reflection 

  On Error Resume Next
  With Session
	<xsl:apply-templates/>

  End With
End Sub
</xsl:template>


<xsl:template match="EVENTS">
	<xsl:variable name = "version">
		<xsl:value-of select = "@version"/>
	</xsl:variable>

	'Events
	<xsl:for-each select="EVENT">
		<xsl:call-template name="EVENT">
			<xsl:with-param name = "event_version">
				<xsl:value-of select = "$version"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:for-each>
</xsl:template>


<xsl:template match="PROPERTIES">
	'Properties
	<xsl:for-each select="PROPERTY">
		<xsl:call-template name="PROPERTY"/>
	</xsl:for-each>

</xsl:template>


<xsl:template match="KEYMAP">
	'Keymappings

	<xsl:for-each select="KEY_MAPPING">
		<xsl:call-template name="PARSE_KEY_MAPPING"/>
	</xsl:for-each>
</xsl:template>

<xsl:template match="MOUSEMAP">
	'Mousemappings

	<xsl:for-each select="MOUSE_MAPPING">
		<xsl:call-template name="PARSE_MOUSE_MAPPING"/>
	</xsl:for-each>
</xsl:template>




<xsl:template name="PARSE_KEY_MAPPING">
	<xsl:variable name = "command">
		<xsl:value-of select = "COMMAND_TYPE"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="position() = 1">
			<xsl:if test = "$command = 'Mixed Macro'">
				<xsl:text>'</xsl:text>
			</xsl:if>
			<xsl:text>.SetKeyMap </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test = "$command = 'Mixed Macro'">
				<xsl:text>'</xsl:text>
			</xsl:if>
			<xsl:text>	.SetKeyMap </xsl:text>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:call-template name="PARSE_KEYSTROKE"/>
	<xsl:call-template name="PARSE_COMMAND"/>
</xsl:template>

<xsl:template name="PARSE_MOUSE_MAPPING">
	<xsl:choose>
		<xsl:when test="position() = 1">
			<xsl:text>.SetMouseMap </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>	.SetMouseMap </xsl:text>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:call-template name="PARSE_MOUSECHORD"/>
	<xsl:call-template name="PARSE_COMMAND"/>
</xsl:template>

<xsl:template name="PARSE_KEYSTROKE">
	<xsl:choose>
		<xsl:when test = "count(MODIFIERS) &gt; 0">
			<xsl:call-template name="PARSE_MODIFIERS">
				<xsl:with-param name="modifiers">
					<xsl:value-of select="MODIFIERS"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:text>"</xsl:text>
			<xsl:value-of select="KEY"/>
			<xsl:text>", </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>rcNormalKey, "</xsl:text>
		    <xsl:value-of select="KEYSTROKE"/>
			<xsl:text>", </xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="PARSE_MOUSECHORD">

	<xsl:variable name = "chord_modifiers">
		<xsl:value-of select="MODIFIERS"/>
	</xsl:variable>

	<xsl:variable name = "btn_string">
		<xsl:choose>
			<xsl:when test="count(MODIFIERS) = 0 ">
				<xsl:value-of select="MOUSECHORD"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="MOUSE_BUTTON"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "btn_name">
		<xsl:choose>
			<xsl:when test = "contains($btn_string, 'when released')">
				<xsl:value-of select = "substring-before($btn_string, ' when released')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$btn_string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "mouse_btn">
		<xsl:choose>
			<xsl:when test="$btn_name = 'Button1' ">
				<xsl:text>LeftBtn</xsl:text>
			</xsl:when>
			<xsl:when test="$btn_name = 'Button2' ">
				<xsl:text>RightBtn</xsl:text>
			</xsl:when>
			<xsl:when test="$btn_name = 'Middle button' ">
				<xsl:text>MiddleBtn</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>UnknownBtn</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "count(MODIFIERS) &gt; 0 and $chord_modifiers != 'Double Click'">
			<xsl:call-template name="PARSE_MODIFIERS">
				<xsl:with-param name="modifiers">
					<xsl:value-of select="MODIFIERS"/>
				</xsl:with-param>
				<xsl:with-param name="chord">
					<xsl:value-of select="MOUSECHORD"/>
				</xsl:with-param>
			</xsl:call-template>

			<xsl:text>"</xsl:text>
			<xsl:value-of select="$mouse_btn"/>

			<xsl:if test="contains($chord_modifiers,'Double Click')">
				<xsl:text>_DblClk</xsl:text>
			</xsl:if>

			<xsl:text>", </xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>rcNormalKey</xsl:text>
			<xsl:if test = "contains($btn_string, 'when released')">
				<xsl:text> + rcReleaseButton</xsl:text>
			</xsl:if>
			<xsl:text>, "</xsl:text>
		    <xsl:value-of select="$mouse_btn"/>
			<xsl:if test="contains($chord_modifiers,'Double Click')">
				<xsl:text>_DblClk</xsl:text>
			</xsl:if>
			<xsl:text>", </xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="PARSE_WHEN_RELEASED">
	<xsl:param name = "chord"/>

	<xsl:variable name = "when_released">
		<xsl:choose>
			<xsl:when test = "contains($chord, 'when released')">true</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name = "othermods">
		<xsl:choose>
			<xsl:when test = "contains($chord, 'Alt')   or
							  contains($chord, 'Ctrl')  or
							  contains($chord, 'Shift')">true</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:if test = "($when_released = 'true') and ($othermods = 'true')">
		<xsl:text> + </xsl:text>
	</xsl:if>
	<xsl:if test = "string($when_released) = 'true'">
		<xsl:text>rcReleaseButton</xsl:text>
	</xsl:if>

</xsl:template>


<xsl:template name="PARSE_MODIFIERS">
	<xsl:param name = "modifiers"/>
	<xsl:param name = "chord"/>

	<xsl:variable name = "remaining">
		<xsl:value-of select="substring-after($modifiers,'+')"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test="string-length($remaining) &gt; 0">
			<xsl:text>rc</xsl:text>
			<xsl:value-of select="substring-before($modifiers,'+')"/>
			<xsl:text>Key</xsl:text>
			<xsl:choose>
				<xsl:when test="(string-length($remaining) &gt; 0) and not(string($remaining) = 'Double Click')">
					<xsl:text> + </xsl:text>
					<xsl:call-template name = "PARSE_MODIFIERS">
						<xsl:with-param name="modifiers">
							<xsl:value-of select="$remaining"/>
						</xsl:with-param>
						<xsl:with-param name = "chord" select = "$chord"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test = "string($chord)">
						<xsl:call-template name = "PARSE_WHEN_RELEASED">
							<xsl:with-param name = "chord" select = "$chord"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:text>, </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="$modifiers != 'Double Click'">
				<xsl:text>rc</xsl:text>
				<xsl:value-of select="$modifiers"/>
				<xsl:text>Key, </xsl:text>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template name="PARSE_COMMAND">
	<xsl:variable name = "command">
		<xsl:value-of select = "COMMAND_TYPE"/>
	</xsl:variable>

	<xsl:variable name = "mapping">
		<xsl:value-of select = "MAPPING"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "($command = 'Menu Command') or ($command = 'Complex Macro')">
			<xsl:text> rcBuiltinFunction</xsl:text>
			<xsl:call-template name = "SIMPLE_MAPPING"/>
		</xsl:when>

		<xsl:when test = "$command = 'Terminal Command'">
			<xsl:text> rcBuiltinFunction</xsl:text>
			<xsl:call-template name = "SIMPLE_MAPPING"/>
		</xsl:when>

		<xsl:when test = "$command = 'Transmit Text'">
			<xsl:text> rcTransmitString</xsl:text>

			<xsl:call-template name = "SIMPLE_MAPPING"/>
		</xsl:when>

		<xsl:when test = "$command = 'VB Macro'">
			<xsl:text> rcVBMacro</xsl:text>

			<xsl:choose>
				<xsl:when test="contains($mapping, 'with data')">

					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-before($mapping,'with data ')"/>
					<xsl:text>"</xsl:text>
					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-after($mapping,'with data ')"/>
					<xsl:text>"&#13;&#10;</xsl:text>

				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name = "SIMPLE_MAPPING"/>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:when>
		<xsl:when test = "$command = 'VB Command'">
			<xsl:text> rcVBCommand</xsl:text>
			<xsl:call-template name = "SIMPLE_MAPPING">
				<xsl:with-param name = "quoteall" select = "true"/>
			</xsl:call-template>
		</xsl:when>

		<xsl:when test = "$command = 'RB Script'">
			<xsl:text> rcRBScript</xsl:text>

			<xsl:choose>
				<xsl:when test="contains($mapping, 'with arguments')">

					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-before($mapping,'with arguments ')"/>
					<xsl:text>"</xsl:text>
					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-after($mapping,'with arguments ')"/>
					<xsl:text>"&#13;&#10;</xsl:text>

				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name = "SIMPLE_MAPPING"/>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:when>

		<xsl:when test = "$command = 'RCL Command' or $command = 'RCL Script'">
			<xsl:text> rcRCLCommand</xsl:text>

			<xsl:choose>
				<xsl:when test="contains($mapping, 'with arguments')">

					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-before($mapping,'with arguments ')"/>
					<xsl:text>"</xsl:text>
					<xsl:text>, "</xsl:text>
						<xsl:value-of select="substring-after($mapping,'with arguments ')"/>
					<xsl:text>"&#13;&#10;</xsl:text>

				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name = "SIMPLE_MAPPING"/>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:when>
		<xsl:when test = "$command = 'Mixed Macro'">
			<xsl:text>Unsupported Keymap Command Type</xsl:text>
			<xsl:call-template name = "SIMPLE_MAPPING"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Unknown Keymap Command Type</xsl:text>
			<xsl:call-template name = "SIMPLE_MAPPING"/>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>




<xsl:template name="SIMPLE_MAPPING">
	<xsl:param name = "quoteall" select = "false"/>

	<xsl:variable name = "mapping">
		<xsl:value-of select = "MAPPING"/>
	</xsl:variable>
	<xsl:variable name = "noQuotes">
		<xsl:choose>
			<xsl:when test = "(string(quoteall) = 'false') and contains($mapping, '&#34;')">true</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:text>, </xsl:text>
	<xsl:if test = "$noQuotes = ''">
		<xsl:text>"</xsl:text>
	</xsl:if>

	<xsl:variable name = "mappingString">
		<xsl:choose>
			<xsl:when test = "contains($mapping, '&quot;')">
				<xsl:call-template name = "doublequoteQuotes">
					<xsl:with-param name = "text" select = "$mapping"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "$mapping"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:call-template name = "translateCtrlChars">
		<xsl:with-param name = "text" select = "$mappingString"/>
	</xsl:call-template>

	<xsl:if test = "$noQuotes = ''">
		<xsl:text>"</xsl:text>
	</xsl:if>
	<xsl:text>&#13;&#10;</xsl:text>
</xsl:template>



<xsl:template name="PARSE_EVENT_OR_BTN_COMMAND_TYPE">
	<xsl:variable name = "command">
		<xsl:value-of select = "COMMAND_TYPE"/>
	</xsl:variable>

	<xsl:choose>
		<xsl:when test = "($command = 'Menu Command') or ($command = 'Complex Macro')">
			<xsl:text> rcBuiltinFunction</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'Terminal Command'">
			<xsl:text> rcBuiltinFunction</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'Transmit Text'">
			<xsl:text> rcTransmitString</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'VB Macro'">
			<xsl:text> rcVBMacro</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'VB Command'">
			<xsl:text> rcVBMacro</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'RB Script'">
			<xsl:text> rcRBScript</xsl:text>
		</xsl:when>
		<xsl:when test = "$command = 'RCL Command' or $command = 'RCL Script'">
			<xsl:text> rcRCLCommand</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>Unknown Event Command Type</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>




<xsl:template match="CONNECTION">

	'Connection Settings

	If .Connected = False Then
	<xsl:call-template name="CONNECTION_TYPE"/>
	<xsl:for-each select="CONNECTION_SETTING">
		<xsl:call-template name="PARSE_CONNECTION_SETTING"/>
	</xsl:for-each>
	End If
</xsl:template>


<xsl:template name="CONNECTION_TYPE">
	<xsl:if test="count(CONNECTION_TYPE) &gt; 0">
		.ConnectionType = "<xsl:value-of select="CONNECTION_TYPE"/>
		<xsl:text>"&#13;&#10;		</xsl:text>
	</xsl:if>
</xsl:template>


<xsl:template name="PARSE_CONNECTION_SETTING">
	 
	<xsl:variable name = "prop_name">
		<xsl:value-of select="@name"/>
	</xsl:variable>

	<xsl:text>.ConnectionSettings = "</xsl:text>

	<xsl:choose>
		<xsl:when test = "count(BOOLEAN) &gt; 0">
			<xsl:value-of select="$prop_name"/>  
			<xsl:text>&#32;</xsl:text>
			<xsl:value-of select="BOOLEAN"/>"
		</xsl:when>
		<xsl:when test = "count(INTEGER) &gt; 0">
			<xsl:value-of select = "$prop_name"/>
			<xsl:text>&#32;</xsl:text>
			 <xsl:value-of select="INTEGER"/>"
		</xsl:when>
		<xsl:when test = "count(ENUMERATION) &gt; 0">
			<xsl:value-of select="$prop_name"/>
			<xsl:text>&#32;</xsl:text>
			<xsl:value-of select="ENUMERATION"/>"
		</xsl:when>
  		<xsl:when test = "count(FILE) &gt; 0">
  			<xsl:value-of select="$prop_name"/>
  			<xsl:text>&#32;</xsl:text> 
			<xsl:value-of select="FILE"/>"
	  	</xsl:when>
		<xsl:when test = "count(STRING) &gt; 0">
  			<xsl:value-of select="$prop_name"/>
  			<xsl:text>&#32;</xsl:text> 
			<xsl:value-of select="STRING"/>"
	  	</xsl:when>

		<xsl:otherwise>
			<xsl:value-of select="$prop_name"/>
			 <xsl:text>	UNKNOWN TYPE!!!</xsl:text>"
		</xsl:otherwise>

   	</xsl:choose>
</xsl:template>



<xsl:template name="PROPERTY">
	<xsl:if test="count(NO_PROPERTY) = 0">
		<xsl:choose>
			<xsl:when test="count(STRING) &gt; 0">
				<xsl:call-template name="STRING_TYPE">
					<xsl:with-param name = "string"><xsl:value-of select="STRING"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="count(CHARACTER) &gt; 0">
				<xsl:call-template name="CHARACTER_TYPE"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="SIMPLE_TYPE"/>		  
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>
 

<xsl:template name="SIMPLE_TYPE">
<xsl:choose>
	<xsl:when test = "count(BOOLEAN) &gt; 0">
	.<xsl:value-of select="@name"/> = <xsl:value-of select="BOOLEAN"/>
	</xsl:when>
	<xsl:when test = "count(INTEGER) &gt; 0">
	.<xsl:value-of select="@name"/> = <xsl:value-of select="INTEGER"/>
	</xsl:when>
	<xsl:when test = "count(ENUMERATION) &gt; 0">
	.<xsl:value-of select="@name"/> = <xsl:value-of select="ENUMERATION"/>
	</xsl:when>
  	<xsl:when test = "count(FOLDER) &gt; 0">
  	.<xsl:value-of select="@name"/> = <xsl:text>&#034;</xsl:text><xsl:value-of select="FOLDER"/><xsl:text>&#034;</xsl:text>
  	</xsl:when>
  	<xsl:when test = "count(FILE) &gt; 0">
  	.<xsl:value-of select="@name"/> = <xsl:text>&#034;</xsl:text><xsl:value-of select="FILE"/><xsl:text>&#034;</xsl:text>
  	</xsl:when>
   </xsl:choose>
</xsl:template>


<xsl:template name="CHARACTER_TYPE">
<xsl:choose>
	<xsl:when test="count(CHARACTER/@ctrl) &gt; 0">
		<xsl:call-template name="CONTROL_CHAR_TYPE"/>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="NORMAL_CHAR_TYPE"/>		  
	</xsl:otherwise>
</xsl:choose>
</xsl:template>


<xsl:template name="CONTROL_CHAR_TYPE">
	<xsl:variable name = "char">
		<xsl:value-of select="CHARACTER"/>
	</xsl:variable>
	<xsl:variable name = "ctrl">
		<xsl:value-of select="substring-after($char,'#')"/>
	</xsl:variable>
	'.<xsl:value-of select="@name"/> = <xsl:value-of select="CHARACTER/@ctrl"/>
	.<xsl:value-of select="@name"/> = chr(<xsl:value-of select="$ctrl"/><xsl:text>&#041;</xsl:text>
</xsl:template>


<xsl:template name="NORMAL_CHAR_TYPE">
		.<xsl:value-of select="@name"/> = <xsl:text>&#034;</xsl:text><xsl:value-of select="CHARACTER"/><xsl:text>&#034;</xsl:text>
</xsl:template>


<xsl:template name="STRING_TYPE">
	<xsl:param name = "string"/>
	.<xsl:value-of select="@name"/> = <xsl:call-template name = "STRING_OUTPUT">
			<xsl:with-param name = "passed_string"><xsl:value-of select="$string"/></xsl:with-param>
		</xsl:call-template>
</xsl:template>


<xsl:template name="STRING_OUTPUT">
	<xsl:param name = "passed_string"/>

	<xsl:choose>
 		<xsl:when test="contains(translate($passed_string, '0123456789','9999999999'),'#999;')">
			<xsl:variable name = "tstring">
				<xsl:value-of select="translate($passed_string, '0123456789','9999999999')"/>
			</xsl:variable>
			<xsl:variable name = "bstring">
				<xsl:value-of select="substring-before($tstring,'#999;')"/>
			</xsl:variable>
			<xsl:variable name = "passed_length">
				<xsl:value-of select="string-length($passed_string)"/>
			</xsl:variable>
		   <xsl:variable name = "pre_length">
				<xsl:value-of select="string-length($bstring)+5"/>
			</xsl:variable>
		   <xsl:variable name = "remaining_length">
				<xsl:value-of select="string-length($passed_string)-(string-length($bstring)+5)"/>
			</xsl:variable>

			<xsl:variable name = "astring">
				<xsl:value-of select="substring($passed_string,$pre_length+1,$remaining_length)"/>
			</xsl:variable>

			<xsl:if test="string-length($bstring) > 0">
				<xsl:text>&#034;</xsl:text><xsl:value-of select="$bstring"/><xsl:text>&#034; &amp; </xsl:text>	
			</xsl:if>
		 		<xsl:text>chr(</xsl:text><xsl:value-of select="substring($passed_string,string-length($bstring)+2,3)"/><xsl:text>&#041;</xsl:text>
			<xsl:if test="string-length($astring) > 0">
				<xsl:text> &amp; </xsl:text>
				<xsl:call-template name = "STRING_OUTPUT">
					<xsl:with-param name = "passed_string"><xsl:value-of select="$astring"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
   		</xsl:when>
		<xsl:otherwise>
			<xsl:text>&#034;</xsl:text><xsl:value-of select="$passed_string"/><xsl:text>&#034;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="EVENT">
	<xsl:param name = "event_version"/>

	<xsl:variable name = "type">
		<xsl:value-of select = "EVENT_TYPE_INDEX"/>
	</xsl:variable>
	<xsl:variable name = "row">
		<xsl:choose>
			<xsl:when test = "$event_version = '1.0'">
				<xsl:value-of select = "EVENT_ROW + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "EVENT_ROW"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "column">
		<xsl:choose>
			<xsl:when test = "$event_version = '1.0'">
				<xsl:value-of select = "EVENT_COLUMN + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "EVENT_COLUMN"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = 'enabled'> 
		<xsl:value-of select = "EVENT_ENABLED"/>
	</xsl:variable>
	<xsl:variable name = "event_string">
		<xsl:value-of select="EVENT_STRING"/>
	</xsl:variable>

	<xsl:variable name = "command_type">
		<xsl:value-of select="COMMAND_TYPE"/>
	</xsl:variable>


	<!-- Event Number -->
	.OnEvent <xsl:value-of select="@number"/><xsl:text>, </xsl:text>

	<!-- Event Type -->
	<xsl:value-of select = "$type"/><xsl:text>,</xsl:text>

	<!-- Command Type -->
	<xsl:call-template name="PARSE_EVENT_OR_BTN_COMMAND_TYPE"/>
	<xsl:text>,</xsl:text>

	<!-- Action -->
	<xsl:if test="string-length(value-of = 'ACTION') &gt; 0">
		<xsl:variable name = "action">
			<xsl:value-of select="ACTION"/>
		</xsl:variable>

		<xsl:if test = "substring($action,1,1) != '&#34;'">
			<xsl:text> "</xsl:text>
		</xsl:if>
		<xsl:value-of select = "ACTION"/>
		<xsl:if test = "substring($action,1,1) != '&#34;'">
			<xsl:text> "</xsl:text>
		</xsl:if>
	</xsl:if>
	<xsl:text>, </xsl:text>

	<!-- Enable -->
	<xsl:choose>
		<xsl:when test="$enabled = 'Yes'">
			<xsl:text>rcEnable</xsl:text>	
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>rcDisable</xsl:text>	
		</xsl:otherwise>
	</xsl:choose>
	<xsl:text>,</xsl:text>

	<!-- After Event -->
	<xsl:value-of select = "EVENT_AFTER"/>

	<xsl:if test = "$type='6' or $type='7' or $type='9'">
		<xsl:value-of select="$row"/>
	</xsl:if>
	<xsl:if test = "$type='12' or $type='6' or $type='7' or $type='9' or
		    		(($command_type ='VB Macro' or $command_type = 'RB Script') and
		    		string-length($event_string) &gt; 0) or
					(($type = '0' or $type = '1' or $type = '8' or $type = '9' or
					$type = '10' or $type = '11') and string-length($event_string) &gt; 0)">
		<xsl:text>,</xsl:text>
	</xsl:if>

	<!-- Event String -->
	<xsl:if test = "$type = '0' or $type = '1' or $type = '8' or $type = '9' or
					$type = '10' or $type = '11'">
	   	<xsl:if test="string-length($event_string) &gt; 0">
			<xsl:text> "</xsl:text>
			<xsl:value-of select= "$event_string"/>
			<xsl:text>"</xsl:text>
		</xsl:if>
	</xsl:if>
	<xsl:if test = "$type='6' or $type='7' or $type='9'">
		<xsl:value-of select="$row"/>
	</xsl:if>
	<xsl:if test = "$type='12' or $type='6' or $type='7' or $type='9' or
		    (($command_type ='VB Macro' or $command_type = 'RB Script') and
		    string-length($event_string) &gt; 0)">
		<xsl:text>,</xsl:text>
	</xsl:if>

	<!-- Row -->
	<xsl:if test = "$type='6' or $type='7' or $type='9'">
		<xsl:value-of select="$row"/>
	</xsl:if>
	<xsl:if test = "$type='12' or $type='6' or $type='7' or $type='9' or
		    (($command_type ='VB Macro' or $command_type = 'RB Script') and
		    string-length($event_string) &gt; 0)">
		<xsl:text>,</xsl:text>
	</xsl:if>

	<!-- Column -->
	<xsl:if test = "$type='6' or $type='7' or $type='9'">
		<xsl:value-of select="$column"/>
	</xsl:if>
	<xsl:if test = "$type='12' or 
		    (($command_type ='VB Macro' or $command_type = 'RB Script') and
		    string-length($event_string) &gt; 0)">
		<xsl:text>,</xsl:text>
	</xsl:if>

	<!-- Key -->
	<xsl:if test = "$type='12'">
		<xsl:value-of select="KEY"/>
	</xsl:if>

	<!-- Event String -->
	<xsl:if test = "($command_type='VB Macro' or $command_type='RB Script') and
			string-length($event_string) &gt; 0">
		<xsl:text>, "</xsl:text>
		<xsl:value-of select="$event_string"/>
		<xsl:text>"</xsl:text>
	</xsl:if>

</xsl:template>


<xsl:template match="TOOLBARS">
	<xsl:call-template name = "lineBreak"/>
	'Toolbars
	<xsl:call-template name = "lineBreak"/>

	<xsl:if test = "COUNT &gt; 0">
		<xsl:for-each select="TOOLBAR">
			<xsl:call-template name="PARSE_TOOLBAR"/>
		</xsl:for-each>
	</xsl:if>
</xsl:template>


<xsl:template name="PARSE_TOOLBAR">
	<xsl:variable name = "tbarname" select = "@name"/>
	<xsl:variable name = "position">
		<xsl:choose>
			<xsl:when test = "not(ANCHORED = 'Yes')">rcFloating</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "concat('rc',LOCATION,'Bar')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "showlabels">
		<xsl:choose>
			<xsl:when test = "(SHOW_LABELS = 'Yes')">False</xsl:when>
			<xsl:otherwise>True</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name = "visible">
		<xsl:choose>
			<xsl:when test = "(VISIBLE = 'Yes')">True</xsl:when>
			<xsl:otherwise>False</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:text>	.DestroyToolbar "</xsl:text>
	<xsl:value-of select = "$tbarname"/>
	<xsl:text>"</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>	.NewToolbar "</xsl:text>
	<xsl:value-of select = "$tbarname"/>
	<xsl:text>"</xsl:text>
	<xsl:call-template name = "lineBreak"/>
	<xsl:text>	.SetToolbarMode "</xsl:text>
	<xsl:value-of select = "$tbarname"/>
	<xsl:text>", </xsl:text>
	<xsl:value-of select = "$position"/>
	<xsl:call-template name = "lineBreak"/>

	<xsl:for-each select="BUTTONS/BUTTON">
		<xsl:call-template name="BUTTON">
			<xsl:with-param name = "tbarname" select = "$tbarname"/>
		</xsl:call-template>
	</xsl:for-each>

	<xsl:text>	.ShowAToolbar "</xsl:text>
	<xsl:value-of select = "$tbarname"/>
	<xsl:text>", </xsl:text>
	<xsl:value-of select = "$visible"/>
	<xsl:call-template name = "lineBreak"/>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "BUTTON">
	<xsl:param name = "tbarname"/>	
	<xsl:text>	.DefineToolbarbutton "</xsl:text>
	<xsl:value-of select = "$tbarname"/>
	<xsl:text>", </xsl:text>
	<xsl:value-of select = "@number"/>
	<xsl:text>, False, "", </xsl:text>
	<xsl:value-of select = "BUTTON_SM_PIC_INDEX/@const"/>
	<xsl:text>, "", </xsl:text>
	<xsl:value-of select = "BUTTON_LG_PIC_INDEX/@const"/>
	<xsl:text>, "</xsl:text>
	<xsl:value-of select = "BUTTON_LABEL"/>
	<xsl:text>", "</xsl:text>
	<xsl:value-of select = "BUTTON_TOOLTIP"/>
	<xsl:text>", "</xsl:text>
	<xsl:value-of select = "BUTTON_HELP"/>
	<xsl:text>", </xsl:text>

	<!-- Command Type -->
	<xsl:call-template name="PARSE_EVENT_OR_BTN_COMMAND_TYPE"/>
	<xsl:text>,</xsl:text>

	<!-- Action -->
	<xsl:if test="string-length(value-of = 'ACTION') &gt; 0">
		<xsl:variable name = "action">
			<xsl:value-of select="ACTION"/>
		</xsl:variable>

		<xsl:if test = "substring($action,1,1) != '&#34;'">
			<xsl:text> "</xsl:text>
		</xsl:if>
		<xsl:value-of select = "ACTION"/>
		<xsl:if test = "substring($action,1,1) != '&#34;'">
			<xsl:text> "</xsl:text>
		</xsl:if>
	</xsl:if>
	<xsl:call-template name = "lineBreak"/>
</xsl:template>


<xsl:template name = "decodeCtrlChar">
	<xsl:param name = "text"/>

	<xsl:choose>
		<xsl:when test = "string-length($text) = 4 and contains($text, '#') and
						 string-length(substring-after($text, '#')) = 3">
			<xsl:value-of select = "concat('&#38;', concat($text, ';'))"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>



<xsl:template name = "doublequoteQuotes">
	<xsl:param name = "text"/>

	<xsl:choose>
		<xsl:when test = "contains($text, '&quot;')">
			<xsl:variable name = "firstpart">
				<xsl:value-of select = "substring-before($text, '&quot;')"/>
			</xsl:variable>
			<xsl:variable name = "remainingpart">
				<xsl:value-of select = "substring-after($text, '&quot;')"/>
			</xsl:variable>
			<xsl:value-of select = "$firstpart"/>
			<xsl:text>""</xsl:text>
			<xsl:call-template name = "doublequoteQuotes">
				<xsl:with-param name = "text" select = "$remainingpart"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name = "translateCtrlChars">
	<xsl:param name = "text"/>

	<xsl:variable name = "startOfDigits">
		<xsl:value-of select = "substring-after($text, '#')"/>
	</xsl:variable>

	<xsl:choose>	
		<xsl:when test = "contains($text, '#') and contains($startOfDigits, ';')">

			<xsl:variable name = "pre">
				<xsl:value-of select = "substring-before($text, '#')"/>
			</xsl:variable>

			<xsl:variable name = "first">
				<xsl:value-of select = 
					"concat('#', substring-after(concat(substring-before($text, ';'), ';'), '#'))"/>
			</xsl:variable>

			<xsl:variable name = "remaining">
				<xsl:value-of select = "substring-after($text, ';')"/>
			</xsl:variable>

			<xsl:variable name = "charCode">
				<xsl:value-of select = "substring-before($startOfDigits, ';')"/>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test = "string-length($charCode) = 3  and not(number($charCode) = Nan)">
					<xsl:variable name = "rest">
						<xsl:call-template name = "translateCtrlChars">
							<xsl:with-param name = "text">
								<xsl:value-of select = "$remaining"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select = "concat(concat($pre, concat('&#38;', $first)), $rest)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select = "$text"/>	
				</xsl:otherwise>
			</xsl:choose>

		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select = "$text"/>
		</xsl:otherwise>
	</xsl:choose>	
</xsl:template>


<xsl:template name = "lineBreak">
	<xsl:text>&#10;</xsl:text>
</xsl:template>


<xsl:template match="text()|@*"/>


</xsl:stylesheet>




