/* $Revision:   1.1  $
 *
 * Name:	WRQ_XPrn.c
 * Product:	Reflection X
 * Copyright:	(C) 1994, WRQ, Inc. All Rights Reserved.
 * Purpose:	Client side support for the WRQ Print extension.
 *
 */

#define NEED_REPLIES
#include "X11/Xlibint.h"
#include "wrq_xprn.h"
#include "X11/extensions/Xext.h"
#include "extutil.h"

static XExtensionInfo _wrq_info_data;
static XExtensionInfo *wrq_info = &_wrq_info_data;
static char *wrq_extension_name = WRQPRINTNAME;

#define WRQCheckExtension(dpy,i,val) \
  XextCheckExtension(dpy, i, wrq_extension_name, val)

static int close_display();
static char *error_string();
static XExtensionHooks wrq_extension_hooks = {
		    NULL,				/* create_gc */
		    NULL,				/* copy_gc */
		    NULL,				/* flush_gc */
		    NULL,				/* free_gc */
		    NULL,				/* create_font */
		    NULL,				/* free_font */
		    close_display,		/* close_display */
		    NULL,				/* wire_to_event */
		    NULL,				/* event_to_wire */
		    NULL,				/* error */
		    error_string,		/* error_string */
};

static char *wrq_error_list[] = {
	"WRQPrinterBadPrinter",
};

static XEXT_GENERATE_FIND_DISPLAY(find_display, wrq_info, wrq_extension_name, 
					&wrq_extension_hooks, 0, NULL)

static XEXT_GENERATE_CLOSE_DISPLAY(close_display, wrq_info)

static XEXT_GENERATE_ERROR_STRING(error_string, wrq_extension_name,
					1, wrq_error_list)


Bool
XWRQPrintQueryExtension(
#if NeedFunctionPrototypes
	Display *dpy,
	int *event_basep,
	int *error_basep)
#else
	dpy,
	event_basep,
	error_basep)
	Display *dpy;
	int *event_basep;
	int *error_basep;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);

	if (XextHasExtension(info)) {
		*event_basep = info->codes->first_event;
		*error_basep = info->codes->first_error;
		return True;
	}
	else
		return False;
}


Bool
XWRQPrintQueryVersion(
#if NeedFunctionPrototypes
	Display *dpy,
	int *Maj,
	int *Min)
#else
	dpy,
	Maj,
	Min)
	Display *dpy;
	int *Maj;
	int *Min;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintQueryVersionReq *req;
	xGenericReply rep;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintQueryVersion, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintQueryVersion;

	if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return False;
	}

	UnlockDisplay(dpy);
	SyncHandle();
	*Maj = rep.data00;
	*Min = rep.data01;
	return True;
}


Bool
XWRQPrintClosePrinter(
#if NeedFunctionPrototypes
	Display *dpy,
	Drawable pid)
#else
	dpy,
	pid)
	Display *dpy;
	Drawable pid;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintClosePrinterReq *req;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintClosePrinter, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintClosePrinter;
	req->pid = pid;
	UnlockDisplay(dpy);
	SyncHandle();
	return xTrue;
}


Bool
XWRQPrintValidatePassWd(
#if NeedFunctionPrototypes
	Display *dpy,
	unsigned char *pwd)
#else
	dpy,
	pwd)
	Display *dpy;
	unsigned char *pwd;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintValidatePWReq *req;
	xGenericReply rep;
	int len;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintValidatePW, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintValidatePW;
	if (pwd != NULL) {
		len = strlen((char *)pwd) + 1;	/* get NULL character */
		req->length += (len + 3) >> 2;
		_XSend(dpy, (char *)pwd, len);
	}
	else {
		unsigned long l = 0;

		req->length += 1;
		_XSend(dpy, (char *)&l, 1);
	}
	/*
	 * Need to get reply from server to see if pwd was valid or not.
	 */
	if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return xFalse;
	}

	UnlockDisplay(dpy);
	SyncHandle();
	return (rep.data00==xFalse?xTrue:xFalse);
}


Drawable
XWRQPrintOpenPrinter(
#if NeedFunctionPrototypes
	Display *dpy,
	char *printer,
	int copies,
	unsigned int mode)
#else
	dpy,
	printer,
	copies,
	mode)
	Display *dpy;
	char *printer;
	int copies;
	unsigned int mode;
#endif
{
	XExtDisplayInfo *info;
	xWRQPrintOpenPrinterReq *req;
	int len;

	if (copies <= 0 ||
		mode != ASCII && mode != GRAPHICS && mode != PASSTHRU)
		return xFalse;

	info = find_display(dpy);
	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintOpenPrinter, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintOpenPrinter;
	req->pid = XAllocID(dpy);
	req->copies = copies;
	req->mode = mode;

	if (printer != NULL) {
		len = strlen(printer) + 1;	/* get NULL character */
		req->length += (len + 3) >> 2;
		_XSend(dpy, printer, len);
	}
	else {
		unsigned long l = 0;

		req->length += 1;
		_XSend(dpy, (char *)&l, 1);
	}

	UnlockDisplay(dpy);
	SyncHandle();
	return req->pid;
}


Bool
XWRQPrintSendTextData(
#if NeedFunctionPrototypes
	Display *dpy,
	Drawable pid,
	unsigned char *buf,
	int count)
#else
	dpy,
	pid,
	buf,
	count)
	Display *dpy;
	Drawable pid;
	unsigned char *buf;
	int count;
#endif
{
	XExtDisplayInfo *info;
	xWRQPrintTextDataReq *req;
	xGenericReply rep;

	if (buf == NULL || count <= 0)
		return True;

	info = find_display(dpy);
	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintTextData, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintTextData;
	req->pid = pid;
	req->data_len = count;
	req->length += (count + 3) >> 2;
	Data(dpy, (char *)buf, count);

	UnlockDisplay(dpy);
	SyncHandle();
	return (rep.data00==xFalse?xTrue:xFalse);
}


Bool
XWRQPrintSendGraphicsData(
#if NeedFunctionPrototypes
	Display *dpy,
	Drawable pid,
	Drawable did)
#else
	dpy,
	pid,
	did)
	Display *dpy;
	Drawable pid;
	Drawable did;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintGraphicsDataReq *req;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintGraphicsData, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintGraphicsData;
	req->pid = pid;
	req->did = did;
	UnlockDisplay(dpy);
	SyncHandle();
	return xTrue;
}


char **
XWRQPrintListPrinters(
#if NeedFunctionPrototypes
	Display *dpy,
	int maximum,
	int *actual)
#else
	dpy,
	maximum,
	actual)
	Display *dpy;
	int maximum;
	int *actual;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintListPrintersReq *req;
	xWRQPrintListPrintersRep rep;
	char *ch, *printer, **plist;
	int i, namelen;
	unsigned long rlen;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintListPrinters, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintListPrinters;
	req->maximum = maximum;

	if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return NULL;
	}
	if (rep.nPrinters != 0) {
		rlen = rep.length << 2;
		if ((plist = (char **)Xmalloc((rep.nPrinters + 1) * sizeof(char *))) == NULL) {
			_XEatData(dpy, rlen);
			UnlockDisplay(dpy);
			SyncHandle();
			return NULL;
		}
		if ((ch = (char *)Xmalloc(rlen + 1)) == NULL) {
			_XEatData(dpy, rlen);
			UnlockDisplay(dpy);
			SyncHandle();
			XFree(plist);
			return NULL;
		}
		_XReadPad(dpy, ch, rlen);
		printer = ch;
		for (i=0; i<(int)rep.nPrinters; i++) {
			namelen = strlen(printer) + 1;
			if ((plist[i] = Xmalloc(namelen)) == NULL) {
				UnlockDisplay(dpy);
				SyncHandle();
				while (i--)
					XFree(plist[i]);
				XFree(plist);
				XFree(ch);
				return NULL;
			}
			memcpy(plist[i], printer, namelen);
			printer += namelen;
		}
		plist[i] = NULL;
		XFree(ch);
	}
	else
		plist = NULL;
	UnlockDisplay(dpy);
	SyncHandle();
	*actual = rep.nPrinters;
	return plist;
}


void
XWRQPrintFreePrinterNames(
#if NeedFunctionPrototypes
	char **list)
#else
	list)
	char **list;
#endif
{
	char **names;

	if (list != NULL) {
		for (names = list; *names != NULL; names++)
			XFree(*names);
		XFree(list);
	}
	return;
}


int
XWRQPrintQueryPrinter(
#if NeedFunctionPrototypes
	Display *dpy,
	Drawable pid,
	WRQ_XPrinterInfo *PrinterInfo)
#else
	dpy,
	pid,
	PrinterInfo)
	Display *dpy;
	Drawable pid;
	WRQ_XPrinterInfo *PrinterInfo;
#endif
{
	XExtDisplayInfo *info = find_display(dpy);
	xWRQPrintQueryPrinterReq *req;
	xWRQPrintQueryPrinterRep rep;

	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintQueryPrinter, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintQueryPrinter;
	req->pid = pid;

	if (!_XReply(dpy, (xReply *)&rep, 
		(sizeof(xWRQPrintQueryPrinterRep) - sizeof(xReply)) >> 2, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return False;
	}
	PrinterInfo->mode = rep.mode;
	PrinterInfo->width = rep.width;
	PrinterInfo->height = rep.height;
	PrinterInfo->xaspect = rep.xaspect;
	PrinterInfo->yaspect = rep.yaspect;
	PrinterInfo->xdpi = rep.xdpi;
	PrinterInfo->ydpi = rep.ydpi;
	PrinterInfo->depth = rep.depth;
	UnlockDisplay(dpy);
	SyncHandle();
	return xTrue;
}


int
XWRQPrintEchoData(
#if NeedFunctionPrototypes
	Display *dpy,
	unsigned char *reqBuf,
	unsigned char *repBuf,
	int count)
#else
	dpy,
	reqBuf,
	repBuf,
	count)
	Display *dpy;
	unsigned char *reqBuf;
	unsigned char *repBuf;
	int count;
#endif
{
	XExtDisplayInfo *info;
	xWRQPrintEchoDataReq *req;
	xWRQPrintEchoDataRep rep;

	if (reqBuf == NULL || repBuf == NULL)
		return 0;
	if (count < 0)
		return -1;
	else if (count == 0)
		return count;

	info = find_display(dpy);
	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintEchoData, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintEchoData;
	req->data_len = count;
	req->length += (count + 3) >> 2;
	_XSend(dpy, (char *)reqBuf, count);

	/* get reply back from server  */
	if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return -1;
	}

	/* get actual data from the wire */
	if ((int)rep.data_len > 0)
		_XReadPad(dpy, (char *)repBuf, rep.data_len);

	UnlockDisplay(dpy);
	SyncHandle();
	return rep.data_len;
}


/*
 * Send data to the server and don't wait around for a reply.
 */
int
XWRQPrintSendData(
#if NeedFunctionPrototypes
	Display *dpy,
	unsigned char *buf,
	int count)
#else
	dpy,
	buf,
	count)
	Display *dpy;
	unsigned char *buf;
	int count;
#endif
{
	XExtDisplayInfo *info;
	xWRQPrintRecvDataReq *req;

	if (buf == NULL || count == 0)
		return 0;
	else if (count < 0)
		return -1;

	info = find_display(dpy);
	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintRecvData, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintRecvData;
	req->data_len = count;
	req->length += (count + 3) >> 2;
	Data(dpy, (char *)buf, count);
	UnlockDisplay(dpy);
	SyncHandle();
	return count;
}


/*
 * Ask the server to send some data and wait for a reply.
 */
int
XWRQPrintRecvData(
#if NeedFunctionPrototypes
	Display *dpy,
	unsigned char *buf,
	int most)
#else
	dpy,
	buf,
	most)
	Display *dpy;
	unsigned char *buf;
	int most;
#endif
{
	XExtDisplayInfo *info;
	xWRQPrintSendDataReq *req;
	xWRQPrintSendDataRep rep;

	if (most < 0)
		return -1;
	else if (most == 0)
		return 0;
	if (buf == NULL)
		return 0;

	info = find_display(dpy);
	WRQCheckExtension(dpy, info, 0);

	LockDisplay(dpy);
	GetReq(WRQPrintSendData, req);
	req->reqType = info->codes->major_opcode;
	req->wrqReqType = X_WRQPrintSendData;
	req->data_len = most;

	/* get reply back from server  */
	if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
		UnlockDisplay(dpy);
		SyncHandle();
		return -1;
	}

	/* get actual data from the wire */
	if ((int)rep.data_len > 0)
		_XReadPad(dpy, (char *)buf, rep.data_len);

	UnlockDisplay(dpy);
	SyncHandle();
	return rep.data_len;
}
