/*	$Id: //x/12.0/dev/printext/wrq_xprn.h#1 $
 *
 * Name:		WRQ_XPrn.h
 * Product:		Reflection X
 * Copyright:	(C) 1994, WRQ, Inc. All Rights Reserved.
 * Purpose:		Protocol definition for the WRQ Print extension.
 *
 */

#ifndef _WRQ_XPRINT_H
#define _WRQ_XPRINT_H

#include "X11/Xproto.h"

#define X_WRQPrintQueryVersion	(CARD8)0
#define X_WRQPrintValidatePW	(CARD8)1
#define X_WRQPrintOpenPrinter	(CARD8)2
#define X_WRQPrintTextData		(CARD8)3
#define X_WRQPrintGraphicsData	(CARD8)4
#define X_WRQPrintClosePrinter	(CARD8)5
#define X_WRQPrintListPrinters	(CARD8)6
#define X_WRQPrintQueryPrinter	(CARD8)7
#define X_WRQPrintEchoData		(CARD8)8
#define X_WRQPrintSendData		(CARD8)9
#define X_WRQPrintRecvData		(CARD8)10

#define WRQPrintNotifyEvent	0
#define WRQPrintNotifyMask	(1L << WRQPrintNotifyEvent)
#define WRQPrintNumEvents	(WRQPrintNotifyEvent + 1)

#define WRQPRINTNAME		"WRQ_XPrint"
#define WRQPrintMajor		1
#define WRQPrintMinor		4

#define CLOSED			(1 << 0)
#define ASCII			(1 << 1)
#define GRAPHICS		(1 << 2)
#define PASSTHRU		(1 << 3)
#define PORTRAIT		(1 << 4)
#define LANDSCAPE		(1 << 5)
#define SIMPLEX			(1 << 6)
#define DUPLEXH			(1 << 7)
#define DUPLEXV			(1 << 8)

typedef struct _PrintQueryVersionReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;		/* must be 4 */
} xWRQPrintQueryVersionReq;
#define sz_xWRQPrintQueryVersionReq 	4


typedef struct _PrintValidatePWReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;		/* must be >= 4 */
} xWRQPrintValidatePWReq;
#define sz_xWRQPrintValidatePWReq	4


typedef struct _PrintOpenPrinterReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;		/* must be >= 12 */
	CARD32	pid B32;		/* printer ID */
	CARD32	mode B32;		/* ASCII|GRAPHICS|PASSTHRU */
	CARD32	copies B32;		/* number of copies > 0 */
} xWRQPrintOpenPrinterReq;
#define sz_xWRQPrintOpenPrinterReq	16


typedef struct _PrintTextDataReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;		/* must be > 12 */
	CARD32	pid B32;		/* printer ID */
	CARD32	data_len B32;		/* number of bytes to print */
} xWRQPrintTextDataReq;
#define sz_xWRQPrintTextDataReq		12


typedef struct _PrintGraphicsDataReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	pid B32;		/* printer ID */
	CARD32	did B32;		/* pixmap ID to print */
} xWRQPrintGraphicsDataReq;
#define sz_xWRQPrintGraphicsDataReq	12


typedef struct _PrintClosePrinterReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	pid B32;		/* printer ID */
} xWRQPrintClosePrinterReq;
#define sz_xWRQPrintClosePrinterReq 	8


typedef struct _PrintListPrintersReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	maximum B32;		/* max printers */
} xWRQPrintListPrintersReq;
#define sz_xWRQPrintListPrintersReq 	8


typedef struct _PrintListPrintersRep {
	BYTE	type;			/* X_Reply */
	BYTE	detail;
	CARD16	sequenceNumber B16;
	CARD32	length B32;
	CARD16	nPrinters B16;
	CARD16	pad1 B16;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
	CARD32	pad6 B32;
} xWRQPrintListPrintersRep;
#define sz_xWRQPrintListPrintersRep 	32


typedef struct _PrintQueryPrinterReq {
	CARD8	reqType;		/* major opcode */
	CARD8	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	pid B32;		/* printer ID */
} xWRQPrintQueryPrinterReq;
#define sz_xWRQPrintQueryPrinterReq 	8


typedef struct _PrintQueryPrinterRep {
	BYTE	type;			/* X_Reply */
	BYTE	detail;
	CARD16	sequenceNumber B16;
	CARD32	length B32;
	CARD32	mode B32;		/* OPEN|ASCII|GRAPHICS|PASSTHRU */
	CARD32	width B32;		/* width */
	CARD32	height B32;		/* height */
	CARD32	xaspect B32;		/* x aspect GRAPHICS mode only */
	CARD32	yaspect B32;		/* y aspect GRAPHICS mode only */
	CARD32	xdpi B32;		/* x dpi GRAPHICS mode only */
	CARD32	ydpi B32;		/* y dpi GRAPHICS mode only */
	CARD32	depth B32;		/* depth of color GRAPHICS mode only */
} xWRQPrintQueryPrinterRep;
#define sz_xWRQPrintQueryPrinterRep 	40


/*
 * Just send some data to the server.
 */
typedef struct _PrintEchoDataReq {
	BYTE	reqType;		/* major opcode */
	BYTE	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	data_len B32;
} xWRQPrintEchoDataReq;
#define sz_xWRQPrintEchoDataReq 	8


/*
 * That will be promptly returned.
 */
typedef struct _PrintEchoDataRep {
	BYTE	type;			/* X_Reply */
	BYTE	detail;
	CARD16	sequenceNumber B16;
	CARD32	length B32;
	CARD32	data_len B32;
	CARD32	pad0 B32;
	CARD32	pad1 B32;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
} xWRQPrintEchoDataRep;
#define sz_xWRQPrintEchoDataRep 	32


/*
 * Client is going to ask for a specific amount of data from
 * the server and then wait around for the reply.
 */
typedef struct _PrintSendDataReq {
	BYTE	reqType;		/* major opcode */
	BYTE	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	data_len B32;
} xWRQPrintSendDataReq;
#define sz_xWRQPrintSendDataReq 	8


typedef struct _PrintSendDataRep {
	BYTE	type;			/* X_Reply */
	BYTE	detail;
	CARD16	sequenceNumber B16;
	CARD32	length B32;		/* number of bytes */
	CARD32	data_len B32;
	CARD32	pad2 B32;
	CARD32	pad3 B32;
	CARD32	pad4 B32;
	CARD32	pad5 B32;
	CARD32	pad6 B32;
} xWRQPrintSendDataRep;
#define sz_xWRQPrintSendDataRep 	32


/*
 * Client wants to just send x number of bytes to server.  There is
 * no reply for this.
 */
typedef struct _PrintRecvDataReq {
	BYTE	reqType;		/* major opcode */
	BYTE	wrqReqType;		/* minor opcode */
	CARD16	length B16;
	CARD32	data_len B32;		/* number of bytes */
} xWRQPrintRecvDataReq;
#define sz_xWRQPrintRecvDataReq 	8


/*
 * All reply structures start off looking like this.
 */
typedef struct _WRQPrintRepHdr {
	BYTE	type;			/* X_Reply */
	BYTE	detail;
	CARD16	sequenceNumber B16;
	CARD32	length B32;		/* number of bytes */
} WRQPrintReplyHeader;

/*
 * Notify the client asynchronously that there is some data waiting
 * to be sent from the server.  If there is less than 27 bytes then
 * everything will fit into the event.  If not then the client can
 * ask to server to "dump" all of the pending data.
 */
typedef struct _WRQPrintNotify {
	BYTE	type;
	BYTE	kind;
	CARD16	sequenceNumber B16;
	BYTE	len;		/* bytes of valid data in this event */
	BYTE	data00;
	BYTE	data01;
	BYTE	data02;
	BYTE	data03;
	BYTE	data04;
	BYTE	data05;
	BYTE	data06;
	BYTE	data07;
	BYTE	data08;
	BYTE	data09;
	BYTE	data10;
	BYTE	data11;
	BYTE	data12;
	BYTE	data13;
	BYTE	data14;
	BYTE	data15;
	BYTE	data16;
	BYTE	data17;
	BYTE	data18;
	BYTE	data19;
	BYTE	data20;
	BYTE	data21;
	BYTE	data22;
	BYTE	data23;
	BYTE	data24;
	BYTE	data25;
	BYTE	data26;
} xWRQPrintNotifyEvent;
#define sz_xWRQPrintNotifyEvent		32


/*
 * Used as a return for the PrinterQuery function.
 */
typedef struct _PrinterQueryData {
	unsigned int mode;
	int width, height;
	int xaspect, yaspect;
	int xdpi, ydpi;
	unsigned int depth;
} WRQ_XPrinterInfo;

#ifndef _WRQXPRINT_SERVER_
#include "X11/Xfuncproto.h"

_XFUNCPROTOBEGIN

Bool
XWRQPrintQueryExtension(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	int *,				/* event_base */
	int *				/* error_base */
#endif
);


Bool
XWRQPrintQueryVersion(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	int *,				/* major version */
	int *				/* minor version */
#endif
);


Bool
XWRQPrintValidatePassWd(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	unsigned char *		/* NULL terminated passwd string */
#endif
);


Drawable
XWRQPrintOpenPrinter(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	char *,				/* NULL terminated printer name (NULL is default) */
	int,				/* number of copies to be printed */
	unsigned int		/* mode in which data will be sent to printer */
#endif
);


Bool
XWRQPrintClosePrinter(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	Drawable			/* printer ID */
#endif
);


Bool
XWRQPrintSendTextData(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	Drawable,			/* printer ID */
	unsigned char *,	/* buffer */
	int					/* number of bytes */
#endif
);


Bool
XWRQPrintSendGraphicsData(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	Drawable,			/* printer ID */
	Drawable			/* pixmap ID */
#endif
);


char **
XWRQPrintListPrinters(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	int maximum,		/* max number to return */
	int *actual			/* actual number returned */
#endif
);


void
XWRQPrintFreePrinterNames(
#if NeedFunctionPrototypes
	char **list			/* pointer to list of names */
#endif
);


int
XWRQPrintQueryPrinter(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	Drawable,			/* printer ID */
	WRQ_XPrinterInfo *	/* return values */
#endif
);


int
XWRQPrintEchoData(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	unsigned char *,	/* request data */
	unsigned char *,	/* reply data */
	int 				/* number of bytes */
#endif
);


int
XWRQPrintSendData(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	unsigned char *,	/* buffer full of data */
	int					/* amount of bytes in buffer */
#endif
);

int
XWRQPrintRecvData(
#if NeedFunctionPrototypes
	Display *,			/* dpy */
	unsigned char *,	/* pointer to buffer */
	int					/* max size of buffer */
#endif
);
_XFUNCPROTOEND

#endif /* _WRQXPRINT_SERVER_ */
#endif	/* _WRQ_PRINT_H */
