/*	$Revision:   1.2  $
 *
 * Name:		xlp.c
 * Product:		Reflection X
 * Copyright:	(C) 1996, WRQ, Inc. All Rights Reserved.
 * Purpose:		Test X client for the WRQ Print extension.  The
 *				client in some way or another will use every API in
 *				the WRQ Printing extension protocol library as an
 *				example of their usage. 
 *
 */

#include <stdio.h>
#include <string.h>
#ifdef __STDC__
#include <stdlib.h>
#else
extern char *getenv();
#endif
#include <X11/X.h>
#include <X11/Xlib.h>
#include "wrq_xprn.h"

#define _DEBUG		0x001
#define _VERBOSE	0x002

#define DEBUG_ON(f)	((f) & _DEBUG)
#define VERBOSE_ON(f)	((f) & _VERBOSE)

#ifndef min
#define min(a, b)	((a) <= (b) ? (a) : (b))
#endif
#define USAGE_MESSAGE "[-display host] [-passwd password] [-n copies] [[-ma]|[-mp]] [-printer name] [-v] [-debug] [file]"

int
#ifdef __STDC__
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif
{
	Display *dpy;
	unsigned int flags = 0, mode = PASSTHRU;
	char **available, *basename, *display = NULL, *printer = NULL;
	unsigned char *data, *pdata, *passwd = NULL;
	int bufsize, num, len, i0, i1, verbose = 0, copies = 1;
	Drawable pid;
	WRQ_XPrinterInfo info;
	FILE *ifd;

	if ((basename = strrchr(argv[0], '/')) != NULL)
		basename += 1;
	else
		basename = argv[0];
	while (*++argv) {
		if (!strcmp(*argv, "-display"))
			display = *++argv;
		else if (!strcmp(*argv, "-debug"))
			flags |= _DEBUG;
		else if (!strcmp(*argv, "-v"))
			flags |= _VERBOSE;
		else if (!strcmp(*argv, "-passwd"))	/* ext. password */
			passwd = (unsigned char *)*++argv;
		else if (!strcmp(*argv, "-printer"))	/* printer name */
			printer = *++argv;
		else if (!strcmp(*argv, "-n"))		/* number of copies */
			copies = atoi(*++argv);
		else if (!strcmp(*argv, "-mp"))		/* (PostScript) mode */
			mode = PASSTHRU;
		else if (!strcmp(*argv, "-ma"))		/* ascii mode */
			mode = ASCII;
		else if (!strcmp(*argv, "-h")) {
			printf("%s usage: %s %s\n", basename, basename, USAGE_MESSAGE);
			exit(1);
		}
		else
			break;
	}
	if (display == NULL) {
		if ((display = getenv("DISPLAY")) == NULL) {
			fprintf(stderr, "%s: Can't find a display to use!\n", basename);
			exit(1);
		}
	}
	if (!(dpy = XOpenDisplay(display))) {
		fprintf(stderr, "%s: Unable to open display %s.\n",
				basename, XDisplayName(display));
		exit(1);
	}
	if (DEBUG_ON(flags))
		(*XSynchronize)(dpy, 1);
/*
 * Query the server to find out if the extension exists.
 */
	if (XWRQPrintQueryExtension(dpy, &i0, &i1) != xTrue) {
		printf("The server at display %s doesn't support the WRQ printer extension.\n", XDisplayName(display));
		XCloseDisplay(dpy);
		exit(0);
	}
	if (VERBOSE_ON(flags))
		printf("The server at display %s supports the WRQ printer extension.\n", XDisplayName(display));
/*
 * The extension exists.  Now see what version it is.
 */

	if (XWRQPrintQueryVersion(dpy, &i0, &i1) != xTrue) {
		fprintf(stderr, "%s: Can't get the version information for the WRQ print extension.\n",
				basename);
		XCloseDisplay(dpy);
		exit(0);
	}
	if (VERBOSE_ON(flags))
		printf("The major and minor version numbers for the WRQ print extension are %d, %d\n", i0, i1);
/*
 * Send a password to make sure we have access to the printer.
 */
	if ((XWRQPrintValidatePassWd(dpy, passwd)) != xTrue) {
		fprintf(stderr, "%s: Password verification failed.\n", basename);
		XCloseDisplay(dpy);
		exit(0);
	}
	if (VERBOSE_ON(flags))
		puts("Password verification succeeded.");
/*
 * Find out what printers are available.
 */
	available = XWRQPrintListPrinters(dpy, 2, &num);
	if (num > 0) {
		if (VERBOSE_ON(flags)) {
			num = min(num, 2);
			puts("Available printers are:");
			for (len=0; len<num; len++)
				printf("\t%s\n", available[len]);
		}
		XWRQPrintFreePrinterNames(available);
	}
	else {
		puts("There are no printers available");
		XCloseDisplay(dpy);
		exit(0);
	}
/*
 * Finally open the default printer.
 */
	if ((pid = XWRQPrintOpenPrinter(dpy, printer, copies, mode)) == 0x10000000) {
		fprintf(stderr, "%s: Can't open printer %s\n",
			basename, (printer==NULL?"default":printer));
		XCloseDisplay(dpy);
		exit(0);
	}
	if (VERBOSE_ON(flags))
		printf("Opened %s\n", (printer==NULL?"default":printer));
/*
 * Get specific information about the printer.
 */
	if (XWRQPrintQueryPrinter(dpy, pid, &info) != xTrue) {
		fprintf(stderr, "%s: Can't query printer %s\n",
			basename, (printer==NULL?"default":printer));
		XWRQPrintClosePrinter(dpy, pid);
		XCloseDisplay(dpy);
		exit(0);
	}
	else {
		if (VERBOSE_ON(flags)) {
			printf("mode is %s\n",
				(info.mode&ASCII?"ASCII":(info.mode&PASSTHRU?"PASSTHRU":(info.mode==GRAPHICS?"GRAPHICS":"UNKNOWN"))));
			printf("width, height is <%d, %d>\n", info.width, info.height);
			printf("xaspect yaspect is <%d, %d>\n", info.xaspect, info.yaspect);
			printf("xdpi, ydpi is <%d, %d>\n", info.xdpi, info.ydpi);
			printf("depth is %d\n", info.depth);
		}
	}
	/*
	 * figure out where we need to read from
	 */
	if (*argv == NULL)
		ifd = stdin;
	else {
		if ((ifd = fopen(*argv, "r")) == NULL) {
			fprintf(stderr, "%s: Can't open %s for reading.\n", basename, *argv);
			XWRQPrintClosePrinter(dpy, pid);
			XCloseDisplay(dpy);
			return 1;
		}
	}

	/*
	 * allocate some initial space to read into
	 */
	bufsize = BUFSIZ;
	if ((data = (unsigned char *)malloc(bufsize)) == NULL) {
		fclose(ifd);
		fprintf(stderr, "%s: Can't allocate %d for buffer space.\n",
			basename, bufsize);
		XWRQPrintClosePrinter(dpy, pid);
		XCloseDisplay(dpy);
		return 1;
	}
	while (!feof(ifd)) {
		memset(data, 0, bufsize);
		if (fgets((char *)data, bufsize, ifd) != NULL) {
			if ((len = strlen((char *)data)) > 0)
				XWRQPrintSendTextData(dpy, pid, data, len);
		}
	}
	free(data);
	XWRQPrintClosePrinter(dpy, pid);
	XCloseDisplay(dpy);
	return 0;
}
