/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.DataObject;
import css.core.service.NotFoundException;
import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.InPort;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.PortInfo;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.service.ScreenManager;
import css.device.common.util.Alarm;
import css.device.common.util.Alarmable;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.util.Vector;
import pnm.util.Audit;

public class CmdManager
implements CmdMgrConstants,
CssConstants,
DeviceConstants,
DeviceErrorCodes,
Alarmable {
    private final String FILE = "CmdManager";
    DeviceSessions ref_DeviceSessions;
    DevicePorts ref_DevicePorts;
    private Protocol m_protocol;
    private Alarm m_alarm;
    private long m_startResetTime;
    private boolean m_resetCmdPort = false;

    public CmdManager(Object[][] objectArray) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)"CmdManager", (String)"Enter CmdManager Constructor");
        this.ref_DeviceSessions = new DeviceSessions();
        this.ref_DevicePorts = new DevicePorts();
        this.m_protocol = new Protocol(0, 1054, 0, objectArray, this, new DataObject());
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)"CmdManager", (String)"Exit CmdManager Constructor");
    }

    public synchronized DataObject doOperation(DataObject dataObject) {
        int n = -1;
        String string = null;
        int n2 = 0;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)"CmdManager", (String)"Enter CmdManager.doOperation");
        n = dataObject.getProtocolKey();
        if (n == 2015) {
            this.destroy();
        } else if (dataObject.getSessionName() == null) {
            n2 = -14;
            dataObject.setError(n2);
        } else {
            string = dataObject.getSessionName();
            if (n == 2014) {
                this.handleCmdMgrPortReset();
                n2 = this.m_protocol.restartDevice();
                dataObject.setError(n2);
                if (n2 != 0) {
                    this.m_resetCmdPort = true;
                }
            } else if (n >= 2000 && n <= 2049) {
                this.handleCmdMgrPortReset();
                if (n >= 2001 && n <= 2004) {
                    if (this.m_protocol.getHeaderVersion((byte)5) != 1) {
                        n2 = -12;
                        dataObject.setError(n2);
                    } else if (this.m_protocol.getHeaderVersion((byte)6) != 1) {
                        n2 = -13;
                        dataObject.setError(n2);
                    }
                }
                if (n2 == 0) {
                    dataObject = this.m_protocol.doOperation(dataObject);
                }
                if (n2 != 0 || dataObject.getError() != 0) {
                    this.m_resetCmdPort = true;
                }
            } else {
                try {
                    Protocol protocol = this.ref_DeviceSessions.getProtocolHandleFromName(string);
                    dataObject = protocol.doOperation(dataObject);
                    n2 = dataObject.getError();
                }
                catch (NotFoundException notFoundException) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"CmdManager", (String)("CmdManager:doOperation: Can't find protocol handle from session name. Name=" + string));
                }
            }
            if (n2 == 0 && (n == 2014 || n == 2009 || n == 2010)) {
                this.handleRestart();
            }
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)"CmdManager", (String)("Exit CmdManager.doOperation. Status = " + n2));
        return dataObject;
    }

    public DeviceSessions getDeviceSessions() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)"CmdManager", (String)("Enter CmdManager.getDeviceSessions." + this.ref_DeviceSessions.dumpDeviceSessions()));
        return this.ref_DeviceSessions;
    }

    public DevicePorts getDevicePorts() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)"CmdManager", (String)("Enter CmdManager.getDevicePorts." + this.ref_DevicePorts.dumpDevicePorts()));
        return this.ref_DevicePorts;
    }

    public synchronized void closeSessionsOnPort(int n, byte by, byte by2) {
        Datagram datagram = new Datagram();
        datagram.setOpcode(by);
        datagram.setSubOpcode(by2);
        Vector vector = this.ref_DeviceSessions.getProtocolHandlesFromPort(n);
        int n2 = 0;
        while (n2 < vector.size()) {
            Protocol protocol = (Protocol)vector.elementAt(n2);
            protocol.reply(datagram);
            if (!protocol.equals(this.m_protocol)) {
                protocol.close();
            }
            ++n2;
        }
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            this.ref_DeviceSessions.deletePort(n);
            if (this.ref_DevicePorts.portExists(n)) {
                while (this.ref_DevicePorts.getPort(n).getCount() > 1) {
                    this.ref_DevicePorts.deletePort(n);
                }
                if (n != 1054) {
                    this.ref_DevicePorts.deletePort(n);
                }
            }
        }
    }

    public void destroy() {
        CssConstants cssConstants;
        Vector vector;
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            vector = this.ref_DevicePorts.getPorts();
        }
        int n = 0;
        while (n < vector.size()) {
            cssConstants = (PortInfo)vector.elementAt(n);
            int n2 = cssConstants.getPortNumber();
            this.closeSessionsOnPort(n2, (byte)-1, (byte)-40);
            ++n;
        }
        cssConstants = this.ref_DevicePorts;
        synchronized (cssConstants) {
            PortInfo portInfo = this.ref_DevicePorts.getPort(1054);
            InPort inPort = portInfo.getInPortHandle();
            inPort.terminate();
            OutPort outPort = portInfo.getOutPortHandle();
            outPort.terminate();
        }
    }

    public void handleRestart() {
        Vector vector;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CmdManager", (String)"Enter handleRestart()");
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            vector = this.ref_DevicePorts.getPorts();
        }
        int n = 0;
        while (n < vector.size()) {
            PortInfo portInfo = (PortInfo)vector.elementAt(n);
            int n2 = portInfo.getPortNumber();
            this.closeSessionsOnPort(n2, (byte)-1, (byte)-40);
            ++n;
        }
        this.m_alarm = new Alarm(15000, this);
        this.m_alarm.start();
        this.m_startResetTime = System.currentTimeMillis();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CmdManager", (String)"Exit handleRestart()");
    }

    private void handleCmdMgrPortReset() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CmdManager", (String)"Enter handleCmdMgrPortReset()");
        if (this.m_resetCmdPort) {
            this.m_resetCmdPort = false;
            DevicePorts devicePorts = this.ref_DevicePorts;
            synchronized (devicePorts) {
                this.ref_DevicePorts.deletePort(1054);
                InPort inPort = new InPort(1054, false, this);
                OutPort outPort = new OutPort(1054, false, this, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                Thread thread2 = new Thread(outPort);
                thread.start();
                thread2.start();
                this.ref_DevicePorts.addPort(1054, inPort, outPort);
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CmdManager", (String)"Exit handleCmdMgrPortReset()");
    }

    public void alarmCall(Object object) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CmdManager", (String)"Enter alarmCall()");
        try {
            this.handleCmdMgrPortReset();
            if (this.m_protocol.getHeaderVersion((byte)5) != 1) {
                String string;
                long l;
                long l2 = System.currentTimeMillis();
                if (l2 - this.m_startResetTime < (l = Long.parseLong(string = System.getProperty("css.resetwaittime", "120000")))) {
                    this.m_alarm = new Alarm(1000, this);
                    this.m_alarm.start();
                } else {
                    ScreenManager.update(false);
                }
                this.m_resetCmdPort = true;
            } else {
                ScreenManager.update(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"CmdManager", (String)("Caught exception " + exception + " while checking for device to restart"));
            ScreenManager.update(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CmdManager", (String)"Exit alarmCall()");
    }
}

