/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.NotFoundException;
import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.protocol.cmdmgr.SessionInfo;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.util.Vector;
import pnm.util.Audit;

class DeviceSessions
implements CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes {
    private Vector m_sessionList;

    public DeviceSessions() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter DeviceSessions Constructor");
        this.m_sessionList = new Vector();
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit DeviceSessions Constructor");
    }

    public Vector getSessions() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter DeviceSessions.getSessions");
        return this.m_sessionList;
    }

    public int addEntry(int n, String string, int n2, Protocol protocol) {
        SessionInfo sessionInfo;
        int n3 = 0;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.addEntry.  ID=" + n + " Name=" + string + " Port=" + n2));
        int n4 = 0;
        while (n4 < this.m_sessionList.size() && n3 == 0) {
            sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n4);
            if (sessionInfo.getID() == n) {
                n3 = -1;
            }
            ++n4;
        }
        if (n3 == 0) {
            sessionInfo = new SessionInfo(n, string, n2, protocol);
            this.m_sessionList.addElement(sessionInfo);
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)("Exit DeviceSessions.addentry. Status=" + n3));
        return n3;
    }

    public int deletePort(int n) {
        int n2 = -20;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.deletePort. Port=" + n));
        int n3 = this.m_sessionList.size() - 1;
        while (n3 >= 0) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n3);
            if (n == sessionInfo.getPortNumber() && sessionInfo.getID() != 0) {
                this.m_sessionList.removeElementAt(n3);
                n2 = 0;
            }
            --n3;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)("Exit DeviceSessions.deletePort. Status=" + n2));
        return n2;
    }

    public int deleteEntry(int n) {
        boolean bl = false;
        int n2 = 0;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.deleteEntry. ID=" + n));
        int n3 = 0;
        while (n3 < this.m_sessionList.size() && !bl) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n3);
            if (n == sessionInfo.getID()) {
                bl = true;
                this.m_sessionList.removeElementAt(n3);
            }
            ++n3;
        }
        if (!bl) {
            n2 = -20;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)("Exit DeviceSessions.deleteEntry.  Status=" + n2));
        return n2;
    }

    public Vector getProtocolHandlesFromPort(int n) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandlesFromPort. Port=" + n));
        Vector<Protocol> vector = new Vector<Protocol>();
        int n2 = 0;
        while (n2 < this.m_sessionList.size()) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n2);
            if (n == sessionInfo.getPortNumber()) {
                vector.addElement(sessionInfo.getHandle());
            }
            ++n2;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandleFromPort.");
        return vector;
    }

    public Protocol getProtocolHandle(int n) throws NotFoundException {
        Protocol protocol = null;
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandle. ID" + n));
        int n2 = 0;
        while (n2 < this.m_sessionList.size() && !bl) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n2);
            if (n == sessionInfo.getID()) {
                bl = true;
                protocol = sessionInfo.getHandle();
            }
            ++n2;
        }
        if (!bl) {
            throw new NotFoundException("No handle found in getProcotolHandle");
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandle");
        return protocol;
    }

    public Protocol getProtocolHandleFromName(String string) throws NotFoundException {
        Protocol protocol = null;
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandleFromName. Name=" + string));
        int n = 0;
        while (n < this.m_sessionList.size() && !bl) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n);
            if (sessionInfo.getName().equalsIgnoreCase(string)) {
                bl = true;
                protocol = sessionInfo.getHandle();
            }
            ++n;
        }
        if (!bl) {
            throw new NotFoundException("Protocol not found in getProtocolHandleFromName");
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandleFromName.");
        return protocol;
    }

    public int getPort(int n) {
        boolean bl = false;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.m_sessionList.size() && !bl) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(n3);
            if (n == sessionInfo.getID()) {
                bl = true;
                n2 = sessionInfo.getPortNumber();
            }
            ++n3;
        }
        return n2;
    }

    public String dumpDeviceSessions() {
        Vector vector = this.getSessions();
        String string = new String();
        int n = 0;
        while (n < vector.size()) {
            SessionInfo sessionInfo = (SessionInfo)vector.elementAt(n);
            string = string + new String("Session Name = " + sessionInfo.getName() + " Session ID = " + sessionInfo.getID() + " Port Number = " + sessionInfo.getPortNumber());
            ++n;
        }
        return string;
    }
}

