/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DatagramQueue;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.PortInfo;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import pnm.util.Audit;

class InPort
implements Runnable,
CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes {
    private DatagramPacket m_datagramPacket;
    private DatagramSocket m_ackDatagramSocket;
    private DatagramSocket m_datagramSocket;
    private InputStream m_inputStream;
    private boolean m_keepAlives;
    private boolean m_remainActive;
    private CmdManager m_manager;
    private byte[] buffer = new byte[2048];
    private DatagramQueue m_datagramQueue;
    private int m_sourcePort;
    private int m_destPort;
    private OutPort ackPort = null;

    InPort(int n, boolean bl, CmdManager cmdManager) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter InPort");
        try {
            this.m_keepAlives = bl;
            this.m_remainActive = true;
            try {
                this.m_datagramSocket = new DatagramSocket(n);
            }
            catch (Exception exception) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("InPort: Port could be in Use. General Exception. " + exception));
                if (this.m_datagramSocket != null) {
                    this.m_datagramSocket.close();
                }
                this.m_datagramSocket = new DatagramSocket();
            }
            if (this.m_keepAlives) {
                this.m_datagramSocket.setSoTimeout(15000);
            }
            this.m_datagramQueue = new DatagramQueue(cmdManager);
            Thread thread = new Thread(this.m_datagramQueue);
            thread.start();
            this.m_manager = cmdManager;
            this.m_sourcePort = this.m_datagramSocket.getLocalPort();
            this.m_destPort = n;
            this.m_ackDatagramSocket = new DatagramSocket();
            this.ackPort = new OutPort(this.m_destPort, false, cmdManager, this.m_ackDatagramSocket);
            Thread thread2 = new Thread(this.ackPort);
            thread2.start();
        }
        catch (SocketException socketException) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("InPort: Socket Creation Error. " + socketException));
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("InPort: Thread Already Exists. " + illegalThreadStateException));
        }
        catch (Exception exception) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("InPort: General Exception. " + exception));
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit InPort.");
    }

    public void run() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter InPort:run.");
        DevicePorts devicePorts = this.m_manager.getDevicePorts();
        try {
            while (this.m_remainActive) {
                block13: {
                    this.m_datagramPacket = new DatagramPacket(this.buffer, this.buffer.length);
                    try {
                        this.m_datagramSocket.receive(this.m_datagramPacket);
                    }
                    catch (IOException iOException) {
                        if (!this.m_keepAlives) {
                            try {
                                this.m_datagramSocket.setSoTimeout(0);
                            }
                            catch (SocketException socketException) {
                                System.out.println("Inport Run: Exception occured " + socketException);
                            }
                        }
                        if (this.m_destPort != 1054) {
                            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"InPort:run: No More Keep Alives.");
                            this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-16);
                            this.m_remainActive = false;
                        }
                        devicePorts = this.m_manager.getDevicePorts();
                        PortInfo portInfo = devicePorts.getPort(this.m_destPort);
                        if (portInfo == null || portInfo.getCount() <= 1) break block13;
                        this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-16);
                    }
                }
                if (this.m_keepAlives) {
                    try {
                        this.m_datagramSocket.setSoTimeout(15000);
                    }
                    catch (SocketException socketException) {
                        System.out.println("INPORT: Run Exception occured " + socketException);
                    }
                }
                Datagram datagram = new Datagram();
                datagram.unpack(this.m_datagramPacket.getData());
                byte[] byArray = new byte[this.m_datagramPacket.getLength()];
                byArray = this.m_datagramPacket.getData();
                if (datagram.getOpcode() == 0 && datagram.getSubOpcode() == 0) continue;
                if ((datagram.getProtocolFlags() & 2) != 0) {
                    Datagram datagram2 = new Datagram(datagram.getSessionType(), datagram.getSessionID(), 1, datagram.getProtocolSequenceNumber());
                    datagram2.setProtocolFlags((short)0);
                    datagram2.setProtocolSequenceNumber(datagram.getProtocolSequenceNumber());
                    datagram2.setSessionFlags((short)0);
                    this.ackPort.sendDatagram(datagram2);
                }
                this.m_datagramQueue.addDatagram(datagram);
            }
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("InPort:run: General Exception." + exception.toString()));
            this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-17);
            this.m_remainActive = false;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit InPort:run.");
    }

    public void terminate() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter InPort.terminate");
        this.ackPort.terminate();
        this.m_remainActive = false;
        this.m_datagramQueue.terminateQueueThread();
        this.m_ackDatagramSocket.close();
        this.m_datagramSocket.close();
    }

    public void setKeepAlives(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)("Enter InPort.setKeepAlives.  Setting=" + bl));
        this.m_keepAlives = bl;
    }

    public DatagramSocket getDatagramSocket() {
        return this.m_datagramSocket;
    }

    public DatagramQueue getDatagramQueue() {
        return this.m_datagramQueue;
    }

    public int getSourcePort() {
        return this.m_sourcePort;
    }
}

