/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.connection.ConnectionInfo;
import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.LinkedList;
import pnm.util.Audit;

public class OutPort
implements CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes,
Runnable {
    DatagramPacket ref_DatagramPacket;
    DatagramSocket ref_DatagramSocket;
    Datagram ref_Datagram;
    private boolean m_remainActive = true;
    private boolean m_keepAlives;
    private int m_port;
    private CmdManager m_manager;
    private LinkedList m_OutportQueue = new LinkedList();
    private InetAddress m_ipAddress;

    public OutPort(int n, boolean bl, CmdManager cmdManager, DatagramSocket datagramSocket) {
        try {
            Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter OutPort Constructor");
            this.m_ipAddress = InetAddress.getByName(ConnectionInfo.getDeviceIpAddress());
            this.m_port = n;
            this.m_keepAlives = bl;
            this.ref_Datagram = new Datagram();
            this.ref_DatagramSocket = datagramSocket;
            this.m_manager = cmdManager;
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("OutPort: General Exception. " + exception));
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit OutPort Constructor.");
    }

    public void run() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter OutPort:run");
        while (this.m_remainActive) {
            try {
                OutPort outPort = this;
                synchronized (outPort) {
                    try {
                        Thread.yield();
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"OutPort:run:Wait timer expired.");
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)illegalMonitorStateException.toString());
                    }
                }
                if (this.m_keepAlives) {
                    this.sendKeepAlive();
                }
                if (this.m_OutportQueue.isEmpty()) continue;
                byte[] byArray = (byte[])this.m_OutportQueue.removeFirst();
                this.ref_DatagramPacket = new DatagramPacket(byArray, byArray.length, this.m_ipAddress, this.m_port);
                this.ref_DatagramSocket.send(this.ref_DatagramPacket);
                OutPort outPort2 = this;
                synchronized (outPort2) {
                    try {
                        this.notify();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)illegalMonitorStateException.toString());
                        this.m_remainActive = false;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"OutPort:run:Bad argument in method call.");
            }
            catch (NullPointerException nullPointerException) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"OutPort:run:Trying to write a null pointer.");
            }
            catch (IOException iOException) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"OutPort:run:AN IO error occurred.");
            }
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit OutPort:run.");
    }

    public int sendKeepAlive() {
        int n = 0;
        byte[] byArray = null;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter sendKeepAlive");
        this.ref_Datagram.setProtocolFlags((short)0);
        this.ref_Datagram.setProtocolSequenceNumber((byte)0);
        this.ref_Datagram.setSessionID((byte)0);
        this.ref_Datagram.setSessionFlags((short)0);
        this.ref_Datagram.setOpcode((byte)0);
        this.ref_Datagram.setSubOpcode((byte)0);
        byArray = this.ref_Datagram.pack();
        try {
            this.ref_DatagramPacket = new DatagramPacket(byArray, byArray.length, this.m_ipAddress, this.m_port);
            this.ref_DatagramSocket.send(this.ref_DatagramPacket);
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.toString(), (String)"OutPort:sendKeepAlive:An IO error occurred.");
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit sendKeepAlive.");
        return n;
    }

    public void terminate() {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter OutPort:terminate");
        this.m_remainActive = false;
        this.m_keepAlives = false;
        this.ref_DatagramSocket.close();
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit OutPort:terminate");
    }

    public synchronized int sendDatagram(Datagram datagram) {
        int n = 0;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter sendDatagram");
        try {
            this.m_OutportQueue.add(datagram.pack());
            this.notify();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)"sendDatagram:Current thread is not the owner of the object's monitor.");
            n = -5;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit sendDatagram.");
        return n;
    }

    public void setKeepAlives(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter OutPort:setKeepAlives");
        this.m_keepAlives = bl;
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit OutPort:setKeepAlives.");
    }
}

