/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.appservices.cs.ConnectionService;
import css.core.appservices.das.SnmpEngineUtilities;
import css.core.util.CssConstants;
import css.device.common.screens.CommonVlanScreen;
import css.device.common.screens.GenericScreenMaker;
import java.util.StringTokenizer;
import pnm.util.Audit;

public class CommonNewVlanScreenMaker
extends GenericScreenMaker {
    private static final String FILE = "CommonNewVlanScreenMaker";
    private static final String NMA_FEATURE_BITMAP_OID = ".1.3.6.1.4.1.161.3.5.9.3";

    public CommonNewVlanScreenMaker() {
        boolean bl = this.checkIfNewVlanSupported();
        this.m_screenName = "Vlan Screen";
        CommonVlanScreen commonVlanScreen = new CommonVlanScreen();
        this.m_gui = commonVlanScreen;
        this.m_screenSize_X = 300;
        this.m_screenSize_Y = 175;
        this.m_handle = this;
        this.m_cmdHandlerRulesTable = bl ? new Object[][]{{new Integer(103), new String[]{"nmaVLanNumberActual", "nmaVLanCount"}, new String[]{"Integer", "Integer"}, new Integer(1004)}, {new Integer(101), new String[]{"nmaAgentState"}, new String[]{"Integer[]"}, new Integer(1006)}, {new Integer(102), new String[]{"nmaVLanNumberRequested"}, new String[]{"int"}, new Integer(1005)}} : new Object[][]{{new Integer(103), new String[]{"vlanNumberActual", "vlanCount"}, new String[]{"Integer", "Integer"}, new Integer(1004)}, {new Integer(101), new String[]{"nmaAgentState"}, new String[]{"Integer[]"}, new Integer(1006)}, {new Integer(102), new String[]{"vlanNumberRequested"}, new String[]{"int"}, new Integer(1005)}};
        this.m_guiListenerRulesTable = new Object[][]{{"INI", new Integer(103), null, null, null, null}, {"m_okBtn", new Integer(101), null, null, "m_window.lockWindow", null}, {"m_okBtn", new Integer(102), new Boolean(true), "userRequest", "getVlanNumber", null}};
        this.m_guiUpdaterRulesTable = new Object[][]{{new Integer(103), "updateCurrentVlanNumber", new String[]{"-1"}}, {new Integer(101), "updateAgentState", new String[]{"-1"}}, {new Integer(102), "updateVlanNumber", new String[]{"-2"}}};
    }

    private boolean checkIfNewVlanSupported() {
        boolean bl;
        block6: {
            bl = false;
            String string = null;
            String string2 = null;
            Long l = null;
            Long l2 = null;
            Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter checkIfNewVlanSupported()");
            String string3 = ConnectionService.getIPAddress();
            string = SnmpEngineUtilities.getSnmpValue((String)string3, (String)NMA_FEATURE_BITMAP_OID);
            if (string != null) {
                string.trim();
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = string;
                        string = stringTokenizer.nextToken();
                    }
                    if (string2 == null) break block6;
                    l = new Long(Long.parseLong(string2, 16));
                    l2 = new Long(Long.parseLong("1", 16));
                    if ((l.byteValue() & l2.byteValue()) == 1) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Exception thrown while trying to get the Feature BitMap: " + exception));
                }
            } else {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"Null returned when getting Feature Bitmap");
            }
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)("Exit checkIfNewVlanSupported() supported = " + bl));
        return bl;
    }
}

