/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.CmdHandler;
import css.core.service.DataObject;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.DateAndTimeConversion;
import css.core.util.ErrorLogUtilities;
import css.core.util.component.GenericListener;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.util.ErrorLogsDataHandler;
import css.device.common.util.StatusReportTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class CommonStatusReportPanel
extends GenericScreen {
    private static final String FILE = "CommonStatusReportPanel";
    private final String LOCAL_ERRORLOG_FILE = "errorlog.xml";
    private final String SCREEN_DISPLAY_UNDEFINED_VALUE = "Error!";
    private final int FTP_TRANSFER_PROTOCOL = 1;
    private final int PULL_PROTOCOL_DIRECTION = 1;
    private final int COMPRESSION_TYPE_NONE = 1;
    private final int INTERNAL = 1;
    private final int EXTERNAL = 2;
    private final int IDLE = 1;
    private final int BUILDING = 2;
    private final int BUILDCOMPLETE = 4;
    private final int TRANSFERING = 8;
    private final int TRANSFERCOMPLETE = 16;
    private final int CLEARING = 32;
    private final int CLEARED = 64;
    private final int FAILURE = 128;
    private final int DEVICE_AGENT_STATE_IDLE = 1;
    private final int DEVICE_AGENT_STATE_BUILDING = 2;
    private final int DEVICE_AGENT_STATE_BUILDCOMPLETE = 3;
    private final int DEVICE_AGENT_STATE_TRANSFERING = 4;
    private final int DEVICE_AGENT_STATE_TRANSFERCOMPLETE = 5;
    private final int DEVICE_AGENT_STATE_CLEARING = 6;
    private final int DEVICE_AGENT_STATE_CLEARED = 7;
    private final int DEVICE_AGENT_STATE_FAILURE = 8;
    private final int DEVICE_ERRORLOG_BUILD_CMD = 1;
    private final int DEVICE_ERRORLOG_TRANSFER_CMD = 2;
    private final int DEVICE_ERRORLOG_CLEAR_CMD = 3;
    private final int DEVICE_ERRORLOG_IDLE_CMD = 4;
    private final String TABLE_TITLE = " ";
    private final String INT_REPORT_MSG = "Selected Report Type Is Not Viewable. Click Save Report Button To Save To File";
    private static ErrorPopup m_errorPopup = new ErrorPopup();
    private Object m_actionListener;
    public GenericListener m_genericListener;
    public String m_userLogFileName;
    private boolean m_protocolSupported = false;
    private int m_protocolXferIndex;
    private int m_currSelectedLog = 0;
    private String[] m_fileName;
    private Integer[] m_fileParseType;
    private Integer[] m_translationFileIndex;
    private Integer[] m_fileCompression;
    private Integer[] m_fileProtocolXferIndex;
    private boolean m_errorLogProcessStatus = true;
    private JPanel m_reportInfoPanel = new JPanel();
    private JPanel m_centerPanel = new JPanel();
    private JPanel m_reportBtnPanel = new JPanel();
    private JLabel m_dateTimeLbl = new JLabel();
    private JLabel m_dateTimeLblValue = new JLabel();
    private JLabel m_typeOfStatusReportLbl = new JLabel();
    private JComboBox m_typeOfStatusReportCbBox = new JComboBox();
    private JLabel m_tableTitleLbl = new JLabel();
    private ActionListener m_reportTypeHandlerAction = new ReportTypeHandler();
    private JScrollPane tablePane = new JScrollPane();
    private JTable m_reportTable = null;
    private StatusReportTableModel m_statusReportTblMdl = null;
    public JButton m_refreshBtn = new JButton();
    public JButton m_saveLogBtn = new JButton();
    public JButton m_clearLogBtn = new JButton();
    public JButton m_clearIntLogBtn = new JButton();
    public JButton m_clearExtLogBtn = new JButton();
    public JButton m_saveIntLogBtn = new JButton();
    public JButton m_saveExtLogBtn = new JButton();
    private ProgressMonitor m_statusReportProgressMonitor;
    private int m_progress = 0;
    private boolean m_abort = false;
    private Hashtable m_reportTypeHashtable = new Hashtable();

    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreeng_window=" + object + "g_statusBarListener =" + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonStatusReportPanel.this);
                CommonStatusReportPanel.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        this.m_window.getContentPane().add("Center", this);
        this.m_reportInfoPanel.setLayout(new GridBagLayout());
        this.m_dateTimeLbl.setText("Report Date/Time");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_dateTimeLbl, gridBagConstraints);
        this.m_dateTimeLblValue.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_dateTimeLblValue, gridBagConstraints);
        this.m_typeOfStatusReportLbl.setText("Report Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_typeOfStatusReportLbl, gridBagConstraints);
        this.m_typeOfStatusReportCbBox.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_typeOfStatusReportCbBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_reportInfoPanel, gridBagConstraints);
        this.m_centerPanel.setLayout(new GridBagLayout());
        this.m_tableTitleLbl.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_centerPanel.add((Component)this.m_tableTitleLbl, gridBagConstraints);
        this.m_statusReportTblMdl = null;
        this.m_reportTable = new JTable();
        this.m_reportTable.setAutoResizeMode(0);
        this.m_reportTable.setShowHorizontalLines(true);
        this.m_reportTable.setShowVerticalLines(true);
        JScrollPane jScrollPane = new JScrollPane(this.m_reportTable);
        jScrollPane.setPreferredSize(new Dimension(380, 160));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.m_centerPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.m_centerPanel, gridBagConstraints);
        this.m_reportBtnPanel.setLayout(new GridBagLayout());
        this.m_saveLogBtn.setText("Save Report");
        this.m_saveLogBtn.setActionCommand("Save Report");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_saveLogBtn, gridBagConstraints);
        this.m_refreshBtn.setText("Refresh");
        this.m_refreshBtn.setActionCommand("Refresh");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_refreshBtn, gridBagConstraints);
        this.m_clearLogBtn.setText("Clear Report");
        this.m_clearLogBtn.setActionCommand("Clear Report");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_clearLogBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_reportBtnPanel, gridBagConstraints);
        this.m_genericListener = new GenericListener();
        this.m_dateTimeLbl.setToolTipText("Date/Time the current report was received from the station");
        this.m_typeOfStatusReportLbl.setToolTipText("Type of status report to be displayed");
        this.m_saveLogBtn.setToolTipText("Saves the report to the file specified by the user");
        this.m_refreshBtn.setToolTipText("Reread the report");
        this.m_clearLogBtn.setToolTipText("Deletes this report log from the station");
        statusBarListener.registerComponent((Component)this.m_saveLogBtn, "Click this button to save the report to a file");
        statusBarListener.registerComponent((Component)this.m_refreshBtn, "Click this button to get the same type of report again");
        statusBarListener.registerComponent((Component)this.m_clearLogBtn, "Click this button to delete this report log from the station");
        this.m_typeOfStatusReportCbBox.setNextFocusableComponent(this.m_reportTable);
        this.m_reportTable.setNextFocusableComponent(this.m_saveLogBtn);
        this.m_saveLogBtn.setNextFocusableComponent(this.m_refreshBtn);
        this.m_refreshBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_clearLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_saveIntLogBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_saveExtLogBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_clearIntLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_clearExtLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_typeOfStatusReportCbBox.requestFocus();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.m_typeOfStatusReportCbBox.removeActionListener(this.m_reportTypeHandlerAction);
        this.m_typeOfStatusReportCbBox.removeAllItems();
        this.enableReportTable();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateScreenDateTime(int n, Integer n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateScreenDateTime(): g_error = " + n + " g_dateTime = " + n2));
        if (n == 0) {
            int n3 = n2;
            this.m_dateTimeLblValue.setText(DateAndTimeConversion.getDate((int)n3) + " " + DateAndTimeConversion.getTime((int)n3));
        } else {
            this.m_dateTimeLblValue.setText("N/A");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateScreenDateTime()");
    }

    void abortProcess(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter abortProcess(): g_error = " + n));
        this.m_errorLogProcessStatus = false;
        if (n == -196708) {
            m_errorPopup.display(-262166);
        } else if (n == -262180) {
            m_errorPopup.display(-262180);
        } else if (n >= -131071 && n <= -65536) {
            m_errorPopup.display(-262176);
        } else if (n >= -262182 && n <= -262166) {
            m_errorPopup.display(n);
        } else if (n >= -196608 && n <= -196708) {
            m_errorPopup.display(-262181);
        } else {
            m_errorPopup.display(-262182);
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unknown Error Recieved: g_error #" + n));
        }
        this.m_statusReportProgressMonitor.close();
        this.enableActionComponents();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit abortProcess()");
    }

    void disableActionComponents() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter disableActionComponents()");
        this.m_typeOfStatusReportCbBox.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        this.m_saveLogBtn.setEnabled(false);
        this.m_clearLogBtn.setEnabled(false);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit disableActionComponents()");
    }

    void enableActionComponents() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter enableActionComponents()");
        this.m_typeOfStatusReportCbBox.setEnabled(true);
        this.m_saveLogBtn.setEnabled(true);
        this.m_clearLogBtn.setEnabled(true);
        if (this.m_reportTable.isEnabled()) {
            this.m_refreshBtn.setEnabled(true);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit enableActionComponents()");
    }

    private void updateProgress(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateProgress(): arguments - g_progress= " + n));
        if (this.m_errorLogProcessStatus) {
            this.m_statusReportProgressMonitor.setProgress(n);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateProgress()");
    }

    private void updateProgress(int n, String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateProgress(): arguments - g_progress= " + n + ", g_note= " + string));
        if (this.m_errorLogProcessStatus) {
            this.m_statusReportProgressMonitor.setProgress(n);
            this.m_statusReportProgressMonitor.setNote(string);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateProgress()");
    }

    private void disableEntireScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter disableEntireScreen()");
        this.m_typeOfStatusReportCbBox.setEnabled(false);
        this.m_reportTable.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        this.m_saveLogBtn.setEnabled(false);
        this.m_clearLogBtn.setEnabled(false);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit disableEntireScreen()");
    }

    private void disableReportTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter disableReportTable()");
        this.m_reportTable.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit disableReportTable()");
    }

    private void enableReportTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter enableReportTable()");
        if (!this.m_reportTable.isEnabled()) {
            this.m_reportTable.setEnabled(true);
        }
        this.m_refreshBtn.setEnabled(true);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit enableReportTable()");
    }

    private void clearTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter clearTable()");
        String string = " ";
        if (this.isReportTypeExternal()) {
            this.m_tableTitleLbl.setText(" ");
        }
        try {
            this.m_statusReportTblMdl = StatusReportTableModel.ClearTable((StatusReportTableModel)this.m_reportTable.getModel());
            this.m_reportTable.setModel(this.m_statusReportTblMdl);
            int n = ((StatusReportTableModel)this.m_reportTable.getModel()).getColumnCount();
            String[] stringArray = new String[n];
            stringArray = ((StatusReportTableModel)this.m_reportTable.getModel()).getColumsArray();
            int n2 = 0;
            while (n2 < n) {
                TableColumn tableColumn = this.m_reportTable.getColumnModel().getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                    ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(stringArray[n2]);
                }
                if ((string = tableColumn.getHeaderValue().toString()).equals("Occurrence Time")) {
                    tableColumn.setMinWidth(155);
                    tableColumn.setPreferredWidth(155);
                    tableColumn.setMinWidth(155);
                } else if (string.equals("Description")) {
                    tableColumn.setMinWidth(290);
                    tableColumn.setPreferredWidth(290);
                    tableColumn.setMinWidth(290);
                } else {
                    tableColumn.setMinWidth(70);
                    tableColumn.setPreferredWidth(70);
                    tableColumn.setMinWidth(70);
                }
                ++n2;
            }
            JTableHeader jTableHeader = this.m_reportTable.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to set up table " + exception.getMessage()));
        }
        this.m_reportTable.repaint();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit clearTable()");
    }

    private int getScreenSelectedErrorLog() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getScreenSelectedErrorLog()");
        int n = this.m_typeOfStatusReportCbBox.getSelectedIndex();
        if (n >= 0) {
            ++n;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getScreenSelectedErrorLog(): Selected index = " + n));
        return n;
    }

    private boolean isAgentStateEqualsTo(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter isAgentStateEqualsTo(): g_state = " + n));
        int n2 = -1;
        DataObject dataObject = null;
        Object[] objectArray = new Object[2];
        objectArray[0] = "." + this.getScreenSelectedErrorLog();
        while (!this.m_statusReportProgressMonitor.isCanceled() && this.m_errorLogProcessStatus) {
            try {
                CmdHandler cmdHandler = this.m_screenMaker.getCmdHandler();
                dataObject = cmdHandler.processSyncRequest(4, objectArray);
                if (dataObject.getError() == 0) {
                    dataObject.convertAllTypeToDefault();
                    if (dataObject.getError() == 0) {
                        int n3;
                        n2 = Integer.parseInt((String)dataObject.getParameterValue(1));
                        if (n2 > 0 && ((n3 = 1 << n2 - 1) & n) > 0) break;
                        if (n2 == 8) {
                            this.deviceAgentStateFailure(n2);
                            continue;
                        }
                        if (n2 > 0) {
                            Thread.sleep(1500L);
                            continue;
                        }
                        this.abortProcess(-262179);
                        continue;
                    }
                    this.abortProcess(-262177);
                    continue;
                }
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("isAgentStateEqualsTo: error in dataobject " + dataObject));
                this.abortProcess(dataObject.getError());
            }
            catch (NumberFormatException numberFormatException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("isAgentStateEqualsTo: error NumberFormatException " + numberFormatException));
                this.abortProcess(-262177);
            }
            catch (Exception exception) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("isAgentStateEqualsTo: generic Exception " + exception));
                this.abortProcess(-262177);
            }
        }
        if (this.m_statusReportProgressMonitor.isCanceled()) {
            if (this.m_typeOfStatusReportCbBox.getSelectedItem().toString().equalsIgnoreCase("Technician")) {
                this.m_refreshBtn.setEnabled(true);
            }
            this.m_genericListener.notifyGuiListener();
        }
        boolean bl = this.m_errorLogProcessStatus && !this.m_statusReportProgressMonitor.isCanceled();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isAgentStateEqualsTo(): return value = " + bl));
        return bl;
    }

    private void deviceAgentStateFailure(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter deviceAgentStateFailure()");
        if (n == 8) {
            this.abortProcess(-262170);
        } else if (n == 3) {
            this.abortProcess(-262178);
        } else if (n == 4) {
            this.abortProcess(-262172);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit deviceAgentStateFailure(): return = " + n));
    }

    public boolean isAgentStateIdle() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isAgentStateIdle()");
        boolean bl = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 100, "Checking if device is ready...");
            bl = this.isAgentStateEqualsTo(213);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isAgentStateIdle(): return = " + bl));
        return bl;
    }

    public boolean startProcessStatus() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startProcessStatus()");
        this.m_window.unlockWindow();
        this.m_statusReportProgressMonitor = new ProgressMonitor(this, "Report Processing Status", "", 0, 2500);
        this.m_statusReportProgressMonitor.setMillisToDecideToPopup(0);
        this.m_statusReportProgressMonitor.setMillisToPopup(0);
        this.m_statusReportProgressMonitor.setNote("Getting Report Information from device..");
        this.m_progress = 5;
        this.m_statusReportProgressMonitor.setProgress(this.m_progress);
        this.disableActionComponents();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startProcessStatus()");
        this.m_errorLogProcessStatus = true;
        return true;
    }

    public Object[] getIdleCmdArguments() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getIdleCmdArguments()");
        Object[] objectArray = new Object[]{"." + this.getScreenSelectedErrorLog(), String.valueOf(4)};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getIdleCmdArguments(): values = " + objectArray));
        return objectArray;
    }

    public void idleCmdUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter IdleCmdUpdate(): g_error = " + n));
        if (n != 0) {
            this.abortProcess(-262175);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit getIdleCmdArguments()");
    }

    public void updateScreenDeviceXferTypeTable(int n, Integer[] integerArray, Integer[] integerArray2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateScreenDeviceXferTypeTable(): g_error = " + n + " g_xferTypeProtocol = " + integerArray + " g_xferTypeDirection = " + integerArray2));
        this.m_protocolSupported = false;
        if (n == 0) {
            try {
                int n2 = 0;
                while (n2 < integerArray.length) {
                    if (integerArray[n2] == 1 && integerArray2[n2] == 1) {
                        this.m_protocolXferIndex = n2 + 1;
                        this.m_protocolSupported = true;
                        break;
                    }
                    ++n2;
                }
                this.m_errorLogProcessStatus = this.m_protocolSupported;
                if (!this.m_protocolSupported) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"Device does not support FTP and Pull protocol");
                    this.abortProcess(-262168);
                }
            }
            catch (Exception exception) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Encountered " + exception.toString() + " when trying to " + "process the Log File Transfer Type Table"));
                this.m_errorLogProcessStatus = false;
                this.m_protocolSupported = false;
                this.abortProcess(-262167);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Received error code " + n + " while trying to get the Log File Transfer Type Table information"));
            this.m_errorLogProcessStatus = false;
            this.abortProcess(n);
        }
        if (!this.m_protocolSupported) {
            this.disableEntireScreen();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateScreenDeviceXferTypeTable()");
    }

    public boolean isDeviceFtpPullProtocolSupported() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter/Exit isDeviceFtpPullProtocolSupported(): return value = " + this.m_protocolSupported));
        this.updateProgress(this.m_progress += 100);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isDeviceFtpPullProtocolSupported() - arguments: m_protocolSupported= " + this.m_protocolSupported));
        return this.m_protocolSupported;
    }

    public void updateDeviceSupportedErrorLogs(int n, String[] stringArray, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, String[] stringArray2, Integer n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateDeviceSupportedErrorLogs(): g_fileName = " + stringArray + " g_fileParseType = " + integerArray + " g_translationFileIndex = " + integerArray2 + " g_fileCompression = " + integerArray3 + " g_fileProtocolXferIndex = " + integerArray4 + " g_fileTypeName = " + stringArray2 + " g_numOfEntries = " + n2));
        if (n == 0) {
            this.m_fileName = stringArray;
            this.m_fileParseType = integerArray;
            this.m_translationFileIndex = integerArray2;
            this.m_fileCompression = integerArray3;
            this.m_fileProtocolXferIndex = integerArray4;
            try {
                int n3 = -1;
                int n4 = 0;
                while (n4 < this.m_fileParseType.length) {
                    if (this.m_fileParseType[n4] == 2 && this.m_fileProtocolXferIndex[n4] == this.m_protocolXferIndex) {
                        n3 = n4;
                        this.m_currSelectedLog = n4 + 1;
                        break;
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    this.m_typeOfStatusReportCbBox.addItem(stringArray2[n5]);
                    ++n5;
                }
                if (n3 == -1) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"Unable to find an External log type with supported protocol");
                    this.abortProcess(-262168);
                    this.disableReportTable();
                    this.m_currSelectedLog = 1;
                    this.m_typeOfStatusReportCbBox.setSelectedIndex(0);
                } else {
                    this.m_typeOfStatusReportCbBox.setSelectedIndex(n3);
                    this.m_tableTitleLbl.setText(" ");
                }
                this.m_typeOfStatusReportCbBox.addActionListener(this.m_reportTypeHandlerAction);
            }
            catch (Exception exception) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Encountered " + exception.toString() + " when processing the Log File Download Table data"));
                this.abortProcess(-262167);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Get Log File Download Table return error " + n));
            this.abortProcess(n);
        }
        this.updateProgress(this.m_progress += 100);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateDeviceSupportedErrorLogs()");
    }

    public Object[] getBuildCmdArguments() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getBuildCmdArguments()");
        this.updateProgress(this.m_progress += 100, "Building report. Please wait..");
        Object[] objectArray = new Object[]{"." + this.getScreenSelectedErrorLog(), String.valueOf(1)};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getBuildCmdArguments(): return = " + objectArray));
        return objectArray;
    }

    public void buildCmdUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildCmdUpdate(): g_error = " + n));
        if (n == 0) {
            this.updateProgress(this.m_progress += 100);
        } else {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Send build command returned error " + n));
            this.abortProcess(n);
            this.m_genericListener.notifyGuiListener();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildCmdUpdate()");
    }

    public Object[] getTransferCmdArguments() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getTransferCmdArgument()");
        this.updateProgress(this.m_progress += 100, "Initialize file transfer. Please Wait..");
        Object[] objectArray = new Object[]{"." + this.getScreenSelectedErrorLog(), String.valueOf(2)};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getTransferCmdArgument(): return = " + objectArray));
        return objectArray;
    }

    public void transferCmdUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter transferCmdUpdate(): g_error = " + n));
        if (n == 0) {
            this.updateProgress(this.m_progress += 200);
        } else {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Send transfer command returned error " + n));
            this.abortProcess(n);
            this.m_genericListener.notifyGuiListener();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit transferCmdUpdate()");
    }

    public boolean isAgentStateBuildComplete() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isAgentStateBuildComplete()");
        this.updateProgress(this.m_progress += 100);
        boolean bl = this.isAgentStateEqualsTo(4);
        if (bl) {
            this.updateProgress(this.m_progress += 100, "Build process completed..");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isAgentStateBuildComplete(): return = " + bl));
        return bl;
    }

    public boolean isAgentStateTransfering() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isAgentStateTransfering()");
        boolean bl = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 100);
            bl = this.isAgentStateEqualsTo(8);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isAgentStateTransfering(): return = " + bl));
        return bl;
    }

    public Object[] getDeviceFilePath() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getDeviceFilePath()");
        Object[] objectArray = null;
        int n = this.getScreenSelectedErrorLog();
        this.updateProgress(this.m_progress += 700, "Transferring report...");
        if (n > 0) {
            objectArray = new Object[]{this.isReportTypeExternal() ? "errorlog.xml" : this.m_userLogFileName, this.m_fileName[n - 1]};
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getDeviceFilePath(): return = " + objectArray[0] + " " + objectArray[1]));
        return objectArray;
    }

    public void ftpGetErrorLogUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter ftpGetErrorLogUpdate(): g_error = " + n));
        int n2 = 0;
        if (n == 0) {
            this.updateProgress(this.m_progress + 600, "Transfer complete...");
            if (this.isReportTypeExternal()) {
                n2 = this.populateErrorLogTable("errorlog.xml");
                if (n2 != 0) {
                    if (n2 == -100) {
                        while (n2 == -100) {
                            n2 = this.populateErrorLogTable("errorlog.xml");
                        }
                        m_errorPopup.display("Some entries not translated. Update DTD file.");
                    } else {
                        this.abortProcess(-262174);
                        this.m_tableTitleLbl.setText(" ");
                    }
                } else {
                    this.m_tableTitleLbl.setText(" ");
                }
            }
            this.updateProgress(this.m_progress + 2000);
            this.enableActionComponents();
        } else {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("FTP Get command returned error " + n));
            this.abortProcess(n);
            this.m_genericListener.notifyGuiListener();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit ftpGetErrorLogUpdate()");
    }

    public boolean confirmClearLogs() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter confirmClearLogs()");
        boolean bl = false;
        ConfirmationPopup confirmationPopup = new ConfirmationPopup();
        confirmationPopup.display("Do You Really Wish To Clear This Log From The Device?");
        bl = confirmationPopup.getStatus();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit confirmClearLogs(): return = " + bl));
        return bl;
    }

    void resetProgressBar() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter resetProgressBar()");
        this.m_statusReportProgressMonitor = new ProgressMonitor(this, "Report Processing Status", "", 0, 2500);
        this.m_statusReportProgressMonitor.setMillisToDecideToPopup(30);
        this.m_statusReportProgressMonitor.setMillisToPopup(0);
        this.m_statusReportProgressMonitor.setNote("Getting Report Information from device..");
        this.m_progress = 20;
        this.updateProgress(20);
        this.m_errorLogProcessStatus = true;
        this.disableActionComponents();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit resetProgressBar()");
    }

    public Object[] startLogProcess() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startLogProcess()");
        Object[] objectArray = new Object[]{"." + this.getScreenSelectedErrorLog(), null};
        this.resetProgressBar();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit startLogProcess(): values = " + objectArray));
        return objectArray;
    }

    public Object[] getClearLogCmdArguments() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getClearLogCmdArguments()");
        Object[] objectArray = new Object[]{"." + this.getScreenSelectedErrorLog(), String.valueOf(3)};
        this.updateProgress(this.m_progress += 300, "Clearing report from device..");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getClearLogCmdArguments(): values = " + objectArray));
        return objectArray;
    }

    public void clearCommandUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter clearCommandUpdate(): g_error = " + n));
        if (n == 0) {
            this.updateProgress(this.m_progress += 500);
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Send clear command returned error " + n));
            this.abortProcess(n);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit getClearLogCmdArguments()");
    }

    public boolean isAgentStateCleared() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isAgentStateCleared()");
        boolean bl = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 300, "Clearing Log ...");
            bl = this.isAgentStateEqualsTo(64);
            this.updateProgress(this.m_progress += 800, "Clearing Log ...");
            this.clearTable();
        }
        this.enableActionComponents();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit getClearLogCmdArguments()");
        return bl;
    }

    public void clearLogIdleCmdUpdate(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter clearLogIdleCmdUpdate(): g_error = " + n));
        if (n == 0) {
            this.updateProgress(this.m_progress += 2000);
        } else {
            this.abortProcess(n);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit clearLogIdleCmdUpdate()");
    }

    public void startProcessUpdate(int n, Integer n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter startProcessUpdate(): g_error = " + n + " g_agentState = " + n2));
        if (n == 0) {
            int n3 = n2;
            if (n3 == 2 || n3 == 6 || n3 == 4) {
                this.abortProcess(-262173);
            }
        } else {
            this.abortProcess(n);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startProcessUpdate()");
    }

    public boolean isFileNameSelected() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isFileNameSelected()");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir", "."));
        int n = jFileChooser.showSaveDialog((Component)this.m_window);
        if (n == 0) {
            this.m_userLogFileName = jFileChooser.getSelectedFile().getPath();
            File file = new File(this.m_userLogFileName);
            if (!CSSUtilities.isValidLogFile((File)file, (ErrorPopup)m_errorPopup)) {
                return false;
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit isFileNameSelected()");
        return n == 0;
    }

    public boolean writeLogToFile() {
        File file;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter writeLogToFile()");
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir", "."));
        int n = jFileChooser.showSaveDialog((Component)this.m_window);
        if (n == 0 && CSSUtilities.isValidLogFile((File)(file = new File(jFileChooser.getSelectedFile().getPath())), (ErrorPopup)m_errorPopup)) {
            try {
                FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile());
                fileWriter.write("Report Date/Time: " + this.m_dateTimeLblValue.getText() + "\n");
                ((StatusReportTableModel)this.m_reportTable.getModel()).WriteTableTofile(fileWriter);
                fileWriter.close();
            }
            catch (Exception exception) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Encountered " + exception.toString() + " while saving log to file"));
                this.abortProcess(-262180);
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit writeLogToFile()");
        return false;
    }

    public boolean setSaveBtnType() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter setSaveBtnType()");
        if (this.isReportTypeInternal()) {
            this.m_saveIntLogBtn.doClick();
        } else if (this.isReportTypeExternal()) {
            this.m_saveExtLogBtn.doClick();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit setSaveBtnType()");
        return true;
    }

    public boolean isReportTypeInternal() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isReportTypeInternal()");
        boolean bl = false;
        int n = this.getScreenSelectedErrorLog();
        try {
            if (n > 0 && this.m_fileParseType[n - 1] == 1) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Caught NumberFormatException while checking parse type value");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isReportTypeInternal(): return = " + bl));
        return bl;
    }

    public boolean isReportTypeExternal() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isReportTypeExternal()");
        boolean bl = false;
        int n = this.getScreenSelectedErrorLog();
        try {
            if (n > 0 && this.m_fileParseType[n - 1] == 2) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Caught NumberFormatException while checking parse type value");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isReportTypeExternal(): return = " + bl));
        return bl;
    }

    public int populateErrorLogTable(String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter populateErrorLogTable(): g_filename = " + string));
        Object var2_2 = null;
        int n = 0;
        String string2 = " ";
        String string3 = null;
        String string4 = null;
        ErrorLogsDataHandler errorLogsDataHandler = new ErrorLogsDataHandler();
        this.m_reportTable.repaint();
        string3 = ErrorLogUtilities.getDtdFileName();
        string4 = errorLogsDataHandler.getDtdFileNameFromErrorLog(string);
        if (!string4.equalsIgnoreCase(string3)) {
            ErrorLogUtilities.renameDtdFile((String)string3, (String)string4);
        }
        try {
            n = errorLogsDataHandler.parseErrorLogFile(string);
            if (n == 0) {
                Vector vector = errorLogsDataHandler.getParsedTableData();
                this.m_reportTable.setModel(StatusReportTableModel.setTableNewValues(vector));
                ((StatusReportTableModel)this.m_reportTable.getModel()).setHeaderInfo(errorLogsDataHandler.getHeaderInfo());
                int n2 = ((StatusReportTableModel)this.m_reportTable.getModel()).getColumnCount();
                String[] stringArray = new String[n2];
                stringArray = ((StatusReportTableModel)this.m_reportTable.getModel()).getColumsArray();
                int n3 = 0;
                while (n3 < n2) {
                    TableColumn tableColumn = this.m_reportTable.getColumnModel().getColumn(n3);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                        ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(stringArray[n3]);
                    }
                    if ((string2 = tableColumn.getHeaderValue().toString()).equals("Occurrence Time")) {
                        tableColumn.setMinWidth(155);
                        tableColumn.setPreferredWidth(155);
                        tableColumn.setMinWidth(155);
                    } else if (string2.equals("Description")) {
                        tableColumn.setMinWidth(290);
                        tableColumn.setPreferredWidth(290);
                        tableColumn.setMinWidth(290);
                    } else {
                        tableColumn.setMinWidth(70);
                        tableColumn.setPreferredWidth(70);
                        tableColumn.setMinWidth(70);
                    }
                    ++n3;
                }
                JTableHeader jTableHeader = this.m_reportTable.getTableHeader();
                jTableHeader.setReorderingAllowed(false);
                this.m_reportTable.revalidate();
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Parse error log file return error = " + n));
                if (n == -1) {
                    n = errorLogsDataHandler.recoverDtdFile();
                }
                this.enableActionComponents();
            }
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)("Encountered " + exception.toString() + " while populating the error log table"));
            this.enableActionComponents();
            n = -1;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit populateErrorLogTable(): return = " + n));
        return n;
    }

    public void notifyGuiListener() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter notifyGuiListener()");
        ActionEvent actionEvent = new ActionEvent(this, 0, "");
        if (this.m_actionListener != null) {
            ((ActionListener)this.m_actionListener).actionPerformed(actionEvent);
        }
        this.enableActionComponents();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit notifyGuiListener()");
    }

    class ReportTypeHandler
    implements ActionListener {
        ReportTypeHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)CommonStatusReportPanel.FILE, (String)"Enter ReportTypeHandler::actionPerformed()");
            if (actionEvent.getSource() == CommonStatusReportPanel.this.m_typeOfStatusReportCbBox && (n = CommonStatusReportPanel.this.getScreenSelectedErrorLog()) != CommonStatusReportPanel.this.m_currSelectedLog) {
                CommonStatusReportPanel.this.m_currSelectedLog = n;
                if (CommonStatusReportPanel.this.isReportTypeInternal()) {
                    CommonStatusReportPanel.this.clearTable();
                    CommonStatusReportPanel.this.disableReportTable();
                    CommonStatusReportPanel.this.m_tableTitleLbl.setText("Selected Report Type Is Not Viewable. Click Save Report Button To Save To File");
                } else if (CommonStatusReportPanel.this.m_fileProtocolXferIndex[n - 1] == CommonStatusReportPanel.this.m_protocolXferIndex && CommonStatusReportPanel.this.m_fileCompression[n - 1] == 1) {
                    CommonStatusReportPanel.this.enableReportTable();
                    CommonStatusReportPanel.this.m_refreshBtn.doClick();
                } else {
                    if (CommonStatusReportPanel.this.m_reportTable.isEnabled()) {
                        CommonStatusReportPanel.this.clearTable();
                    }
                    CommonStatusReportPanel.this.disableReportTable();
                    CommonStatusReportPanel.this.abortProcess(-262168);
                }
            }
            Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)CommonStatusReportPanel.FILE, (String)"Exit ReportTypeHandler::actionPerformed()");
        }
    }
}

