/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.component.WaitPopup;
import css.device.common.service.ServiceMaker;
import css.device.common.service.Serviceable;
import java.util.Vector;
import pnm.ui.PnmDialog;
import pnm.util.Audit;
import pnm.util.EngineUtilities;

public class ScreenManager {
    private static final String FILE = "ScreenManager";
    private static ScreenManager c_instance = null;
    private static ServiceMaker c_deviceServiceMaker = null;
    private Vector m_screens = null;
    private boolean m_isAvailable;
    private WaitPopup m_resetPopup = null;

    private ScreenManager() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter ScreenManager()");
        this.m_screens = new Vector();
        this.m_isAvailable = true;
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit ScreenManager()");
    }

    static ScreenManager newInstance() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter newInstance()");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit newInstance()");
        c_instance = new ScreenManager();
        return c_instance;
    }

    public static void suspend() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter suspend()");
        if (ScreenManager.c_instance.m_isAvailable) {
            int n = ScreenManager.c_instance.m_screens.size();
            while (n > 0) {
                Serviceable serviceable = (Serviceable)ScreenManager.c_instance.m_screens.get(n - 1);
                serviceable.closeScreen(true);
                --n;
            }
            ScreenManager.c_instance.m_screens.removeAllElements();
            ScreenManager.c_instance.m_resetPopup = new WaitPopup(null);
            ScreenManager.c_instance.m_resetPopup.display("Please Wait While Device Resets.");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit suspend()");
    }

    public static void closeScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter closeScreen()");
        int n = ScreenManager.c_instance.m_screens.size();
        while (n > 0) {
            Serviceable serviceable = (Serviceable)ScreenManager.c_instance.m_screens.get(n - 1);
            serviceable.closeScreen(true);
            --n;
        }
        ScreenManager.c_instance.m_screens.removeAllElements();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit closeScreen()");
    }

    public static void registerScreen(Serviceable serviceable) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter registerScreen() g_screen = " + serviceable));
        if (ScreenManager.c_instance.m_isAvailable) {
            Vector vector = ScreenManager.c_instance.m_screens;
            synchronized (vector) {
                if (!ScreenManager.c_instance.m_screens.contains(serviceable)) {
                    ScreenManager.c_instance.m_screens.add(serviceable);
                }
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit registerScreen()");
    }

    public static void removeScreen(Serviceable serviceable) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter removeScreen() g_screen = " + serviceable));
        if (ScreenManager.c_instance.m_isAvailable) {
            Vector vector = ScreenManager.c_instance.m_screens;
            synchronized (vector) {
                ScreenManager.c_instance.m_screens.removeElement(serviceable);
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit removeScreen()");
    }

    public static void update(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter update()");
        if (ScreenManager.c_instance.m_isAvailable) {
            if (ScreenManager.c_instance.m_resetPopup != null) {
                ScreenManager.c_instance.m_resetPopup.hide();
                ScreenManager.c_instance.m_resetPopup = null;
            }
            Vector vector = ScreenManager.c_instance.m_screens;
            synchronized (vector) {
                if (!bl) {
                    PnmDialog.error((Object)EngineUtilities.getMainApplicationWindow(), (String)"Timed Out While Waiting For Device To Be Restarted");
                } else {
                    EngineUtilities.getMainApplicationWindow().getStatusBar().update("Device is restarted successfully");
                }
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit update()");
    }

    public static void update() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter update()");
        if (ScreenManager.c_instance.m_isAvailable && ScreenManager.c_instance.m_resetPopup != null) {
            ScreenManager.c_instance.m_resetPopup.hide();
            ScreenManager.c_instance.m_resetPopup = null;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit update()");
    }

    public static void shutDown() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter shutDown()");
        if (ScreenManager.c_instance.m_isAvailable) {
            CSSUtilities.disableServiceMenu();
            Vector vector = ScreenManager.c_instance.m_screens;
            synchronized (vector) {
                int n = ScreenManager.c_instance.m_screens.size();
                while (n > 0) {
                    Serviceable serviceable = (Serviceable)ScreenManager.c_instance.m_screens.get(n - 1);
                    serviceable.closeScreen(true);
                    --n;
                }
                ScreenManager.c_instance.m_screens.removeAllElements();
            }
            ScreenManager.c_instance.m_isAvailable = false;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit shutDown()");
    }

    public static void setDeviceServiceMakerHandle(ServiceMaker serviceMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter setDeviceServiceMakerHandle()");
        c_deviceServiceMaker = serviceMaker;
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit setDeviceServiceMakerHandle()");
    }

    public static ServiceMaker getDeviceServiceMakerHandle() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter/Exit setDeviceServiceMakerHandle()");
        return c_deviceServiceMaker;
    }
}

