/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.service.DataObject;
import css.core.util.CSSUtilities;
import css.core.util.ClassFinder;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.popup.PopupProperties;
import css.device.common.service.ScreenManager;
import css.device.common.tables.CommonOidTable;
import css.device.common.util.DeviceConstants;
import java.util.Iterator;
import java.util.jar.JarFile;
import pnm.util.Audit;

public class ServiceMaker
implements CssErrorCodes,
CssConstants,
DeviceConstants,
CommonOidTable {
    private final String FILE = "ServiceMaker";
    protected static String m_deviceType = "UNKNOWN";

    public int initiateService() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ServiceMaker", (String)"Enter initiateService()");
        int n = -1;
        DataObject dataObject = null;
        dataObject = CSSUtilities.addOID((Object[][])CommonOidTable.COMMON_OID_TABLE, (String)"Common Service Initialization");
        if (dataObject.getError() != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ServiceMaker", (String)"Trouble adding the common OIDs to SNMP Interface");
        }
        ScreenManager.newInstance();
        try {
            String string = MetadataAcquisitionService.getServiceFilename();
            JarFile jarFile = new JarFile(string);
            ClassFinder classFinder = new ClassFinder(jarFile, "css.device");
            Iterator iterator = classFinder.findClass("ServiceMaker", 2);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.equals("css.device.common.service.ServiceMaker")) continue;
                Audit.audit((int)8, (String)"ServiceMaker", (String)("Found a match of the Class Name " + string2));
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                Object obj = clazz.newInstance();
                n = ((ServiceMaker)obj).initiateService();
                if (n == 0) {
                    ScreenManager.setDeviceServiceMakerHandle((ServiceMaker)obj);
                    n = PopupProperties.addMessages((String)"css/device/common/util/DeviceErrorMsg.txt");
                }
                break;
            }
        }
        catch (Exception exception) {
            Audit.error((String)"ServiceMaker", (String)(exception.toString() + " while trying to find/instantiate device ServiceMaker class"));
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ServiceMaker", (String)("Exit initiateService() status = " + n));
        return n;
    }

    public static String getDeviceType() {
        return m_deviceType;
    }

    public void handleMenuItemDependencies(String string) {
    }
}

