/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import css.core.util.CssConstants;
import css.core.util.ErrorLogUtilities;
import css.device.common.util.ErrorLogsColInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pnm.util.Audit;

public class ErrorLogsDataHandler
extends HandlerBase
implements DocumentHandler,
CssConstants {
    private static final String FILE = "ErrorLogsDataHandler";
    static String LOG_DELIM_ATTR = "delim";
    static final String DEFAULT_DELIM = "|";
    static String COL_TAG = "Col";
    static String ELEMENT_TAG = "E";
    static String LOG_TAG = "Log";
    static String COL_ATTR_1 = "type";
    static String COL_ATTR_2 = "name";
    static String HEAD_TAG = "Head";
    String DELIM;
    final String DOCTYPE_TAG = "!DOCTYPE";
    final String UNDEFINED_ENTITY_MSG = "Reference to undefined entity";
    Vector m_errorLogsData = null;
    boolean m_ElementHeaderTagStart = false;
    boolean m_ElementTagStart = false;
    StringBuffer strBuf = null;
    StringBuffer m_strHeaderBuf = new StringBuffer();
    String m_parseErrorMessage = null;
    Writer out;
    int m_rowIndex;

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public int parseErrorLogFile(String string) {
        int n = 0;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)("Enter parseErrorLogFileg_fileName=" + string));
        try {
            this.m_errorLogsData = new Vector();
            this.m_rowIndex = -1;
            this.DELIM = DEFAULT_DELIM;
            InputSource inputSource = Resolver.createInputSource((File)new File(string));
            ValidatingParser validatingParser = new ValidatingParser();
            validatingParser.setDocumentHandler(this);
            validatingParser.setErrorHandler(new MyErrorHandler());
            validatingParser.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            this.m_parseErrorMessage = sAXParseException.getMessage();
            n = -1;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
                exception.printStackTrace();
            }
            n = -2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = -3;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)("Exit parseErrorLogFile: status=" + n));
        return n;
    }

    public int recoverDtdFile() {
        int n = -2;
        boolean bl = false;
        int n2 = -1;
        if (this.m_parseErrorMessage.startsWith("Reference to undefined entity")) {
            String string = this.m_parseErrorMessage.substring(this.m_parseErrorMessage.indexOf("&") + 1, this.m_parseErrorMessage.indexOf(";"));
            String string2 = ErrorLogUtilities.getDtdFileName();
            if (string != null && string2 != null) {
                try {
                    File file = new File(string2);
                    FileWriter fileWriter = new FileWriter(string2, true);
                    fileWriter.write("<!ENTITY " + string + " \"ERROR! Entry not found in DTD file.\">");
                    fileWriter.close();
                }
                catch (Exception exception) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Unable to recover dtd file.");
                }
                n = -100;
            }
        }
        return n;
    }

    public Vector getParsedTableData() {
        return this.m_errorLogsData;
    }

    public String getDtdFileNameFromErrorLog(String string) {
        String string2 = null;
        String string3 = null;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("!DOCTYPE") < 0) continue;
                int n = string3.indexOf("\"");
                int n2 = string3.lastIndexOf("\"");
                string2 = string3.substring(n + 1, n2);
                break;
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ErrorLogsDataHandler class", (String)"Unable to get dtd file name.");
        }
        return string2;
    }

    public String getHeaderInfo() {
        return this.m_strHeaderBuf.toString();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)("Enter startElementtag=" + string + "attrs=" + attributeList));
        if (string.equalsIgnoreCase(LOG_TAG)) {
            int n = 0;
            while (n < attributeList.getLength()) {
                if (attributeList.getName(n).equalsIgnoreCase(LOG_DELIM_ATTR)) {
                    this.DELIM = attributeList.getValue(n);
                }
                ++n;
            }
        }
        if (string.equalsIgnoreCase(COL_TAG)) {
            ErrorLogsColInfo errorLogsColInfo = new ErrorLogsColInfo();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = 0;
            while (n < attributeList.getLength()) {
                String string5 = attributeList.getName(n);
                if (string5.equalsIgnoreCase(COL_ATTR_1)) {
                    string2 = attributeList.getType(n);
                    string3 = attributeList.getValue(n);
                } else if (string5.equalsIgnoreCase(COL_ATTR_2)) {
                    string4 = attributeList.getValue(n);
                }
                ++n;
            }
            errorLogsColInfo.setColInfo(string4, string3, string2);
            this.m_errorLogsData.addElement(errorLogsColInfo);
        } else if (string.equalsIgnoreCase(ELEMENT_TAG)) {
            this.m_ElementTagStart = true;
            this.strBuf = new StringBuffer();
        } else if (string.equalsIgnoreCase(HEAD_TAG)) {
            this.m_ElementHeaderTagStart = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)"Exit startElement");
    }

    public void endElement(String string) throws SAXException {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)("Enter endElementname=" + string));
        if (string.equalsIgnoreCase(ELEMENT_TAG)) {
            ++this.m_rowIndex;
            this.m_ElementTagStart = false;
            int n = this.parseErrorLogsTableData();
            if (n != 0) {
                throw new SAXException("Error Parsing: Invalid Row Data, Row# " + n);
            }
        } else if (string.equalsIgnoreCase(HEAD_TAG)) {
            this.m_ElementHeaderTagStart = false;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)"Exit endElement");
    }

    public int parseErrorLogsTableData() {
        int n = 0;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)"Enter parseErrorLogsTableData");
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.strBuf.toString(), this.DELIM);
            int n2 = 0;
            while (n2 < this.m_errorLogsData.size()) {
                if (stringTokenizer.hasMoreTokens()) {
                    ErrorLogsColInfo errorLogsColInfo = (ErrorLogsColInfo)this.m_errorLogsData.elementAt(n2);
                    errorLogsColInfo.addColValue(stringTokenizer.nextToken());
                } else {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ErrorLogsDataHandler class", (String)"parseErrorLogsTableData: error in storing error log data");
                    n = -1;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ErrorLogsDataHandler class", (String)("parseErrorLogsTableData: generic Exception :" + exception));
            n = -1;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)("Exit parseErrorLogsTableData:status " + n));
        return n;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)("Enter charactersbuf[]=" + cArray + " offset=" + n + " len=" + n2));
        int n3 = 0;
        while (n3 < n2) {
            if (this.m_ElementTagStart) {
                this.strBuf.append(cArray[n + n3]);
            } else if (this.m_ElementHeaderTagStart) {
                this.m_strHeaderBuf.append(cArray[n + n3]);
            }
            ++n3;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)"Exit characters ");
    }

    public void printTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"ErrorLogsDataHandler class", (String)"Enter printTable");
        if (this.m_errorLogsData == null) {
            System.out.println("m_errorLogsData = null");
            return;
        }
        System.out.println("********** START TABLE DATA **********");
        int n = 0;
        while (n < this.m_errorLogsData.size()) {
            ErrorLogsColInfo errorLogsColInfo = (ErrorLogsColInfo)this.m_errorLogsData.elementAt(n);
            System.out.println(errorLogsColInfo.getColName());
            System.out.println("_________________");
            Vector vector = errorLogsColInfo.getColValues();
            int n2 = 0;
            while (n2 < vector.size()) {
                System.out.println((String)vector.elementAt(n2));
                ++n2;
            }
            System.out.println("_________________");
            ++n;
        }
        System.out.println("********** END TABLE DATA **********");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"ErrorLogsDataHandler class", (String)"Exit printTable");
    }

    static class MyErrorHandler
    extends HandlerBase {
        MyErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ErrorLogsDataHandler class", (String)("MyErrorHandler" + sAXParseException.getMessage()));
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"ErrorLogsDataHandler class", (String)("MyErrorHandler** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "   " + sAXParseException.getMessage()));
        }
    }
}

