/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.scsummit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SCSummitBatteryEqualizationScreen
extends GenericScreen {
    private final String BATEQ_LABEL_ON = "Equalization is ON";
    private final String BATEQ_LABEL_OFF = "Equalization is OFF";
    private final String BATEQ_LABEL_UNKNOWN = "Equalization State is Unknown";
    private final String BAT_TYPE_ERROR = "Error!";
    private final String BAT_TYPE_1 = "None";
    private final String BAT_TYPE_5 = "C&D TEL SERIES AGM VRLA";
    private final String BAT_TYPE_6 = "C&D MPS SERIES Gel VRLA";
    private final String BAT_TYPE_7 = "Exide Marathon AGM VRLA";
    private final String BAT_TYPE_8 = "Exide PowerFit AGM VRLA";
    private final String BAT_TYPE_9 = "Exide Sprinter AGM VRLA";
    private final String BAT_TYPE_10 = "Exide DryFit A400 Gel VRLA";
    private final String BAT_TYPE_11 = "Exide DryFit A500 Gel VRLA";
    private final String BAT_TYPE_12 = "Exide DryFit A600 Gel VRLA";
    private final String BAT_TYPE_13 = "Exide DryFit A700 Gel VRLA";
    private final String BAT_TYPE_14 = "Exide Classic Flooded Lead-Antimony";
    private final String BAT_TYPE_15 = "Exide Classic Flooded Lead-Calcium";
    private final String BAT_TYPE_16 = "Other AGM VRLA";
    private final String BAT_TYPE_17 = "Other Gel VRLA";
    private final String BAT_TYPE_18 = "Other Flooded";
    private final String BAT_TYPE_19 = "Saft Ni-Cd";
    private final String BAT_TYPE_20 = "Alcad Ni-Cd";
    private final String BAT_TYPE_21 = "Other Ni-Cd";
    private final String BATEQ_BTN_OFF = "Turn Equalization OFF";
    private final String BATEQ_BTN_OFF_TOOLTIP = "Turn Battery Equalization OFF";
    private final String BATEQ_BTN_OFF_STATUS_MSG = "Click to turn Equalization OFF";
    private final String BATEQ_BTN_ON = "Turn Equalization ON";
    private final String BATEQ_BTN_ON_TOOLTIP = "Turn Battery Equalization ON";
    private final String BATEQ_BTN_ON_STATUS_MSG = "Click to turn Equalization ON";
    private static final String FILE = "SCSummitBatteryEqualizationScreen";
    public JButton m_batteryBtn;
    private ErrorPopup m_errorPopup = new ErrorPopup();
    private ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    private JTextArea m_batteryEquMsg;
    private JLabel m_batteryTypelbl;
    private JLabel m_batterytypeValue;
    private JLabel m_batteryStateValue;
    private StatusBarListener m_statusBarListener;

    public SCSummitBatteryEqualizationScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter constructor method");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit constructor method");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreen methodg_window" + object + "g_statusBarListener" + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_statusBarListener = statusBarListener;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        this.m_batteryEquMsg = new JTextArea();
        this.m_batteryEquMsg.setText("When battery equalization is turned ON, the connected device will \nequalize the battery for a specific period of time, which depends \non the battery type, and then it will turn equalization OFF.\n\nOnce equalization is turned ON, the CSS can be disconnected from the\ndevice.\n\nThe user is also given the ability to turn OFF equalization before\nequalization has been completed for a particular type of battery.\n\nSee on-line help for specific battery equalization times.");
        this.m_batteryEquMsg.setBackground(UIManager.getColor("text"));
        this.m_batteryTypelbl = new JLabel("Battery Type:");
        this.m_batterytypeValue = new JLabel();
        this.m_batteryStateValue = new JLabel();
        this.m_batteryBtn = new JButton();
        this.initialize();
        this.add((Component)this.m_batteryEquMsg, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_batteryTypelbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 180, 20, 0), 0, 0));
        this.add((Component)this.m_batteryStateValue, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        this.add((Component)this.m_batterytypeValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 280, 0, 0), 0, 0));
        this.add((Component)this.m_batteryBtn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusBarListener.registerComponent((Component)this.m_batteryBtn, "Click to turn Equalization ON");
        this.m_window.setCursor(new Cursor(3));
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Exit buildScreen Method()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.m_batteryBtn.setText("Turn Equalization ON");
        this.m_batteryBtn.setToolTipText("Turn Battery Equalization ON");
        this.m_batteryStateValue.setText("Equalization State is Unknown");
        this.m_batterytypeValue.setText("N/A");
        this.m_window.setCursor(new Cursor(3));
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateBatteryType(int n, String string) {
        int n2 = 0;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateBatteryType g_type" + string + "g_error" + n));
        if (n == 0 && string != null) {
            try {
                n2 = Integer.parseInt(string);
                switch (n2) {
                    case 1: {
                        this.m_batterytypeValue.setText("None");
                        this.m_batteryBtn.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.m_batterytypeValue.setText("C&D TEL SERIES AGM VRLA");
                        break;
                    }
                    case 6: {
                        this.m_batterytypeValue.setText("C&D MPS SERIES Gel VRLA");
                        break;
                    }
                    case 7: {
                        this.m_batterytypeValue.setText("Exide Marathon AGM VRLA");
                        break;
                    }
                    case 8: {
                        this.m_batterytypeValue.setText("Exide PowerFit AGM VRLA");
                        break;
                    }
                    case 9: {
                        this.m_batterytypeValue.setText("Exide Sprinter AGM VRLA");
                        break;
                    }
                    case 10: {
                        this.m_batterytypeValue.setText("Exide DryFit A400 Gel VRLA");
                        break;
                    }
                    case 11: {
                        this.m_batterytypeValue.setText("Exide DryFit A500 Gel VRLA");
                        break;
                    }
                    case 12: {
                        this.m_batterytypeValue.setText("Exide DryFit A600 Gel VRLA");
                        break;
                    }
                    case 13: {
                        this.m_batterytypeValue.setText("Exide DryFit A700 Gel VRLA");
                        break;
                    }
                    case 14: {
                        this.m_batterytypeValue.setText("Exide Classic Flooded Lead-Antimony");
                        break;
                    }
                    case 15: {
                        this.m_batterytypeValue.setText("Exide Classic Flooded Lead-Calcium");
                        break;
                    }
                    case 16: {
                        this.m_batterytypeValue.setText("Other AGM VRLA");
                        break;
                    }
                    case 17: {
                        this.m_batterytypeValue.setText("Other Gel VRLA");
                        break;
                    }
                    case 18: {
                        this.m_batterytypeValue.setText("Other Flooded");
                        break;
                    }
                    case 19: {
                        this.m_batterytypeValue.setText("Saft Ni-Cd");
                        break;
                    }
                    case 20: {
                        this.m_batterytypeValue.setText("Alcad Ni-Cd");
                        break;
                    }
                    case 21: {
                        this.m_batterytypeValue.setText("Other Ni-Cd");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Invalid Battery Type value " + numberFormatException));
                this.m_batterytypeValue.setText("Error!");
                this.m_batteryBtn.setEnabled(false);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"unable to get battery type");
            this.m_batterytypeValue.setText("Error!");
            this.m_batteryBtn.setEnabled(false);
        }
        this.m_window.unlockWindow();
        this.m_window.setCursor(new Cursor(0));
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateBatteryType ");
    }

    public void updateBatteryEqualization(int n, String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateBatteryEqualization g_state" + string + "g_error" + n));
        if (n == 0 && string != null) {
            if (string.equalsIgnoreCase("ON")) {
                this.m_batteryBtn.setText("Turn Equalization OFF");
                this.m_batteryBtn.setToolTipText("Turn Battery Equalization OFF");
                this.m_statusBarListener.updateComponent((Component)this.m_batteryBtn, "Click to turn Equalization OFF");
                this.m_batteryStateValue.setText("Equalization is ON");
            } else if (string.equalsIgnoreCase("OFF")) {
                this.m_batteryBtn.setText("Turn Equalization ON");
                this.m_batteryBtn.setToolTipText("Turn Battery Equalization ON");
                this.m_statusBarListener.updateComponent((Component)this.m_batteryBtn, "Click to turn Equalization ON");
                this.m_batteryStateValue.setText("Equalization is OFF");
            } else {
                this.m_batteryStateValue.setText("Equalization State is Unknown");
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"unable to update battery equalization");
                this.popupError(-620300);
            }
        } else {
            this.m_batteryStateValue.setText("Equalization State is Unknown");
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"unable to update battery equalization");
            this.popupError(-620300);
        }
        this.m_window.unlockWindow();
        this.m_window.setCursor(new Cursor(0));
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateBatteryEqualization ");
    }

    public void updateBatteryEqualizationSet(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateBatteryEqualizationSet g_error" + n));
        if (n == 0) {
            if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization ON")) {
                this.m_batteryBtn.setText("Turn Equalization OFF");
                this.m_batteryBtn.setToolTipText("Turn Battery Equalization OFF");
                this.m_statusBarListener.updateComponent((Component)this.m_batteryBtn, "Click to turn Equalization OFF");
                this.m_batteryStateValue.setText("Equalization is ON");
            } else if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization OFF")) {
                this.m_batteryBtn.setText("Turn Equalization ON");
                this.m_batteryBtn.setToolTipText("Turn Battery Equalization ON");
                this.m_statusBarListener.updateComponent((Component)this.m_batteryBtn, "Click to turn Equalization ON");
                this.m_batteryStateValue.setText("Equalization is OFF");
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"unable to update battery equalization");
            if (this.isBatteryEqualizationOn()) {
                this.popupError(-620302);
            } else {
                this.popupError(-620301);
            }
        }
        System.setProperty("css.serialCmdPacer", "100");
        this.m_window.setCursor(new Cursor(0));
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateBatteryEqualizationSet ");
    }

    public boolean isBatteryEqualizationOn() {
        boolean bl = true;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isBatteryEqualizationOn ");
        this.m_window.setCursor(new Cursor(3));
        if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization ON")) {
            bl = false;
            System.setProperty("css.serialCmdPacer", "5000");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit isBatteryEqualizationOn ");
        return bl;
    }

    public void handleStartSession(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter handleStartSession" + n));
        if (n != 0) {
            this.popupError(-620303);
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit handleStartSession");
    }
}

