/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.scsummit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.DateAndTimeConversion;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.util.CommonTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SCSummitGPSInfoScreen
extends GenericScreen {
    private final int ZERO_DEGREE_LATPOS = 324000000;
    private final int ZERO_DEGREE_LOGPOS = 648000000;
    private final String NO_FIX = "No Fix";
    private final String TWOD_FIX = "2D Fix";
    private final String THREED_FIX = "3D Fix";
    private final String PROPAGATION_MODE = "Propagation Mode";
    private final String CODE_SEARCH = "Code Search";
    private final String CODE_ACQUIRE = "Code Acquire";
    private final String AUTOMATIC_GAIN = "Automatic Gain Control Set";
    private final String POSITION_REQUEST = "Position Request Acquire";
    private final String BIT_SYNC = "Bit Sync Detect";
    private final String MESSAGE_SYNC = "Message Sync Detect";
    private final String SAT_TIME_AVAILABLE = "Satellite Time Available";
    private final String EPHEMERIS_ACQ = "Ephemeris Acquire";
    private final String AVAILABLE = "Available for position";
    private static final String FILE = "SCSummitGPSInfoScreen";
    private final String c_buttontxt = "Refresh";
    private final String c_gpslatitudeposTooltip = "The current latitude position of the GPS receiver.";
    private final String c_gpslongitudeposTooltip = "The current longitude position of the GPS receiver.";
    private final String c_gpsestimatedaltitudeTooltip = "The current Altitude of the GPS receiver.";
    private final String c_gpsdatetimeTooltip = "The current date and time.";
    private final String c_gpsdopTooltip = "A higher DOP indicates the current satellite locations are providing inferior measurements.";
    private final String c_gpstrackedsatellitesTooltip = "The current number of tracked satellites.";
    private final String c_gpsreceiverstatusTooltip = "The GPS Receiver Status.";
    private final String c_gpschannelsvidTooltip = "The Space Vehicle Identification Number.";
    private final String c_gpschannelmodeTooltip = "The GPS channel mode.";
    private final String c_gpschannelsignalTooltip = "GPS Channel Signal Strength.";
    private final String c_buttonTooltip = "Get the latest GPS information from the Site Controller.";
    private final String c_buttonStatusMessage = "Click this button to get the latest GPS information from the Site Controller.";
    private final String c_gpschanneltitletxt = "GPS Channel";
    private String[] c_columnNames = new String[]{"GPS Channel SVID", "GPS Channel Mode", "GPS Channel Signal Strength (dB-Hz)"};
    private String[] m_gpsChannelSVID = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private String[] m_gpsChannelMode = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private String[] m_gpsChannelSignalStrength = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private final Object[][] m_gpsChannelData = new Object[][]{{this.m_gpsChannelSVID[0], this.m_gpsChannelMode[0], this.m_gpsChannelSignalStrength[0]}, {this.m_gpsChannelSVID[1], this.m_gpsChannelMode[1], this.m_gpsChannelSignalStrength[1]}, {this.m_gpsChannelSVID[2], this.m_gpsChannelMode[2], this.m_gpsChannelSignalStrength[2]}, {this.m_gpsChannelSVID[3], this.m_gpsChannelMode[3], this.m_gpsChannelSignalStrength[3]}, {this.m_gpsChannelSVID[4], this.m_gpsChannelMode[4], this.m_gpsChannelSignalStrength[4]}, {this.m_gpsChannelSVID[5], this.m_gpsChannelMode[5], this.m_gpsChannelSignalStrength[5]}, {this.m_gpsChannelSVID[6], this.m_gpsChannelMode[6], this.m_gpsChannelSignalStrength[6]}, {this.m_gpsChannelSVID[7], this.m_gpsChannelMode[7], this.m_gpsChannelSignalStrength[7]}, {this.m_gpsChannelSVID[8], this.m_gpsChannelMode[8], this.m_gpsChannelSignalStrength[8]}, {this.m_gpsChannelSVID[9], this.m_gpsChannelMode[9], this.m_gpsChannelSignalStrength[9]}, {this.m_gpsChannelSVID[10], this.m_gpsChannelMode[10], this.m_gpsChannelSignalStrength[10]}, {this.m_gpsChannelSVID[11], this.m_gpsChannelMode[11], this.m_gpsChannelSignalStrength[11]}};
    public JButton m_refreshButton = new JButton();
    private JTable m_gpschanneltable;
    private JLabel m_gpslatitudeposvalue;
    private JLabel m_gpslongitudevalue;
    private JLabel m_gpsestimatedaltitudevalue;
    private JLabel m_datetimevalue;
    private JLabel m_gpscurrentdopvalue;
    private JLabel m_gpstrackedsatellitesvalue;
    private JLabel m_gpsreceiverstatusvalue;
    private StatusBarListener m_statusBarListener;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private boolean m_gpschannelerror = false;
    private boolean m_gpsinfoerror = false;
    private int degreeLatValue = 0;
    private int minuteLatValue = 0;
    private int secondLatValue = 0;
    private String latPos = " ";
    private int degreeLongValue = 0;
    private int minuteLongValue = 0;
    private int secondLongValue = 0;
    private String longPos = " ";
    private int m_numberTrackedSat = 0;

    public SCSummitGPSInfoScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter constructor method");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit constructor()");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter buildScreen");
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("GPS Current Latitude Position");
        jLabel.setToolTipText("The current latitude position of the GPS receiver.");
        this.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("GPS Current Longitude Position");
        jLabel2.setToolTipText("The current longitude position of the GPS receiver.");
        this.add((Component)jLabel2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("GPS Current Estimated Altitude (m)");
        jLabel3.setToolTipText("The current Altitude of the GPS receiver.");
        this.add((Component)jLabel3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("GPS Current Date/Time");
        jLabel4.setToolTipText("The current date and time.");
        this.add((Component)jLabel4, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("GPS Current DOP");
        jLabel5.setToolTipText("A higher DOP indicates the current satellite locations are providing inferior measurements.");
        this.add((Component)jLabel5, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("GPS Number Of Tracked Satellites");
        jLabel6.setToolTipText("The current number of tracked satellites.");
        this.add((Component)jLabel6, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("GPS Receiver Status");
        jLabel7.setToolTipText("The GPS Receiver Status.");
        this.add((Component)jLabel7, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.m_gpslatitudeposvalue = new JLabel("");
        this.m_gpslatitudeposvalue.setSize(15, 0);
        this.add((Component)this.m_gpslatitudeposvalue, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_gpslongitudevalue = new JLabel("");
        this.m_gpslongitudevalue.setSize(15, 0);
        this.add((Component)this.m_gpslongitudevalue, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_gpsestimatedaltitudevalue = new JLabel("");
        this.m_gpsestimatedaltitudevalue.setSize(15, 0);
        this.add((Component)this.m_gpsestimatedaltitudevalue, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_datetimevalue = new JLabel("");
        this.m_datetimevalue.setSize(40, 1);
        this.add((Component)this.m_datetimevalue, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_gpscurrentdopvalue = new JLabel("");
        this.m_gpscurrentdopvalue.setSize(40, 1);
        this.add((Component)this.m_gpscurrentdopvalue, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_gpstrackedsatellitesvalue = new JLabel("");
        this.m_gpstrackedsatellitesvalue.setSize(40, 1);
        this.add((Component)this.m_gpstrackedsatellitesvalue, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        this.m_gpsreceiverstatusvalue = new JLabel("");
        this.m_gpsreceiverstatusvalue.setSize(40, 1);
        this.add((Component)this.m_gpsreceiverstatusvalue, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 10, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder titledBorder = new TitledBorder(border, "GPS Channel");
        jPanel.setBorder(titledBorder);
        this.add((Component)jPanel, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.m_gpschanneltable = new JTable();
        CommonTableModel commonTableModel = new CommonTableModel();
        commonTableModel.setDataVector(this.m_gpsChannelData, this.c_columnNames);
        this.m_gpschanneltable.setModel(commonTableModel);
        this.m_gpschanneltable.setShowHorizontalLines(true);
        this.m_gpschanneltable.setShowVerticalLines(true);
        this.m_gpschanneltable.setEnabled(false);
        JTableHeader jTableHeader = this.m_gpschanneltable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_gpschanneltable);
        jScrollPane.setPreferredSize(new Dimension(650, 230));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        TableColumn tableColumn = this.m_gpschanneltable.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("The Space Vehicle Identification Number.");
        }
        if ((tableCellRenderer = (tableColumn = this.m_gpschanneltable.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("The GPS channel mode.");
        }
        if ((tableCellRenderer = (tableColumn = this.m_gpschanneltable.getColumnModel().getColumn(2)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("GPS Channel Signal Strength.");
        }
        this.add((Component)this.m_refreshButton, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_refreshButton.setToolTipText("Get the latest GPS information from the Site Controller.");
        this.m_refreshButton.setText("Refresh");
        statusBarListener.registerComponent((Component)this.m_refreshButton, "Click this button to get the latest GPS information from the Site Controller.");
        this.initialize();
        this.m_window.setDefaultCloseOperation(1);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.resetFlag();
        this.m_gpslatitudeposvalue.setText(" ");
        this.m_gpslongitudevalue.setText(" ");
        this.m_gpsestimatedaltitudevalue.setText(" ");
        this.m_datetimevalue.setText(" ");
        this.m_gpscurrentdopvalue.setText(" ");
        this.m_gpstrackedsatellitesvalue.setText(" ");
        this.m_gpsreceiverstatusvalue.setText(" ");
        this.resetChannelTable();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    private void resetChannelTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter resetChannelTable()");
        int n = 0;
        while (n < this.m_gpschanneltable.getRowCount()) {
            int n2 = 0;
            while (n2 < this.m_gpschanneltable.getColumnCount()) {
                this.m_gpschanneltable.setValueAt(" ", n, n2);
                ++n2;
            }
            ++n;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit resetChannelTable()");
    }

    public void resetFlag() {
        this.m_gpschannelerror = false;
        this.m_gpsinfoerror = false;
    }

    public void updateGPSInformation(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, Integer[] integerArray5, Integer[] integerArray6, Integer[] integerArray7, Integer[] integerArray8) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateGPSInformation arguments: g_error = " + n + " scInstance = " + integerArray + " scGPSInitialLatPos = " + integerArray2 + "scGPSCurrentTimeMessage = " + integerArray5 + "scGPSCurrDOP = " + integerArray6 + "scGPSNumOfTrackedSat = " + integerArray7 + "scGPSChannelReceiverStatus = " + integerArray8));
        this.m_gpsinfoerror = false;
        if (n == 0) {
            this.m_window.setCursor(new Cursor(3));
            this.m_window.lockWindow();
            if (integerArray2.length != 0) {
                this.updateGPSLatPos(integerArray2[0]);
            }
            if (integerArray3.length != 0) {
                this.updateGPSLongPos(integerArray3[0]);
            }
            if (integerArray4.length != 0) {
                this.updateGPSEstimatedAltitude(integerArray4[0]);
            }
            if (integerArray5.length != 0) {
                this.updateDateTime(integerArray5[0]);
            }
            if (integerArray6.length != 0) {
                this.updategpsDOP(integerArray6[0]);
            }
            if (integerArray7.length != 0) {
                this.updategpsTrackedSatellites(integerArray7[0]);
            }
            if (integerArray8.length != 0) {
                this.updateReceiverStatus(integerArray8[0]);
            }
        }
        if (n != 0 || integerArray2.length == 0 || integerArray3.length == 0 || integerArray2.length == 0 || integerArray4.length == 0 || integerArray5.length == 0 || integerArray6.length == 0 || integerArray7.length == 0 || integerArray8.length == 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting Site Controller Parameters");
            this.popupError(-458756);
            this.m_gpsinfoerror = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateGPSInformation");
    }

    public void updateGPSChannelTable(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateGPSChannelTable arguments: g_error = " + n + " g_instance= " + integerArray + " scGPSChannelSVID = " + integerArray2 + "scGPSChannelMode = " + integerArray3 + "scGPSChannelSignalStrength = " + integerArray4));
        this.m_gpschannelerror = false;
        this.resetChannelTable();
        if (n == 0) {
            this.m_window.setCursor(new Cursor(3));
            this.m_window.lockWindow();
            int n2 = 0;
            while (n2 < this.m_numberTrackedSat) {
                if (n2 == this.m_numberTrackedSat) break;
                int n3 = integerArray[n2] - 1;
                this.m_gpschanneltable.setValueAt(integerArray2[n2], n3, 0);
                switch (integerArray3[n2]) {
                    case 1: {
                        this.m_gpschanneltable.setValueAt("Code Search", n3, 1);
                        break;
                    }
                    case 2: {
                        this.m_gpschanneltable.setValueAt("Code Acquire", n3, 1);
                        break;
                    }
                    case 3: {
                        this.m_gpschanneltable.setValueAt("Automatic Gain Control Set", n3, 1);
                        break;
                    }
                    case 4: {
                        this.m_gpschanneltable.setValueAt("Position Request Acquire", n3, 1);
                        break;
                    }
                    case 5: {
                        this.m_gpschanneltable.setValueAt("Bit Sync Detect", n3, 1);
                        break;
                    }
                    case 6: {
                        this.m_gpschanneltable.setValueAt("Message Sync Detect", n3, 1);
                        break;
                    }
                    case 7: {
                        this.m_gpschanneltable.setValueAt("Satellite Time Available", n3, 1);
                        break;
                    }
                    case 8: {
                        this.m_gpschanneltable.setValueAt("Ephemeris Acquire", n3, 1);
                        break;
                    }
                    case 9: {
                        this.m_gpschanneltable.setValueAt("Available for position", n3, 1);
                    }
                }
                this.m_gpschanneltable.setValueAt(integerArray4[n2], n3, 2);
                ++n2;
            }
            this.m_window.unlockWindow();
            this.m_window.setCursor(new Cursor(0));
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting Site Controller Parameters");
            if (!this.m_gpsinfoerror) {
                this.popupError(-458756);
                this.m_gpschannelerror = true;
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateGPSChannelTable");
    }

    private void gpsLatPositionConverter(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter gpsLatPositionConverter argument: g_pos= " + n.toString()));
        int n2 = StrictMath.abs(n - 324000000);
        if (n == 324000000) {
            this.degreeLatValue = 0;
            this.minuteLatValue = 0;
            this.secondLatValue = 0;
            this.latPos = " ";
        } else {
            this.degreeLatValue = (n2 /= 1000) / 3600;
            this.minuteLatValue = (n2 %= 3600) / 60;
            this.secondLatValue = n2 % 60;
            if (n < 324000000) {
                this.latPos = "S";
            }
            if (n > 324000000) {
                this.latPos = "N";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit gpsLatPositionConverter");
    }

    private void updateGPSLatPos(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateGPSLatPos argument: g_pos= " + n.toString()));
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        this.gpsLatPositionConverter(n);
        string = String.valueOf(this.degreeLatValue);
        string2 = String.valueOf(this.minuteLatValue);
        string3 = String.valueOf(this.secondLatValue);
        this.m_gpslatitudeposvalue.setText(string + "\u00ba " + string2 + "' " + string3 + "\" " + this.latPos);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateGPSLatPos");
    }

    private void gpsLongPositionConverter(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter gpsLongPositionConverter argument: g_pos= " + n.toString()));
        int n2 = StrictMath.abs(n - 648000000);
        if (n == 648000000) {
            this.degreeLongValue = 0;
            this.minuteLongValue = 0;
            this.secondLongValue = 0;
            this.longPos = " ";
        } else {
            this.degreeLongValue = (n2 /= 1000) / 3600;
            this.minuteLongValue = (n2 %= 3600) / 60;
            this.secondLongValue = n2 % 60;
            if (n < 648000000) {
                this.longPos = "W";
            }
            if (n > 648000000) {
                this.longPos = "E";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit gpsLongPositionConverter");
    }

    private void updateGPSLongPos(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateGPSLongPos argument: g_pos= " + n.toString()));
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        this.gpsLongPositionConverter(n);
        string = String.valueOf(this.degreeLongValue);
        string2 = String.valueOf(this.minuteLongValue);
        string3 = String.valueOf(this.secondLongValue);
        this.m_gpslongitudevalue.setText(string + "\u00ba " + string2 + "' " + string3 + "\" " + this.longPos);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateGPSLongPos");
    }

    private void updateGPSEstimatedAltitude(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateGPSEstimatedAltitude argument: g_altitude= " + n.toString()));
        double d = 0.0;
        double d2 = 0.0;
        String string = " ";
        d = n.doubleValue() - 1000.0;
        d2 = d / 100.0;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        string = decimalFormat.format(d2);
        this.m_gpsestimatedaltitudevalue.setText(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateGPSEstimatedAltitude");
    }

    private void updateDateTime(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateDateTime argument: g_time= " + n.toString()));
        String string = " ";
        string = DateAndTimeConversion.getDate((int)n) + "  " + DateAndTimeConversion.getTime((int)n);
        this.m_datetimevalue.setText(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateDateTime");
    }

    private void updategpsDOP(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updategpsDOP argument: g_gpsDOP= " + n.toString()));
        float f = 0.0f;
        String string = " ";
        f = n.floatValue() / 10.0f;
        string = String.valueOf(f);
        this.m_gpscurrentdopvalue.setText(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updategpsDOP");
    }

    private void updategpsTrackedSatellites(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updategpsTrackedSatellites argument: g_trackedSatellites= " + n));
        this.m_gpstrackedsatellitesvalue.setText(n.toString());
        this.m_numberTrackedSat = n;
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updategpsTrackedSatellites");
    }

    private void updateReceiverStatus(Integer n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateReceiverStatus argument: g_receiverStatus= " + n));
        switch (n) {
            case 1: {
                this.m_gpsreceiverstatusvalue.setText("No Fix");
                break;
            }
            case 2: {
                this.m_gpsreceiverstatusvalue.setText("2D Fix");
                break;
            }
            case 3: {
                this.m_gpsreceiverstatusvalue.setText("3D Fix");
                break;
            }
            case 4: {
                this.m_gpsreceiverstatusvalue.setText("Propagation Mode");
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateReceiverStatus");
    }
}

