/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.scsummit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.Logger;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.scsummit.screens.SCSummitStatusPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SCSummitHistoryTab
extends JPanel
implements ActionListener,
CssConstants,
DeviceErrorCodes {
    private static final String FILE = "SCSummitHistoryTab";
    private final String STATUS_PANEL = "Status Panel: History";
    private final String SITE_CONTROLLER_STATUS = " Site Controller Status:  ";
    private final String START_LOG = "Start Log";
    private final String STOP_LOG = "Stop Log";
    private final String CLEAR_LOG = "Clear Log";
    private final String N_A = "N/A";
    private final String ACTIVE = "Active";
    private final String STANDBY = "Standby";
    private final String NON_REDUNDANT = "Non Redundant";
    private JTable m_table;
    private DefaultTableModel m_model;
    private JLabel m_scStatusLbl;
    private JButton m_startStopLogBtn;
    private JButton m_clearLogBtn;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
    private SCSummitStatusPanel m_mainPanel;
    private Logger m_log;

    public SCSummitHistoryTab(SCSummitStatusPanel sCSummitStatusPanel) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)" Enter Constructor");
        this.m_mainPanel = sCSummitStatusPanel;
        this.setLayout(new GridBagLayout());
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)" Exit Contructor");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        JLabel jLabel = new JLabel(" Site Controller Status:  ");
        jLabel.setToolTipText("Current Status of the Site Controller");
        jPanel.add(jLabel);
        this.m_scStatusLbl = new JLabel("N/A");
        jPanel.add(this.m_scStatusLbl);
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        jPanel.add(jLabel2);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(new Dimension(50, 15));
        JLabel jLabel5 = new JLabel();
        jLabel5.setPreferredSize(new Dimension(50, 15));
        Object[][] objectArray = new Object[][]{{"", "", "", "", ""}};
        Object[] objectArray2 = new String[]{"Date/Time", "Object Name", "State", "Cause"};
        this.m_model = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new JTable(this.m_model);
        this.m_table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(400, 250));
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)1, (double)1.0, (double)1.0, (int)4, (int)4, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JTextField jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 1);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 2);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 3);
        jTextField.setEnabled(false);
        TableCellRenderer tableCellRenderer = null;
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(0);
        this.setTableTooltips(tableCellRenderer, tableColumn);
        int n = 0;
        while (n < objectArray2.length) {
            if (n == 0) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(125);
                tableColumn.setPreferredWidth(125);
                tableColumn.setMinWidth(125);
            } else if (n == 1) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
            } else if (n == 2) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
            } else if (n == 3) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(140);
                tableColumn.setPreferredWidth(140);
                tableColumn.setMinWidth(140);
            }
            ++n;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4));
        jPanel2.add(jLabel4);
        this.m_startStopLogBtn = new JButton("Start Log");
        this.m_startStopLogBtn.addActionListener(this);
        this.m_startStopLogBtn.setToolTipText("Starts/Stops the storing of event logs.");
        jPanel2.add(this.m_startStopLogBtn);
        jPanel2.add(jLabel5);
        this.m_clearLogBtn = new JButton("Clear Log");
        this.m_clearLogBtn.addActionListener(this);
        this.m_clearLogBtn.setToolTipText("Clears the entries in the displayed table.");
        jPanel2.add(this.m_clearLogBtn);
        statusBarListener.registerComponent((Component)this.m_clearLogBtn, "Click this button to clear the entries in the displayed table.");
        statusBarListener.registerComponent((Component)this.m_startStopLogBtn, "Click this button to start/stop the storing of event logs.");
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)7, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.clearSCSummitHistoryTable();
        this.m_scStatusLbl.setText("N/A");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateSCStatus(int n, Integer n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSCStatus()arguments: g_error = " + n + "g_scStatus = " + n2));
        if (n == 0) {
            switch (n2) {
                case 1: {
                    this.m_scStatusLbl.setText("Active");
                    break;
                }
                case 2: {
                    this.m_scStatusLbl.setText("Standby");
                    break;
                }
                case 3: {
                    this.m_scStatusLbl.setText("Non Redundant");
                }
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting SC Status");
            this.popupError(-458762);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSCStatus()");
    }

    public void clearSCSummitHistoryTable() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter clearSCSummitHistoryTable()");
        Object[][] objectArray = new Object[][]{{"", "", "", ""}};
        Object[] objectArray2 = new String[]{"Date/Time", "Object Name", "State", "Cause"};
        this.m_model = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_model);
        TableCellRenderer tableCellRenderer = null;
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(0);
        this.setTableTooltips(tableCellRenderer, tableColumn);
        int n = 0;
        while (n < objectArray2.length) {
            if (n == 0) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(125);
                tableColumn.setPreferredWidth(125);
                tableColumn.setMinWidth(125);
            } else if (n == 1) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
            } else if (n == 2) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
            } else if (n == 3) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setMinWidth(140);
                tableColumn.setPreferredWidth(140);
                tableColumn.setMinWidth(140);
            }
            ++n;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit clearSCSummitHistoryTable()");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter clearSCSummitHistoryTable()arguments: ActionEvent: " + actionEvent));
        if (actionEvent.getSource() == this.m_clearLogBtn) {
            this.clearSCSummitHistoryTable();
        } else if (this.m_startStopLogBtn.getText() == "Start Log") {
            File file;
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            n = jFileChooser.showSaveDialog((Component)this.m_window);
            if (n == 0 && CSSUtilities.isValidLogFile((File)(file = jFileChooser.getSelectedFile()), (ErrorPopup)this.m_errPopup)) {
                try {
                    this.m_log = new Logger(file);
                    Date date = new Date();
                    String string = this.m_formatter.format(date);
                    this.m_log.write("Start Log Time is: " + string + "\n");
                    this.m_startStopLogBtn.setText("Stop Log");
                    this.m_mainPanel.startWriteToFile();
                }
                catch (IOException iOException) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to create file for writing" + iOException));
                    this.closeFile(false);
                }
            }
        } else {
            this.closeFile(true);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit actionPerformed()");
    }

    private void closeFile(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter closeFile()arguments: g_userClicked: " + bl));
        if (this.m_log != null) {
            if (bl) {
                try {
                    Date date = new Date();
                    String string = this.m_formatter.format(date);
                    this.m_log.write("Stop Log Time is: " + string + "\n");
                    this.m_log.close();
                }
                catch (IOException iOException) {
                    this.popupError(-327859);
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to close file for writing" + iOException));
                }
            } else {
                this.popupError(-327859);
                try {
                    this.m_log.close();
                }
                catch (IOException iOException) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to close file for writing" + iOException));
                }
            }
        }
        this.m_startStopLogBtn.setText("Start Log");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit closeFile()");
    }

    public void updateSCSummitHistoryTable(String string, String string2, String string3, String string4) {
        Object object;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSCSummitHistoryTable() arguments: g_time: " + string + " g_object: " + string2 + " g_state: " + string3 + " g_cause: " + string4));
        String string5 = "";
        string = string + "000";
        try {
            long l = new Long(string);
            object = new Date(l);
            string5 = this.m_formatter.format((Date)object);
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)3, (String)FILE, (String)("Couldn't get time. Using current time: " + numberFormatException.getMessage()));
            Date date = new Date();
            string5 = this.m_formatter.format(date);
        }
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                object = string5 + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\n";
                this.m_log.write((String)object);
                this.m_log.flush();
            }
            catch (IOException iOException) {
                this.popupError(-327859);
                this.m_startStopLogBtn.setText("Start Log");
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to write to File" + iOException));
            }
        }
        if (((String)this.m_table.getValueAt(0, 0)).equals("")) {
            this.m_table.setValueAt(string5, 0, 0);
            this.m_table.setValueAt(string2, 0, 1);
            this.m_table.setValueAt(string3, 0, 2);
            this.m_table.setValueAt(string4, 0, 3);
        } else {
            this.m_model.addRow(new Object[]{string5, string2, string3, string4});
            this.m_table.setModel(this.m_model);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSCSummitHistoryTable()");
    }

    public void writeToFile() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter writeToFile()");
        String string = "Object Name: History Screen\n";
        string = string + "Site Controller Status: " + this.m_scStatusLbl.getText() + "\n";
        string = string + "Time/Date" + "\t" + "Object Name" + "\t" + "State" + "\t" + "Cause" + "\n";
        int n = 0;
        while (n < this.m_table.getRowCount()) {
            int n2 = 0;
            while (n2 < this.m_table.getColumnCount()) {
                string = string + this.m_table.getValueAt(n, n2) + "\t";
                ++n2;
            }
            string = string + "\n";
            ++n;
        }
        this.appendString(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit writeToFile()");
    }

    public void appendString(String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter appendString()arguments: g_string = " + string));
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                this.m_log.write(string);
                this.m_log.flush();
            }
            catch (IOException iOException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to write to File" + iOException));
                this.closeFile(false);
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit appendString()");
    }

    public boolean isFileOpen() {
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isFileOpen()");
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup();
            confirmationPopup.display(-458764);
            if (confirmationPopup.getStatus()) {
                this.closeFile(true);
            } else {
                bl = true;
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit isFileOpen()");
        return bl;
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    private void setTableTooltips(TableCellRenderer tableCellRenderer, TableColumn tableColumn) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter setTableTooltips()");
        tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Date/Time");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Object Name");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(2)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("State");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(3)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Cause");
        }
        this.m_table.repaint();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit setTableTooltips()");
    }
}

