/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.scsummit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.component.CssJTable;
import css.core.util.component.GenericListener;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.scsummit.screens.SCSummitChannelTab;
import css.device.sc_platform.scsummit.screens.SCSummitHistoryTab;
import css.device.sc_platform.scsummit.screens.SCSummitSiteTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SCSummitSiteControllerTab
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    private final String STATUS_PANEL = "Status Panel: Site Controller";
    private final String SC_NUMBER = "Site Controller No: ";
    private final String OBJECT_NAME = "Site Controller Name: ";
    private final String STATUS = "Status: ";
    private final String SITE_CONTROLLER = "Site Controller: ";
    private final String USER_REQ_SC_STATE = "User Requested Site Controller State: ";
    private final String N_A = "N/A";
    private final String ENABLED = "Enabled";
    private final String USER_DISABLED = "User Disabled";
    private final String RESTART = "Restart";
    private final String UNKNOWN = "Unknown";
    private final String INITIALIZATION = "Initialization";
    private final String CRITICAL_MALFUNCTION = "Critical Malfunction";
    private final String VERSION_VALIDATION = "Version Validation";
    private final String SC_POWER_UP = "Site Controller Power Up";
    private final String CRITICAL_DISABLED = "Critical Malfunction";
    private final String MAJOR_DISABLED = "Major Malfunction";
    private final String MINOR_DISABLED = "Minor Malfunction";
    private final String WARNING_DISABLED = "Warning Disabled";
    private final String NO_REASON = "No Reason";
    private final String USER_REQUESTED = "User Requested";
    private final String SITE_CONTROLLER_POWER_UP = "Site Controller Power Up";
    private final String MULTIPLE_SC_WITH_SAME_NUMBER = "Multiple Site Controllers with same Number";
    private final String SC_CROSSLOAD_FAILURE = "SC Software Crossload Failure";
    private final String SC_CORRUPT_NVM = "NVM is corrupted";
    private final String SC_SOFTWARE_VER_MISSMATCH = "Software Version Mismatch";
    private final String HW_FAILURE = "Hardware Failure";
    private final String SAT_NOT_VISIBLE = "Satellite Not Visible";
    private final String CONNECTIVITY_FAILURE = "Connectivity Failure";
    private final String PS_FAILURE = "Power Supply Failure";
    private final String FAN_FAILURE = "Fan Failure";
    private final String PS_FAN_FAILURE = "PS Fan Failure";
    private final String PS_INPUT_VOLT = "Input Voltage Failure";
    private final String PS_BATTERY_TEMP = "Excessive Battery Temperature";
    private final String PS_BATTERY_VOLT = "Detected Battery Voltage Failure";
    private final String PS28_FAILURE = "28 Volt Line Failure";
    private final String PS_HW_FAILURE = "PS Hardware Failure";
    private final String ACTIVE = "Active";
    private final String STANDBY = "Standby";
    private final String NON_REDUNDANT = "Non Redundant";
    private final String FILE = "SCSummitSiteControllerTab";
    public JComboBox m_scReqStateCbBox;
    public GenericListener m_genericListener;
    private boolean m_userInitiated = true;
    private JLabel m_scNumberLbl;
    private JLabel m_scStatusLbl;
    private JLabel m_scNameLbl;
    private UIInternalFrame m_window;
    private Integer m_scInstance;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private SCSummitHistoryTab m_history;
    private SCSummitChannelTab m_channel;
    private SCSummitSiteTab m_site;
    private int m_originalIndex = -1;
    private boolean m_isDeviceActive = false;
    private CssJTable m_table;

    public SCSummitSiteControllerTab(SCSummitHistoryTab sCSummitHistoryTab, SCSummitSiteTab sCSummitSiteTab, SCSummitChannelTab sCSummitChannelTab) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter Constructor");
        this.m_history = sCSummitHistoryTab;
        this.m_site = sCSummitSiteTab;
        this.m_channel = sCSummitChannelTab;
        this.setLayout(new GridBagLayout());
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit Constructor");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 2));
        JLabel jLabel = new JLabel("Site Controller No: ");
        jLabel.setToolTipText("Site Controller Identification Number");
        jPanel.add(jLabel);
        this.m_scNumberLbl = new JLabel("N/A");
        jPanel.add(this.m_scNumberLbl);
        JLabel jLabel2 = new JLabel("Site Controller Name: ");
        jLabel2.setToolTipText("Name assigned to the Site Controller");
        JLabel jLabel3 = new JLabel("Status: ");
        jLabel3.setToolTipText("Current Status of the Site Controller");
        this.m_scNameLbl = new JLabel("N/A");
        jPanel.add(jLabel2);
        jPanel.add(this.m_scNameLbl);
        this.m_scStatusLbl = new JLabel("N/A");
        jPanel.add(jLabel3);
        jPanel.add(this.m_scStatusLbl);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JLabel jLabel4 = new JLabel("User Requested Site Controller State: ");
        jLabel4.setToolTipText("Set the state of Site Controller as per Users Request");
        jPanel2.add(jLabel4);
        this.m_genericListener = new GenericListener();
        this.m_scReqStateCbBox = new JComboBox();
        this.m_scReqStateCbBox.addItem("Enabled");
        this.m_scReqStateCbBox.addItem("User Disabled");
        this.m_scReqStateCbBox.addItem("Restart");
        jPanel2.add(this.m_scReqStateCbBox);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)20, (int)0, (int)0);
        String string = System.getProperty("css.core.deviceandhwtype", "Unknown");
        Object[][] objectArray = string.indexOf("HPDSC") >= 0 ? new Object[][]{{"Site Controller", " ", " "}, {"Fan", " ", " "}, {"Switch", " ", " "}, {"Power Supply", " ", " "}, {"GPS", " ", " "}} : new Object[][]{{"Site Controller", " ", " "}, {"Fan", " ", " "}, {"Switch", " ", " "}, {"Power Supply", " ", " "}};
        Object[] objectArray2 = new String[]{"Object Name", "State", "Cause"};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new CssJTable((TableModel)defaultTableModel);
        this.m_table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_table);
        jScrollPane.setPreferredSize(new Dimension(400, 103));
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JTextField jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 1);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 2);
        jTextField.setEnabled(false);
        TableColumn tableColumn = null;
        int n = 0;
        while (n < objectArray2.length) {
            if (n == 0) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(120);
            } else if (n == 1) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(130);
            } else if (n == 2) {
                tableColumn = this.m_table.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(145);
            }
            ++n;
        }
        this.initialize();
        statusBarListener.registerComponent((Component)this.m_scReqStateCbBox, "Select State of Site Controller from the Drop down Combo Box");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter initialize()");
        this.m_scNameLbl.setText("N/A");
        this.m_scNumberLbl.setText("N/A");
        this.m_scStatusLbl.setText("N/A");
        this.m_userInitiated = false;
        this.m_scReqStateCbBox.setSelectedIndex(0);
        this.m_userInitiated = true;
        int n = 0;
        while (n < this.m_table.getRowCount()) {
            int n2 = 1;
            while (n2 < this.m_table.getColumnCount()) {
                this.m_table.setValueAt(" ", n, n2);
                ++n2;
            }
            ++n;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit initialize()");
    }

    public void updateSCInstanceNumReqState(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, String[] stringArray) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateSCInstanceNumReqState() arguments: g_error = " + n + " g_instance = " + integerArray[0] + " g_number = " + integerArray2[0] + " g_reqState = " + integerArray3[0] + " g_name = " + stringArray[0]));
        if (n == 0) {
            this.m_scNameLbl.setText(stringArray[0]);
            this.m_scInstance = integerArray[0];
            this.m_scNumberLbl.setText(integerArray2[0].toString());
            this.m_userInitiated = false;
            switch (integerArray3[0]) {
                case 2: {
                    this.m_scReqStateCbBox.setSelectedIndex(0);
                    break;
                }
                case 3: {
                    this.m_scReqStateCbBox.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.m_scReqStateCbBox.setSelectedIndex(2);
                }
            }
            this.m_originalIndex = this.m_scReqStateCbBox.getSelectedIndex();
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Site Controller Number, Instance ID, Name, Req State");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateSCInstanceNumReqState()");
    }

    public boolean isSetRequired() {
        boolean bl = this.m_userInitiated;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter isSetRequired()");
        if (!this.m_userInitiated) {
            this.m_userInitiated = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit isSetRequired() return: " + bl));
        return bl;
    }

    public void updateScCommonBox(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateScCommonBox()arguments: g_error = " + n + " scCommonBoxAlias = " + stringArray[0] + " scCommonBoxState = " + integerArray3[0] + " scCommonBoxCause = " + integerArray4[0]));
        String string = null;
        String string2 = null;
        if (n == 0) {
            if (integerArray3[0] != null && integerArray4[0] != null) {
                string = this.convBoxStateNumToName(integerArray3[0]);
                this.m_table.setValueAt(string, 0, 1);
                string2 = this.convBoxCauseNumToName(integerArray4[0]);
                this.m_table.setValueAt(string2, 0, 2);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Site Controller State and Cause");
                this.popupError(-458756);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Site Controller State and Cause");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateScCommonBox()");
    }

    public void updateScCommonFan(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateScCommonFan()arguments: g_error = " + n + " scCommonFanAlias = " + stringArray[0] + " scCommonFanState = " + integerArray3[0] + " scCommonFanCause = " + integerArray4[0]));
        String string = null;
        String string2 = null;
        if (n == 0) {
            if (integerArray3[0] != null && integerArray4[0] != null) {
                string = this.convFanStateNumToName(integerArray3[0]);
                this.m_table.setValueAt(string, 1, 1);
                string2 = this.convFanCauseNumToName(integerArray4[0]);
                this.m_table.setValueAt(string2, 1, 2);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Fan State and Cause");
                this.popupError(-458756);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Fan State and Cause");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateScCommonFan()");
    }

    public void updateScCommonGPS(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateScCommonGPS()arguments: g_error = " + n + " scCommonGPSAlias = " + stringArray[0] + " scCommonGPSState = " + integerArray3[0] + " scCommonGPSCause = " + integerArray4[0]));
        String string = null;
        String string2 = null;
        if (n == 0) {
            if (integerArray3[0] != null && integerArray4[0] != null) {
                string = this.convGPSStateNumToName(integerArray3[0]);
                this.m_table.setValueAt(string, 4, 1);
                string2 = this.convGPSCauseNumToName(integerArray4[0]);
                this.m_table.setValueAt(string2, 4, 2);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting GPS State and Cause");
                this.popupError(-458756);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting GPS State and Cause");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateScCommonGPS()");
    }

    public void updateScCommonSwitch(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateScCommonSwitch()arguments: g_error = " + n + " scCommonSwitchAlias = " + stringArray[0] + " scCommonSwitchState = " + integerArray3[0] + " scCommonSwitchCause = " + integerArray4[0]));
        String string = null;
        String string2 = null;
        if (n == 0) {
            if (integerArray3[0] != null && integerArray4[0] != null) {
                string = this.convSwitchStateNumToName(integerArray3[0]);
                this.m_table.setValueAt(string, 2, 1);
                string2 = this.convSwitchCauseNumToName(integerArray4[0]);
                this.m_table.setValueAt(string2, 2, 2);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Switch State and Cause");
                this.popupError(-458756);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Switch State and Cause");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateScCommonSwitch()");
    }

    public void updateScCommonPwrSupply(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateScCommonPwrSupply() arguments: g_error = " + n + " scCommonPwrSupplyAlias = " + stringArray[0] + " scCommonPwrSupplyState = " + integerArray3[0] + " scCommonPwrSupplyCause = " + integerArray4[0]));
        String string = null;
        String string2 = null;
        if (n == 0) {
            if (integerArray3[0] != null && integerArray4[0] != null) {
                string = this.convPwrSupplyStateNumToName(integerArray3[0]);
                this.m_table.setValueAt(string, 3, 1);
                string2 = this.convPwrSupplyCauseNumToName(integerArray4[0]);
                this.m_table.setValueAt(string2, 3, 2);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Power Supply State and Cause");
                this.popupError(-458756);
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Power Supply State and Cause");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateScCommonPwrSupply()");
    }

    public void updateSCStatus(int n, Integer n2) {
        String string = null;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateSCStatus() arguments: g_error = " + n + " g_scStatus = " + n2));
        if (n == 0) {
            string = this.convBoxStatus(n2);
            this.m_scStatusLbl.setText(string);
            this.m_history.updateSCStatus(n, n2);
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in getting Site Controller Status");
            this.popupError(-458756);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateSCStatus()");
    }

    public boolean isDeviceActive() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter isDeviceActive()");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit isDeviceActive() return = " + this.m_isDeviceActive));
        return this.m_isDeviceActive;
    }

    public Object[] getScReqState() {
        Object[] objectArray = null;
        Integer n = null;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter getScReqState()");
        switch (this.m_scReqStateCbBox.getSelectedIndex()) {
            case 0: {
                n = new Integer(2);
                break;
            }
            case 1: {
                n = new Integer(3);
                break;
            }
            case 2: {
                n = new Integer(4);
            }
        }
        objectArray = new Object[]{"." + this.m_scInstance.toString(), n.toString()};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit getScReqState() return: " + objectArray));
        return objectArray;
    }

    public void updateSCReqState(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter updateSCReqState()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Error in setting User Requested State for Site Controller");
            this.popupError(-458757);
            this.m_userInitiated = false;
            this.m_scReqStateCbBox.setSelectedIndex(this.m_originalIndex);
        } else {
            this.m_originalIndex = this.m_scReqStateCbBox.getSelectedIndex();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit updateSCReqState()");
    }

    public void realTimeUpdate(String string, String string2, String string3, String string4, String string5) {
        String string6;
        String string7;
        int n = -1;
        int n2 = -1;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter realTimeUpdate()arguments: g_time = " + string + "g_stateName = " + string2 + " g_stateVal = " + string3 + "g_causeName = " + string4 + " g_causeVal = " + string5));
        try {
            n = new Integer(string3);
            n2 = new Integer(string5);
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.toString(), (String)"Number Format Exception while processing the Trap");
        }
        if (string2.indexOf("scCommonBoxState") != -1) {
            string7 = this.convBoxStateNumToName(n);
            this.m_table.setValueAt(string7, 0, 1);
            string6 = this.convBoxCauseNumToName(n2);
            this.m_table.setValueAt(string6, 0, 2);
            this.m_history.updateSCSummitHistoryTable(string, "Site Controller", string7, string6);
        }
        if (string2.indexOf("scCommonFanState") != -1) {
            string7 = this.convFanStateNumToName(n);
            this.m_table.setValueAt(string7, 1, 1);
            string6 = this.convFanCauseNumToName(n2);
            this.m_table.setValueAt(string6, 1, 2);
            this.m_history.updateSCSummitHistoryTable(string, "Fan", string7, string6);
        }
        if (string2.indexOf("scCommonGPSState") != -1) {
            string7 = this.convGPSStateNumToName(n);
            this.m_table.setValueAt(string7, 4, 1);
            string6 = this.convGPSCauseNumToName(n2);
            this.m_table.setValueAt(string6, 4, 2);
            this.m_history.updateSCSummitHistoryTable(string, "GPS", string7, string6);
        }
        if (string2.indexOf("scCommonSwitchState") != -1) {
            string7 = this.convSwitchStateNumToName(n);
            this.m_table.setValueAt(string7, 2, 1);
            string6 = this.convSwitchCauseNumToName(n2);
            this.m_table.setValueAt(string6, 2, 2);
            this.m_history.updateSCSummitHistoryTable(string, "Switch", string7, string6);
        }
        if (string2.indexOf("scCommonPwrSupplyState") != -1) {
            string7 = this.convPwrSupplyStateNumToName(n);
            this.m_table.setValueAt(string7, 3, 1);
            string6 = this.convPwrSupplyCauseNumToName(n2);
            this.m_table.setValueAt(string6, 3, 2);
            this.m_history.updateSCSummitHistoryTable(string, "Power Supply", string7, string6);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit realTimeUpdate()");
    }

    public void realTimeUpdate(String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter realTimeUpdate()arguments: g_state = " + string));
        try {
            Integer n = new Integer(string);
            String string2 = this.convBoxStatus(n);
            this.m_scStatusLbl.setText(string2);
            if (string2.equalsIgnoreCase("Active")) {
                this.m_genericListener.notifyGuiListener();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"SCSummitSiteControllerTab", (String)"Number Format Exception while processing the Trap");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit realTimeUpdate()");
    }

    private String convBoxStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convBoxStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 3: {
                string = "User Disabled";
                break;
            }
            case 4: {
                string = "Restart";
                break;
            }
            case 5: {
                string = "Initialization";
                break;
            }
            case 6: {
                string = "Critical Malfunction";
                break;
            }
            case 8: {
                string = "Version Validation";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convBoxStateNumToName() return: " + string));
        return string;
    }

    private String convBoxCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convBoxCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "User Requested";
                break;
            }
            case 3: {
                string = "Site Controller Power Up";
                break;
            }
            case 4: {
                string = "Multiple Site Controllers with same Number";
                break;
            }
            case 6: {
                string = "SC Software Crossload Failure";
                break;
            }
            case 7: {
                string = "NVM is corrupted";
                break;
            }
            case 8: {
                string = "Software Version Mismatch";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convBoxCauseNumToName() return: " + string));
        return string;
    }

    private String convFanStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convFanStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 4: {
                string = "Critical Malfunction";
                break;
            }
            case 5: {
                string = "Major Malfunction";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convFanStateNumToName() return: " + string));
        return string;
    }

    private String convFanCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convFanCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "Hardware Failure";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convFanCauseNumToName() return: " + string));
        return string;
    }

    private String convGPSStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convGPSStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 6: {
                string = "Minor Malfunction";
                break;
            }
            case 5: {
                string = "Major Malfunction";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convGPSStateNumToName() return: " + string));
        return string;
    }

    private String convGPSCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convGPSCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "Hardware Failure";
                break;
            }
            case 3: {
                string = "Satellite Not Visible";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convGPSCauseNumToName() return: " + string));
        return string;
    }

    private String convSwitchStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convSwitchStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 4: {
                string = "Critical Malfunction";
                break;
            }
            case 5: {
                string = "Major Malfunction";
                break;
            }
            case 6: {
                string = "Minor Malfunction";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convSwitchStateNumToName() return: " + string));
        return string;
    }

    private String convSwitchCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convSwitchCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "Hardware Failure";
                break;
            }
            case 3: {
                string = "Connectivity Failure";
                break;
            }
            case 4: {
                string = "Power Supply Failure";
                break;
            }
            case 5: {
                string = "Fan Failure";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convSwitchCauseNumToName() return: " + string));
        return string;
    }

    private String convPwrSupplyStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convPwrSupplyStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 4: {
                string = "Critical Malfunction";
                break;
            }
            case 5: {
                string = "Major Malfunction";
                break;
            }
            case 6: {
                string = "Minor Malfunction";
                break;
            }
            case 7: {
                string = "Warning Disabled";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convPwrSupplyStateNumToName() return: " + string));
        return string;
    }

    private String convPwrSupplyCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)("Enter convPwrSupplyCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "PS Fan Failure";
                break;
            }
            case 3: {
                string = "Input Voltage Failure";
                break;
            }
            case 4: {
                string = "Excessive Battery Temperature";
                break;
            }
            case 5: {
                string = "Detected Battery Voltage Failure";
                break;
            }
            case 6: {
                string = "28 Volt Line Failure";
                break;
            }
            case 7: {
                string = "PS Hardware Failure";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convPwrSupplyCauseNumToName() return: " + string));
        return string;
    }

    public void writeToFile() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter writeToFile()");
        String string = "Object Name: Site Controller\n";
        string = string + "Site Controller Number: " + this.m_scNumberLbl.getText() + "\n";
        string = string + "Site Controller Status: " + this.m_scStatusLbl.getText() + "\n";
        string = string + "User Requested Site Controller State: " + this.m_scReqStateCbBox.getSelectedItem() + "\n";
        string = string + "\n" + "\n";
        this.m_history.appendString(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit writeToFile()");
    }

    private String convBoxStatus(Integer n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter convBoxStatus()");
        switch (n) {
            case 1: {
                this.m_isDeviceActive = true;
                string = "Active";
                break;
            }
            case 2: {
                this.m_isDeviceActive = false;
                this.m_channel.initialize();
                string = "Standby";
                break;
            }
            case 3: {
                this.m_isDeviceActive = false;
                this.m_channel.initialize();
                this.m_site.initialize();
                string = "Non Redundant";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)("Exit convBoxStatus()" + string));
        return string;
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    public boolean isHPDSC() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"SCSummitSiteControllerTab", (String)"Enter isHPDSC()");
        boolean bl = false;
        String string = System.getProperty("css.core.deviceandhwtype", "Unknown");
        if (string.indexOf("HPDSC") >= 0) {
            bl = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"SCSummitSiteControllerTab", (String)"Exit isHPDSC()");
        return bl;
    }
}

