/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.scsummit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.popup.ErrorPopup;
import css.device.common.service.ScreenManager;
import css.device.common.service.Serviceable;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.scsummit.screens.SCSummitChannelTab;
import css.device.sc_platform.scsummit.screens.SCSummitHistoryTab;
import css.device.sc_platform.scsummit.screens.SCSummitSiteControllerTab;
import css.device.sc_platform.scsummit.screens.SCSummitSiteTab;
import css.device.sc_platform.scsummit.screens.SCSummitStatusPanelMaker;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SCSummitStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes,
Serviceable {
    public static final String FILE = "SCSummitStatusPanel";
    public SCSummitSiteTab m_site;
    public SCSummitSiteControllerTab m_siteController;
    public SCSummitChannelTab m_channel;
    public SCSummitHistoryTab m_history;
    private JTabbedPane m_tabbedPane;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();

    public SCSummitStatusPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        this.m_tabbedPane = new JTabbedPane();
        this.m_history = new SCSummitHistoryTab(this);
        this.m_site = new SCSummitSiteTab(this.m_history);
        this.m_channel = new SCSummitChannelTab(this.m_history);
        this.m_siteController = new SCSummitSiteControllerTab(this.m_history, this.m_site, this.m_channel);
        this.m_site.buildScreen(this.m_window, statusBarListener);
        this.m_siteController.buildScreen(this.m_window, statusBarListener);
        this.m_channel.buildScreen(this.m_window, statusBarListener);
        this.m_history.buildScreen(this.m_window, statusBarListener);
        this.m_tabbedPane.addTab("Site Info", this.m_site);
        this.m_tabbedPane.addTab("Site Controller", this.m_siteController);
        this.m_tabbedPane.addTab("Channel", this.m_channel);
        this.m_tabbedPane.addTab("History", this.m_history);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add(this.m_tabbedPane);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.m_site.initialize();
        this.m_siteController.initialize();
        this.m_channel.initialize();
        this.m_history.initialize();
        this.m_tabbedPane.setSelectedIndex(0);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateRegistration(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateRegistration()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in Registering with the Device. Closing the Screen");
            this.popupError(-458752);
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateRegistration()");
    }

    public void updateDeRegistration(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateDeRegistration()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in Deregistering with the Device. Closing the Screen anyways");
            this.popupError(-458753);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateDeRegistration()");
    }

    public void realTimeUpdate(Object object) {
        String string;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String[] stringArray = null;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter realTimeUpdate()arguments: g_rtObj = " + object));
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        int n8 = realTimeDataObject.getSize();
        stringArray = new String[n8];
        int n9 = 0;
        while (n9 < n8) {
            stringArray[n9] = "";
            try {
                stringArray[n9] = realTimeDataObject.getName(n9);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
            if (stringArray[n9].indexOf("State") != -1) {
                n = n9;
            } else if (stringArray[n9].indexOf("Cause") != -1) {
                n2 = n9;
            } else if (stringArray[n9].equalsIgnoreCase("nmaDateTime")) {
                n4 = n9;
            } else if (stringArray[n9].indexOf("ScBoxAlarmCode") != -1) {
                n5 = n9;
            } else if (stringArray[n9].indexOf("ScBoxText") != -1) {
                n6 = n9;
            } else if (stringArray[n9].indexOf("nmaDeviceState") != -1) {
                n7 = n9;
            }
            ++n9;
        }
        if (n7 != -1) {
            try {
                string = (String)realTimeDataObject.getValue(n7);
                this.m_siteController.realTimeUpdate(string);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
        }
        if (n6 != -1 && n5 != -1 && n4 != -1) {
            try {
                string = (String)realTimeDataObject.getValue(n5);
                String string2 = (String)realTimeDataObject.getValue(n6);
                String string3 = (String)realTimeDataObject.getValue(n4);
                this.m_site.realTimeUpdate(string, string2, string3);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
        } else if (n != -1 && n2 != -1 && n4 != -1) {
            string = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            try {
                string = (String)realTimeDataObject.getValue(n);
                string4 = (String)realTimeDataObject.getValue(n2);
                string6 = (String)realTimeDataObject.getValue(n4);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
            if (stringArray[n].indexOf("SiteState") != -1) {
                this.m_site.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("scCommonBoxState") != -1) {
                this.m_siteController.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("scCommonFanState") != -1) {
                this.m_siteController.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("scCommonGPSState") != -1) {
                this.m_siteController.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("scCommonSwitchState") != -1) {
                this.m_siteController.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("scCommonPwrSupplyState") != -1) {
                this.m_siteController.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf("ChlState") != -1) {
                this.m_channel.realTimeUpdate(string6, stringArray[n], string, stringArray[n2], string4);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Couldn't Interpret the RealTimeData Packet correctly");
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Couldn't Interpret the RealTimeData Packet correctly");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit realTimeUpdate()");
    }

    public void startWriteToFile() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startWriteToFile()");
        this.m_site.writeToFile();
        this.m_siteController.writeToFile();
        this.m_channel.writeToFile();
        this.m_history.writeToFile();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startWriteToFile()");
    }

    public void closeScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter SCSummit Status Panel closeScreen() method");
        if (this.m_window != null) {
            this.m_window.unlockWindow();
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit SCSummit Status Panel closeScreen() method");
    }

    public void startScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startScreen()");
        this.initialize();
        SCSummitStatusPanelMaker.getGuiListener().startProcess();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startScreen()");
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    public void closeScreen(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter closeScreen(): g_cleanup = " + bl));
        if (bl) {
            try {
                this.m_window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit closeScreen()");
    }
}

