/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.device.common.util.DeviceConstants;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import pnm.util.Audit;

public class ApplicationMessenger
implements CssConstants,
DeviceConstants {
    private static final String FILE = "ApplicationMessenger";
    PipedOutputStream m_pos = null;
    ObjectOutputStream m_ostream = null;

    public ApplicationMessenger(PipedInputStream pipedInputStream) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)("Enter Constructor of ApplicationMessenger  class = " + pipedInputStream));
        try {
            this.m_pos = new PipedOutputStream(pipedInputStream);
            this.m_ostream = new ObjectOutputStream(this.m_pos);
        }
        catch (IOException iOException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Unable to open pipe");
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit Constructor of ApplicationMessenger Class");
    }

    public void setData(Object object) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)("Enter setData method = " + object));
        try {
            this.m_ostream.writeObject((RealTimeDataObject)object);
            this.m_ostream.flush();
            this.m_ostream.reset();
            this.m_pos.flush();
        }
        catch (IOException iOException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Unable to write data to pipe");
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit setData method = ");
    }

    void closeOutputStreams() {
        try {
            this.m_ostream.close();
            this.m_pos.close();
        }
        catch (IOException iOException) {
            Audit.audit((int)3, (String)FILE, (String)("Exception in closing streams: " + iOException.getMessage()));
        }
    }
}

