/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.NotFoundException;
import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.util.Vector;
import pnm.util.Audit;

public class DatagramQueue
implements Runnable,
CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes {
    private Vector m_datagrams;
    private Vector m_realTimedatagrams;
    private boolean m_isActive = true;
    private CmdManager m_manager;

    public DatagramQueue(CmdManager cmdManager) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)this.toString(), (String)"Enter Constructor of DatagramQueue");
        this.m_datagrams = new Vector();
        this.m_realTimedatagrams = new Vector();
        this.m_manager = cmdManager;
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)this.toString(), (String)"Exit Constructor of DatagramQueue Class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.m_isActive) {
            DatagramQueue datagramQueue = this;
            synchronized (datagramQueue) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("sendDatagram:Wait timer expired. " + interruptedException));
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("sendDatagram:Current thread is not the owner of the object's monitor. " + illegalMonitorStateException));
                }
            }
            while (!this.m_realTimedatagrams.isEmpty()) {
                try {
                    Datagram datagram;
                    DatagramQueue datagramQueue2 = this;
                    synchronized (datagramQueue2) {
                        datagram = (Datagram)this.m_realTimedatagrams.elementAt(0);
                        this.m_realTimedatagrams.removeElementAt(0);
                    }
                    DeviceSessions deviceSessions = this.m_manager.getDeviceSessions();
                    Protocol protocol = deviceSessions.getProtocolHandle(datagram.getSessionID());
                    protocol.reply(datagram);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.toString(), (String)("Array Index out of bounds in m_datagrams. " + arrayIndexOutOfBoundsException));
                }
                catch (NotFoundException notFoundException) {
                    Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.toString(), (String)"CmdManager:doOperation: Can't find protocol handle from session id.");
                }
            }
        }
    }

    public int addDatagram(Datagram datagram) {
        int n = 0;
        short s = 0;
        s = datagram.getSessionFlags();
        DatagramQueue datagramQueue = this;
        synchronized (datagramQueue) {
            if ((s & 1) != 0) {
                this.m_realTimedatagrams.addElement(datagram);
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("sendDatagram:Current thread is not the owner of the object's monitor. " + illegalMonitorStateException));
                    n = -5;
                }
            } else {
                this.m_datagrams.addElement(datagram);
            }
        }
        return n;
    }

    public void terminateQueueThread() {
        this.m_isActive = false;
        this.m_datagrams.clear();
        this.m_realTimedatagrams.clear();
        DatagramQueue datagramQueue = this;
        synchronized (datagramQueue) {
            try {
                this.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)this.toString(), (String)("terminateQueueThread:Current thread is not the owner of the object's monitor. " + illegalMonitorStateException));
            }
        }
    }

    public Datagram getReplyIfAvailable() {
        DatagramQueue datagramQueue = this;
        synchronized (datagramQueue) {
            if (!this.m_datagrams.isEmpty()) {
                Datagram datagram = (Datagram)this.m_datagrams.elementAt(0);
                this.m_datagrams.removeElementAt(0);
                Datagram datagram2 = datagram;
                return datagram2;
            }
            Datagram datagram = null;
            return datagram;
        }
    }

    public void clearReplyQueue() {
        DatagramQueue datagramQueue = this;
        synchronized (datagramQueue) {
            this.m_datagrams.clear();
        }
    }
}

