/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.DataObject;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.device.common.protocol.cmdmgr.ApplicationMessenger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.InPort;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.TranslationInfo;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.io.PipedInputStream;
import pnm.util.Audit;

class Protocol
implements CssConstants,
CmdMgrConstants,
CssErrorCodes,
DeviceConstants,
DeviceErrorCodes {
    public static final String FILE = "Protocol";
    DataObject ref_DataObject;
    DevicePorts ref_DevicePorts;
    DeviceSessions ref_DeviceSessions;
    private byte m_sessionID;
    private byte m_opcode = 0;
    private byte m_subcode = 0;
    private byte m_sessionType;
    private int m_port;
    private TranslationInfo m_translationInfo;
    private DataObject m_dataObject;
    private CmdManager m_commandManager;
    private ApplicationMessenger m_applicationPipe;

    Protocol(byte by, int n, byte by2, Object[][] objectArray, CmdManager cmdManager, DataObject dataObject) {
        InPort inPort = null;
        OutPort outPort = null;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol Constructor");
        this.m_sessionType = by;
        this.m_port = n;
        this.m_sessionID = by2;
        this.m_commandManager = cmdManager;
        this.m_translationInfo = new TranslationInfo(objectArray);
        this.ref_DevicePorts = cmdManager.getDevicePorts();
        this.ref_DeviceSessions = cmdManager.getDeviceSessions();
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            if (!this.ref_DevicePorts.portExists(n) && n == 1054) {
                inPort = new InPort(n, false, cmdManager);
                outPort = new OutPort(n, false, cmdManager, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                thread.start();
                Thread thread2 = new Thread(outPort);
                thread2.start();
            } else if (!this.ref_DevicePorts.portExists(n) && n != 1054) {
                inPort = new InPort(n, true, cmdManager);
                outPort = new OutPort(n, true, cmdManager, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                thread.start();
                Thread thread3 = new Thread(outPort);
                thread3.start();
            } else if (this.ref_DevicePorts.portExists(n) && n == 1054) {
                inPort = this.ref_DevicePorts.getInPortHandle(n);
                inPort.setKeepAlives(true);
                outPort = this.ref_DevicePorts.getOutPortHandle(n);
                outPort.setKeepAlives(true);
            } else if (this.ref_DevicePorts.portExists(n) && n != 1054) {
                inPort = this.ref_DevicePorts.getInPortHandle(n);
                outPort = this.ref_DevicePorts.getOutPortHandle(n);
            }
            this.ref_DevicePorts.addPort(n, inPort, outPort);
            this.ref_DeviceSessions.addEntry(by2, this.getName(by, dataObject), n, this);
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit Protocol Constructor");
    }

    public synchronized DataObject doOperation(DataObject dataObject) {
        byte[] byArray;
        Datagram datagram = null;
        Datagram datagram2 = null;
        int n = 0;
        byte by = 0;
        byte by2 = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        Integer n4 = new Integer(-1);
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol.doOperation");
        this.m_dataObject = dataObject;
        datagram = this.buildDatagram(dataObject, this.m_sessionType, this.m_sessionID);
        if (datagram == null) {
            dataObject.setError(-10);
            n3 = -10;
        } else {
            if (datagram.getSessionID() == 0) {
                datagram.setProtocolFlags((short)1);
            }
            datagram2 = null;
            datagram2 = this.routeDatagram(datagram);
            if (datagram2 == null) {
                dataObject.setError(-15);
                n3 = -15;
            } else if (datagram2.getOpcode() == -1) {
                byArray = datagram2.getData();
                dataObject.setError(-1);
                n3 = -1;
            }
        }
        if (n3 == 0) {
            n = dataObject.getProtocolKey();
            if (n == 2001 || n == 2004 || n == 2003 || n == 2002) {
                byArray = datagram2.getData();
                by = byArray[0];
                by2 = byArray[1];
                n2 = byArray[2];
                n2 <<= 8;
                n2 |= byArray[3];
                n2 <<= 8;
                n2 |= byArray[4];
                n2 <<= 8;
                Protocol protocol = new Protocol(by, n2 |= byArray[5], by2, (Object[][])dataObject.getParameterValue("TranslationInfo"), this.m_commandManager, dataObject);
                if (dataObject.getParameterValue("realTimeDataPipe") != n4) {
                    PipedInputStream pipedInputStream = (PipedInputStream)dataObject.getParameterValue("realTimeDataPipe");
                    ApplicationMessenger applicationMessenger = new ApplicationMessenger(pipedInputStream);
                    protocol.setApplicationPipe(applicationMessenger);
                } else {
                    dataObject.setError(-7);
                    n3 = -7;
                }
            } else if (datagram.getOpcode() == 1) {
                this.close();
            }
            dataObject = this.buildDataObject(datagram2);
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)("Exit Protocol.doOperation. Status=" + n3));
        return dataObject;
    }

    public void setApplicationPipe(ApplicationMessenger applicationMessenger) {
        this.m_applicationPipe = applicationMessenger;
    }

    public void removeApplicationPipe() {
        if (this.m_applicationPipe != null) {
            this.m_applicationPipe.closeOutputStreams();
            this.m_applicationPipe = null;
        }
    }

    public int reply(Datagram datagram) {
        int n = 0;
        short s = 0;
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol.reply");
        s = datagram.getSessionFlags();
        this.checkForError(datagram);
        if ((s & 1) != 0) {
            try {
                RealTimeDataObject realTimeDataObject = new RealTimeDataObject();
                String[] stringArray = this.m_translationInfo.getOpcodeReceiveParamsNameArray(datagram.getOpcode(), datagram.getSubOpcode());
                String[] stringArray2 = this.m_translationInfo.getOpcodeReceiveDataFormat(datagram.getOpcode(), datagram.getSubOpcode());
                byte[] byArray = datagram.getData();
                int n2 = 0;
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        int n4;
                        byte[] byArray2;
                        if (stringArray[n3].equalsIgnoreCase("X")) {
                            if (byArray.length - n2 != 0) {
                                int n5 = n2;
                                byArray2 = new byte[byArray.length - n2];
                                n4 = 0;
                                while (n4 < byArray.length - n2) {
                                    byArray2[n4] = byArray[n5++];
                                    ++n4;
                                }
                                realTimeDataObject.insertValue(stringArray[n3], "byte[]", (Object)byArray2);
                            } else {
                                realTimeDataObject.insertValue(stringArray[n3], "byte[]", null);
                            }
                        } else {
                            int n6 = new Integer(stringArray2[n3]);
                            byArray2 = new byte[n6];
                            n4 = 0;
                            while (n4 < n6) {
                                byArray2[n4] = byArray[n2++];
                                ++n4;
                            }
                            realTimeDataObject.insertValue(stringArray[n3], "byte[]", (Object)byArray2);
                        }
                        ++n3;
                    }
                } else {
                    realTimeDataObject = null;
                }
                this.m_applicationPipe.setData(realTimeDataObject);
            }
            catch (Exception exception) {
                RealTimeDataObject realTimeDataObject = new RealTimeDataObject();
                realTimeDataObject.setError(-262165);
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Corrupted real time data");
            }
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit Protocol.reply");
        return n;
    }

    public Datagram buildDatagram(DataObject dataObject, byte by, byte by2) {
        byte[] byArray;
        Datagram datagram;
        block11: {
            String string = null;
            String[] stringArray = null;
            Object[] objectArray = null;
            Object var8_7 = null;
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            int n = -1;
            Object var12_11 = null;
            Object var13_12 = null;
            byte[] byArray2 = null;
            datagram = null;
            byArray = null;
            int n2 = 0;
            int n3 = 0;
            Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol.buildDatagram");
            if (dataObject == null) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Dataobject is null");
                return datagram;
            }
            try {
                this.m_dataObject = dataObject;
                int n4 = dataObject.getProtocolKey();
                string = dataObject.getSessionName();
                stringArray2 = this.m_translationInfo.getSendParamsNameArray(n4);
                stringArray3 = this.m_translationInfo.getSendDataFormat(n4);
                this.m_opcode = this.m_translationInfo.getActionCode(n4);
                this.m_subcode = this.m_translationInfo.getActionSubCode(n4);
                stringArray = dataObject.getParameterNamesArray();
                if (stringArray2 == null) break block11;
                int n5 = 0;
                while (n5 < stringArray3.length) {
                    try {
                        n3 += Integer.parseInt(stringArray3[n5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Cannot convert string to integer: " + numberFormatException));
                    }
                    ++n5;
                }
                byArray = new byte[n3];
                if (stringArray != null) {
                    int n6 = 0;
                    while (n6 < stringArray.length) {
                        if (!stringArray[n6].equalsIgnoreCase(stringArray2[n6])) {
                            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Send Name array does not match");
                            dataObject.setError(-8);
                            datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                            datagram.setProtocolFlags((short)3);
                            return datagram;
                        }
                        objectArray = dataObject.getParameterValuesArray();
                        int n7 = new Integer(stringArray3[n6]);
                        byArray2 = this.convertToByteFormat(objectArray[n6]);
                        int n8 = n7 - 1;
                        while (n8 >= 0) {
                            byArray[n2] = byArray2[n8];
                            ++n2;
                            --n8;
                        }
                        ++n6;
                    }
                    break block11;
                }
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Name array received from dataobject is null");
                dataObject.setError(-7);
                datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                datagram.setProtocolFlags((short)3);
                return datagram;
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Couldn't find row in translation Info");
                datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                datagram.setProtocolFlags((short)3);
                return datagram;
            }
        }
        datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
        datagram.setProtocolFlags((short)3);
        if (byArray != null) {
            datagram.setData(byArray);
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit Protocol.buildDatagram");
        return datagram;
    }

    public DataObject buildDataObject(Datagram datagram) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        Object var6_4 = null;
        byte[] byArray = null;
        int n = -1;
        byte[] byArray2 = null;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol.buildDataobject");
        if (datagram == null) {
            this.m_dataObject.setError(-10);
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Datagram is null");
        } else {
            try {
                byArray = datagram.getData();
                stringArray = this.m_translationInfo.getOpcodeReceiveParamsNameArray(this.m_opcode, this.m_subcode);
                String[] stringArray3 = this.m_translationInfo.getOpcodeReceiveDataFormat(this.m_opcode, this.m_subcode);
                stringArray2 = this.m_dataObject.getParameterNamesArray();
                if (stringArray != null) {
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            if (stringArray[n3].equalsIgnoreCase(stringArray2[n4])) {
                                int n5 = new Integer(stringArray3[n3]);
                                byArray2 = new byte[n5];
                                int n6 = 0;
                                while (n6 < n5) {
                                    byArray2[n6] = byArray[n2++];
                                    ++n6;
                                }
                                this.m_dataObject.setParameterValue(stringArray2[n4], (Object)byArray2);
                                break;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Receive Name array does not match");
                this.m_dataObject.setError(-22);
            }
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)("End of buildDataObject method = " + this.m_dataObject));
        return this.m_dataObject;
    }

    public byte[] convertToByteFormat(Object object) {
        byte[] byArray = null;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)("Enter ConvertToByteFormat g_obj" + object));
        try {
            if (object instanceof Long) {
                long l = (Long)object;
                byArray = new byte[8];
                byArray[0] = (byte)(l & 0xFFL);
                int n = 1;
                while (n < 8) {
                    byArray[n] = (byte)(l >> 8 * n & 0xFFL);
                    ++n;
                }
            } else if (object instanceof Double) {
                double d = (Double)object;
                long l = Double.doubleToLongBits(d);
                byArray = new byte[8];
                byArray[0] = (byte)(l & 0xFFL);
                int n = 1;
                while (n < 8) {
                    byArray[n] = (byte)(l >> 8 * n & 0xFFL);
                    ++n;
                }
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                byArray = new byte[4];
                byArray[0] = (byte)(n & 0xFF);
                int n2 = 1;
                while (n2 < 4) {
                    byArray[n2] = (byte)(n >> 8 * n2 & 0xFF);
                    ++n2;
                }
            } else if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                int n = Float.floatToIntBits(f);
                byArray = new byte[4];
                byArray[0] = (byte)(n & 0xFF);
                int n3 = 1;
                while (n3 < 4) {
                    byArray[n3] = (byte)(n >> 8 * n3 & 0xFF);
                    ++n3;
                }
            } else if (object instanceof Short) {
                short s = (Short)object;
                byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
            } else if (object instanceof String) {
                byArray = ((String)object).getBytes();
            } else if (object instanceof Boolean) {
                byArray = new byte[1];
                byArray[0] = !((Boolean)object).booleanValue() ? new Byte(0).byteValue() : new Byte(1).byteValue();
            } else if (object instanceof Byte) {
                byArray = new byte[]{(Byte)object};
            } else if (object instanceof Character) {
                char c = ((Character)object).charValue();
                byArray = new byte[]{(byte)(c & 0xFF), (byte)(c >> 8 & 0xFF)};
            }
        }
        catch (Exception exception) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Unable to convert to byte array[]" + exception));
        }
        return byArray;
    }

    public String getName(byte by, DataObject dataObject) {
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)("Enter Protocol.getName.  SessionType=" + by));
        String string = by == 0 ? "command" : dataObject.getSessionName();
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)("Exit Protocol.getName. Name=" + string));
        return string;
    }

    public Datagram routeDatagram(Datagram datagram) {
        Datagram datagram2 = null;
        Datagram datagram3 = null;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)"Enter Protocol.routeDatagram");
        OutPort outPort = this.ref_DevicePorts.getOutPortHandle(this.m_port);
        InPort inPort = this.ref_DevicePorts.getInPortHandle(this.m_port);
        inPort.getDatagramQueue().clearReplyQueue();
        int n = 0;
        while (n < 3 && datagram2 == null) {
            block19: {
                outPort.sendDatagram(datagram);
                try {
                    Protocol protocol = this;
                    synchronized (protocol) {
                        int n2 = 0;
                        while (n2 < 24) {
                            datagram3 = inPort.getDatagramQueue().getReplyIfAvailable();
                            if (datagram3 != null) {
                                datagram2 = datagram3;
                                break;
                            }
                            this.wait(250L);
                            ++n2;
                        }
                    }
                    if (datagram2 != null) {
                        if (datagram2.getSessionType() == 0) {
                            if (datagram2.getSubOpcode() == datagram.getOpcode()) {
                                n = 3;
                            } else {
                                datagram2 = null;
                            }
                            break block19;
                        }
                        if (datagram2.getOpcode() == 1 && datagram2.getSubOpcode() == datagram.getProtocolSequenceNumber()) {
                            n = 3;
                            if (datagram.getOpcode() == 1) break block19;
                            Protocol protocol2 = this;
                            synchronized (protocol2) {
                                datagram2 = null;
                                int n3 = 0;
                                while (n3 < 40) {
                                    datagram3 = inPort.getDatagramQueue().getReplyIfAvailable();
                                    if (datagram3 != null) {
                                        datagram2 = datagram3;
                                        break;
                                    }
                                    this.wait(250L);
                                    ++n3;
                                }
                                break block19;
                            }
                        }
                        Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"InPort:routeDatagram: NO IDEA ABOUT PACKET SO IGNORE.");
                        break block19;
                    }
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"InPort:routeDatagram: Reply Was Null");
                }
                catch (InterruptedException interruptedException) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"InPort:routeDatagram: Wait Timer expired.");
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    Audit.audit((int)CssConstants.AUDIT_FATAL_EXCEPTION, (String)FILE, (String)"InPort:routeDatagram: Illegal Monitor State.");
                }
            }
            ++n;
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)"Exit Protocol.routeDatagram");
        return datagram2;
    }

    public byte getHeaderVersion(byte by) {
        Datagram datagram = null;
        byte by2 = 0;
        Audit.audit((int)CssConstants.AUDIT_ENTER_METHOD, (String)FILE, (String)("Enter Protocol.getHeaderVersion.  Version Type=" + by));
        datagram = null;
        Datagram datagram2 = new Datagram(0, 0, by, 0);
        datagram2.setProtocolFlags((short)1);
        datagram = this.routeDatagram(datagram2);
        if (datagram != null) {
            byte[] byArray = datagram.getData();
            by2 = byArray[0];
        }
        Audit.audit((int)CssConstants.AUDIT_EXIT_METHOD, (String)FILE, (String)("Exit Protocol.getHeaderVersion.  Version=" + by2));
        return by2;
    }

    public void sendPipeData(byte[] byArray) {
        this.m_applicationPipe.setData(byArray);
    }

    public int restartDevice() {
        int n = 0;
        Datagram datagram = new Datagram(0, 0, 7, 0);
        datagram.setProtocolFlags((short)1);
        OutPort outPort = this.ref_DevicePorts.getOutPortHandle(1054);
        n = outPort.sendDatagram(datagram);
        return n;
    }

    public void close() {
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            this.ref_DevicePorts.deletePort(this.m_port);
            this.ref_DeviceSessions.deleteEntry(this.m_sessionID);
            this.removeApplicationPipe();
        }
    }

    public void checkForError(Datagram datagram) {
        if (datagram.getOpcode() == -1 && this.m_applicationPipe != null && datagram.getSubOpcode() < 0) {
            RealTimeDataObject realTimeDataObject = new RealTimeDataObject();
            realTimeDataObject.setError(datagram.getSubOpcode() + -262144);
            this.m_applicationPipe.setData(realTimeDataObject);
        }
    }
}

