/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.deviceifcfactory.DeviceInterfaceFactory;
import css.core.deviceifcfactory.RecipeFileManager;
import css.core.screens.tools.StatusBarListener;
import css.core.util.CSSException;
import css.core.util.CssConstants;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.CommonHardwareVersion;
import css.device.common.screens.CommonSoftwareVersion;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class CommonVersion
extends GenericScreen {
    private final String FILE = "CommonVersion";
    private static final String INVALID_STRING = "Invalid";
    private static final int INVALID_NUMBER = Integer.MAX_VALUE;
    private static final String NONE = "None";
    private static final String NO_FILE_PRESENT = "No File Present";
    private static final String CRC_ERROR = "CRC Error";
    private static final String NMA_MARKED_INVALID = "NMA Marked Invalid";
    private static final String TRANSFER_IN_PROGRESS = "Transfer In Progress";
    private static final String TRANSFER_INCOMPLETE = "Transfer Incomplete";
    private static final String INSTALL_INCOMPLETE = "Prepare To Install Incomplete";
    private static final int HARDWARE_VER_TYPE = 4;
    private static final int FILESET_VER_TYPE = 6;
    private static final int INVALID_OP_STATUS = 1;
    private static final int INUSE_OP_STATUS = 3;
    private static final String INVALID = "Invalid";
    private static final String PRESENT = "Present";
    private static final String INUSE = "In Use";
    private static final String TRANSFERRED = "Transferred";
    private CommonSoftwareVersion m_commonSoftwareVersion;
    private CommonHardwareVersion m_commonHardwareVersion;
    private JTabbedPane m_tabbedPane;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private boolean bankFound = false;

    public CommonVersion() {
        this.m_commonSoftwareVersion = new CommonSoftwareVersion();
        this.m_commonHardwareVersion = new CommonHardwareVersion();
        this.setLayout(new GridBagLayout());
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter buildScreen() arguments:g_window = " + object + " g_statusBarListener = " + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonVersion.this);
                CommonVersion.this.m_window.setVisible(false);
            }
        });
        this.m_tabbedPane = new JTabbedPane();
        this.m_commonSoftwareVersion.buildScreen((UIInternalFrame)object, statusBarListener);
        this.m_commonHardwareVersion.buildScreen((UIInternalFrame)object, statusBarListener);
        this.m_tabbedPane.addTab("Hardware Version", this.m_commonHardwareVersion);
        this.m_tabbedPane.addTab("Software Version", this.m_commonSoftwareVersion);
        this.m_tabbedPane.setSelectedIndex(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)"Enter initialize()");
        this.m_commonSoftwareVersion.initialize();
        this.m_commonHardwareVersion.initialize();
        this.m_tabbedPane.setSelectedIndex(0);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)"Exit initialize()");
    }

    public void updateVersionParams(int n, Integer[] integerArray, String[] stringArray, String[] stringArray2, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, Integer[] integerArray5, Integer[] integerArray6, Integer[] integerArray7, Integer[] integerArray8, Integer[] integerArray9, Integer[] integerArray10, Integer[] integerArray11, Integer[] integerArray12, String[] stringArray3) {
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter updateVersionParams() arguments:g_error = " + n + " g_verIndex = " + integerArray + "g_name = " + stringArray + "g_version = " + stringArray2 + " g_locationId = " + integerArray2 + "g_verType = " + integerArray3 + " g_filesetId = " + integerArray4 + "g_opStatus = " + integerArray5 + " g_state = " + integerArray6 + "g_currentIndex = " + integerArray7 + " g_nextIndex = " + integerArray8 + "g_fallbackIndex = " + integerArray9 + " g_sysUpgradeDate = " + integerArray10 + "g_boxUpgradeDate = " + integerArray11 + "g_activationDate = " + integerArray12));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.toString(), (String)"Error in getting Version Table Info");
            this.m_errPopup.display(-524288);
        } else {
            Vector[] vectorArray = new Vector[8];
            int n2 = 0;
            while (n2 < vectorArray.length) {
                vectorArray[n2] = new Vector();
                ++n2;
            }
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < integerArray3.length) {
                if (integerArray3[n3] == 4) {
                    String string = this.convDate(integerArray12[n3]);
                    this.m_commonHardwareVersion.updateTable(stringArray[n3], stringArray2[n3], string);
                } else {
                    boolean bl3 = this.checkOID(stringArray3[n3]);
                    if (integerArray5[n3] == 3 && integerArray3[n3] == 6 && bl3) {
                        String string = "Invalid";
                        String string2 = "Invalid";
                        String string3 = "Invalid";
                        int n4 = integerArray7[n3];
                        int n5 = integerArray8[n3];
                        int n6 = integerArray9[n3];
                        int n7 = 0;
                        while (n7 < integerArray.length) {
                            int n8;
                            if (integerArray[n7] == n4) {
                                n8 = integerArray2[n7];
                                string = this.convIndexToString(n8);
                            }
                            if (integerArray[n7] == n5) {
                                n8 = integerArray2[n7];
                                string2 = this.convIndexToString(n8);
                            }
                            if (integerArray[n7] == n6) {
                                n8 = integerArray2[n7];
                                string3 = this.convIndexToString(n8);
                            }
                            ++n7;
                        }
                        if (n4 == Integer.MAX_VALUE) {
                            string = "Invalid";
                        }
                        if (n5 == Integer.MAX_VALUE) {
                            string2 = "Invalid";
                        }
                        if (n6 == Integer.MAX_VALUE) {
                            string3 = "Invalid";
                        }
                        if (this.bankFound & !bl) {
                            this.m_commonSoftwareVersion.updateIndexes(string, string2, string3);
                            bl = true;
                        }
                    }
                    bl2 = false;
                    if (integerArray5[n3] != 1) {
                        bl2 = true;
                    } else {
                        int n9 = 0;
                        while (n9 < integerArray3.length) {
                            if (integerArray4[n9].intValue() == integerArray4[n3].intValue() && integerArray5[n9] != 1) {
                                bl2 = true;
                                break;
                            }
                            ++n9;
                        }
                    }
                    if (bl2) {
                        int n10 = vectorArray[0].size();
                        int n11 = 0;
                        while (n11 < vectorArray[0].size()) {
                            if (integerArray4[n3].intValue() == ((Integer)vectorArray[0].elementAt(n11)).intValue()) {
                                if (integerArray3[n3] == 6) {
                                    n10 = n11;
                                    break;
                                }
                                n10 = n11 + 1;
                                break;
                            }
                            ++n11;
                        }
                        vectorArray[0].insertElementAt(integerArray4[n3], n10);
                        vectorArray[1].insertElementAt(stringArray[n3], n10);
                        vectorArray[2].insertElementAt(stringArray2[n3], n10);
                        if (integerArray5[n3] == 1) {
                            vectorArray[3].insertElementAt(this.convState(integerArray6[n3]), n10);
                        } else {
                            vectorArray[3].insertElementAt(this.convOpStatus(integerArray5[n3]), n10);
                        }
                        vectorArray[4].insertElementAt(this.convIndexToString(integerArray2[n3]), n10);
                        vectorArray[5].insertElementAt(this.convDate(integerArray10[n3]), n10);
                        vectorArray[6].insertElementAt(this.convDate(integerArray11[n3]), n10);
                        vectorArray[7].insertElementAt(this.convDate(integerArray12[n3]), n10);
                    }
                }
                ++n3;
            }
            if (vectorArray[0].size() > 0) {
                int n12 = (Integer)vectorArray[0].elementAt(0);
                int n13 = 0;
                while (n13 < vectorArray[0].size()) {
                    if (n12 != (Integer)vectorArray[0].elementAt(n13)) {
                        n12 = (Integer)vectorArray[0].elementAt(n13);
                        this.m_commonSoftwareVersion.updateTable("", "", "", "", "", "", "");
                    }
                    this.m_commonSoftwareVersion.updateTable((String)vectorArray[1].elementAt(n13), (String)vectorArray[2].elementAt(n13), (String)vectorArray[3].elementAt(n13), (String)vectorArray[4].elementAt(n13), (String)vectorArray[5].elementAt(n13), (String)vectorArray[6].elementAt(n13), (String)vectorArray[7].elementAt(n13));
                    ++n13;
                }
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)"Exit updateVersionParams()");
    }

    private String convState(int n) {
        String string = "n/a";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter convState()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = NONE;
                break;
            }
            case 2: {
                string = NO_FILE_PRESENT;
                break;
            }
            case 3: {
                string = CRC_ERROR;
                break;
            }
            case 4: {
                string = NMA_MARKED_INVALID;
                break;
            }
            case 5: {
                string = TRANSFER_IN_PROGRESS;
                break;
            }
            case 6: {
                string = TRANSFER_INCOMPLETE;
                break;
            }
            case 7: {
                string = INSTALL_INCOMPLETE;
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)("Exit convState() return: " + string));
        return string;
    }

    private String convOpStatus(int n) {
        String string = "n/a";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter convOpStatus()arguments: g_status = " + n));
        switch (n) {
            case 1: {
                string = "Invalid";
                break;
            }
            case 2: {
                string = PRESENT;
                break;
            }
            case 3: {
                string = INUSE;
                break;
            }
            case 4: {
                string = TRANSFERRED;
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)("Exit convOpStatus() return: " + string));
        return string;
    }

    private String convDate(int n) {
        String string = "n/a";
        long l = 0L;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter convDate()arguments: g_date = " + n));
        l = 0xFFFFFFFFL & (long)n;
        Date date = new Date(l *= 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        string = simpleDateFormat.format(date);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
        string = string + " " + simpleDateFormat2.format(date);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)("Exit convDate() return: " + string));
        return string;
    }

    private String convIndexToString(int n) {
        String string = "n/a";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.toString(), (String)("Enter convIndexToString()arguments: g_index = " + n));
        if (n == 1) {
            string = "DRAM";
        } else if (n > 1) {
            string = "BANK " + (n - 1);
            this.bankFound = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.toString(), (String)("Exit convIndexToString() return: " + string));
        return string;
    }

    private boolean checkOID(String string) {
        boolean bl = false;
        try {
            RecipeFileManager recipeFileManager = new RecipeFileManager();
            Vector vector = recipeFileManager.getExtraParams(DeviceInterfaceFactory.getCurrentDeviceName(), "EthernetConnectionInterface");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.startsWith(vector.get(n2).toString())) {
                    bl = true;
                    break;
                }
                bl = false;
                ++n2;
            }
        }
        catch (CSSException cSSException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"Common Version", (String)("checkOID():" + cSSException.toString()));
        }
        return bl;
    }
}

