/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class CommonVlanScreen
extends GenericScreen
implements ActionListener {
    private final String FILE = "CommonVlanScreen";
    private ErrorPopup m_errorPopup = new ErrorPopup();
    public JButton m_okBtn = new JButton("  OK  ");
    private JButton m_cancelBtn = new JButton("Cancel");
    private JTextField m_vlanRequestedTFld;
    private JLabel m_vlanActualTFld;
    private int m_count;
    Integer[] m_agentState;
    boolean m_state = true;

    public CommonVlanScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)"Enter constructor method");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit constructor method");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)("Enter buildScreen() arguments: g_window = " + object + ", g_statusBar = " + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonVlanScreen.this);
                CommonVlanScreen.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setText("Actual Vlan Number");
        jLabel.setToolTipText("Actual Vlan Number of the Station");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(50, 10));
        jPanel3.add(jLabel2);
        this.m_vlanActualTFld = new JLabel("N/A");
        this.m_vlanActualTFld.setBackground(this.getBackground());
        this.m_vlanActualTFld.setPreferredSize(new Dimension(60, 20));
        jPanel3.add(this.m_vlanActualTFld);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Requested Vlan Number");
        jLabel3.setToolTipText("Requested Vlan Number of the device");
        jPanel4.add(jLabel3);
        JLabel jLabel4 = new JLabel("");
        jLabel4.setPreferredSize(new Dimension(22, 10));
        jPanel4.add(jLabel4);
        this.m_vlanRequestedTFld = new JTextField();
        this.m_vlanRequestedTFld.setPreferredSize(new Dimension(60, 20));
        this.m_vlanRequestedTFld.addActionListener(this);
        jPanel4.add(this.m_vlanRequestedTFld);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this.m_okBtn.setToolTipText("Set Requested Vlan Number in device");
        jPanel5.add(this.m_okBtn);
        JLabel jLabel5 = new JLabel("");
        jLabel5.setPreferredSize(new Dimension(10, 10));
        jPanel5.add(jLabel5);
        this.m_cancelBtn.setToolTipText("Ignore any changes and close Screen");
        this.m_cancelBtn.addActionListener(this);
        jPanel5.add(this.m_cancelBtn);
        jPanel2.add(jPanel5);
        statusBarListener.registerComponent((Component)this.m_vlanRequestedTFld, "Enter Vlan number ");
        statusBarListener.registerComponent((Component)this.m_okBtn, "Click this button to set Vlan Number in device");
        statusBarListener.registerComponent((Component)this.m_cancelBtn, "Click this button to clear all changes and return to previous settings");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit buildScreen() ");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)"Enter initialize()");
        this.m_vlanActualTFld.setText("N/A");
        this.m_vlanRequestedTFld.setText(" ");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit initialize()");
    }

    public Object[] getVlanNumber() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)"Enter getVlanNumber");
        Object[] objectArray = new Object[]{this.m_vlanRequestedTFld.getText().trim()};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)(" Exit getVlanNumber " + objectArray));
        return objectArray;
    }

    public void updateVlanNumber(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)("Enter updateVlanNumber(), arguments: g_error = " + n));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"CommonVlanScreen", (String)"Unable to set vlan Number");
            if (this.m_window.isVisible()) {
                this.m_errorPopup.display(-327930);
            }
        } else {
            this.m_vlanActualTFld.setText(this.m_vlanRequestedTFld.getText().trim());
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit updateVlanNumber()");
    }

    public void updateCurrentVlanNumber(int n, Integer n2, Integer n3) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)("Enter updateCurrentVlanNumber(), arguments: g_error = " + n + "g_vlanNumber " + n2 + " g_vLanCount " + n3));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"CommonVlanScreen", (String)"Unable to get vlan number");
            this.popupError(-327931);
        } else {
            this.m_count = n3;
            this.m_vlanActualTFld.setText(n2.toString());
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit updateCurrentVlanNumber()");
    }

    public void updateAgentState(int n, Integer[] integerArray) {
        int n2 = 0;
        if (n == 0) {
            this.m_agentState = integerArray;
            n2 = Array.getLength(this.m_agentState);
            int n3 = 0;
            while (n3 < n2) {
                this.m_state = this.m_agentState[n3] == 1 || this.m_agentState[n3] == 6;
                ++n3;
            }
        }
    }

    public boolean validateVlanNumber() {
        boolean bl = true;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)"Enter validateVlanNumber");
        try {
            int n = new Integer(this.m_vlanRequestedTFld.getText().trim());
            if (n < 1 || n > this.m_count) {
                this.popupError(-327932);
                this.m_window.unlockWindow();
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.popupError(-327932);
            this.m_window.unlockWindow();
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)"CommonVlanScreen", (String)"Invalid format of the requestion vlan number");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)("Exit validateVlanNumber " + bl));
        return bl;
    }

    public boolean userRequest() {
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)"Enter userRequest");
        bl = this.validateVlanNumber();
        if (!this.m_state) {
            this.popupError("Invalid Agent State. Cannot Change Vlan Number.");
            this.m_window.unlockWindow();
            bl = false;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)("Exit userRequest " + bl));
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)"CommonVlanScreen", (String)("Enter actionPerformed() " + actionEvent));
        if (actionEvent.getSource() == this.m_cancelBtn) {
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        if (actionEvent.getSource() == this.m_vlanRequestedTFld) {
            this.m_okBtn.doClick();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)"CommonVlanScreen", (String)"Exit actionPerformed() ");
    }
}

