/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.screens.ScreenInterface;
import css.device.common.service.ScreenManager;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Cursor;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public abstract class GenericScreen
extends JPanel
implements DeviceConstants,
DeviceErrorCodes,
CssConstants,
CssErrorCodes,
ScreenInterface {
    public String FILE = "Generic Screen";
    public String MENU_ITEM_NAME = "Screen Name";
    public GenericScreenMaker m_screenMaker = null;
    public UIInternalFrame m_window;

    public abstract void buildScreen(Object var1, StatusBarListener var2, GenericScreenMaker var3);

    public abstract void initialize();

    public void close() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter close()");
        if (this.m_window != null && this.m_window.isVisible()) {
            this.m_window.unlockWindow();
            this.m_window.setVisible(false);
            ScreenManager.removeScreen(this);
            ScreenManager.getDeviceServiceMakerHandle().handleMenuItemDependencies(this.MENU_ITEM_NAME);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit close()");
    }

    public void popupError(String string) {
        if (this.m_window.isVisible()) {
            PnmDialog.error((Object)this.m_window, (String)string);
        }
    }

    public void popupError(int n) {
        if (this.m_window.isVisible()) {
            ErrorPopup errorPopup = new ErrorPopup();
            errorPopup.display(n);
        }
    }

    public void popupInfo(String string) {
        if (this.m_window.isVisible()) {
            PnmDialog.info((Object)this.m_window, (String)string);
        }
    }

    public void startScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter startScreen()");
        this.m_screenMaker.getGuiListener().startProcess();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit startScreen()");
    }

    public void closeScreen(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)("Enter closeScreen(): g_cleanup = " + bl));
        if (bl) {
            try {
                this.m_window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.m_window.setVisible(false);
            ScreenManager.getDeviceServiceMakerHandle().handleMenuItemDependencies(this.MENU_ITEM_NAME);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit closeScreen()");
    }

    public void closeScreen(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter closeScreen method ");
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)this.FILE, (String)"Unable to close screen ");
            this.popupError(-70);
        }
        this.m_window.setVisible(false);
        this.m_window.setCursor(new Cursor(0));
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit closeScreen method ");
    }
}

