/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.ScreenMaker;
import css.core.screens.tools.StatusBarListener;
import css.core.service.CmdHandler;
import css.core.service.CmdHandlerRules;
import css.core.service.GuiListener;
import css.core.service.GuiListenerRules;
import css.core.service.GuiUpdater;
import css.core.service.GuiUpdaterRules;
import css.core.service.ProtocolMultiplexer;
import css.core.util.CssConstants;
import css.core.util.component.CssUIInternalFrame;
import css.device.common.screens.ScreenInterface;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceProtocolMultiplexer;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pnm.ui.UIStatusBar;
import pnm.util.Audit;
import pnm.util.EngineUtilities;

public class GenericScreenMaker
extends ScreenMaker
implements DeviceConstants,
DeviceErrorCodes,
CssConstants {
    protected String FILE = "GenericScreenMaker";
    protected ScreenInterface m_gui;
    protected GenericScreenMaker m_handle;
    protected CssUIInternalFrame m_window;
    protected GuiListener m_guiListener = null;
    protected UIStatusBar m_statusBar = null;
    protected CmdHandler m_cmdHandler = null;
    protected String m_screenName = "Service Screen";
    protected String m_sessionType = "command";
    protected int m_screenSize_X = 430;
    protected int m_screenSize_Y = 400;

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter initialize()");
        if (!this.m_window.isShowing()) {
            this.m_gui.initialize();
            this.m_window.lockWindow();
            this.m_guiListener.startProcess();
            ScreenManager.registerScreen(this.m_gui);
            this.m_window.setVisible(true);
        }
        EngineUtilities.getMainApplicationNavigator().updateWorkspace((Object)this.m_window, this.m_screenName);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit initialize()");
    }

    public void buildService() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter buildService()");
        this.m_window = new CssUIInternalFrame(this.m_screenName);
        this.m_window.setDefaultCloseOperation(0);
        EngineUtilities.getMainApplicationNavigator().updateWorkspace((Object)this.m_window, this.m_screenName);
        this.m_statusBar = new UIStatusBar();
        StatusBarListener statusBarListener = new StatusBarListener(this.m_statusBar);
        this.m_window.setSize(this.m_screenSize_X, this.m_screenSize_Y);
        this.m_gui.buildScreen(this.m_window, statusBarListener, this.m_handle);
        JScrollPane jScrollPane = new JScrollPane((JPanel)((Object)this.m_gui));
        this.m_window.getContentPane().add((Component)jScrollPane, "Center");
        this.m_window.getContentPane().add((Component)this.m_statusBar, "South");
        ServiceProtocolMultiplexer serviceProtocolMultiplexer = ServiceProtocolMultiplexer.getServiceProtocolMultiplexer();
        CmdHandlerRules cmdHandlerRules = new CmdHandlerRules(this.m_cmdHandlerRulesTable);
        this.m_cmdHandler = new CmdHandler(cmdHandlerRules, this.m_sessionType, (ProtocolMultiplexer)serviceProtocolMultiplexer);
        GuiListenerRules guiListenerRules = new GuiListenerRules(this.m_guiListenerRulesTable);
        this.m_guiListener = new GuiListener((Object)this.m_gui, (Object)this.m_window, this.m_cmdHandler, guiListenerRules);
        GuiUpdaterRules guiUpdaterRules = new GuiUpdaterRules(this.m_guiUpdaterRulesTable);
        GuiUpdater guiUpdater = new GuiUpdater(guiUpdaterRules, (Object)this.m_gui, this.m_guiListener);
        this.m_cmdHandler.setGuiUpdater(guiUpdater);
        ScreenManager.registerScreen(this.m_gui);
        this.m_window.lockWindow();
        this.m_guiListener.startProcess();
        this.m_window.show();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit buildService()");
    }

    public GuiListener getGuiListener() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter getGuiListener()");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit getGuiListener()");
        return this.m_guiListener;
    }

    public UIStatusBar getStatusBar() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter getStatusBar()");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit getStatusBar()");
        return this.m_statusBar;
    }

    public CmdHandler getCmdHandler() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)this.FILE, (String)"Enter getCmdHandler()");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)this.FILE, (String)"Exit getCmdHandler()");
        return this.m_cmdHandler;
    }
}

