/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.protocol.ascii.SerialAsciiOperation;
import css.core.protocol.ftp.FtpOperation;
import css.core.protocol.snmp.SnmpInterface;
import css.core.service.DataObject;
import css.core.service.ProtocolMultiplexer;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.tables.CssTranslationInfoRules;
import css.device.common.util.DeviceErrorCodes;
import pnm.util.Audit;

public class ServiceProtocolMultiplexer
extends ProtocolMultiplexer
implements CssErrorCodes,
CssConstants,
DeviceErrorCodes {
    private static ServiceProtocolMultiplexer m_serviceProtocolMultiplexer;
    private CmdManager m_command;

    public DataObject process(DataObject dataObject) {
        DataObject dataObject2 = null;
        if ((long)dataObject.getProtocolKey() < 999L) {
            if (ProtocolMultiplexer.m_ftp == null) {
                ProtocolMultiplexer.m_ftp = new FtpOperation();
            }
            if ((dataObject2 = ProtocolMultiplexer.m_ftp.doOperation(dataObject)).getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -65536);
                } else {
                    dataObject2.setError(dataObject2.getError() + -65536);
                }
            }
        } else if ((long)dataObject.getProtocolKey() < 1999L) {
            if (ProtocolMultiplexer.m_snmp == null) {
                ProtocolMultiplexer.m_snmp = new SnmpInterface();
            }
            if ((dataObject2 = ProtocolMultiplexer.m_snmp.doOperation(dataObject)).getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -196608);
                } else {
                    dataObject2.setError(dataObject2.getError() + -196608);
                }
            }
        } else if ((long)dataObject.getProtocolKey() < 19999L) {
            if (this.m_command == null) {
                this.m_command = new CmdManager(CssTranslationInfoRules.cssCommandManagerRules);
            }
            if ((dataObject2 = this.m_command.doOperation(dataObject)).getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -262144);
                } else {
                    dataObject2.setError(dataObject2.getError() + -262144);
                }
            }
        } else if ((long)dataObject.getProtocolKey() < 29999L) {
            if (ProtocolMultiplexer.m_ascii == null) {
                ProtocolMultiplexer.m_ascii = new SerialAsciiOperation();
            }
            if ((dataObject2 = ProtocolMultiplexer.m_ascii.doOperation(dataObject)).getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -131072);
                } else {
                    dataObject2.setError(dataObject2.getError() + -131072);
                }
            }
        } else {
            Audit.error((String)this.toString(), (String)("process: undefined protocal key " + dataObject.getProtocolKey()));
        }
        return dataObject2;
    }

    public static void setServiceProtocolMultiplexer(ServiceProtocolMultiplexer serviceProtocolMultiplexer) {
        m_serviceProtocolMultiplexer = serviceProtocolMultiplexer;
    }

    public static ServiceProtocolMultiplexer getServiceProtocolMultiplexer() {
        return m_serviceProtocolMultiplexer;
    }
}

