/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import css.core.connection.ConnectionInfo;
import css.core.util.CSSUtilities;
import css.core.util.Ping;
import css.core.util.popup.InfoPopup;
import pnm.util.Audit;
import pnm.util.EngineUtilities;

public class ServiceUtilities {
    private static final String FILE = "ServiceUtilities";
    private static InfoPopup m_infoPopup = new InfoPopup();

    public static void resetWaitTime(int n) {
        EngineUtilities.getMainApplicationWindow().lockWindow();
        m_infoPopup.display("CSS will be locked while device is resetting.");
        boolean bl = new Ping().ping(ConnectionInfo.getDeviceIpAddress(), 10);
        if (!bl) {
            m_infoPopup.display("Unable to communicate with device after reset. Service screens will remain unavailable.");
            CSSUtilities.disableServiceMenu();
        } else {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                Audit.audit((int)3, (String)FILE, (String)("Exception thrown when trying to sleep: " + exception.getMessage()));
            }
            m_infoPopup.display("Device has successfully reset.");
        }
        EngineUtilities.getMainApplicationWindow().unlockWindow();
    }
}

