/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc;

import css.core.appservices.cs.ConnectionInfoObject;
import css.core.appservices.cs.ConnectionService;
import css.core.util.CssConstants;
import css.device.common.screens.CommonNewVlanScreenMaker;
import css.device.common.screens.CommonStatusReportPanelMaker;
import css.device.common.screens.CommonVersionMaker;
import css.device.sc_platform.common.screens.refoscillator.ScRefOscScreenMaker;
import css.device.sc_platform.isc.screens.IscStatusPanelMaker;
import pnm.ui.PnmDialog;
import pnm.util.Audit;
import pnm.util.EngineUtilities;
import pnm.util.OperationHandlerIfc;

public class IscServiceOperationalHandler
implements OperationHandlerIfc,
CssConstants {
    public static final String FILE = "IscServiceOperationalHandler";
    private final String TOOLS_NOT_CONNECTED_SERIAL = "serial_connection_not_established";
    private IscStatusPanelMaker iscStatusPanelMaker;
    private CommonVersionMaker iscVersionMaker;
    private CommonStatusReportPanelMaker iscStatusReportPanelMaker;
    private CommonNewVlanScreenMaker iscVlanScreenMaker;
    private ScRefOscScreenMaker refOscScreenMaker;

    public IscServiceOperationalHandler() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter constructor method");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit constructor method");
    }

    public void operationSelected(String string, Object object) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter operation selected method g_operationName =" + string + "g_sourceObject" + object));
        if (string.equalsIgnoreCase("Status Panel Screens")) {
            if (this.iscStatusPanelMaker == null) {
                this.iscStatusPanelMaker = new IscStatusPanelMaker();
                this.iscStatusPanelMaker.buildService();
            } else {
                this.iscStatusPanelMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Status Report Screen")) {
            if (this.iscStatusReportPanelMaker == null) {
                this.iscStatusReportPanelMaker = new CommonStatusReportPanelMaker();
                this.iscStatusReportPanelMaker.buildService();
            } else {
                this.iscStatusReportPanelMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Versions Screen")) {
            if (this.iscVersionMaker == null) {
                this.iscVersionMaker = new CommonVersionMaker();
                this.iscVersionMaker.buildService();
            } else {
                this.iscVersionMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Vlan Screen")) {
            if (this.iscVlanScreenMaker == null) {
                this.iscVlanScreenMaker = new CommonNewVlanScreenMaker();
                this.iscVlanScreenMaker.buildService();
            } else {
                this.iscVlanScreenMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Ref Osc Screen")) {
            if ((ConnectionInfoObject.getConnectionState() != 1 || ConnectionInfoObject.getConnectionType().equalsIgnoreCase("ethernet")) && PnmDialog.confirm((Object)EngineUtilities.getMainApplicationWindow(), (String)"serial_connection_not_established")) {
                IscServiceOperationalHandler.handleConnectionScreen();
            }
            if (ConnectionInfoObject.getConnectionState() == 1 && ConnectionInfoObject.getConnectionType().equalsIgnoreCase("serial")) {
                if (this.refOscScreenMaker == null) {
                    this.refOscScreenMaker = new ScRefOscScreenMaker();
                    this.refOscScreenMaker.buildService();
                } else {
                    this.refOscScreenMaker.initialize();
                }
            }
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"No such operation name exist");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit operation selected method");
    }

    public static void handleConnectionScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter handleConnectionScreen");
        ConnectionService.changeConnection();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit handleConnectionScreen");
    }
}

