/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.popup.ErrorPopup;
import css.device.common.service.ScreenManager;
import css.device.common.service.Serviceable;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.isc.screens.ChannelTab;
import css.device.sc_platform.isc.screens.HistoryTab;
import css.device.sc_platform.isc.screens.IscStatusPanelMaker;
import css.device.sc_platform.isc.screens.SiteControllerTab;
import css.device.sc_platform.isc.screens.SiteTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class IscStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes,
Serviceable {
    public static final String FILE = "IscStatusPanel";
    public SiteTab m_site;
    public SiteControllerTab m_siteController;
    public ChannelTab m_channel;
    public HistoryTab m_history;
    private String ISC_SiteState = "ISC_SiteState";
    private String ISC_SiteCause = "ISC_SiteCause";
    private String ISC_SCState = "ISC_SCState";
    private String ISC_SCCause = "ISC_SCCause";
    private String ISC_commFanState = "ISC_commFanState";
    private String ISC_commFanCause = "ISC_commFanCause";
    private String ISC_nmaDateTime = "nmaDateTime";
    private String ISC_ScBoxAlarmCode = "ISC_ScBoxAlarmCode";
    private String ISC_ScBoxText = "ISC_ScBoxText";
    private String ISC_nmaDeviceState = "nmaDeviceState";
    private String ISC_ChlState = "ISC_ChlState";
    private String ISC_ChlCause = "ISC_ChlCause";
    private String ISC_SSState = "ISC_SSState";
    private JTabbedPane m_tabbedPane;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();

    public IscStatusPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        this.m_tabbedPane = new JTabbedPane();
        this.m_history = new HistoryTab(this);
        this.m_site = new SiteTab(this.m_history);
        this.m_channel = new ChannelTab(this.m_history);
        this.m_siteController = new SiteControllerTab(this.m_history, this.m_site, this.m_channel);
        this.m_site.buildScreen(this.m_window, statusBarListener);
        this.m_siteController.buildScreen(this.m_window, statusBarListener);
        this.m_channel.buildScreen(this.m_window, statusBarListener);
        this.m_history.buildScreen(this.m_window, statusBarListener);
        this.m_tabbedPane.addTab("Site Info", this.m_site);
        this.m_tabbedPane.addTab("Site Controller", this.m_siteController);
        this.m_tabbedPane.addTab("Channel", this.m_channel);
        this.m_tabbedPane.addTab("History", this.m_history);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add(this.m_tabbedPane);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.m_site.initialize();
        this.m_siteController.initialize();
        this.m_channel.initialize();
        this.m_history.initialize();
        this.m_tabbedPane.setSelectedIndex(0);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateRegistration(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateRegistration()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in Registering with the Device. Closing the Screen");
            this.popupError(-458765);
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateRegistration()");
    }

    public void updateDeRegistration(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateDeRegistration()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in Deregistering with the Device. Closing the Screen anyways");
            this.popupError(-458766);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateDeRegistration()");
    }

    public void realTimeUpdate(Object object) {
        String string;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        String[] stringArray = null;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter realTimeUpdate()arguments: g_rtObj = " + object));
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        int n11 = realTimeDataObject.getSize();
        stringArray = new String[n11];
        int n12 = 0;
        while (n12 < n11) {
            stringArray[n12] = "";
            try {
                stringArray[n12] = realTimeDataObject.getName(n12);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
            if (stringArray[n12].indexOf(this.ISC_SiteState) != -1) {
                n = n12;
            } else if (stringArray[n12].indexOf(this.ISC_SiteCause) != -1) {
                n2 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_SCState) != -1) {
                n = n12;
            } else if (stringArray[n12].indexOf(this.ISC_SCCause) != -1) {
                n2 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_commFanState) != -1) {
                n3 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_commFanCause) != -1) {
                n4 = n12;
            } else if (stringArray[n12].equalsIgnoreCase(this.ISC_nmaDateTime)) {
                n5 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_ScBoxAlarmCode) != -1) {
                n6 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_ScBoxText) != -1) {
                n7 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_nmaDeviceState) != -1) {
                n8 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_ChlState) != -1) {
                n9 = n12;
            } else if (stringArray[n12].indexOf(this.ISC_ChlCause) != -1) {
                n10 = n12;
            }
            ++n12;
        }
        if (n8 != -1) {
            try {
                string = (String)realTimeDataObject.getValue(n8);
                this.m_siteController.realTimeUpdate(string);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
        }
        if (n7 != -1 && n6 != -1 && n5 != -1) {
            try {
                string = (String)realTimeDataObject.getValue(n6);
                String string2 = (String)realTimeDataObject.getValue(n7);
                String string3 = (String)realTimeDataObject.getValue(n5);
                this.m_site.realTimeUpdate(string, string2, string3);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
        } else if (n != -1 && n2 != -1 && n5 != -1) {
            string = "";
            String string4 = "";
            String string5 = "";
            try {
                string = (String)realTimeDataObject.getValue(n);
                string4 = (String)realTimeDataObject.getValue(n2);
                string5 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Data " + (Object)((Object)notFoundException)));
            }
            if (stringArray[n].indexOf(this.ISC_SiteState) != -1) {
                this.m_site.realTimeUpdate(string5, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf(this.ISC_SCState) != -1) {
                this.m_siteController.realTimeUpdate(string5, string, string4);
            } else if (stringArray[n].indexOf(this.ISC_ChlState) != -1) {
                this.m_channel.realTimeUpdate(string5, stringArray[n], string, stringArray[n2], string4);
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Couldn't Interpret the RealTimeData Packet correctly");
            }
        } else if (n9 != -1 && n10 != -1 && n5 != -1) {
            string = "";
            String string6 = "";
            String string7 = "";
            try {
                string = (String)realTimeDataObject.getValue(n9);
                string6 = (String)realTimeDataObject.getValue(n10);
                string7 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving Channel fault Data " + (Object)((Object)notFoundException)));
            }
            this.m_channel.realTimeUpdate(string7, stringArray[n9], string, stringArray[n10], string6);
        } else if (n3 != -1 && n4 != -1 && n5 != -1) {
            string = "";
            String string8 = "";
            String string9 = "";
            try {
                string = (String)realTimeDataObject.getValue(n3);
                string8 = (String)realTimeDataObject.getValue(n4);
                string9 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)("Got NotFoundException while retrieving fan fault Data " + (Object)((Object)notFoundException)));
            }
            this.m_siteController.realTimeFanUpdate(string9, string, string8);
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Couldn't Interpret the RealTimeData Packet correctly");
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit realTimeUpdate()");
    }

    public void startWriteToFile() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startWriteToFile()");
        this.m_site.writeToFile();
        this.m_siteController.writeToFile();
        this.m_channel.writeToFile();
        this.m_history.writeToFile();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startWriteToFile()");
    }

    public void closeScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter PSC Status Panel closeScreen");
        if (this.m_window != null) {
            this.m_window.unlockWindow();
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit PSC Status Panel closeScreen");
    }

    public void updateSCStatus(int n, Integer n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSCStatus()arguments: g_error = " + n + "g_scStatus = " + n2));
        this.m_siteController.updateSCStatus(n, n2);
        this.m_history.updateSCStatus(n, n2);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSCStatus()");
    }

    public void startScreen() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter startScreen()");
        this.initialize();
        IscStatusPanelMaker.getGuiListener().startProcess();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit startScreen()");
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    public void closeScreen(boolean bl) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter closeScreen(): g_cleanup = " + bl));
        if (bl) {
            try {
                this.m_window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.m_window.setVisible(false);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit closeScreen()");
    }
}

