/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.isc.screens.HistoryTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SiteTab
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    public static final String FILE = "SiteTab";
    private final String STATUS_PANEL = "Status Panel: Site";
    private final String SITE_ID = "Site ID: ";
    private final String OBJECT_NAME = "Site Name: ";
    private final String STATE = "State: ";
    private final String CAUSE = "Cause: ";
    private final String ACTIVE_SITE_LINK = "Active Site Link: ";
    private final String ACTIVE_SITE_CONTROLLER = "Active Site Controller: ";
    private final String CURRENT_CONTROL_CHANNEL = "Current Control Channel: ";
    private final String USER_REQUESTED_SITE_STATE = "User Requested Site State: ";
    private final String SITE = "Site";
    private final String N_A = "N/A";
    private final String SITE_OFF = "Site OFF";
    private final String SITE_FAILSOFT = "Site Failsoft";
    private final String SITE_TRUNKING = "Site Trunking";
    private final String WIDE_TRUNKING = "Wide Trunking";
    private final String UNKNOWN = "Unknown";
    private final String SITE_TO_WIDE_TRUNKING = "Site To Wide Trunking";
    private final String NO_REASON = "";
    private final String NO_VOICE_CHANNEL_PRESENT = "No Voice Channel Present";
    private final String NO_CONTROL_CHANNEL_PRESENT = "No Control Channel Present";
    private final String SITE_CONTROL_PATH_DOWN = "Site Control Path Down";
    private final String USER_REQUESTED = "User Requested";
    private final String RECOVERY = "Recovery";
    private static final int UNDEFINED = 127;
    private static final int ASC = 5;
    private static final int ASL = 3;
    private static final int CCC = 4;
    private JLabel m_siteIdLbl;
    private JLabel m_siteStateLbl;
    private JLabel m_siteCauseLbl;
    private JLabel m_siteNameLbl;
    private JLabel m_activeSiteLinkLbl;
    private JLabel m_activeScLbl;
    private JLabel m_cccLbl;
    public JComboBox m_userReqSiteStateCbBox;
    private UIInternalFrame m_window;
    private Integer m_siteInstance;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private HistoryTab m_history;
    private boolean m_userInitiated = true;
    private int m_originalIndex = -1;

    public SiteTab(HistoryTab historyTab) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter constructor method");
        this.m_history = historyTab;
        this.setLayout(new GridBagLayout());
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit constructor method");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2));
        JLabel jLabel = new JLabel("Site ID: ");
        jLabel.setToolTipText("Identification Number of Site");
        this.m_siteIdLbl = new JLabel("N/A");
        jPanel.add(jLabel);
        jPanel.add(this.m_siteIdLbl);
        JLabel jLabel2 = new JLabel("Site Name: ");
        jLabel2.setToolTipText("Name of the Site");
        this.m_siteNameLbl = new JLabel("N/A");
        jPanel.add(jLabel2);
        jPanel.add(this.m_siteNameLbl);
        JLabel jLabel3 = new JLabel("State: ");
        jLabel3.setToolTipText("Defines the current state of Site");
        this.m_siteStateLbl = new JLabel("N/A");
        jPanel.add(jLabel3);
        jPanel.add(this.m_siteStateLbl);
        JLabel jLabel4 = new JLabel("Cause: ");
        jLabel4.setToolTipText("Additional Information on the current status of the Site");
        this.m_siteCauseLbl = new JLabel("N/A");
        jPanel.add(jLabel4);
        jPanel.add(this.m_siteCauseLbl);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)15, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        JLabel jLabel5 = new JLabel("Active Site Controller: ");
        jLabel5.setToolTipText("Number of Site Controller that is responsible for maintaining the Site Resources");
        jPanel2.add(jLabel5);
        this.m_activeScLbl = new JLabel("N/A");
        jPanel2.add(this.m_activeScLbl);
        JLabel jLabel6 = new JLabel("Active Site Link: ");
        jLabel6.setToolTipText("Number of the Site Controller that receives information from Zone Controller");
        jPanel2.add(jLabel6);
        this.m_activeSiteLinkLbl = new JLabel("N/A");
        jPanel2.add(this.m_activeSiteLinkLbl);
        JLabel jLabel7 = new JLabel("Current Control Channel: ");
        jLabel7.setToolTipText("Number of Comparator that is currently assigned as Control Channel at the Site");
        jPanel2.add(jLabel7);
        this.m_cccLbl = new JLabel("N/A");
        jPanel2.add(this.m_cccLbl);
        JLabel jLabel8 = new JLabel("      ");
        JLabel jLabel9 = new JLabel("      ");
        jPanel2.add(jLabel8);
        jPanel2.add(jLabel9);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        JLabel jLabel10 = new JLabel("      ");
        JLabel jLabel11 = new JLabel("      ");
        jPanel3.add(jLabel10);
        jPanel3.add(jLabel11);
        JLabel jLabel12 = new JLabel("User Requested Site State: ");
        jLabel12.setToolTipText("Set the state of Site Controller per user's request");
        jPanel3.add(jLabel12);
        this.m_userReqSiteStateCbBox = new JComboBox();
        this.m_userReqSiteStateCbBox.setEnabled(false);
        this.m_userReqSiteStateCbBox.addItem("Site OFF");
        this.m_userReqSiteStateCbBox.addItem("Site Failsoft");
        this.m_userReqSiteStateCbBox.addItem("Site Trunking");
        this.m_userReqSiteStateCbBox.addItem("Wide Trunking");
        jPanel3.add(this.m_userReqSiteStateCbBox);
        GridBagAdder.add((Container)this, (Component)jPanel3, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_userReqSiteStateCbBox, "Select State of Site from the Drop down Combo Box");
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter initialize()");
        this.m_siteNameLbl.setText("N/A");
        this.m_siteIdLbl.setText("N/A");
        this.m_siteStateLbl.setText("N/A");
        this.m_siteCauseLbl.setText("N/A");
        this.m_activeSiteLinkLbl.setText("N/A");
        this.m_activeScLbl.setText("N/A");
        this.m_cccLbl.setText("N/A");
        this.m_userInitiated = false;
        this.m_userReqSiteStateCbBox.setEnabled(false);
        this.m_userReqSiteStateCbBox.setSelectedIndex(0);
        this.m_userInitiated = true;
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit initialize()");
    }

    public void updateSiteStateCause(int n, int n2) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSiteStateCause() arguments:g_state = " + n + "g_cause = " + n2));
        String string = this.convStateNumToName(n);
        this.m_siteStateLbl.setText(string);
        String string2 = this.convCauseNumToName(n2);
        this.m_siteCauseLbl.setText(string2);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSiteStateCause()");
    }

    public void updateSiteInstanceIdStateCause(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSiteInstanceIdStateCause()arguments: g_error = " + n + "g_instance = " + integerArray[0] + "g_siteId = " + integerArray2[0] + "g_siteState = " + integerArray3[0] + "g_siteCause = " + integerArray4[0]));
        if (n == 0) {
            this.m_siteInstance = integerArray[0];
            this.m_siteIdLbl.setText(integerArray2[0].toString());
            this.updateSiteStateCause(integerArray3[0], integerArray4[0]);
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting Site Instance, Site ID, State and Cause fields");
            this.popupError(-458754);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSiteInstanceIdStateCause()");
    }

    public void updateSiteAslCccReqState(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, String[] stringArray) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSiteAslCccReqState()arguments: g_error = " + n + "g_asl = " + integerArray[0] + "g_ccc = " + integerArray2[0] + "g_reqState = " + integerArray3[0] + "g_name = " + stringArray[0]));
        if (n == 0) {
            this.m_siteNameLbl.setText(stringArray[0]);
            int n2 = integerArray[0];
            this.m_activeSiteLinkLbl.setText(this.convAslValue(n2));
            int n3 = integerArray2[0];
            this.m_cccLbl.setText(this.convCccValue(n3));
            this.m_userInitiated = false;
            this.m_userReqSiteStateCbBox.setEnabled(true);
            switch (integerArray3[0]) {
                case 21: {
                    this.m_userReqSiteStateCbBox.setSelectedIndex(0);
                    break;
                }
                case 31: {
                    this.m_userReqSiteStateCbBox.setSelectedIndex(1);
                    break;
                }
                case 51: {
                    this.m_userReqSiteStateCbBox.setSelectedIndex(2);
                    break;
                }
                case 71: {
                    this.m_userReqSiteStateCbBox.setSelectedIndex(3);
                }
            }
            this.m_originalIndex = this.m_userReqSiteStateCbBox.getSelectedIndex();
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting Site Asl,CCC and Req State fields");
            this.popupError(-458754);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSiteAslCccReqState()");
    }

    public void updateSiteAsc(int n, String string) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSiteAsc()arguments: g_error = " + n + "g_asc = " + string));
        if (n == 0) {
            this.m_activeScLbl.setText(string);
        } else {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in getting Active Site Controller Field");
            this.popupError(-458754);
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSiteAsc()");
    }

    public boolean isSetRequired() {
        boolean bl = false;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter isSetRequired()");
        bl = this.m_userInitiated;
        if (!this.m_userInitiated) {
            this.m_userInitiated = true;
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit isSetRequired() return: " + bl));
        return bl;
    }

    public Object[] getSiteReqState() {
        Object[] objectArray = null;
        Integer n = null;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter getSiteReqState()");
        switch (this.m_userReqSiteStateCbBox.getSelectedIndex()) {
            case 0: {
                n = new Integer(21);
                break;
            }
            case 1: {
                n = new Integer(31);
                break;
            }
            case 2: {
                n = new Integer(51);
                break;
            }
            case 3: {
                n = new Integer(71);
            }
        }
        objectArray = new Object[]{"." + this.m_siteInstance.toString(), n.toString()};
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit getSiteReqState() return: " + objectArray));
        return objectArray;
    }

    public void updateSiteReqState(int n) {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter updateSiteReqState()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Error in setting User Requested State for Site");
            this.popupError(-458755);
            this.m_userInitiated = false;
            this.m_userReqSiteStateCbBox.setSelectedIndex(this.m_originalIndex);
        } else {
            this.m_originalIndex = this.m_userReqSiteStateCbBox.getSelectedIndex();
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit updateSiteReqState()");
    }

    public void realTimeUpdate(String string, String string2, String string3) {
        int n = -1;
        String string4 = "";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter realTimeUpdate()arguments: g_alarmCode = " + string + "g_boxText = " + string2 + "g_timeValue = " + string3));
        try {
            n = new Integer(string);
            string4 = string2.trim();
            if (n == 5) {
                this.m_activeScLbl.setText(string4);
                this.m_history.updateHistoryTable(string3, "Site", "Active Site Controller: ", this.m_activeScLbl.getText());
            } else if (n == 3) {
                this.m_activeSiteLinkLbl.setText(string4);
                this.m_history.updateHistoryTable(string3, "Site", "Active Site Link: ", this.m_activeSiteLinkLbl.getText());
            } else if (n == 4) {
                this.m_cccLbl.setText(string4);
                this.m_history.updateHistoryTable(string3, "Site", "Current Control Channel: ", this.m_cccLbl.getText());
            } else {
                Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Alarm code Does not match. Discard the trap.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)(" Number Format Exception while processing the Trap " + numberFormatException));
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit realTimeUpdate()");
    }

    public void realTimeUpdate(String string, String string2, String string3, String string4, String string5) {
        int n = -1;
        int n2 = -1;
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter realTimeUpdate()arguments: g_time = " + string + "g_stateNum = " + string2 + "g_stateVal = " + string3 + "g_causeNum = " + string4 + "g_causeVal = " + string5));
        try {
            n = new Integer(string3);
            n2 = new Integer(string5);
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)CssConstants.AUDIT_UNEXPECTED_CONDITION, (String)FILE, (String)"Number Format Exception while processing the Trap");
        }
        String string6 = this.convStateNumToName(n);
        this.m_siteStateLbl.setText(string6);
        String string7 = this.convCauseNumToName(n2);
        this.m_siteCauseLbl.setText(string7);
        this.m_history.updateHistoryTable(string, "Site", string6, string7);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit realTimeUpdate()");
    }

    private String convStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter convStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 21: {
                string = "Site OFF";
                break;
            }
            case 31: {
                string = "Site Failsoft";
                break;
            }
            case 51: {
                string = "Site Trunking";
                break;
            }
            case 61: {
                string = "Site To Wide Trunking";
                break;
            }
            case 71: {
                string = "Wide Trunking";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit convStateNumToName() return: " + string));
        return string;
    }

    private String convCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter convCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "";
                break;
            }
            case 4: {
                string = "No Voice Channel Present";
                break;
            }
            case 5: {
                string = "No Control Channel Present";
                break;
            }
            case 6: {
                string = "Site Control Path Down";
                break;
            }
            case 7: {
                string = "User Requested";
                break;
            }
            case 8: {
                string = "Recovery";
            }
        }
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit convCauseNumToName() return: " + string));
        return string;
    }

    private String convAslValue(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter convAslValue()arguments: g_value = " + n));
        string = n == 127 ? "UNDEFINED" : new Integer(n).toString();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit convAslValue() " + string));
        return string;
    }

    private String convCccValue(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter convCccValue()arguments: g_value = " + n));
        string = n == 127 ? "UNDEFINED" : new Integer(n).toString();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)("Exit convCccValue() " + string));
        return string;
    }

    private String convAscValue(int n) {
        String string = "N/A";
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)("Enter convAscValue()arguments: g_value = " + n));
        string = n == 127 ? "UNDEFINED" : new Integer(n).toString();
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit convAscValue() ");
        return string;
    }

    public void writeToFile() {
        Audit.audit((int)CssConstants.AUDIT_APP_ENTER_METHOD, (String)FILE, (String)"Enter writeToFile()");
        String string = "Site Controller Name: Site\n";
        string = string + "Site ID: " + this.m_siteIdLbl.getText() + "\n";
        string = string + "Site Name: " + "Site" + "\n";
        string = string + "Site State: " + this.m_siteStateLbl.getText() + "\n";
        string = string + "Site Cause: " + this.m_siteCauseLbl.getText() + "\n";
        string = string + "Active Site Link: " + this.m_activeSiteLinkLbl.getText() + "\n";
        string = string + "Active Site Controller: " + this.m_activeScLbl.getText() + "\n";
        string = string + "Current Control Channel: " + this.m_cccLbl.getText() + "\n";
        string = string + "User Requested Site State: " + this.m_userReqSiteStateCbBox.getSelectedItem() + "\n";
        string = string + "\n" + "\n";
        this.m_history.appendString(string);
        Audit.audit((int)CssConstants.AUDIT_APP_EXIT_METHOD, (String)FILE, (String)"Exit writeToFile()");
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }
}

