/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.InPort;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.PortInfo;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.util.Vector;
import pnm.util.Audit;

class DevicePorts
implements CmdMgrConstants,
CssConstants,
DeviceConstants,
DeviceErrorCodes {
    private Vector m_portList;

    public DevicePorts() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts Constructor.");
        this.m_portList = new Vector();
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit DevicePorts Constructor.");
    }

    public Vector getPorts() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts.getPorts.");
        return this.m_portList;
    }

    public PortInfo getPort(int n) {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts.getPort");
        PortInfo portInfo = null;
        for (int i = 0; i < this.m_portList.size() && portInfo == null; ++i) {
            PortInfo portInfo2 = (PortInfo)this.m_portList.elementAt(i);
            if (n != portInfo2.getPortNumber()) continue;
            portInfo = portInfo2;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DevicePorts.getPort. portInfo=" + portInfo));
        return portInfo;
    }

    public boolean portExists(int n) {
        boolean bl = false;
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts.portExists.");
        for (int i = 0; i < this.m_portList.size() && !bl; ++i) {
            PortInfo portInfo = (PortInfo)this.m_portList.elementAt(i);
            if (portInfo.getPortNumber() != n) continue;
            bl = true;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DevicePorts.portExists. Return=" + bl));
        return bl;
    }

    public synchronized int addPort(int n, InPort inPort, OutPort outPort) {
        int n2 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts.addPort(1).");
        if (!this.portExists(n)) {
            PortInfo portInfo = new PortInfo(n, inPort, outPort);
            portInfo.setCount(1);
            this.m_portList.addElement(portInfo);
        } else {
            this.addPort(n);
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DevicePorts.addPort(1).  Status=" + n2));
        return n2;
    }

    public int addPort(int n) {
        int n2 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DevicePorts.addPort(2).");
        if (this.portExists(n)) {
            PortInfo portInfo = this.getPort(n);
            int n3 = portInfo.getCount();
            portInfo.setCount(n3 + 1);
        } else {
            n2 = -6;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DevicePorts.addPort(2).  Status=" + n2));
        return n2;
    }

    public synchronized int deletePort(int n) {
        int n2 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DevicePorts.deletePort. Port=" + n));
        if (this.portExists(n)) {
            PortInfo portInfo = this.getPort(n);
            int n3 = portInfo.getCount();
            if (n3 > 1) {
                portInfo.setCount(--n3);
                if (n3 == 1 && n == 1054) {
                    this.getOutPortHandle(n).setKeepAlives(false);
                    this.getInPortHandle(n).setKeepAlives(false);
                }
            } else {
                this.getInPortHandle(n).terminate();
                this.getOutPortHandle(n).terminate();
                this.m_portList.removeElement(portInfo);
            }
        } else {
            n2 = -6;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DevicePorts.deletePort.  Status=" + n2));
        return n2;
    }

    public InPort getInPortHandle(int n) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DevicePorts.getPortHandle. Port=" + n));
        PortInfo portInfo = this.getPort(n);
        return portInfo.getInPortHandle();
    }

    public OutPort getOutPortHandle(int n) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DevicePorts.getOutPortHandle. Port=" + n));
        PortInfo portInfo = this.getPort(n);
        return portInfo.getOutPortHandle();
    }

    public String dumpDevicePorts() {
        Vector vector = this.getPorts();
        String string = new String();
        for (int i = 0; i < vector.size(); ++i) {
            PortInfo portInfo = (PortInfo)vector.elementAt(i);
            string = string + new String("Entry " + i + ": Port Number = " + portInfo.getPortNumber() + " Session Count = " + portInfo.getCount() + "\n");
        }
        return string;
    }
}

