/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.connection.ConnectionInfo;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.LinkedList;

public class OutPort
implements CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes,
Runnable {
    private static final CssLogger LOG = CssLogger.getCssLogger(OutPort.class);
    DatagramSocket ref_DatagramSocket;
    private boolean m_remainActive = true;
    private boolean m_keepAlives;
    private int m_port;
    private LinkedList<byte[]> m_OutportQueue = new LinkedList();
    private InetAddress m_ipAddress;

    public OutPort(int n, boolean bl, CmdManager cmdManager, DatagramSocket datagramSocket) {
        LOG.enter("OutPort", new Object[]{n, bl, cmdManager, datagramSocket});
        try {
            this.m_ipAddress = InetAddress.getByName(ConnectionInfo.getDeviceIpAddress());
            this.m_port = n;
            this.m_keepAlives = bl;
            this.ref_DatagramSocket = datagramSocket;
        }
        catch (Exception exception) {
            LOG.error((Object)"OutPort: General Exception.", (Throwable)exception);
        }
        LOG.exit("OutPort");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.enter("run");
        while (this.m_remainActive) {
            try {
                Object object = this;
                synchronized (object) {
                    try {
                        Thread.yield();
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error((Object)"OutPort:run:Wait timer expired", (Throwable)interruptedException);
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        LOG.error((Object)"OutPort: Exception", (Throwable)illegalMonitorStateException);
                    }
                }
                if (this.m_keepAlives) {
                    this.sendKeepAlive();
                }
                while (!this.m_OutportQueue.isEmpty()) {
                    object = this.m_OutportQueue.removeFirst();
                    DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, this.m_ipAddress, this.m_port);
                    this.ref_DatagramSocket.send(datagramPacket);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error((Object)"OutPort:run:Bad argument in method call.", (Throwable)illegalArgumentException);
            }
            catch (IOException iOException) {
                LOG.error((Object)"OutPort:run:AN IO error occurred.", (Throwable)iOException);
            }
        }
        LOG.exit("run");
    }

    public int sendKeepAlive() {
        int n = 0;
        byte[] byArray = null;
        LOG.enter("sendKeepAlive");
        Datagram datagram = new Datagram();
        datagram.setProtocolFlags((short)0);
        datagram.setProtocolSequenceNumber((byte)0);
        datagram.setSessionID((byte)0);
        datagram.setSessionFlags((short)0);
        datagram.setOpcode((byte)0);
        datagram.setSubOpcode((byte)0);
        byArray = datagram.pack();
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.m_ipAddress, this.m_port);
            this.ref_DatagramSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            LOG.error((Object)"OutPort:sendKeepAlive:An IO error occurred.", (Throwable)exception);
        }
        LOG.exit("sendKeepAlive", (Object)n);
        return n;
    }

    public void terminate() {
        LOG.enter("terminate");
        this.m_remainActive = false;
        this.m_keepAlives = false;
        this.ref_DatagramSocket.close();
        LOG.exit("terminate");
    }

    public synchronized int sendDatagram(Datagram datagram) {
        int n = 0;
        LOG.enter("sendDatagram", new Object[]{datagram});
        try {
            boolean bl = false;
            for (byte[] byArray : this.m_OutportQueue) {
                if (!Arrays.equals(datagram.pack(), byArray)) continue;
                LOG.error((Object)"sendDatagram - Already got this datagram on the queue! Will not send this datagram.");
                bl = true;
                break;
            }
            if (!bl) {
                this.m_OutportQueue.add(datagram.pack());
                this.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            LOG.error((Object)"sendDatagram - Current thread is not the owner of the object's monitor.", (Throwable)illegalMonitorStateException);
            n = -5;
        }
        LOG.exit("sendDatagram", (Object)n);
        return n;
    }

    public void setKeepAlives(boolean bl) {
        LOG.enter("setKeepAlives", new Object[]{bl});
        this.m_keepAlives = bl;
        LOG.exit("setKeepAlives");
    }
}

