/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public abstract class ChannelNumber
extends GenericScreen
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String FILE = "ChannelNumber";
    protected ErrorPopup m_errorPopup = new ErrorPopup();
    protected ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    public JButton m_okBtn = new JButton("  OK  ");
    private JButton m_cancelBtn = new JButton("Cancel");
    protected JTextField m_channelNumberTFld;
    protected JLabel m_channelNumberLbl;

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)1009, (String)"ChannelNumber", (String)("Enter buildScreen() arguments: g_window = " + object + ", g_statusBar = " + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(ChannelNumber.this);
                ChannelNumber.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setText("Current BR/CM Pairing Number");
        jLabel.setToolTipText("Current BR/CM Pairing Number of the device");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(1, 10));
        jPanel3.add(jLabel2);
        this.m_channelNumberLbl = new JLabel("N/A");
        this.m_channelNumberLbl.setBackground(this.getBackground());
        this.m_channelNumberLbl.setPreferredSize(new Dimension(60, 20));
        jPanel3.add(this.m_channelNumberLbl);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        JLabel jLabel3 = new JLabel();
        if (this.isBR_CM()) {
            jLabel3.setText("BR/CM Pairing Number");
            jLabel3.setToolTipText("BR/CM Pairing Number of the device");
        } else {
            jLabel3.setText("Channel Number");
            jLabel3.setToolTipText("Channel Number of the device");
        }
        jPanel4.add(jLabel3);
        JLabel jLabel4 = new JLabel("");
        jLabel4.setPreferredSize(new Dimension(45, 10));
        jPanel4.add(jLabel4);
        this.m_channelNumberTFld = new JTextField();
        this.m_channelNumberTFld.setPreferredSize(new Dimension(60, 20));
        this.m_channelNumberTFld.addActionListener(this);
        jPanel4.add(this.m_channelNumberTFld);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        if (this.isBR_CM()) {
            this.m_okBtn.setToolTipText("Set BR/CM Pairing Number in device");
        } else {
            this.m_okBtn.setToolTipText("Set Channel Number in device");
        }
        jPanel5.add(this.m_okBtn);
        JLabel jLabel5 = new JLabel("");
        jLabel5.setPreferredSize(new Dimension(10, 10));
        jPanel5.add(jLabel5);
        this.m_cancelBtn.setToolTipText("Ignore any changes and close Screen");
        this.m_cancelBtn.addActionListener(this);
        jPanel5.add(this.m_cancelBtn);
        jPanel2.add(jPanel5);
        if (this.isBR_CM()) {
            statusBarListener.registerComponent((Component)this.m_channelNumberTFld, "Enter Valid BR/CM Pairing Number: See Help");
            statusBarListener.registerComponent((Component)this.m_okBtn, "Click this button to set BR/CM Pairing Number in device");
        } else {
            statusBarListener.registerComponent((Component)this.m_channelNumberTFld, "Enter Valid Channel Number: See Help");
            statusBarListener.registerComponent((Component)this.m_okBtn, "Click this button to set Channel Number in device");
        }
        statusBarListener.registerComponent((Component)this.m_cancelBtn, "Click this button to clear all changes and return to previous settings");
        Audit.audit((int)1010, (String)"ChannelNumber", (String)"Exit buildScreen() ");
    }

    @Override
    public void initialize() {
        Audit.audit((int)1009, (String)"ChannelNumber", (String)"Enter initialize()");
        this.m_channelNumberLbl.setText("N/A");
        this.m_channelNumberTFld.setText("");
        this.m_okBtn.setEnabled(true);
        this.m_cancelBtn.setEnabled(true);
        this.m_channelNumberTFld.setEnabled(true);
        Audit.audit((int)1010, (String)"ChannelNumber", (String)"Exit initialize()");
    }

    public Object[] getChannelNumber() {
        Object[] objectArray = new Object[1];
        Audit.audit((int)1009, (String)"ChannelNumber", (String)"Enter getChannelNumber");
        this.m_window.lockWindow();
        objectArray[0] = Integer.valueOf(this.m_channelNumberTFld.getText());
        Audit.audit((int)1010, (String)"ChannelNumber", (String)(" Exit getChannelNumber " + objectArray));
        return objectArray;
    }

    public abstract void updateChannelNumber(int var1, Integer var2);

    public void updateCurrentChannelNumber(int n, Integer[] integerArray) {
        Audit.audit((int)1009, (String)"ChannelNumber", (String)("Enter updateCurrentChannelNumber(), arguments: g_error = " + n + "g_channelNumber " + integerArray));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)"ChannelNumber", (String)"Unable to get receiver State");
            this.popupError(-524342);
        } else {
            this.m_channelNumberLbl.setText(integerArray[0].toString());
        }
        Audit.audit((int)1010, (String)"ChannelNumber", (String)"Exit updateCurrentChannelNumber()");
    }

    public boolean validateChannelNumber() {
        boolean bl = true;
        Audit.audit((int)1009, (String)"ChannelNumber", (String)"Enter validateChannelNumber");
        try {
            int n = new Integer(this.m_channelNumberTFld.getText());
            int n2 = 30;
            int n3 = -524344;
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.isGcm8000ConvPlatform((String)string).booleanValue()) {
                n2 = 200;
                n3 = -524347;
            }
            if (n < 1 || n > n2) {
                this.m_errorPopup.display(n3);
                this.m_channelNumberTFld.requestFocus();
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.m_errorPopup.display(-524340);
            Audit.audit((int)1010, (String)"ChannelNumber", (String)("Exit validateChannelNumber " + bl));
        }
        return bl;
    }

    public boolean userRequest() {
        boolean bl = false;
        Audit.audit((int)1009, (String)"ChannelNumber", (String)"Enter userRequest");
        bl = this.validateChannelNumber();
        if (bl) {
            this.m_confirmPopup.display(-524341);
            bl = this.m_confirmPopup.getStatus();
        }
        Audit.audit((int)1010, (String)"ChannelNumber", (String)("Exit userRequest " + bl));
        return bl;
    }

    public void updateResetDependencies(int n) {
        Audit.audit((int)1009, (String)"ChannelNumber", (String)("Enter updateResetDependencies(): g_error = " + n));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)"ChannelNumber", (String)"Unable to reset station");
            this.popupError(-327733);
        } else {
            ScreenManager.suspend();
        }
        Audit.audit((int)1010, (String)"ChannelNumber", (String)"Exit updateResetDependencies()");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Audit.audit((int)1009, (String)"ChannelNumber", (String)("Enter actionPerformed() " + actionEvent));
        if (actionEvent.getSource() == this.m_cancelBtn) {
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        } else if (actionEvent.getSource() == this.m_channelNumberTFld) {
            this.m_okBtn.doClick();
        }
        Audit.audit((int)1010, (String)"ChannelNumber", (String)"Exit actionPerformed() ");
    }

    public boolean isBR_CM() {
        boolean bl = false;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isBaseRadio((String)string).booleanValue() || Devices.isGcm8000Platform((String)string).booleanValue()) {
            bl = true;
        }
        return bl;
    }
}

