/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.components;

import css.core.appservices.metadataservices.MetadataEventSource;
import css.core.appservices.metadataservices.MetadataServicesProvider;
import css.core.appservices.metadataservices.eventsources.ChannelStateListener;
import css.core.appservices.metadataservices.eventsources.SiteCallLoadCapacityComputationIfc;
import css.core.appservices.metadataservices.eventsources.WriteDoneListener;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.CssJTable;
import css.core.util.popup.ErrorPopup;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServicePrecloseable;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pnm.ui.UIInternalFrame;

public class SiteCallLoadCapacityPanel
extends JPanel
implements ServicePrecloseable {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(SiteCallLoadCapacityPanel.class);
    private final int USER_REQ_STATE_COLUMN = 3;
    private final int INSTANCE_ID_SHIFT = 1;
    private static final String N_A = "N/A";
    private static final String SITE_CALL_LOAD_OVERRIDE_DISABLED = "2";
    private UIInternalFrame m_frmParent = null;
    private CssJTable m_oChannelTable = null;
    private JTextField m_voCurrentValue = new JTextField("N/A");
    private JTextField m_voCurrentOverrideValue = new JTextField("N/A");
    private String m_sCurrentOverrideValue = "1";
    public JButton m_butStoreCurrentValue = new JButton();
    public JButton m_butReadAfterWrite = new JButton();
    public JButton m_butReadExplicitFlags = new JButton();
    private ChannelUpdater m_oChannelUpdater = new ChannelUpdater();
    private WriteDoneListener m_oWriteDoneUpdater = new WriteDoneListener(){

        public void writeDone() {
            LOG.enter("writeDone");
            SiteCallLoadCapacityPanel.this.c_tabExplicitChannels.clear();
            SiteCallLoadCapacityPanel.this.m_butReadAfterWrite.doClick();
            LOG.exit("writeDone");
        }
    };
    private Map<Integer, Integer> c_tabExplicitChannels = new TreeMap<Integer, Integer>();
    private List<Integer> m_listEnabledChannels = Collections.synchronizedList(new LinkedList());

    public List<Integer> getEnabledChannels() {
        LOG.enter("getEnabledChannels");
        LOG.exit("getEnabledChannels", this.m_listEnabledChannels);
        return this.m_listEnabledChannels;
    }

    public void addEnabledChannel(int n) {
        LOG.enter("addEnabledChannel", new Object[]{n});
        this.m_listEnabledChannels.add(n);
        LOG.exit("addEnabledChannel");
    }

    public int removeEnabledChannel() {
        LOG.enter("removeEnabledChannel");
        int n = this.m_listEnabledChannels.remove(0);
        LOG.exit("removeEnabledChannel");
        return n;
    }

    public SiteCallLoadCapacityPanel(UIInternalFrame uIInternalFrame, CssJTable cssJTable) {
        LOG.enter("SiteCallLoadCapacityPanel", new Object[]{uIInternalFrame});
        this.m_frmParent = uIInternalFrame;
        this.m_oChannelTable = cssJTable;
        this.m_voCurrentValue.setEditable(false);
        this.m_voCurrentOverrideValue.setEditable(false);
        JLabel jLabel = new JLabel("Site Call Load Capacity Value");
        JLabel jLabel2 = new JLabel("Site Call Load Capacity Override Value");
        jLabel.setToolTipText("Displays the current value of the Site Call Load Capacity.");
        jLabel2.setToolTipText("Displays the current value of the Site Call Load Capacity Override.");
        this.setLayout(new GridBagLayout());
        GridBagAdder.add((Container)this, (Component)jLabel2, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)13, (int)1, (int)5, (int)15, (int)5, (int)7, (int)0);
        GridBagAdder.add((Container)this, (Component)this.m_voCurrentOverrideValue, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)5, (int)7, (int)5, (int)15, (int)0);
        GridBagAdder.add((Container)this, (Component)jLabel, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)13, (int)1, (int)5, (int)15, (int)5, (int)7, (int)0);
        GridBagAdder.add((Container)this, (Component)this.m_voCurrentValue, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)5, (int)7, (int)5, (int)15, (int)0);
        LOG.exit("SiteCallLoadCapacityPanel");
    }

    private void displayError(String string) {
        LOG.enter("displayError", new Object[]{string});
        if (this.m_frmParent.isVisible()) {
            if (null != string) {
                ErrorPopup errorPopup = new ErrorPopup();
                errorPopup.display(string);
            } else {
                LOG.warn((Object)"Not displaying a null!");
            }
        } else {
            LOG.trace((Object)"displayError - screen is not visible. Not displaying a message.");
        }
        LOG.exit("canCloseScreen");
    }

    public void updateChannelState(int n, int n2) {
        LOG.enter("updateChannelState", new Object[]{n, n2});
        this.m_oChannelUpdater.update(n, n2);
        LOG.exit("updateChannelState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preclose() {
        LOG.enter("preclose");
        Set set = MetadataServicesProvider.getInstance().getEventSourcesFor(ChannelStateListener.class);
        if (null != set) {
            Set set2 = set;
            synchronized (set2) {
                for (MetadataEventSource metadataEventSource : set) {
                    if (metadataEventSource instanceof ChannelStateListener) {
                        this.m_oChannelUpdater.deleteObserver((Observer)((ChannelStateListener)metadataEventSource));
                        continue;
                    }
                    LOG.warn((Object)("preclse - cannot deregister the " + metadataEventSource));
                }
            }
        } else {
            LOG.warn((Object)"Cannot deregister myself - no Observer has been found!");
        }
        MetadataServicesProvider.getInstance().removeService((MetadataEventSource)this.m_oWriteDoneUpdater);
        ScreenManager.removePrecloseOperation(this);
        LOG.exit("preclose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preopen() {
        LOG.enter("preopen");
        this.m_voCurrentValue.setText(N_A);
        ScreenManager.registerPrecloseOperation(this);
        Set set = MetadataServicesProvider.getInstance().getEventSourcesFor(ChannelStateListener.class);
        if (null != set) {
            Set set2 = set;
            synchronized (set2) {
                for (MetadataEventSource metadataEventSource : set) {
                    if (metadataEventSource instanceof ChannelStateListener) {
                        this.m_oChannelUpdater.addObserver((Observer)((ChannelStateListener)metadataEventSource));
                        continue;
                    }
                    LOG.warn((Object)("preopen - cannot register the " + metadataEventSource));
                }
            }
        } else {
            LOG.warn((Object)"Cannot register myself - no Observer has been found!");
        }
        MetadataServicesProvider.getInstance().registerService((MetadataEventSource)this.m_oWriteDoneUpdater);
        LOG.exit("preopen");
    }

    public void updateSclcCapacity(int n, Integer n2, Integer n3) {
        LOG.enter("updateSclcCapacity", new Object[]{n, n2});
        if (0 != n || null == n2) {
            this.displayError("Cannot get the saved value of Site Call Load Capacity from the connected device.");
            LOG.warn((Object)("updateSclcCapacity - cannot update SCLC value, error code: " + n));
        } else {
            this.m_voCurrentValue.setText(n2.toString());
            this.m_sCurrentOverrideValue = n3.toString();
            this.m_voCurrentOverrideValue.setText(this.convertSclcOverrideToString());
        }
        LOG.exit("updateSclcCapacity");
    }

    private String convertSclcOverrideToString() {
        LOG.enter("convertSclcOverrideToString");
        String string = "Enabled";
        if (this.m_sCurrentOverrideValue.equals(SITE_CALL_LOAD_OVERRIDE_DISABLED)) {
            string = "Disabled";
        }
        LOG.exit("convertSclcOverrideToString", (Object)string);
        return string;
    }

    public Object[] getSclcParams() {
        LOG.enter("getSclcParams");
        Object[] objectArray = new Object[2];
        String string = this.m_voCurrentValue.getText();
        Integer n = 30;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (N_A.equals(string)) {
                LOG.warn((Object)"Trying to store N/A value - using degfault!", (Throwable)numberFormatException);
            }
            LOG.error((Object)"getSclcParams - cannot convert SCLC value!", (Throwable)numberFormatException);
        }
        objectArray[0] = n.toString();
        objectArray[1] = this.m_sCurrentOverrideValue;
        if (null != this.m_frmParent) {
            this.m_frmParent.lockWindow();
        } else {
            LOG.warn((Object)"Cannot lock parent window!");
        }
        LOG.exit("updateSclcparams", objectArray);
        return objectArray;
    }

    public void updateSclcParams(int n) {
        LOG.enter("updateSclcParams", new Object[]{n});
        if (0 != n) {
            this.displayError("Cannot store the Site Call Load Capacity value to the device!");
            LOG.warn((Object)("Updating SCLC params in device failed: " + n));
        }
        if (null != this.m_frmParent) {
            this.m_frmParent.unlockWindow();
        } else {
            LOG.warn((Object)"Cannot unlock parent window!");
        }
        LOG.exit("updateSclcParams");
    }

    public boolean isSclcOverrideDisabled() {
        LOG.enter("isSclcOverrideDisabled");
        LOG.exit("isSclcOverrideDisabled");
        return this.m_sCurrentOverrideValue.equals(SITE_CALL_LOAD_OVERRIDE_DISABLED);
    }

    public void setStoreSclcEnabled(boolean bl) {
        LOG.enter("setStoreSclcEnabled", new Object[]{bl});
        this.m_butStoreCurrentValue.setEnabled(bl);
        LOG.exit("setStoreSclcEnabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateSclc() {
        LOG.enter("recalculateSclc");
        String string = null;
        Set set = MetadataServicesProvider.getInstance().getEventSourcesFor(SiteCallLoadCapacityComputationIfc.class);
        if (null != set) {
            Set set2 = set;
            synchronized (set2) {
                for (MetadataEventSource metadataEventSource : set) {
                    if (metadataEventSource instanceof SiteCallLoadCapacityComputationIfc) {
                        string = ((SiteCallLoadCapacityComputationIfc)metadataEventSource).recalculateSclc(this.c_tabExplicitChannels);
                        break;
                    }
                    LOG.warn((Object)("recalculateSclc - cannot find the computator class: " + metadataEventSource));
                }
            }
        }
        if (this.isSclcOverrideDisabled() && !this.m_voCurrentValue.getText().equals(string)) {
            this.m_voCurrentValue.setText(string);
            if (this.m_butStoreCurrentValue.isEnabled()) {
                this.m_butStoreCurrentValue.doClick();
            }
        }
        LOG.exit("recalculateSclc");
    }

    public Object[] getNextExplicitChannelInstanceId() {
        LOG.enter("getNextExplicitChannelInstanceId");
        Object[] objectArray = new Object[]{"." + Integer.toString(this.removeEnabledChannel() + 1)};
        LOG.exit("getNextExplicitChannelInstanceId", objectArray);
        return objectArray;
    }

    public void updateExplicitNumber(int n, String string, Integer n2) {
        LOG.enter("updateExplicitNumber", new Object[]{n, string, n2});
        if (n == 0) {
            int n3 = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1)) - 1;
            String string2 = (String)this.m_oChannelTable.getValueAt(n3, 3);
            int n4 = n2 - 1;
            if (string2.equalsIgnoreCase("User Disabled") || string2.equalsIgnoreCase("Unconfigured")) {
                n4 = 0;
            }
            this.c_tabExplicitChannels.put(n3, n4);
            if (this.m_listEnabledChannels.size() > 0) {
                this.m_butReadExplicitFlags.doClick();
            } else {
                this.recalculateSclc();
            }
        } else {
            LOG.error((Object)"updateExplicitNumber - Channel explicit flag can not be read!");
        }
        LOG.exit("updateExplicitNumber");
    }

    private class ChannelUpdater
    extends Observable {
        private final CssLogger LOG = CssLogger.getCssLogger(SiteCallLoadCapacityPanel.class);

        private ChannelUpdater() {
        }

        public void update(int n, int n2) {
            this.LOG.enter("update", new Object[]{n, n2});
            String string = 0 == n2 ? "1" : "0";
            ChannelStateListener.ChannelState channelState = new ChannelStateListener.ChannelState(n, string);
            this.setChanged();
            this.notifyObservers(channelState);
            this.LOG.exit("update");
        }
    }
}

