/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.component.CssJTable;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.isc.screens.HistoryTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class ChannelTab
extends JPanel
implements TableModelListener,
CssConstants,
DeviceErrorCodes {
    public static final String FILE = "ChannelTab";
    private final String STATUS_PANEL = "Status Panel: Channel";
    private final String ENABLED = "Enabled";
    private final String UNCONFIGURED = "Unconfigured";
    private final String USER_DISABLED = "User Disabled";
    private final String UNKNOWN = "Unknown";
    private final String MALFUNCTION = "Malfunction";
    private final String IMPAIRED = "Impaired";
    private final String NO_REASON = "";
    private final String CHANNEL_HARDWARE_FAILURE = "Channel Hardware Failure";
    private final String INCOMPLETE_CHANNEL_COVERAGE = "Incomplete Channel Coverage";
    private final String USER_REQUESTED = "User Requested";
    private final String BAND_PLAN_MISMATCH = "Band Plan Mismatch";
    private boolean[] m_userInitiated = new boolean[28];
    public CssJTable m_table;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private Object[] m_eventObject;
    private HistoryTab m_history;
    private int[] m_originalIndex = new int[28];
    private int m_eventRow = -1;

    public ChannelTab(HistoryTab historyTab) {
        this.m_history = historyTab;
        this.setLayout(new GridBagLayout());
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter buildScreen() arguments:g_window = " + uIInternalFrame + " g_statusBarListener = " + statusBarListener));
        this.m_window = uIInternalFrame;
        Object[][] objectArray = new Object[][]{{"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}, {"", "", "", ""}};
        Object[] objectArray2 = new String[]{"Channel No.", "State", "Cause", "User Requested Channel State"};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new CssJTable((TableModel)defaultTableModel);
        this.m_table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_table);
        jScrollPane.setPreferredSize(new Dimension(450, 350));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Enabled");
        jComboBox.addItem("Unconfigured");
        jComboBox.addItem("User Disabled");
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.m_table.getModel().addTableModelListener(this);
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JTextField jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 1);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 2);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 3);
        jTextField.setEnabled(false);
        for (int i = 0; i < 28; ++i) {
            this.m_userInitiated[i] = true;
            this.m_originalIndex[i] = -1;
        }
        TableColumn tableColumn2 = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            if (i == 0) {
                tableColumn2 = this.m_table.getColumnModel().getColumn(i);
                tableColumn2.setPreferredWidth(75);
                continue;
            }
            if (i == 1) {
                tableColumn2 = this.m_table.getColumnModel().getColumn(i);
                tableColumn2.setPreferredWidth(80);
                continue;
            }
            if (i == 2) {
                tableColumn2 = this.m_table.getColumnModel().getColumn(i);
                tableColumn2.setPreferredWidth(85);
                continue;
            }
            if (i != 3) continue;
            tableColumn2 = this.m_table.getColumnModel().getColumn(i);
            tableColumn2.setPreferredWidth(175);
        }
        tableColumn2 = this.m_table.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn2.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Channel Number");
        }
        if ((tableCellRenderer = (tableColumn2 = this.m_table.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("State");
        }
        if ((tableCellRenderer = (tableColumn2 = this.m_table.getColumnModel().getColumn(2)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Cause");
        }
        if ((tableCellRenderer = (tableColumn2 = this.m_table.getColumnModel().getColumn(3)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("User Requested Channel State");
        }
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent((JTable)this.m_table, null, true, 0, 3);
        statusBarListener.registerComponent((Component)jTextField, "Select State of Channel from drop down Combo Box");
        Audit.audit((int)1010, (String)FILE, (String)"Exit buildScreen()");
    }

    public void initialize() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter initialize()");
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            this.m_userInitiated[i] = false;
            for (int j = 0; j < this.m_table.getColumnCount(); ++j) {
                this.m_table.setValueAt((Object)"", i, j);
            }
            this.m_userInitiated[i] = true;
            this.m_originalIndex[i] = -1;
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit initialize()");
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter tableChanged()argument: TableModelEvent " + tableModelEvent));
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        int n3 = tableModelEvent.getColumn();
        if (n3 == 3) {
            if (this.m_userInitiated[n]) {
                Integer n4 = null;
                String string = (String)this.m_table.getValueAt(n, n3);
                if (string.equalsIgnoreCase("Enabled")) {
                    n4 = new Integer(2);
                } else if (string.equalsIgnoreCase("Unconfigured")) {
                    n4 = new Integer(3);
                } else if (string.equalsIgnoreCase("User Disabled")) {
                    n4 = new Integer(4);
                }
                this.m_eventObject = new Object[]{"." + new Integer(n + 1).toString(), n4.toString()};
                this.m_table.notifyGuiListener();
                this.m_eventRow = n;
            } else {
                this.m_userInitiated[n] = true;
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit tableChanged()");
    }

    public void updateChannelParams(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter updateChannelParams()arguments: g_error = " + n + "g_instance = " + integerArray + "g_state = " + integerArray2 + "g_cause = " + integerArray3 + "g_reqState = " + integerArray4));
        if (n == 0) {
            String string = "";
            for (int i = 0; i < integerArray.length && i != 28; ++i) {
                int n2 = integerArray[i] - 1;
                this.updateChlStateCause(n2, integerArray2[i], integerArray3[i]);
                switch (integerArray4[i]) {
                    case 2: {
                        string = "Enabled";
                        this.m_originalIndex[i] = 0;
                        break;
                    }
                    case 3: {
                        string = "Unconfigured";
                        this.m_originalIndex[i] = 1;
                        break;
                    }
                    case 4: {
                        string = "User Disabled";
                        this.m_originalIndex[i] = 2;
                    }
                }
                this.m_userInitiated[n2] = false;
                this.m_table.setValueAt((Object)integerArray[i], n2, 0);
                this.m_table.setValueAt((Object)string, n2, 3);
            }
        } else {
            Audit.audit((int)1002, (String)FILE, (String)"Error in getting Channel params");
            this.popupError(-458758);
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateChannelParams()");
    }

    public void updateChlStateCause(int n, int n2, int n3) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter updateChlStateCause() arguments:g_row = " + n + "g_state = " + n2 + "g_cause = " + n3));
        String string = this.convStateNumToName(n2);
        String string2 = this.convCauseNumToName(n3);
        this.m_table.setValueAt((Object)string, n, 1);
        this.m_table.setValueAt((Object)string2, n, 2);
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateChlStateCause()");
    }

    public Object[] getChlReqState() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter getChlReqState()");
        Audit.audit((int)1010, (String)FILE, (String)("Exit getChlReqState() return: " + this.m_eventObject));
        return this.m_eventObject;
    }

    public void updateChlReqState(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter updateChlReqState()arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)FILE, (String)"Error in setting User Requested State for Channel");
            this.popupError(-458759);
            String string = "";
            switch (this.m_originalIndex[this.m_eventRow]) {
                case 0: {
                    string = "Enabled";
                    break;
                }
                case 1: {
                    string = "Unconfigured";
                    break;
                }
                case 2: {
                    string = "User Disabled";
                }
            }
            this.m_userInitiated[this.m_eventRow] = false;
            this.m_table.setValueAt((Object)string, this.m_eventRow, 3);
        } else {
            String string = (String)this.m_table.getValueAt(this.m_eventRow, 3);
            if (string.equalsIgnoreCase("Enabled")) {
                this.m_originalIndex[this.m_eventRow] = 0;
            } else if (string.equalsIgnoreCase("Unconfigured")) {
                this.m_originalIndex[this.m_eventRow] = 1;
            } else if (string.equalsIgnoreCase("User Disabled")) {
                this.m_originalIndex[this.m_eventRow] = 2;
            }
        }
        this.m_eventRow = -1;
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateChlReqState()");
    }

    public void realTimeUpdate(String string, String string2, String string3, String string4, String string5) {
        String string6;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Audit.audit((int)1009, (String)FILE, (String)("Enter realTimeUpdate()arguments: g_time = " + string + "g_stateNum = " + string2 + "g_stateVal = " + string3 + "g_causeNum = " + string4 + "g_causeVal = " + string5));
        int n4 = string2.lastIndexOf(".");
        try {
            string6 = string2.substring(n4 + 1);
            n3 = new Integer(string6);
            --n3;
            n = new Integer(string3);
            n2 = new Integer(string5);
        }
        catch (NumberFormatException numberFormatException) {
            Audit.audit((int)1002, (String)FILE, (String)"Number Format Exception while processing the Trap");
        }
        string6 = this.convStateNumToName(n);
        String string7 = this.convCauseNumToName(n2);
        this.m_table.setValueAt((Object)string6, n3, 1);
        this.m_table.setValueAt((Object)string7, n3, 2);
        String string8 = "Channel" + (n3 + 1);
        this.m_history.updateHistoryTable(string, string8, string6, string7);
        Audit.audit((int)1010, (String)FILE, (String)"Exit realTimeUpdate()");
    }

    private String convStateNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)1009, (String)FILE, (String)("Enter convStateNumToName()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 3: {
                string = "Unconfigured";
                break;
            }
            case 4: {
                string = "User Disabled";
                break;
            }
            case 5: {
                string = "Malfunction";
                break;
            }
            case 6: {
                string = "Impaired";
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)("Exit convStateNumToName() return: " + string));
        return string;
    }

    private String convCauseNumToName(int n) {
        String string = "N/A";
        Audit.audit((int)1009, (String)FILE, (String)("Enter convCauseNumToName()arguments: g_cause = " + n));
        switch (n) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "Channel Hardware Failure";
                break;
            }
            case 3: {
                string = "Incomplete Channel Coverage";
                break;
            }
            case 4: {
                string = "User Requested";
                break;
            }
            case 5: {
                string = "Band Plan Mismatch";
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)("Exit convCauseNumToName() return: " + string));
        return string;
    }

    public void writeToFile() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter writeToFile()");
        String string = "Object Name: Channel\n";
        string = string + "Channel #" + "\t" + "State" + "\t" + "Cause" + "\t" + "User Requested State" + "\n";
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            for (int j = 0; j < this.m_table.getColumnCount(); ++j) {
                string = string + this.m_table.getValueAt(i, j) + "\t";
            }
            string = string + "\n";
        }
        this.m_history.appendString(string);
        Audit.audit((int)1010, (String)FILE, (String)"Exit writeToFile()");
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }
}

