/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.Logger;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.common.util.LogFileClosable;
import css.device.sc_platform.isc.screens.IscStatusPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pnm.ui.UIInternalFrame;
import pnm.util.path.PathConstants;

public class HistoryTab
extends JPanel
implements ActionListener,
CssConstants,
DeviceErrorCodes,
LogFileClosable {
    private static final long serialVersionUID = 1L;
    private final String SITE_CONTROLLER_STATUS = " Site Controller Status:  ";
    private final String START_LOG = "Start Log";
    private final String STOP_LOG = "Stop Log";
    private final String CLEAR_LOG = "Clear Log";
    private final String N_A = "N/A";
    private final String ACTIVE = "Active";
    private final String STANDBY = "Standby";
    private final String NON_REDUNDANT = "Non Redundant";
    private static final CssLogger LOG = CssLogger.getCssLogger(HistoryTab.class);
    public JTable m_table;
    private DefaultTableModel m_model;
    private JLabel m_scStatusLbl;
    private JButton m_startStopLogBtn;
    private JButton m_clearLogBtn;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private Logger m_log;
    private SimpleDateFormat m_oDeviceDateFormatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
    private SimpleDateFormat m_oHostDateFormatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
    IscStatusPanel m_mainPanel;

    public HistoryTab(IscStatusPanel iscStatusPanel) {
        this.m_mainPanel = iscStatusPanel;
        this.m_oDeviceDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setLayout(new GridBagLayout());
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.m_window = uIInternalFrame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        JLabel jLabel = new JLabel(" Site Controller Status:  ");
        jLabel.setToolTipText("Current Status of the Site Controller");
        jPanel.add(jLabel);
        this.m_scStatusLbl = new JLabel("N/A");
        jPanel.add(this.m_scStatusLbl);
        JLabel jLabel2 = new JLabel();
        jPanel.add(jLabel2);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(50, 15));
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(new Dimension(50, 15));
        Object[][] objectArray = new Object[][]{{"", "", "", ""}};
        Object[] objectArray2 = new String[]{"Date/Time", "Object Name", "State", "Cause"};
        this.m_model = new DefaultTableModel(objectArray, objectArray2);
        this.m_table = new JTable(this.m_model);
        this.m_table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(400, 250));
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)1, (double)1.0, (double)1.0, (int)4, (int)4, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JTextField jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 1);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 2);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_table.getCellEditor(0, 0).getTableCellEditorComponent(this.m_table, null, true, 0, 3);
        jTextField.setEnabled(false);
        TableColumn tableColumn = this.m_table.getColumnModel().getColumn(0);
        this.setTableTooltips(tableColumn);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (i == 0) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(125);
                tableColumn.setPreferredWidth(125);
                tableColumn.setMinWidth(125);
                continue;
            }
            if (i == 1) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
                continue;
            }
            if (i == 2) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
                continue;
            }
            if (i != 3) continue;
            tableColumn = this.m_table.getColumnModel().getColumn(i);
            tableColumn.setMinWidth(140);
            tableColumn.setPreferredWidth(140);
            tableColumn.setMinWidth(140);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4));
        jPanel2.add(jLabel3);
        this.m_startStopLogBtn = new JButton("Start Log");
        this.m_startStopLogBtn.addActionListener(this);
        this.m_startStopLogBtn.setToolTipText("Starts/Stops the storing of event logs.");
        jPanel2.add(this.m_startStopLogBtn);
        jPanel2.add(jLabel4);
        this.m_clearLogBtn = new JButton("Clear Log");
        this.m_clearLogBtn.addActionListener(this);
        this.m_clearLogBtn.setToolTipText("Clears the entries in the displayed table.");
        jPanel2.add(this.m_clearLogBtn);
        statusBarListener.registerComponent((Component)this.m_clearLogBtn, "Click this button to clear the entries in the displayed table.");
        statusBarListener.registerComponent((Component)this.m_startStopLogBtn, "Click this button to start/stop the storing of event logs.");
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)7, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.clearHistoryTable();
        this.m_scStatusLbl.setText("N/A");
        LOG.exit("initialize");
    }

    public void updateSCStatus(int n, Integer n2) {
        LOG.enter("updateSCStatus", new Object[]{Integer.toString(n), n2});
        if (n == 0) {
            switch (n2) {
                case 1: {
                    this.m_scStatusLbl.setText("Active");
                    break;
                }
                case 2: {
                    this.m_scStatusLbl.setText("Standby");
                    break;
                }
                case 3: {
                    this.m_scStatusLbl.setText("Non Redundant");
                }
            }
        } else {
            LOG.info((Object)"Error in getting SC Status");
            this.popupError(-458762);
        }
        LOG.exit("updateSCStatus");
    }

    public void clearHistoryTable() {
        LOG.enter("clearHistoryTable");
        Object[][] objectArray = new Object[][]{{"", "", "", ""}};
        Object[] objectArray2 = new String[]{"Date/Time", "Object Name", "State", "Cause"};
        this.m_model = new DefaultTableModel(objectArray, objectArray2);
        this.m_table.setModel(this.m_model);
        TableColumn tableColumn = null;
        tableColumn = this.m_table.getColumnModel().getColumn(0);
        this.setTableTooltips(tableColumn);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (i == 0) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(125);
                tableColumn.setPreferredWidth(125);
                tableColumn.setMinWidth(125);
                continue;
            }
            if (i == 1) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
                continue;
            }
            if (i == 2) {
                tableColumn = this.m_table.getColumnModel().getColumn(i);
                tableColumn.setMinWidth(85);
                tableColumn.setPreferredWidth(85);
                tableColumn.setMinWidth(85);
                continue;
            }
            if (i != 3) continue;
            tableColumn = this.m_table.getColumnModel().getColumn(i);
            tableColumn.setMinWidth(140);
            tableColumn.setPreferredWidth(140);
            tableColumn.setMinWidth(140);
        }
        LOG.exit("clearHistoryTable");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        LOG.enter("actionPerformed", new Object[]{actionEvent});
        if (actionEvent.getSource() == this.m_clearLogBtn) {
            this.clearHistoryTable();
        } else if ("Start Log".equals(this.m_startStopLogBtn.getText())) {
            File file;
            JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
            n = jFileChooser.showSaveDialog((Component)this.m_window);
            if (n == 0 && CSSUtilities.isValidLogFile((File)(file = jFileChooser.getSelectedFile()), (ErrorPopup)this.m_errPopup)) {
                try {
                    this.m_log = new Logger(file);
                    Date date = new Date();
                    String string = this.m_oHostDateFormatter.format(date);
                    this.m_log.write("Start Log Time is: " + string + "\n");
                    this.m_startStopLogBtn.setText("Stop Log");
                    this.m_mainPanel.startWriteToFile();
                }
                catch (IOException iOException) {
                    LOG.info((Object)"Unable to create file for writing", (Throwable)iOException);
                    this.m_errPopup.display(-327859);
                    this.closeFile(false);
                }
                catch (Exception exception) {
                    LOG.info((Object)"Unable to create log file", (Throwable)exception);
                    this.m_errPopup.display(-327860);
                    this.closeFile(false);
                }
            }
        } else {
            this.closeFile(true);
            this.m_startStopLogBtn.setText("Start Log");
        }
        LOG.exit("actionPerformed");
    }

    public void closeFile(boolean bl) {
        LOG.enter("closeFile", new Object[]{Boolean.toString(bl)});
        if (bl) {
            try {
                Date date = new Date();
                String string = this.m_oHostDateFormatter.format(date);
                this.writeToLog("Stop Log Time is: " + string + "\n");
                this.closeLog();
            }
            catch (IOException iOException) {
                LOG.info((Object)"Unable to close file for writing", (Throwable)iOException);
            }
        } else if (this.m_log != null && this.m_log.isLogEnabled()) {
            this.popupError(-458763);
            try {
                this.closeLog();
            }
            catch (IOException iOException) {
                LOG.info((Object)"Unable to close file for writing", (Throwable)iOException);
            }
        }
        this.m_startStopLogBtn.setText("Start Log");
        LOG.exit("closeFile");
    }

    @Override
    public void closeFile() {
        LOG.enter("closeFile");
        this.closeFile(true);
        LOG.exit("enclosing_method");
    }

    public void updateHistoryTable(String string, String string2, String string3, String string4) {
        Object object;
        LOG.enter("updateHistoryTable", new Object[]{string, string2, string3, string4});
        String string5 = "";
        string = string + "000";
        try {
            long l = new Long(string);
            object = new Date(l);
            string5 = this.m_oDeviceDateFormatter.format((Date)object);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.info((Object)"Couldn't get time. Using current time", (Throwable)numberFormatException);
            Date date = new Date();
            string5 = this.m_oHostDateFormatter.format(date);
        }
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                object = string5 + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\n";
                this.writeToLog((String)object, true);
            }
            catch (IOException iOException) {
                LOG.info((Object)"Unable to write to File", (Throwable)iOException);
            }
        }
        if (((String)this.m_table.getValueAt(0, 0)).equals("")) {
            this.m_table.setValueAt(string5, 0, 0);
            this.m_table.setValueAt(string2, 0, 1);
            this.m_table.setValueAt(string3, 0, 2);
            this.m_table.setValueAt(string4, 0, 3);
        } else {
            this.m_model.addRow(new Object[]{string5, string2, string3, string4});
            this.m_table.setModel(this.m_model);
        }
        LOG.exit("updateHistoryTable");
    }

    public void writeToFile() {
        LOG.enter("writeToFile");
        String string = "Object Name: History Screen\n";
        string = string + "Site Controller Status: " + this.m_scStatusLbl.getText() + "\n";
        string = string + "Time/Date" + "\t" + "Object Name" + "\t" + "State" + "\t" + "Cause" + "\n";
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            for (int j = 0; j < this.m_table.getColumnCount(); ++j) {
                string = string + this.m_table.getValueAt(i, j) + "\t";
            }
            string = string + "\n";
        }
        this.appendString(string);
        LOG.exit("writeToFile");
    }

    public void appendString(String string) {
        LOG.enter("appendString", new Object[]{string});
        try {
            this.writeToLog(string, true);
        }
        catch (IOException iOException) {
            LOG.info((Object)"Unable to write to File", (Throwable)iOException);
            this.closeFile(false);
        }
        LOG.exit("appendString");
    }

    @Override
    public boolean isFileOpen() {
        LOG.enter("isFileOpen");
        boolean bl = false;
        bl = this.m_log != null && this.m_log.isLogEnabled();
        LOG.exit("isFileOpen", (Object)Boolean.toString(bl));
        return bl;
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    private void setTableTooltips(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Date/Time");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Object Name");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(2)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("State");
        }
        if ((tableCellRenderer = (tableColumn = this.m_table.getColumnModel().getColumn(3)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Cause");
        }
        this.m_table.repaint();
    }

    private void writeToLog(String string) throws IOException {
        this.writeToLog(string, false);
    }

    private void writeToLog(String string, boolean bl) throws IOException {
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                this.m_log.write(string);
                if (bl) {
                    this.m_log.flush();
                }
            }
            catch (IOException iOException) {
                this.popupError(-327859);
                this.m_startStopLogBtn.setText("Start Log");
                throw iOException;
            }
        }
    }

    private void closeLog() throws IOException {
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            this.m_log.close();
        }
    }
}

