/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.GenericListener;
import css.core.util.component.SafeComboBox;
import css.core.util.component.SafeComboBoxTrigger;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.DeviceErrorCodes;
import css.device.sc_platform.isc.screens.ChannelTab;
import css.device.sc_platform.isc.screens.HistoryTab;
import css.device.sc_platform.isc.screens.SiteTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pnm.ui.UIInternalFrame;

public class SiteControllerTab
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(SiteControllerTab.class);
    private final String SC_NUMBER = "Site Controller No: ";
    private final String OBJECT_NAME = "Site Controller Name: ";
    private final String STATE = "Site Controller State: ";
    private final String CAUSE = "Site Controller Cause: ";
    private final String FAN_STATE = "Fan State: ";
    private final String FAN_CAUSE = "Fan Cause: ";
    private final String STATUS = "Status: ";
    private final String USER_REQ_SC_STATE = "User Requested Site Controller State: ";
    private final String N_A = "N/A";
    private final String ENABLED = "Enabled";
    private final String USER_DISABLED = "User Disabled";
    private final String RESTART = "Restart";
    private final String UNKNOWN = "Unknown";
    private final String INITIALIZATION = "Initialization";
    private final String CRITICAL_MALFUNCTION = "Critical Malfunction";
    private final String SOFTWARE_DOWNLOAD = "Software Download";
    private final String VERSION_VALIDATION = "Version Validation";
    private final String OPERATIONAL = "Operational";
    private final String CRITICAL_FAILED = "Critical Failed";
    private final String MAJOR_FAILED = "Major_Failed";
    private final String MINOR_FAILED = "Minor_Failed";
    private final String WARNING_FAILED = "Warning Failed";
    private final String HARDWARE_FAILURE = "Hardware Failure";
    private final String NO_REASON = "No Reason";
    private final String USER_REQUESTED = "User Requested";
    private final String SITE_CONTROLLER_POWER_UP = "Site Controller Power Up";
    private final String MULTIPLE_SC_WITH_SAME_NUMBER = "Multiple Site Controllers with same Number";
    private final String SOFTWARE_DOWNLOAD_MANAGER = "Software Download Manager Action";
    private final String SC_SOFTWARE_CROSSLOAD_FAILURE = "SC Software Crossload Failed";
    private final String CORRUPT_NVM = "NVM is corrupted";
    private final String SOFTWARE_VERSION_MISMATCH = "Software Version Mismatch";
    private final String ACTIVE = "Active";
    private final String STANDBY = "Standby";
    private final String NON_REDUNDANT = "Non Redundant";
    private boolean m_userInitiated = true;
    private JLabel m_scNumberLbl;
    private JLabel m_scStateLbl;
    private JLabel m_scCauseLbl;
    private JLabel m_scFanStateLbl;
    private JLabel m_scFanCauseLbl;
    private JLabel m_scStatusLbl;
    private JLabel m_scNameLbl;
    public JComboBox m_scReqStateCbBox;
    private UIInternalFrame m_window;
    private Integer m_scInstance;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private HistoryTab m_history;
    private ChannelTab m_channel;
    private SiteTab m_site;
    private int m_originalIndex = -1;
    private boolean m_isDeviceActive = false;
    private boolean m_isDeviceEnabled = false;
    public GenericListener m_genericListener;

    public SiteControllerTab(HistoryTab historyTab, SiteTab siteTab, ChannelTab channelTab) {
        LOG.enter("SiteControllerTab", new Object[]{historyTab, siteTab, channelTab});
        this.m_history = historyTab;
        this.m_site = siteTab;
        this.m_channel = channelTab;
        this.setLayout(new GridBagLayout());
        LOG.exit("SiteControllerTab");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.m_window = uIInternalFrame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 3));
        JLabel jLabel = new JLabel("Site Controller No: ");
        jLabel.setToolTipText("Site Controller Identification Number");
        jPanel.add(jLabel);
        this.m_scNumberLbl = new JLabel("N/A");
        jPanel.add(this.m_scNumberLbl);
        JLabel jLabel2 = new JLabel();
        jPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel("Site Controller Name: ");
        jLabel3.setToolTipText("Name assigned to the Site Controller");
        JLabel jLabel4 = new JLabel("Site Controller State: ");
        jLabel4.setToolTipText("Defines the current state of the Site Controller");
        JLabel jLabel5 = new JLabel("Site Controller Cause: ");
        jLabel5.setToolTipText("Additional Information on the current state of the Site Controller");
        JLabel jLabel6 = new JLabel("Fan State: ");
        jLabel6.setToolTipText("Defines the current fan state of the Site Controller");
        JLabel jLabel7 = new JLabel("Fan Cause: ");
        jLabel7.setToolTipText("Additional Information on the current fan state of the Site Controller");
        JLabel jLabel8 = new JLabel("Status: ");
        jLabel8.setToolTipText("Current Status of the Site Controller");
        this.m_scNameLbl = new JLabel("N/A");
        jPanel.add(jLabel3);
        jPanel.add(this.m_scNameLbl);
        JLabel jLabel9 = new JLabel();
        jPanel.add(jLabel9);
        this.m_scStateLbl = new JLabel("N/A");
        jPanel.add(jLabel4);
        jPanel.add(this.m_scStateLbl);
        JLabel jLabel10 = new JLabel();
        jPanel.add(jLabel10);
        this.m_scCauseLbl = new JLabel("N/A");
        jPanel.add(jLabel5);
        jPanel.add(this.m_scCauseLbl);
        JLabel jLabel11 = new JLabel();
        jPanel.add(jLabel11);
        this.m_scFanStateLbl = new JLabel("N/A");
        jPanel.add(jLabel6);
        jPanel.add(this.m_scFanStateLbl);
        JLabel jLabel12 = new JLabel();
        jPanel.add(jLabel12);
        this.m_scFanCauseLbl = new JLabel("N/A");
        jPanel.add(jLabel7);
        jPanel.add(this.m_scFanCauseLbl);
        JLabel jLabel13 = new JLabel();
        jPanel.add(jLabel13);
        this.m_scStatusLbl = new JLabel("N/A");
        jPanel.add(jLabel8);
        jPanel.add(this.m_scStatusLbl);
        JLabel jLabel14 = new JLabel();
        jPanel.add(jLabel14);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        JLabel jLabel15 = new JLabel("         ");
        JLabel jLabel16 = new JLabel("         ");
        JLabel jLabel17 = new JLabel("         ");
        jPanel2.add(jLabel15);
        jPanel2.add(jLabel16);
        jPanel2.add(jLabel17);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JLabel jLabel18 = new JLabel("User Requested Site Controller State: ");
        jLabel18.setToolTipText("Set the state of Site Controller as per Users Request");
        jPanel3.add(jLabel18);
        this.m_genericListener = new GenericListener();
        this.m_scReqStateCbBox = new SafeComboBox(new SafeComboBoxTrigger(){

            public boolean isSafeSelect(Object object, Object object2) {
                LOG.enter("isSafeSelect", new Object[]{object, object2});
                LOG.exit("isSafeSelect", (Object)SiteControllerTab.this.m_userInitiated);
                return SiteControllerTab.this.m_userInitiated;
            }
        }, "Confirm Site Controller State change");
        this.m_scReqStateCbBox.addItem("Enabled");
        this.m_scReqStateCbBox.addItem("User Disabled");
        this.m_scReqStateCbBox.addItem("Restart");
        jPanel3.add(this.m_scReqStateCbBox);
        GridBagAdder.add((Container)this, (Component)jPanel3, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_scReqStateCbBox, "Select State of Site Controller from the Drop down Combo Box");
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_scNameLbl.setText("N/A");
        this.m_scNumberLbl.setText("N/A");
        this.m_scStateLbl.setText("N/A");
        this.m_scCauseLbl.setText("N/A");
        this.m_scFanStateLbl.setText("N/A");
        this.m_scFanCauseLbl.setText("N/A");
        this.m_scStatusLbl.setText("N/A");
        this.m_userInitiated = false;
        this.m_scReqStateCbBox.setSelectedIndex(0);
        this.m_userInitiated = true;
        LOG.exit("initialize");
    }

    public void updateSCInstanceNumReqState(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, String[] stringArray) {
        LOG.enter("updateSCInstanceNumReqState", new Object[]{Integer.toString(n), integerArray, integerArray2, integerArray3, stringArray});
        if (n == 0) {
            this.m_scNameLbl.setText(stringArray[0]);
            this.m_scInstance = integerArray[0];
            this.m_scNumberLbl.setText(integerArray2[0].toString());
            this.m_userInitiated = false;
            switch (integerArray3[0]) {
                case 2: {
                    this.m_scReqStateCbBox.setSelectedIndex(0);
                    break;
                }
                case 3: {
                    this.m_scReqStateCbBox.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.m_scReqStateCbBox.setSelectedIndex(2);
                }
            }
            this.m_originalIndex = this.m_scReqStateCbBox.getSelectedIndex();
        } else {
            LOG.error((Object)"updateSCInstanceNumReqState - Error in getting Site Controller Number, Instance ID, Name, Req State");
            this.popupError(-458756);
        }
        LOG.exit("updateSCInstanceNumReqState");
    }

    public boolean isSetRequired() {
        LOG.enter("isSetRequired");
        boolean bl = this.m_userInitiated;
        if (!this.m_userInitiated) {
            this.m_userInitiated = true;
        }
        LOG.exit("isSetRequired");
        return bl;
    }

    public void updateScStateCause(int n, Integer[] integerArray, Integer[] integerArray2) {
        LOG.enter("updateScStateCause", new Object[]{Integer.toString(n), integerArray, integerArray2});
        if (n == 0) {
            this.updateScStateCause(integerArray[0], integerArray2[0]);
        } else {
            LOG.error((Object)"updateScStateCause - Error in getting Site Controller State and Cause");
            this.popupError(-458756);
        }
        LOG.exit("updateScStateCause");
    }

    public void updateScFanStateCause(int n, Integer[] integerArray, Integer[] integerArray2) {
        LOG.enter("updateScFanStateCause", new Object[]{Integer.toString(n), integerArray, integerArray2});
        if (n == 0) {
            this.updateScFanStateCause(integerArray[0], integerArray2[0]);
        } else {
            LOG.error((Object)"updateScFanStateCause - Error in getting Site Controller State and Cause");
            this.popupError(-458756);
        }
        LOG.exit("updateScFanStateCause");
    }

    public void updateScStateCause(int n, int n2) {
        LOG.enter("updateScStateCause", new Object[]{Integer.toString(n), Integer.toString(n2)});
        String string = this.convStateNumToName(n);
        this.m_scStateLbl.setText(string);
        String string2 = this.convCauseNumToName(n2);
        this.m_scCauseLbl.setText(string2);
        LOG.exit("updateScStateCause");
    }

    public void updateScFanStateCause(int n, int n2) {
        LOG.enter("updateScFanStateCause", new Object[]{Integer.toString(n), Integer.toString(n2)});
        String string = this.fanStateNumToName(n);
        this.m_scFanStateLbl.setText(string);
        String string2 = this.fanCauseNumToName(n2);
        this.m_scFanCauseLbl.setText(string2);
        LOG.exit("updateScFanStateCause");
    }

    public void updateSCStatus(int n, Integer n2) {
        LOG.enter("updateSCStatus", new Object[]{Integer.toString(n), n2});
        String string = null;
        if (n == 0) {
            string = this.convBoxStatus(n2);
            this.m_scStatusLbl.setText(string);
        } else {
            LOG.error((Object)"updateSCStatus - Error in getting Site Controller Status");
            this.popupError(-458756);
        }
        LOG.exit("updateSCStatus");
    }

    public boolean isDeviceActive() {
        LOG.enter("isDeviceActive");
        LOG.exit("isDeviceActive", (Object)this.m_isDeviceActive);
        return this.m_isDeviceActive;
    }

    public boolean isDeviceEnabled() {
        LOG.enter("isDeviceEnabled");
        LOG.exit("isDeviceEnabled", (Object)this.m_isDeviceEnabled);
        return this.m_isDeviceEnabled;
    }

    public Object[] getScReqState() {
        LOG.enter("getScReqState");
        Object[] objectArray = null;
        Integer n = null;
        switch (this.m_scReqStateCbBox.getSelectedIndex()) {
            case 0: {
                n = new Integer(2);
                break;
            }
            case 1: {
                n = new Integer(3);
                break;
            }
            case 2: {
                n = new Integer(4);
            }
        }
        objectArray = new Object[]{"." + this.m_scInstance.toString(), n.toString()};
        LOG.exit("getScReqState", objectArray);
        return objectArray;
    }

    public void updateSCReqState(int n) {
        LOG.enter("updateSCReqState", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.error((Object)"updateSCReqState - Error in setting User Requested State for Site Controller");
            this.popupError(-458757);
            this.m_userInitiated = false;
            this.m_scReqStateCbBox.setSelectedIndex(this.m_originalIndex);
        } else {
            this.m_originalIndex = this.m_scReqStateCbBox.getSelectedIndex();
        }
        LOG.exit("updateSCReqState");
    }

    public void realTimeUpdate(String string, String string2, String string3) {
        LOG.enter("realTimeUpdate", new Object[]{string, string2, string3});
        int n = -1;
        int n2 = -1;
        try {
            n = new Integer(string2);
            n2 = new Integer(string3);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"realTimeUpdate - Number Format Exception while processing the Trap", (Throwable)numberFormatException);
        }
        String string4 = this.convStateNumToName(n);
        this.m_scStateLbl.setText(string4);
        String string5 = this.convCauseNumToName(n2);
        this.m_scCauseLbl.setText(string5);
        this.m_history.updateHistoryTable(string, "Site Controller", string4, string5);
        LOG.exit("realTimeUpdate");
    }

    public void realTimeFanUpdate(String string, String string2, String string3) {
        LOG.enter("realTimeFanUpdate", new Object[]{string, string2, string3});
        int n = -1;
        int n2 = -1;
        try {
            n = new Integer(string2);
            n2 = new Integer(string3);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"realTimeFanUpdate - Number Format Exception while processing fan Trap", (Throwable)numberFormatException);
        }
        String string4 = this.fanStateNumToName(n);
        this.m_scFanStateLbl.setText(string4);
        String string5 = this.fanCauseNumToName(n2);
        this.m_scFanCauseLbl.setText(string5);
        this.m_history.updateHistoryTable(string, "Fan", string4, string5);
        LOG.exit("realTimeFanUpdate");
    }

    public void realTimeUpdate(String string) {
        LOG.enter("realTimeUpdate", new Object[]{string});
        try {
            Integer n = new Integer(string);
            String string2 = this.convBoxStatus(n);
            this.m_scStatusLbl.setText(string2);
            if (string2.equalsIgnoreCase("Active")) {
                this.m_genericListener.notifyGuiListener();
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"realTimeUpdate - Number Format Exception while processing the Trap");
        }
        LOG.exit("realTimeUpdate");
    }

    private String convStateNumToName(int n) {
        LOG.enter("convStateNumToName", new Object[]{Integer.toString(n)});
        String string = "N/A";
        this.m_isDeviceEnabled = false;
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                this.m_isDeviceEnabled = true;
                break;
            }
            case 3: {
                string = "User Disabled";
                break;
            }
            case 4: {
                string = "Restart";
                break;
            }
            case 5: {
                string = "Initialization";
                break;
            }
            case 6: {
                string = "Critical Malfunction";
                break;
            }
            case 7: {
                string = "Software Download";
                break;
            }
            case 8: {
                string = "Version Validation";
                break;
            }
            default: {
                LOG.error((Object)("convStateNumToName - Unexpected state was received: " + n));
            }
        }
        LOG.exit("convStateNumToName", (Object)string);
        return string;
    }

    private String fanStateNumToName(int n) {
        LOG.enter("fanStateNumToName", new Object[]{Integer.toString(n)});
        String string = "N/A";
        switch (n) {
            case 1: {
                string = "Unknown";
                break;
            }
            case 2: {
                string = "Enabled";
                break;
            }
            case 3: {
                string = "Operational";
                break;
            }
            case 4: {
                string = "Critical Failed";
                break;
            }
            case 5: {
                string = "Major_Failed";
                break;
            }
            case 6: {
                string = "Minor_Failed";
                break;
            }
            case 7: {
                string = "Warning Failed";
                break;
            }
            case 8: {
                string = "Initialization";
            }
        }
        LOG.exit("fanStateNumToName", (Object)string);
        return string;
    }

    private String convCauseNumToName(int n) {
        LOG.enter("convCauseNumToName", new Object[]{Integer.toString(n)});
        String string = "N/A";
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "User Requested";
                break;
            }
            case 3: {
                string = "Site Controller Power Up";
                break;
            }
            case 4: {
                string = "Multiple Site Controllers with same Number";
                break;
            }
            case 5: {
                string = "Software Download Manager Action";
                break;
            }
            case 6: {
                string = "SC Software Crossload Failed";
                break;
            }
            case 7: {
                string = "NVM is corrupted";
                break;
            }
            case 8: {
                string = "Software Version Mismatch";
            }
        }
        LOG.exit("convCauseNumToName", (Object)string);
        return string;
    }

    private String fanCauseNumToName(int n) {
        LOG.enter("fanCauseNumToName", new Object[]{Integer.toString(n)});
        String string = "N/A";
        switch (n) {
            case 1: {
                string = "No Reason";
                break;
            }
            case 2: {
                string = "Hardware Failure";
            }
        }
        LOG.exit("fanCauseNumToName", (Object)string);
        return string;
    }

    public void writeToFile() {
        LOG.enter("writeToFile");
        String string = "Object Name: Site Controller\n";
        string = string + "Site Controller Number: " + this.m_scNumberLbl.getText() + "\n";
        string = string + "Site Controller State: " + this.m_scStateLbl.getText() + "\n";
        string = string + "Site Controller Cause: " + this.m_scCauseLbl.getText() + "\n";
        string = string + "Site Controller Status: " + this.m_scStatusLbl.getText() + "\n";
        string = string + "User Requested Site Controller State: " + this.m_scReqStateCbBox.getSelectedItem() + "\n";
        string = string + "\n" + "\n";
        this.m_history.appendString(string);
        LOG.exit("writeToFile");
    }

    private String convBoxStatus(Integer n) {
        LOG.enter("convBoxStatus", new Object[]{n});
        String string = "N/A";
        switch (n) {
            case 1: {
                this.m_isDeviceActive = true;
                string = "Active";
                break;
            }
            case 2: {
                this.m_isDeviceActive = false;
                this.m_channel.initialize();
                string = "Standby";
                break;
            }
            case 3: {
                this.m_isDeviceActive = false;
                this.m_channel.initialize();
                this.m_site.initialize();
                string = "Non Redundant";
            }
        }
        LOG.exit("convBoxStatus", (Object)string);
        return string;
    }

    private void popupError(int n) {
        LOG.enter("popupError", new Object[]{Integer.toString(n)});
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
        LOG.exit("popupError");
    }
}

