/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.popup.ErrorPopup;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServicePrecloseable;
import css.device.common.service.Serviceable;
import css.device.common.util.DeviceErrorCodes;
import css.device.common.util.LoggerClosingHandler;
import css.device.sc_platform.isc.screens.ChannelTab;
import css.device.sc_platform.isc.screens.HistoryTab;
import css.device.sc_platform.isc.screens.IscStatusPanelMaker;
import css.device.sc_platform.isc.screens.SiteControllerTab;
import css.device.sc_platform.isc.screens.SiteTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pnm.ui.UIInternalFrame;

public class IscStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes,
Serviceable {
    private static final long serialVersionUID = 5102386245643160247L;
    public SiteTab m_site;
    public SiteControllerTab m_siteController;
    public ChannelTab m_channel;
    public HistoryTab m_history;
    private String ISC_SiteState = "ISC_SiteState";
    private String ISC_SiteCause = "ISC_SiteCause";
    private String ISC_SCState = "ISC_SCState";
    private String ISC_SCCause = "ISC_SCCause";
    private String ISC_commFanState = "ISC_commFanState";
    private String ISC_commFanCause = "ISC_commFanCause";
    private String ISC_nmaDateTime = "nmaDateTime";
    private String ISC_ScBoxAlarmCode = "ISC_ScBoxAlarmCode";
    private String ISC_ScBoxText = "ISC_ScBoxText";
    private String ISC_nmaDeviceState = "nmaDeviceState";
    private String ISC_ChlState = "ISC_ChlState";
    private String ISC_ChlCause = "ISC_ChlCause";
    private JTabbedPane m_tabbedPane;
    private UIInternalFrame m_window;
    private ErrorPopup m_errPopup = new ErrorPopup();
    private LoggerClosingHandler m_oLoggerClosingHandler = null;
    private static final CssLogger LOG = CssLogger.getCssLogger(IscStatusPanel.class);

    public IscStatusPanel() {
        this.setLayout(new GridBagLayout());
    }

    public IscStatusPanel(ServicePrecloseable servicePrecloseable) {
        this();
        LOG.enter("IscStatusPanel", new Object[]{servicePrecloseable});
        this.m_oLoggerClosingHandler = (LoggerClosingHandler)servicePrecloseable;
        LOG.exit("IscStatusPanel");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.m_window = uIInternalFrame;
        this.m_tabbedPane = new JTabbedPane();
        this.m_history = new HistoryTab(this);
        this.m_site = new SiteTab(this.m_history);
        this.m_channel = new ChannelTab(this.m_history);
        this.m_siteController = new SiteControllerTab(this.m_history, this.m_site, this.m_channel);
        this.m_site.buildScreen(this.m_window, statusBarListener);
        this.m_siteController.buildScreen(this.m_window, statusBarListener);
        this.m_channel.buildScreen(this.m_window, statusBarListener);
        this.m_history.buildScreen(this.m_window, statusBarListener);
        this.m_tabbedPane.addTab("Site Info", this.m_site);
        this.m_tabbedPane.addTab("Site Controller", this.m_siteController);
        this.m_tabbedPane.addTab("Channel", this.m_channel);
        this.m_tabbedPane.addTab("History", this.m_history);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add(this.m_tabbedPane);
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_site.initialize();
        this.m_siteController.initialize();
        this.m_channel.initialize();
        this.m_history.initialize();
        this.m_tabbedPane.setSelectedIndex(0);
        LOG.exit("initialize");
    }

    public void updateRegistration(int n) {
        LOG.enter("updateRegistration", new Object[]{Integer.toString(n)});
        if (0 != n) {
            LOG.info((Object)"Error in Registering with the Device. Closing the Screen");
            if (-54 == n) {
                this.popupError(-262187);
            } else {
                this.popupError(-458765);
            }
            this.m_window.setVisible(false);
        }
        LOG.exit("updateRegistration");
    }

    public void updateDeRegistration(int n) {
        LOG.enter("updateDeRegistration", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.info((Object)"Error in Deregistering with the Device. Closing the Screen anyways");
            this.popupError(-458766);
        }
        LOG.exit("updateDeRegistration");
    }

    public void realTimeUpdate(Object object) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        String[] stringArray = null;
        LOG.enter("realTimeUpdate", new Object[]{object});
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        int n11 = realTimeDataObject.getSize();
        stringArray = new String[n11];
        for (int i = 0; i < n11; ++i) {
            stringArray[i] = "";
            try {
                stringArray[i] = realTimeDataObject.getName(i);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving Data", (Throwable)notFoundException);
            }
            if (stringArray[i].indexOf(this.ISC_SiteState) != -1) {
                n = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_SiteCause) != -1) {
                n2 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_SCState) != -1) {
                n = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_SCCause) != -1) {
                n2 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_commFanState) != -1) {
                n3 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_commFanCause) != -1) {
                n4 = i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.ISC_nmaDateTime)) {
                n5 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_ScBoxAlarmCode) != -1) {
                n6 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_ScBoxText) != -1) {
                n7 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_nmaDeviceState) != -1) {
                n8 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_ChlState) != -1) {
                n9 = i;
                continue;
            }
            if (stringArray[i].indexOf(this.ISC_ChlCause) == -1) continue;
            n10 = i;
        }
        if (n8 != -1) {
            try {
                String string = (String)realTimeDataObject.getValue(n8);
                this.m_siteController.realTimeUpdate(string);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving Data", (Throwable)notFoundException);
            }
        }
        if (n7 != -1 && n6 != -1 && n5 != -1) {
            try {
                String string = (String)realTimeDataObject.getValue(n6);
                String string2 = (String)realTimeDataObject.getValue(n7);
                String string3 = (String)realTimeDataObject.getValue(n5);
                this.m_site.realTimeUpdate(string, string2, string3);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving Data", (Throwable)notFoundException);
            }
        } else if (n != -1 && n2 != -1 && n5 != -1) {
            String string = "";
            String string4 = "";
            String string5 = "";
            try {
                string = (String)realTimeDataObject.getValue(n);
                string4 = (String)realTimeDataObject.getValue(n2);
                string5 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving Data", (Throwable)notFoundException);
            }
            if (stringArray[n].indexOf(this.ISC_SiteState) != -1) {
                this.m_site.realTimeUpdate(string5, stringArray[n], string, stringArray[n2], string4);
            } else if (stringArray[n].indexOf(this.ISC_SCState) != -1) {
                this.m_siteController.realTimeUpdate(string5, string, string4);
            } else if (stringArray[n].indexOf(this.ISC_ChlState) != -1) {
                this.m_channel.realTimeUpdate(string5, stringArray[n], string, stringArray[n2], string4);
            } else {
                LOG.info((Object)"Couldn't Interpret the RealTimeData Packet correctly");
            }
        } else if (n9 != -1 && n10 != -1 && n5 != -1) {
            String string = "";
            String string6 = "";
            String string7 = "";
            try {
                string = (String)realTimeDataObject.getValue(n9);
                string6 = (String)realTimeDataObject.getValue(n10);
                string7 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving Channel fault Data", (Throwable)notFoundException);
            }
            this.m_channel.realTimeUpdate(string7, stringArray[n9], string, stringArray[n10], string6);
        } else if (n3 != -1 && n4 != -1 && n5 != -1) {
            String string = "";
            String string8 = "";
            String string9 = "";
            try {
                string = (String)realTimeDataObject.getValue(n3);
                string8 = (String)realTimeDataObject.getValue(n4);
                string9 = (String)realTimeDataObject.getValue(n5);
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Got NotFoundException while retrieving fan fault Data", (Throwable)notFoundException);
            }
            this.m_siteController.realTimeFanUpdate(string9, string, string8);
        } else {
            LOG.info((Object)"Couldn't Interpret the RealTimeData Packet correctly");
        }
        LOG.exit("realTimeUpdate");
    }

    public void startWriteToFile() {
        LOG.enter("startWriteToFile");
        this.m_site.writeToFile();
        this.m_siteController.writeToFile();
        this.m_channel.writeToFile();
        this.m_history.writeToFile();
        LOG.exit("startWriteToFile");
    }

    public boolean isLogClosed() {
        LOG.enter("isLogClosed");
        boolean bl = this.m_oLoggerClosingHandler.isLogClosed(this.m_history);
        LOG.exit("isLogClosed", (Object)Boolean.toString(bl));
        return bl;
    }

    public void closeScreen() {
        LOG.enter("closeScreen");
        if (this.m_window != null) {
            this.m_window.unlockWindow();
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        LOG.exit("closeScreen");
    }

    public void updateSCStatus(int n, Integer n2) {
        LOG.enter("updateSCStatus", new Object[]{Integer.toString(n), n2});
        this.m_siteController.updateSCStatus(n, n2);
        this.m_history.updateSCStatus(n, n2);
        LOG.exit("updateSCStatus");
    }

    @Override
    public void startScreen() {
        LOG.enter("startScreen");
        this.initialize();
        IscStatusPanelMaker.getGuiListener().startProcess();
        LOG.exit("startScreen");
    }

    private void popupError(int n) {
        if (this.m_window.isVisible()) {
            this.m_errPopup.display(n);
        }
    }

    @Override
    public void closeScreen(boolean bl) {
        LOG.enter("closeScreen", new Object[]{Boolean.toString(bl)});
        if (bl) {
            try {
                this.m_window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                LOG.warn((Object)"setClosed(true)", (Throwable)propertyVetoException);
            }
        } else {
            this.m_window.setVisible(false);
        }
        LOG.exit("closeScreen");
    }
}

