/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.connection.ConnectionInfo;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DatagramQueue;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.PortInfo;
import css.device.common.protocol.cmdmgr.RetryableDatagram;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;

class InPort
implements Runnable,
CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(InPort.class);
    private DatagramSocket m_ackDatagramSocket;
    private DatagramSocket m_datagramSocket;
    private boolean m_keepAlives;
    private boolean m_remainActive;
    private CmdManager m_manager;
    private DatagramQueue m_datagramQueue;
    private int m_sourcePort;
    private int m_destPort;
    private OutPort ackPort = null;
    private InetAddress m_deviceAddress;
    private int FSP_PORT_MIN = 49370;
    private int FSP_PORT_MAX = 49389;

    InPort(int n, boolean bl, CmdManager cmdManager) {
        LOG.enter("InPort", new Object[]{n, bl, cmdManager});
        try {
            block14: {
                this.m_deviceAddress = InetAddress.getByName(ConnectionInfo.getDeviceIpAddress());
                this.m_keepAlives = bl;
                this.m_remainActive = true;
                try {
                    this.m_datagramSocket = new DatagramSocket(n);
                }
                catch (Exception exception) {
                    LOG.warn((Object)"InPort - Port could be in Use. General Exception.", (Throwable)exception);
                    if (this.m_datagramSocket != null) {
                        this.m_datagramSocket.close();
                    }
                    this.m_datagramSocket = this.createDatagramSocket();
                    if (null != this.m_datagramSocket) break block14;
                    LOG.error((Object)"InPort - No available UDP ports for FSP communication.");
                }
            }
            if (this.m_keepAlives && null != this.m_datagramSocket) {
                this.m_datagramSocket.setSoTimeout(15000);
            }
            this.m_datagramQueue = new DatagramQueue(cmdManager);
            Thread thread = new Thread(this.m_datagramQueue);
            thread.start();
            this.m_manager = cmdManager;
            if (null != this.m_datagramSocket) {
                this.m_sourcePort = this.m_datagramSocket.getLocalPort();
            }
            this.m_destPort = n;
            this.m_ackDatagramSocket = this.createDatagramSocket();
            if (null == this.m_ackDatagramSocket) {
                LOG.error((Object)"InPort - No available UDP ports for ACKs in FSP communication.");
            } else {
                this.ackPort = new OutPort(this.m_destPort, false, cmdManager, this.m_ackDatagramSocket);
                Thread thread2 = new Thread(this.ackPort);
                thread2.start();
            }
        }
        catch (SocketException socketException) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            LOG.error((Object)"InPort - Socket Creation Error.", (Throwable)socketException);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            LOG.error((Object)"InPort - Thread Already Exists", (Throwable)illegalThreadStateException);
        }
        catch (Exception exception) {
            if (this.m_datagramSocket != null) {
                this.m_datagramSocket.close();
            }
            LOG.error((Object)"InPort - General Exception.", (Throwable)exception);
        }
        LOG.exit("InPort");
    }

    @Override
    public void run() {
        byte[] byArray = new byte[2048];
        LOG.enter("run");
        DevicePorts devicePorts = this.m_manager.getDevicePorts();
        try {
            while (this.m_remainActive) {
                block17: {
                    Arrays.fill(byArray, (byte)0);
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    try {
                        this.m_datagramSocket.receive(datagramPacket);
                        InetAddress inetAddress = datagramPacket.getAddress();
                        if (null != inetAddress) {
                            if (inetAddress.equals(this.m_deviceAddress)) {
                                RetryableDatagram retryableDatagram = new RetryableDatagram();
                                retryableDatagram.unpack(datagramPacket.getData());
                                if (retryableDatagram.getOpcode() != 0 || retryableDatagram.getSubOpcode() != 0) {
                                    if ((retryableDatagram.getProtocolFlags() & 2) != 0) {
                                        Datagram datagram = new Datagram(retryableDatagram.getSessionType(), retryableDatagram.getSessionID(), 1, retryableDatagram.getProtocolSequenceNumber());
                                        datagram.setProtocolFlags((short)0);
                                        datagram.setProtocolSequenceNumber((byte)0);
                                        datagram.setSessionFlags((short)0);
                                        LOG.trace((Object)("run - Sending ACK:" + datagram.datagramString()));
                                        this.ackPort.sendDatagram(datagram);
                                    }
                                    this.m_datagramQueue.addDatagram(retryableDatagram);
                                }
                            } else {
                                LOG.warn((Object)"Device address mismatch, received datagram from unknown source.");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.m_keepAlives) {
                            try {
                                if (!this.m_datagramSocket.isClosed()) {
                                    this.m_datagramSocket.setSoTimeout(0);
                                }
                            }
                            catch (SocketException socketException) {
                                LOG.warn((Object)("Inport Run: Exception occured " + socketException));
                            }
                        }
                        if (this.m_destPort != 1054) {
                            LOG.warn((Object)"run - No More Keep Alives.");
                            this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-16);
                            this.m_remainActive = false;
                        }
                        devicePorts = this.m_manager.getDevicePorts();
                        PortInfo portInfo = devicePorts.getPort(this.m_destPort);
                        if (portInfo == null || portInfo.getCount() <= 1) break block17;
                        this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-16);
                    }
                }
                if (!this.m_keepAlives) continue;
                try {
                    this.m_datagramSocket.setSoTimeout(15000);
                }
                catch (SocketException socketException) {
                    LOG.error((Object)"run - cannot set timeout", (Throwable)socketException);
                }
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"run - General Exception", (Throwable)exception);
            this.m_manager.closeSessionsOnPort(this.m_destPort, (byte)-1, (byte)-17);
            this.m_remainActive = false;
        }
        LOG.exit("run");
    }

    public void terminate() {
        LOG.enter("terminate");
        this.ackPort.terminate();
        this.m_remainActive = false;
        this.m_datagramQueue.terminateQueueThread();
        this.m_ackDatagramSocket.close();
        this.m_datagramSocket.close();
        LOG.exit("terminate");
    }

    public void setKeepAlives(boolean bl) {
        LOG.enter("setKeepAlives", new Object[]{bl});
        this.m_keepAlives = bl;
        LOG.exit("setKeepAlives");
    }

    public DatagramSocket getDatagramSocket() {
        return this.m_datagramSocket;
    }

    public DatagramQueue getDatagramQueue() {
        return this.m_datagramQueue;
    }

    public int getSourcePort() {
        return this.m_sourcePort;
    }

    private DatagramSocket createDatagramSocket() {
        DatagramSocket datagramSocket = null;
        for (int i = this.FSP_PORT_MIN; i <= this.FSP_PORT_MAX; ++i) {
            try {
                datagramSocket = new DatagramSocket(i);
                if (null == datagramSocket) continue;
                break;
            }
            catch (SocketException socketException) {
                LOG.trace((Object)("Cannot bind to port: " + i + " try to bind to next."));
            }
        }
        return datagramSocket;
    }
}

