/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import css.core.util.CssLogger;
import css.device.common.service.ScreenManager;
import css.device.common.util.ClosingHandler;
import css.device.common.util.LogFileClosable;

public class LoggerClosingHandler
extends ClosingHandler {
    private static final CssLogger LOG = CssLogger.getCssLogger(LoggerClosingHandler.class);

    public LoggerClosingHandler() {
        this.m_sDisplayedMessage = "log_close_confirmation";
        LOG.enter("LoggerClosingHandler");
        LOG.exit("LoggerClosingHandler");
    }

    public LoggerClosingHandler(String string) {
        this.m_sDisplayedMessage = "log_close_confirmation";
        LOG.enter("LoggerClosingHandler", new Object[]{string});
        if (null != string) {
            this.m_sDisplayedMessage = string;
        } else {
            LOG.warn((Object)"p_sPopupMessage is null. Popup Message left to default!");
        }
        LOG.exit("LoggerClosingHandler");
    }

    public boolean canCloseLog() {
        LOG.enter("canCloseLog");
        boolean bl = this.canClose();
        LOG.exit("canCloseLog", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isLogClosed(LogFileClosable logFileClosable) {
        LOG.enter("isLogClosed");
        boolean bl = false;
        if (null != logFileClosable && logFileClosable.isFileOpen()) {
            if (this.canCloseLog()) {
                logFileClosable.closeFile();
                this.reset();
                ScreenManager.removePrecloseOperation(this);
                bl = true;
            } else {
                LOG.info((Object)"Screen not closed! - user decission");
            }
        } else {
            this.reset();
            ScreenManager.removePrecloseOperation(this);
            bl = true;
        }
        LOG.exit("isLogClosed", (Object)Boolean.toString(bl));
        return bl;
    }
}

