/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.refoscillator;

import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.InfoPopup;
import css.device.common.service.Serviceable;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ScRefOscScreen
extends JPanel
implements CssConstants,
CssErrorCodes,
DeviceErrorCodes,
Serviceable {
    private static final long serialVersionUID = 1L;
    static final int REF_OSC_VALUE_MIN = Short.MIN_VALUE;
    static final int REF_OSC_VALUE_MAX = Short.MAX_VALUE;
    static final double REF_OSC_FREQ_MIN = 4.99999;
    static final double REF_OSC_FREQ_MAX = 5.00001;
    static final int ALIGN_STATE = 1;
    static final int PAUSE_STATE = 2;
    static final double REF_OSC_FREQ_VALUE = 5.0;
    static final double MIN_MHZ_PER_STEP = 6.0E-11;
    static final double TYPICAL_MHZ_PER_STEP = 1.4E-10;
    static final double MAX_MHZ_PER_STEP = 3.1E-10;
    private JDialog m_window = null;
    private final String AUTOCALC_BUTTON_TEXT = "Auto Calculate";
    private final String SAVE_BUTTON_TEXT = "Save";
    private final String CANCEL_BUTTON_TEXT = "Cancel";
    private final String REF_OSC_FREQ_TFLD_STATUS_MSG = "Site Controller Reference Oscillator Frequency reading Range: 4.999990000 to 5.000010000";
    private final String AUTOCALC_BUTTON_STATUS_MSG = "Click to Auto Calculate the Reference Oscillator value.";
    private final String DOWN_BUTTON_STATUS_MSG = "Select the amount to Reference Oscillator value decrement.";
    private final String UP_BUTTON_STATUS_MSG = "Select the amount to Reference Oscillator value increment.";
    private final String SAVE_BUTTON_STATUS_MSG = "Click the save button to save the set reference oscillator value.";
    private final String RANGE_BAR_TOOLTIP = "";
    private final String REF_OSC_COMBOBOX_TOOLTIP = "Select a +/- selection value to decrement or increment the Ref Oscillator value.";
    private final String REF_OSC_FREQ_TFLD_TOOLTIP = "Frequency Measuring Range: 4.999990000 to 5.000010000";
    private final String AUTOCALC_BUTTON_TOOLTIP = "This button will Auto Calculate the reference oscillator value.";
    private final String DOWN_BUTTON_TOOLTIP = "Decrement Reference Oscillator value by the - selection.";
    private final String UP_BUTTON_TOOLTIP = "Increment Reference Oscillator value by the + selection.";
    private final String SAVE_BUTTON_TOOLTIP = "This button will save the current reference oscillator value to the device.";
    private final String CANCEL_BUTTON_TOOLTIP = "This button will cancel set reference oscillator value and exit the screen.";
    private static final CssLogger LOG = CssLogger.getCssLogger(ScRefOscScreen.class);
    private JPanel m_oscillatorPanel;
    private JPanel m_panel1;
    private JPanel m_panel2;
    private JPanel m_panel3;
    private JPanel m_panel4;
    private JPanel m_panel5;
    private JTextArea m_infoTArea;
    private JProgressBar m_progressBar;
    private JLabel m_refOscValueLbl;
    private JComboBox m_refOscComboBox;
    String[] c_refOscComboList = new String[]{"1", "10", "100", "1000", "10000"};
    public JButton m_downBtn;
    public JButton m_upBtn;
    private JLabel m_refOscFreqLbl;
    private JTextField m_refOscFreqTFld;
    private JLabel m_mhzLbl;
    public JButton m_autoCalcBtn;
    public JButton m_saveBtn;
    public JButton m_cancelBtn;
    private ErrorPopup m_errorPopup = new ErrorPopup();
    private InfoPopup m_infoPopup = new InfoPopup();
    private ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    int m_state = 1;
    int m_refOscValue = 0;
    int m_refOscValueDelta = 0;
    double m_refOscFreq = 0.0;
    double m_refOscFreqPrevious = 0.0;
    boolean m_valueChanged = false;

    public ScRefOscScreen() {
        LOG.enter("ScRefOscScreen");
        LOG.exit("ScRefOscScreen");
    }

    public void buildScreen(JDialog jDialog, StatusBarListener statusBarListener) {
        this.m_window = jDialog;
        CloseScreenWindowHandler closeScreenWindowHandler = new CloseScreenWindowHandler();
        this.m_window.addWindowListener(closeScreenWindowHandler);
        this.m_oscillatorPanel = new JPanel();
        this.m_panel1 = new JPanel();
        this.m_infoTArea = new JTextArea();
        this.m_panel2 = new JPanel();
        this.m_progressBar = new JProgressBar();
        this.m_panel3 = new JPanel();
        this.m_refOscValueLbl = new JLabel();
        this.m_refOscComboBox = new JComboBox<String>(this.c_refOscComboList);
        this.m_downBtn = new JButton();
        this.m_upBtn = new JButton();
        this.m_panel4 = new JPanel();
        this.m_refOscFreqLbl = new JLabel();
        this.m_refOscFreqTFld = new JTextField();
        this.m_mhzLbl = new JLabel();
        this.m_autoCalcBtn = new JButton();
        this.m_panel5 = new JPanel();
        this.m_saveBtn = new JButton();
        this.m_cancelBtn = new JButton();
        this.m_refOscComboBox.setNextFocusableComponent(this.m_downBtn);
        this.m_downBtn.setNextFocusableComponent(this.m_upBtn);
        this.m_upBtn.setNextFocusableComponent(this.m_refOscFreqTFld);
        this.m_refOscFreqTFld.setNextFocusableComponent(this.m_autoCalcBtn);
        this.m_autoCalcBtn.setNextFocusableComponent(this.m_saveBtn);
        this.m_saveBtn.setNextFocusableComponent(this.m_cancelBtn);
        this.m_cancelBtn.setNextFocusableComponent(this.m_refOscComboBox);
        LOG.enter("buildScreen", new Object[]{jDialog, statusBarListener});
        this.m_oscillatorPanel.setLayout(new GridBagLayout());
        this.m_oscillatorPanel.setPreferredSize(new Dimension(570, 510));
        this.m_oscillatorPanel.setBorder(new EtchedBorder());
        this.m_panel1.setLayout(new GridBagLayout());
        this.m_infoTArea.append("1. The Site Controller needs to be powered on for 7 days\n");
        this.m_infoTArea.append("   to allow the oscillator to stabilize before the oscillator\n");
        this.m_infoTArea.append("   is adjusted.\n");
        this.m_infoTArea.append("2. Using a service monitor with a measurement accuracy of .001 PPM,\n");
        this.m_infoTArea.append("   as provided by a rubidium reference, monitor the selected station\u2019s\n");
        this.m_infoTArea.append("   transmit output frequency.\n");
        this.m_infoTArea.append("3. Once the target frequency has been reached, save the Reference\n");
        this.m_infoTArea.append("   Oscillator setting to the device by clicking the Save button.\n");
        this.m_infoTArea.append("4. If a standby controller is present, it also must be aligned.\n");
        this.m_infoTArea.setEditable(false);
        this.m_infoTArea.setBackground(this.m_oscillatorPanel.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_panel1.add((Component)this.m_infoTArea, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.m_oscillatorPanel.add((Component)this.m_panel1, gridBagConstraints2);
        this.m_panel2.setLayout(new GridBagLayout());
        this.m_progressBar.setPreferredSize(new Dimension(410, 25));
        this.m_progressBar.setMinimumSize(new Dimension(410, 25));
        this.m_progressBar.setMinimum(Short.MIN_VALUE);
        this.m_progressBar.setMaximum(Short.MAX_VALUE);
        this.m_progressBar.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_panel2.add((Component)this.m_progressBar, gridBagConstraints);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.anchor = 11;
        this.m_oscillatorPanel.add((Component)this.m_panel2, gridBagConstraints2);
        this.m_panel3.setLayout(new GridBagLayout());
        this.m_panel3.setBorder(BorderFactory.createTitledBorder("Manual Adjust"));
        this.m_refOscValueLbl.setText("+/- Ref Oscillator Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        gridBagConstraints.anchor = 17;
        this.m_panel3.add((Component)this.m_refOscValueLbl, gridBagConstraints);
        this.m_downBtn.setPreferredSize(new Dimension(42, 30));
        this.m_downBtn.setMaximumSize(new Dimension(42, 30));
        this.m_downBtn.setMinimumSize(new Dimension(42, 30));
        this.m_downBtn.setText("<");
        this.m_downBtn.setToolTipText("Decrement Reference Oscillator value by the - selection.");
        statusBarListener.registerComponent((Component)this.m_downBtn, "Select the amount to Reference Oscillator value decrement.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 17, 15, 5);
        gridBagConstraints.anchor = 17;
        this.m_panel3.add((Component)this.m_downBtn, gridBagConstraints);
        this.m_refOscComboBox.setPreferredSize(new Dimension(75, 21));
        this.m_refOscComboBox.setMaximumSize(new Dimension(75, 21));
        this.m_refOscComboBox.setMinimumSize(new Dimension(75, 21));
        this.m_refOscComboBox.setToolTipText("Select a +/- selection value to decrement or increment the Ref Oscillator value.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        gridBagConstraints.anchor = 17;
        this.m_panel3.add((Component)this.m_refOscComboBox, gridBagConstraints);
        this.m_upBtn.setPreferredSize(new Dimension(42, 30));
        this.m_upBtn.setMaximumSize(new Dimension(42, 30));
        this.m_upBtn.setMinimumSize(new Dimension(42, 30));
        this.m_upBtn.setText(">");
        this.m_upBtn.setToolTipText("Increment Reference Oscillator value by the + selection.");
        statusBarListener.registerComponent((Component)this.m_upBtn, "Select the amount to Reference Oscillator value increment.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 5, 15, 80);
        gridBagConstraints.anchor = 17;
        this.m_panel3.add((Component)this.m_upBtn, gridBagConstraints);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.anchor = 11;
        this.m_oscillatorPanel.add((Component)this.m_panel3, gridBagConstraints2);
        this.m_panel4.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder("Auto Calculate");
        this.m_panel4.setBorder(titledBorder);
        this.m_refOscFreqLbl.setText("Ref Oscillator Frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        gridBagConstraints.anchor = 17;
        this.m_panel4.add((Component)this.m_refOscFreqLbl, gridBagConstraints);
        this.m_refOscFreqTFld.setText(" ");
        this.m_refOscFreqTFld.setPreferredSize(new Dimension(95, 21));
        this.m_refOscFreqTFld.setMaximumSize(new Dimension(95, 21));
        this.m_refOscFreqTFld.setMinimumSize(new Dimension(95, 21));
        this.m_refOscFreqTFld.setToolTipText("Frequency Measuring Range: 4.999990000 to 5.000010000");
        statusBarListener.registerComponent((Component)this.m_refOscFreqTFld, "Site Controller Reference Oscillator Frequency reading Range: 4.999990000 to 5.000010000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 15, 0);
        gridBagConstraints.anchor = 17;
        this.m_panel4.add((Component)this.m_refOscFreqTFld, gridBagConstraints);
        this.m_mhzLbl.setText("MHz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 5, 15, 10);
        gridBagConstraints.anchor = 17;
        this.m_panel4.add((Component)this.m_mhzLbl, gridBagConstraints);
        this.m_autoCalcBtn.setPreferredSize(new Dimension(115, 30));
        this.m_autoCalcBtn.setMaximumSize(new Dimension(115, 30));
        this.m_autoCalcBtn.setMinimumSize(new Dimension(115, 30));
        this.m_autoCalcBtn.setText("Auto Calculate");
        this.m_autoCalcBtn.setToolTipText("This button will Auto Calculate the reference oscillator value.");
        statusBarListener.registerComponent((Component)this.m_autoCalcBtn, "Click to Auto Calculate the Reference Oscillator value.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        gridBagConstraints.anchor = 13;
        this.m_panel4.add((Component)this.m_autoCalcBtn, gridBagConstraints);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.anchor = 15;
        this.m_oscillatorPanel.add((Component)this.m_panel4, gridBagConstraints2);
        String string = MetadataAcquisitionService.getHardwareType();
        if (string != null && string.startsWith("GCP 8000")) {
            this.m_panel4.setEnabled(false);
            this.m_panel4.setOpaque(false);
            titledBorder.setTitleColor(Color.gray);
            this.m_refOscFreqLbl.setEnabled(false);
            this.m_refOscFreqTFld.setEnabled(false);
            this.m_refOscFreqTFld.setOpaque(false);
            this.m_mhzLbl.setEnabled(false);
            this.m_autoCalcBtn.setEnabled(false);
        }
        this.m_panel5.setLayout(new GridBagLayout());
        this.m_saveBtn.setPreferredSize(new Dimension(75, 30));
        this.m_saveBtn.setMaximumSize(new Dimension(75, 30));
        this.m_saveBtn.setMinimumSize(new Dimension(75, 30));
        this.m_saveBtn.setText("Save");
        this.m_saveBtn.setToolTipText("This button will save the current reference oscillator value to the device.");
        statusBarListener.registerComponent((Component)this.m_saveBtn, "Click the save button to save the set reference oscillator value.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 75, 5, 35);
        gridBagConstraints.anchor = 17;
        this.m_panel5.add((Component)this.m_saveBtn, gridBagConstraints);
        this.m_cancelBtn.setPreferredSize(new Dimension(75, 30));
        this.m_cancelBtn.setBorder(new BevelBorder(0));
        this.m_cancelBtn.setMaximumSize(new Dimension(75, 30));
        this.m_cancelBtn.setText("Cancel");
        this.m_cancelBtn.setToolTipText("This button will cancel set reference oscillator value and exit the screen.");
        this.m_cancelBtn.setMinimumSize(new Dimension(75, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 35, 5, 75);
        gridBagConstraints.anchor = 13;
        this.m_panel5.add((Component)this.m_cancelBtn, gridBagConstraints);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.anchor = 15;
        this.m_oscillatorPanel.add((Component)this.m_panel5, gridBagConstraints2);
        this.add((Component)this.m_oscillatorPanel, "North");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setString("Updating Reference Oscillator Value, please wait");
        this.m_progressBar.setValue(0);
        this.m_refOscFreqTFld.setText("");
        this.m_window.setCursor(new Cursor(3));
        LOG.exit("initialize");
    }

    public void handleStartSession(int n) {
        LOG.enter("handleStartSession", new Object[]{Integer.toString(n)});
        if (n != 0) {
            this.m_errorPopup.display(-70);
            this.m_window.hide();
        }
        LOG.exit("handleStartSession");
    }

    public void closeScreen() {
        LOG.enter("closeScreen");
        this.m_window.setVisible(false);
        this.m_window.setCursor(new Cursor(0));
        LOG.exit("closeScreen");
    }

    public void handleRefOscValue(int n, String string) {
        block7: {
            LOG.enter("handleRefOscValue", new Object[]{Integer.toString(n), string});
            if (n == 0 && string != null) {
                this.m_progressBar.setStringPainted(true);
                try {
                    this.m_refOscValue = Integer.parseInt(string);
                    if (this.m_refOscValue >= Short.MIN_VALUE && this.m_refOscValue <= Short.MAX_VALUE) {
                        this.updateRefOscValueBar();
                        break block7;
                    }
                    this.m_progressBar.setString("Out of range");
                    this.m_errorPopup.display(-458854);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_progressBar.setString("Update fail");
                    this.m_errorPopup.display(-458861);
                    LOG.error((Object)"handleRefOscValue - run() catch exception", (Throwable)numberFormatException);
                }
            } else if (n == -131087) {
                this.m_progressBar.setString("Timeout Occurred, please check connection");
                this.m_errorPopup.display(n);
            } else {
                this.m_progressBar.setString("Update fail");
                LOG.error((Object)"handleRefOscValue - unable to handle Ref Osc Value");
                this.m_errorPopup.display(-458856);
            }
        }
        this.m_window.setCursor(new Cursor(0));
        LOG.exit("handleRefOscValue");
    }

    public boolean validateRefOscFreq() {
        boolean bl = true;
        LOG.enter("validateRefOscFreq");
        try {
            this.m_refOscFreq = Double.parseDouble(this.m_refOscFreqTFld.getText());
            if (this.m_refOscFreq >= 4.99999 && this.m_refOscFreq <= 5.00001) {
                if (this.checkPauseState()) {
                    this.m_state = 2;
                    bl = this.calculateRefOsc(this.m_refOscFreq);
                } else {
                    bl = false;
                }
            } else {
                this.m_errorPopup.display(-458855);
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"validateRefOscFreq", (Throwable)numberFormatException);
            this.m_errorPopup.display(-458859);
            bl = false;
        }
        LOG.exit("validateRefOscFreq", (Object)Boolean.toString(bl));
        return bl;
    }

    private boolean calculateRefOsc(double d) {
        LOG.enter("calculateRefOsc", new Object[]{Double.toString(d)});
        boolean bl = true;
        try {
            int n;
            if (this.m_refOscFreqPrevious != 0.0 && this.m_refOscValueDelta != 0) {
                double d2;
                double d3 = (this.m_refOscFreqPrevious - d) / (double)this.m_refOscValueDelta;
                if (d3 >= 6.0E-11 && d3 <= 3.1E-10) {
                    if (d > 5.0) {
                        d2 = (d - 5.0) / d3;
                        n = this.m_refOscValue - (int)Math.round(d2);
                    } else {
                        d2 = (5.0 - d) / d3;
                        n = this.m_refOscValue + (int)Math.round(d2);
                    }
                } else if (d > 5.0) {
                    d2 = (d - 5.0) / 1.4E-10;
                    n = this.m_refOscValue - (int)Math.round(d2);
                } else {
                    d2 = (5.0 - d) / 1.4E-10;
                    n = this.m_refOscValue + (int)Math.round(d2);
                }
                this.m_refOscValueDelta = (int)Math.round(d2);
            } else {
                double d4;
                if (d > 5.0) {
                    d4 = (d - 5.0) / 1.4E-10;
                    n = this.m_refOscValue - (int)Math.round(d4);
                } else {
                    d4 = (5.0 - d) / 1.4E-10;
                    n = this.m_refOscValue + (int)Math.round(d4);
                }
                this.m_refOscValueDelta = (int)Math.round(d4);
            }
            if (n <= Short.MAX_VALUE && n >= Short.MIN_VALUE) {
                this.m_refOscValue = n;
            } else {
                this.m_errorPopup.display(-458862);
                bl = false;
                this.m_state = 1;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"calculateRefOsc - Exception caught calculateRefOsc()", (Throwable)exception);
            this.m_errorPopup.display(-458859);
            bl = false;
            this.m_state = 1;
        }
        this.m_refOscFreqPrevious = d;
        LOG.exit("calculateRefOsc", (Object)Boolean.toString(bl));
        return bl;
    }

    public Object[] setRefOscValue() {
        LOG.enter("setRefOscValue");
        this.m_valueChanged = true;
        Object[] objectArray = new Integer[]{new Integer(this.m_refOscValue)};
        LOG.exit("setRefOscValue", objectArray);
        return objectArray;
    }

    public boolean validateRefOscValueInc() {
        Object e = this.m_refOscComboBox.getItemAt(this.m_refOscComboBox.getSelectedIndex());
        String string = e.toString();
        boolean bl = true;
        LOG.enter("validateRefOscValueInc");
        int n = Integer.parseInt(string);
        int n2 = n + this.m_refOscValue;
        if (n2 < Short.MAX_VALUE) {
            if (this.checkPauseState()) {
                this.m_state = 2;
                this.m_refOscValue = n2;
                this.m_refOscValueDelta += n;
            } else {
                bl = false;
                this.m_state = 1;
            }
        } else if (this.m_refOscValue < Short.MAX_VALUE) {
            if (this.checkPauseState()) {
                this.m_state = 2;
                this.m_refOscValueDelta += Short.MAX_VALUE - this.m_refOscValue;
                this.m_refOscValue = Short.MAX_VALUE;
            } else {
                bl = false;
                this.m_state = 1;
            }
        } else {
            this.m_infoPopup.display(-458852);
            bl = false;
            this.m_state = 1;
        }
        LOG.exit("validateRefOscValueInc", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean validateRefOscValueDec() {
        Object e = this.m_refOscComboBox.getItemAt(this.m_refOscComboBox.getSelectedIndex());
        String string = e.toString();
        boolean bl = true;
        LOG.enter("validateRefOscValueDec");
        int n = Integer.parseInt(string);
        int n2 = this.m_refOscValue - n;
        if (n2 > Short.MIN_VALUE) {
            if (this.checkPauseState()) {
                this.m_state = 2;
                this.m_refOscValue = n2;
                this.m_refOscValueDelta -= n;
            } else {
                bl = false;
                this.m_state = 1;
            }
        } else if (n2 <= Short.MIN_VALUE && this.m_refOscValue > Short.MIN_VALUE) {
            if (this.checkPauseState()) {
                this.m_state = 2;
                this.m_refOscValueDelta -= Short.MIN_VALUE - this.m_refOscValue;
                this.m_refOscValue = Short.MIN_VALUE;
            } else {
                bl = false;
                this.m_state = 1;
            }
        } else {
            this.m_infoPopup.display(-458853);
            bl = false;
            this.m_state = 1;
        }
        LOG.exit("validateRefOscValueDec", (Object)Boolean.toString(bl));
        return bl;
    }

    public void updateRefOscValue(int n) {
        this.m_state = 1;
        LOG.enter("updateRefOscValue", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.updateRefOscValueBar();
        } else if (n == -131087) {
            this.m_progressBar.setStringPainted(true);
            this.m_progressBar.setString("Timeout Occurred, please check connection");
            this.m_errorPopup.display(n);
        } else {
            this.m_errorPopup.display(-458856);
        }
        LOG.exit("updateRefOscValue");
    }

    public void updateRefOscValueBar() {
        LOG.enter("updateRefOscValueBar");
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setString(String.valueOf(this.m_refOscValue));
        this.m_progressBar.setValue(this.m_refOscValue);
        LOG.exit("updateRefOscValueBar");
    }

    public void handleSaveBtn(int n) {
        LOG.enter("handleSaveBtn", new Object[]{Integer.toString(n)});
        if (n == -131087) {
            this.m_progressBar.setStringPainted(true);
            this.m_progressBar.setString("Timeout Occurred, please check connection");
            this.m_errorPopup.display(n);
        } else if (n != 0) {
            this.m_errorPopup.display(-458857);
        } else {
            this.m_valueChanged = false;
        }
        LOG.exit("handleSaveBtn");
    }

    public void handleAbortBtn(int n) {
        LOG.enter("handleAbortBtn", new Object[]{Integer.toString(n)});
        if (n == -131087) {
            this.m_errorPopup.display(n);
            this.m_window.setVisible(false);
        } else if (n != 0) {
            this.m_errorPopup.display(-458858);
        } else {
            this.m_valueChanged = false;
            this.m_window.setVisible(false);
        }
        LOG.exit("handleAbortBtn");
    }

    public boolean checkPauseState() {
        boolean bl = true;
        LOG.enter("checkPauseState");
        bl = this.m_state != 2;
        LOG.exit("checkPauseState", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean saveValueCheck() {
        boolean bl = true;
        boolean bl2 = false;
        LOG.enter("saveValueCheck");
        if (this.m_valueChanged) {
            this.m_confirmPopup.display(-458860);
            bl2 = this.m_confirmPopup.getStatus();
            if (bl2) {
                this.m_saveBtn.doClick();
                this.m_window.setVisible(false);
                bl = false;
            }
        }
        LOG.exit("saveValueCheck", (Object)Boolean.toString(bl));
        return bl;
    }

    @Override
    public void closeScreen(boolean bl) {
        LOG.enter("closeScreen", new Object[]{Boolean.toString(bl)});
        this.m_window.setVisible(false);
        LOG.exit("closeScreen");
    }

    @Override
    public void startScreen() {
        LOG.enter("startScreen");
        this.initialize();
        LOG.exit("startScreen");
    }

    class CloseScreenWindowHandler
    extends WindowAdapter {
        CloseScreenWindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (ScRefOscScreen.this.m_valueChanged) {
                int n = 100;
                ScRefOscScreen.this.m_cancelBtn.doClick();
                while (ScRefOscScreen.this.m_valueChanged && n > 0) {
                    --n;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"windowClosing", (Throwable)exception);
                    }
                }
            }
            ((JDialog)windowEvent.getSource()).hide();
        }
    }
}

