/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.isc;

import css.core.appservices.cs.ConnectionService;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.device.common.screens.CommonNewVlanScreenMaker;
import css.device.common.screens.CommonStatusReportPanelMaker;
import css.device.common.screens.CommonVersionMaker;
import css.device.sc_platform.common.screens.refoscillator.ScRefOscScreenMaker;
import css.device.sc_platform.isc.screens.IscStatusPanelMaker;
import pnm.util.OperationHandlerIfc;

public class IscServiceOperationalHandler
implements OperationHandlerIfc,
CssConstants {
    public static final CssLogger LOG = CssLogger.getCssLogger(IscServiceOperationalHandler.class);
    private IscStatusPanelMaker iscStatusPanelMaker;
    private CommonVersionMaker iscVersionMaker;
    private CommonStatusReportPanelMaker iscStatusReportPanelMaker;
    private CommonNewVlanScreenMaker iscVlanScreenMaker;
    private ScRefOscScreenMaker refOscScreenMaker;

    public IscServiceOperationalHandler() {
        LOG.enter("IscServiceOperationalHandler");
        LOG.exit("IscServiceOperationalHandler");
    }

    public void operationSelected(String string, Object object) {
        LOG.enter("operationSelected", new Object[]{string, object});
        if (string.equalsIgnoreCase("Status Panel Screens")) {
            if (this.iscStatusPanelMaker == null) {
                this.iscStatusPanelMaker = new IscStatusPanelMaker();
                this.iscStatusPanelMaker.buildService();
            } else {
                this.iscStatusPanelMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Status Report Screen")) {
            if (this.iscStatusReportPanelMaker == null) {
                this.iscStatusReportPanelMaker = new CommonStatusReportPanelMaker();
                this.iscStatusReportPanelMaker.buildService();
            } else {
                this.iscStatusReportPanelMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Versions Screen")) {
            if (this.iscVersionMaker == null) {
                this.iscVersionMaker = new CommonVersionMaker();
                this.iscVersionMaker.buildService();
            } else {
                this.iscVersionMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Vlan Screen")) {
            if (this.iscVlanScreenMaker == null) {
                this.iscVlanScreenMaker = new CommonNewVlanScreenMaker();
                this.iscVlanScreenMaker.buildService();
            } else {
                this.iscVlanScreenMaker.initialize();
            }
        } else if (string.equalsIgnoreCase("Ref Osc Screen")) {
            boolean bl = ConnectionService.requestConnectionType((String)"serial");
            if (bl) {
                if (this.refOscScreenMaker == null) {
                    this.refOscScreenMaker = new ScRefOscScreenMaker();
                    this.refOscScreenMaker.buildService();
                } else {
                    this.refOscScreenMaker.initialize();
                }
            }
        } else {
            LOG.warn((Object)("No such operation name exist: " + string));
        }
        LOG.exit("operationSelected");
    }
}

