/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import css.core.util.CssLogger;
import css.core.util.popup.ConfirmationPopup;
import css.device.common.service.ServicePrecloseable;

public class ClosingHandler
implements ServicePrecloseable {
    private static final CssLogger LOG = CssLogger.getCssLogger(ClosingHandler.class);
    protected String m_sDisplayedMessage = null;
    protected volatile boolean m_bNoPopupDisplay = false;

    @Override
    public void preclose() {
        LOG.enter("preclose");
        this.m_bNoPopupDisplay = true;
        LOG.exit("preclose");
    }

    public boolean canClose() {
        LOG.enter("canClose");
        boolean bl = false;
        if (this.m_bNoPopupDisplay) {
            bl = true;
        } else if (null != this.m_sDisplayedMessage && 0 != this.m_sDisplayedMessage.length()) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup();
            confirmationPopup.display(this.m_sDisplayedMessage);
            bl = confirmationPopup.getStatus();
        } else {
            LOG.error((Object)"canClose - m_sDisplayedMessage is empty!!!");
        }
        LOG.exit("canClose", (Object)Boolean.toString(bl));
        return bl;
    }

    public void reset() {
        LOG.enter("reset");
        this.m_bNoPopupDisplay = false;
        LOG.exit("reset");
    }
}

