/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.device.common.util.ErrorLogsColInfo;
import css.device.common.util.Translater;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class StatusReportTableModel
extends AbstractTableModel
implements CssConstants {
    private static final long serialVersionUID = -8029615363526888337L;
    private static final CssLogger LOG = CssLogger.getCssLogger(StatusReportTableModel.class);
    String[] m_tabColumnNames = null;
    Object[][] m_tabData = null;
    String m_sHeaderInfo;

    public StatusReportTableModel() {
        LOG.enter("StatusReportTableModel");
        LOG.exit("StatusReportTableModel");
    }

    public StatusReportTableModel(String[] stringArray, Object[][] objectArray) {
        LOG.enter("StatusReportTableModel", new Object[]{stringArray, objectArray});
        this.m_tabColumnNames = stringArray;
        this.m_tabData = objectArray;
        LOG.exit("StatusReportTableModel");
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        if (null != this.m_tabColumnNames) {
            n = this.m_tabColumnNames.length;
        }
        return n;
    }

    @Override
    public String getColumnName(int n) {
        String string = null;
        if (null != this.m_tabColumnNames && n < this.m_tabColumnNames.length) {
            string = this.m_tabColumnNames[n];
        }
        return string;
    }

    public String[] getColumsArray() {
        return this.m_tabColumnNames;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.m_tabData[n][n2] = object;
        this.fireTableCellUpdated(n, n2);
    }

    public static StatusReportTableModel clearTable(StatusReportTableModel statusReportTableModel) {
        LOG.enter("ClearTable", new Object[]{statusReportTableModel});
        LOG.exit("ClearTable");
        return new StatusReportTableModel(statusReportTableModel.getColumsArray(), null);
    }

    public void setHeaderInfo(String string) {
        LOG.enter("setHeaderInfo", new Object[]{string});
        this.m_sHeaderInfo = string;
        LOG.exit("setHeaderInfo");
    }

    public String getHeaderInfo() {
        LOG.enter("getHeaderInfo");
        LOG.exit("getHeaderInfo", (Object)this.m_sHeaderInfo);
        return this.m_sHeaderInfo;
    }

    public static StatusReportTableModel setTableNewValues(Vector vector) {
        LOG.enter("setTableNewValues", new Object[]{vector});
        StatusReportTableModel statusReportTableModel = null;
        String[] stringArray = null;
        Object[][] objectArray = null;
        try {
            if (null != vector && vector.size() > 0) {
                stringArray = new String[vector.size()];
                ListIterator listIterator = vector.listIterator();
                int n = 0;
                while (listIterator.hasNext()) {
                    ErrorLogsColInfo errorLogsColInfo = (ErrorLogsColInfo)listIterator.next();
                    stringArray[n] = Translater.translateString(errorLogsColInfo.getColName());
                    Vector vector2 = errorLogsColInfo.getColValues();
                    ListIterator listIterator2 = vector2.listIterator();
                    if (n == 0) {
                        objectArray = new Object[vector2.size()][vector.size()];
                    }
                    int n2 = 0;
                    while (listIterator2.hasNext()) {
                        objectArray[n2][n] = errorLogsColInfo.getColType().equals("epochTime") ? Translater.translateToEpochTime((String)listIterator2.next()) : Translater.translateString((String)listIterator2.next());
                        ++n2;
                    }
                    ++n;
                }
                statusReportTableModel = new StatusReportTableModel(stringArray, objectArray);
            } else {
                LOG.trace((Object)"setTableNewValues - data is empty");
                statusReportTableModel = new StatusReportTableModel(null, null);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"setTableNewValues - unexpected excepion was thrown", (Throwable)exception);
        }
        LOG.exit("setTableNewValues", statusReportTableModel);
        return statusReportTableModel;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (null != this.m_tabData) {
            n = this.m_tabData.length;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object[] objectArray;
        Object object = null;
        if (null != this.m_tabData && n < this.m_tabData.length && null != (objectArray = this.m_tabData[n]) && n2 < objectArray.length) {
            object = objectArray[n2];
        }
        return object;
    }
}

