/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.timesuspender.Ticker;
import css.core.util.timesuspender.TickerFactory;
import css.core.util.timesuspender.TimeSuspendedJLabel;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.common.screens.statuspanel.BrStationStatusPanel;
import css.device.platform.common.screens.statuspanel.BrStatusPanelScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import pnm.ui.UIInternalFrame;
import pnm.util.IntegerFormat;

public class BrHardwareStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrHardwareStatusPanel.class);
    private static final long serialVersionUID = -1L;
    static final String OPERATIONAL = "OPERATIONAL";
    static final String WARMING_UP = "WARMING UP";
    static final String FAILED = "FAILED";
    static final String LOCKED = "LOCKED";
    static final String ACTIVE = "ACTIVE";
    static final String DISABLED = "DISABLED";
    static final String UNLOCKED = "UNLOCKED";
    static final String PA_ACTIVE = "ACTIVE";
    static final String N_A = "N/A";
    static final String NOT_AVAILABLE = "NOT AVAILABLE";
    static final String NOT_CONFIGURED = "NOT CONFIGURED";
    static final String TXT_NOT_APPLICABLE = "NOT_APPLICABLE";
    static final String UNKNOWN = "UNKNOWN";
    static final String NOT_APPLICABLE = "NOT APPLICABLE";
    static final String AC_POWER = "AC Power";
    static final String DC_POWER = "DC Power";
    static final String PS_FAILED = "PS Failed";
    static final String EMPTY = "";
    private String c_systemId = "System ID(hex)";
    private String c_siteId = "Site ID";
    private String c_subsiteId = "Subsite ID";
    private String c_stationName = "Station Name";
    private String c_siteName = "Site Name";
    private String c_rxFrequency = "Rx Frequency(MHz)";
    private String c_txFrequency = "Tx Frequency(MHz)";
    private String c_exciter = "Exciter";
    private String c_txSynthesizer = "Tx Synthesizer";
    private String c_powerAmplifier = "Power Amplifier";
    private String c_externalRef = "External Reference";
    private String c_integratedRefA = "Integrated Reference A";
    private String c_integratedRefB = "Integrated Reference B";
    private String c_control = "Control";
    private String c_receiver = "Receiver";
    private String c_rxSynthesizer = "Rx Synthesizer";
    private String c_powerSupply = "Power Supply";
    private String c_infraLink = "Digital Infrastructure Link";
    private String c_lan1 = "LAN 1";
    private String c_lan2 = "LAN 2";
    private String c_sInternalFreqRef = "Internal Frequency Reference";
    private String c_stationConfiguration = "Station Configuration";
    private String c_hardwareStatus = "Hardware Status";
    private JLabel m_systemIdLbl;
    private JLabel m_siteIdLbl;
    private JLabel m_subsiteIdLbl;
    private JLabel m_stationNameLbl;
    private JLabel m_siteNameLbl;
    private JLabel m_labTxFrequencyValue;
    private JLabel m_labRxFrequencyValue;
    private JLabel m_exciterLbl;
    private JLabel m_txSynthesizerLbl;
    private JLabel m_powerAmplifierLbl;
    private JLabel m_externalRefLbl;
    private JLabel m_integratedRefALbl;
    private JLabel m_integratedRefBLbl;
    private JLabel m_controlLbl;
    private JLabel m_receiverLbl;
    private JLabel m_rxSynthesizerLbl;
    private JLabel m_powerSupplyLbl;
    private JLabel m_infraLinkLbl;
    private JLabel m_lan1Lbl;
    private JLabel m_lan2Lbl;
    private JLabel m_labInternalFreqRefVal;
    private UIInternalFrame m_window;
    private BrStatusPanelScreen m_statusPanelScreen;
    private BrStationStatusPanel m_stationStatusPanel;

    public BrHardwareStatusPanel(BrStatusPanelScreen brStatusPanelScreen, BrStationStatusPanel brStationStatusPanel) {
        this.m_statusPanelScreen = brStatusPanelScreen;
        this.m_stationStatusPanel = brStationStatusPanel;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        JLabel jLabel;
        int n = 100;
        int n2 = 15;
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.c_stationConfiguration);
        jPanel.setBorder(titledBorder);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)1.0, (double)1.0, (int)4, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.c_hardwareStatus);
        jPanel2.setBorder(titledBorder2);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)4, (double)1.0, (double)1.0, (int)7, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        Ticker ticker = TickerFactory.getServiceTicker();
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(this.c_siteId);
        jLabel2.setToolTipText("ID assigned to the site in which this station is configured.");
        jLabel2.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)jLabel2, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_siteIdLbl = new JLabel(N_A);
        this.m_siteIdLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)this.m_siteIdLbl, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(this.c_systemId);
        jLabel3.setToolTipText("Unique ID assigned to the system.");
        jLabel3.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)jLabel3, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_systemIdLbl = new JLabel(N_A);
        this.m_systemIdLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)this.m_systemIdLbl, (int)4, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(this.c_stationName);
        jLabel4.setToolTipText("Name given to the station.");
        jLabel4.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)jLabel4, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_stationNameLbl = new JLabel(N_A);
        this.m_stationNameLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)this.m_stationNameLbl, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(this.c_siteName);
        jLabel5.setToolTipText("Name given to the site.");
        jLabel5.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)jLabel5, (int)3, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_siteNameLbl = new JLabel(N_A);
        this.m_siteNameLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)this.m_siteNameLbl, (int)4, (int)1, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            JLabel jLabel6 = new JLabel("Current Tx Frequency");
            jLabel6.setToolTipText("Current Tx Frequency.");
            jLabel6.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)jLabel6, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
            this.m_labTxFrequencyValue = new JLabel(N_A);
            this.m_labTxFrequencyValue.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)this.m_labTxFrequencyValue, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        } else {
            JLabel jLabel7 = new JLabel();
            jLabel7.setText(this.c_txFrequency);
            jLabel7.setToolTipText("Frequency assigned to the transmitter of the station.");
            jLabel7.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)jLabel7, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
            this.m_labTxFrequencyValue = new JLabel(N_A);
            this.m_labTxFrequencyValue.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)this.m_labTxFrequencyValue, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        }
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(this.c_subsiteId);
        jLabel8.setToolTipText("ID assigned to the Subsite in which this station is configured.");
        jLabel8.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)jLabel8, (int)3, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_subsiteIdLbl = new JLabel(N_A);
        this.m_subsiteIdLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel, (Component)this.m_subsiteIdLbl, (int)4, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jLabel = new JLabel("Current Rx Frequency");
            jLabel.setToolTipText("Current Rx Frequency");
            jLabel.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)jLabel, (int)0, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
            this.m_labRxFrequencyValue = new JLabel(N_A);
            this.m_labRxFrequencyValue.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)this.m_labRxFrequencyValue, (int)1, (int)3, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        } else {
            jLabel = new JLabel();
            jLabel.setText(this.c_rxFrequency);
            jLabel.setToolTipText("Configured frequency of the receiver.");
            jLabel.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)jLabel, (int)0, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
            this.m_labRxFrequencyValue = new JLabel(N_A);
            this.m_labRxFrequencyValue.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel, (Component)this.m_labRxFrequencyValue, (int)1, (int)3, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        }
        jLabel = new JLabel();
        jLabel.setText(this.c_exciter);
        jLabel.setToolTipText("Current status of the exciter.");
        jLabel.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_exciterLbl = new TimeSuspendedJLabel(ticker);
        this.m_exciterLbl.setText(N_A);
        this.m_exciterLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_exciterLbl, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(this.c_externalRef);
        jLabel9.setToolTipText("Current status of external reference.");
        jLabel9.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel9, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_externalRefLbl = new TimeSuspendedJLabel(ticker);
        this.m_externalRefLbl.setText(N_A);
        this.m_externalRefLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_externalRefLbl, (int)4, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText(this.c_txSynthesizer);
        jLabel10.setToolTipText("Current status of the tx synthesizer.");
        jLabel10.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel10, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_txSynthesizerLbl = new TimeSuspendedJLabel(ticker);
        this.m_txSynthesizerLbl.setText(N_A);
        this.m_txSynthesizerLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_txSynthesizerLbl, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText(this.c_integratedRefA);
        jLabel11.setToolTipText("Current status of integrated reference A.");
        jLabel11.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel11, (int)3, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_integratedRefALbl = new TimeSuspendedJLabel(ticker);
        this.m_integratedRefALbl.setText(N_A);
        this.m_integratedRefALbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_integratedRefALbl, (int)4, (int)1, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText(this.c_control);
        jLabel12.setToolTipText("Current status of the control module.");
        jLabel12.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel12, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_controlLbl = new TimeSuspendedJLabel(ticker);
        this.m_controlLbl.setText(N_A);
        this.m_controlLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_controlLbl, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText(this.c_integratedRefB);
        jLabel13.setToolTipText("Current status of integrated reference B.");
        jLabel13.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel13, (int)3, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_integratedRefBLbl = new TimeSuspendedJLabel(ticker);
        this.m_integratedRefBLbl.setText(N_A);
        this.m_integratedRefBLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_integratedRefBLbl, (int)4, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel14 = new JLabel();
        jLabel14.setText(this.c_rxSynthesizer);
        jLabel14.setToolTipText("Current status of the Rx Synthesizer.");
        jLabel14.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel14, (int)0, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_rxSynthesizerLbl = new TimeSuspendedJLabel(ticker);
        this.m_rxSynthesizerLbl.setText(N_A);
        this.m_rxSynthesizerLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_rxSynthesizerLbl, (int)1, (int)3, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel15 = new JLabel();
        jLabel15.setText(this.c_receiver);
        jLabel15.setToolTipText("Current status of the receiver.");
        jLabel15.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel15, (int)3, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_receiverLbl = new TimeSuspendedJLabel(ticker);
        this.m_receiverLbl.setText(N_A);
        this.m_receiverLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_receiverLbl, (int)4, (int)3, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel16 = new JLabel();
        jLabel16.setText(this.c_powerAmplifier);
        jLabel16.setToolTipText("Current status of the power amplifier.");
        jLabel16.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel16, (int)0, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_powerAmplifierLbl = new TimeSuspendedJLabel(ticker);
        this.m_powerAmplifierLbl.setText(N_A);
        this.m_powerAmplifierLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_powerAmplifierLbl, (int)1, (int)4, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel17 = new JLabel();
        jLabel17.setText(this.c_powerSupply);
        jLabel17.setToolTipText("Current status of the power supply.");
        jLabel17.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel17, (int)3, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_powerSupplyLbl = new TimeSuspendedJLabel(ticker);
        this.m_powerSupplyLbl.setText(N_A);
        this.m_powerSupplyLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_powerSupplyLbl, (int)4, (int)4, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel18 = new JLabel();
        jLabel18.setText(this.c_lan1);
        jLabel18.setToolTipText("Current activity of LAN 1.");
        jLabel18.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel18, (int)0, (int)5, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_lan1Lbl = new TimeSuspendedJLabel(ticker);
        this.m_lan1Lbl.setText(N_A);
        this.m_lan1Lbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_lan1Lbl, (int)1, (int)5, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel19 = new JLabel();
        jLabel19.setText(this.c_lan2);
        jLabel19.setToolTipText("Current activity of LAN 2.");
        jLabel19.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel19, (int)3, (int)5, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_lan2Lbl = new TimeSuspendedJLabel(ticker);
        this.m_lan2Lbl.setText(N_A);
        this.m_lan2Lbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_lan2Lbl, (int)4, (int)5, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel20 = new JLabel();
        jLabel20.setText(this.c_infraLink);
        jLabel20.setToolTipText("Current status of the Infrastructure Link.");
        jLabel20.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)jLabel20, (int)0, (int)6, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_infraLinkLbl = new TimeSuspendedJLabel(ticker);
        this.m_infraLinkLbl.setText(N_A);
        this.m_infraLinkLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel2, (Component)this.m_infraLinkLbl, (int)1, (int)6, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        JLabel jLabel21 = new JLabel();
        jLabel21.setText(this.c_sInternalFreqRef);
        jLabel21.setToolTipText("Current SAC Frequency Reference.");
        jLabel21.setPreferredSize(new Dimension(n, n2));
        this.m_labInternalFreqRefVal = new TimeSuspendedJLabel(ticker);
        this.m_labInternalFreqRefVal.setText(N_A);
        this.m_labInternalFreqRefVal.setPreferredSize(new Dimension(n, n2));
        if (this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication()) {
            GridBagAdder.add((Container)jPanel2, (Component)jLabel21, (int)3, (int)6, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
            GridBagAdder.add((Container)jPanel2, (Component)this.m_labInternalFreqRefVal, (int)4, (int)6, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_systemIdLbl.setText(N_A);
        this.m_siteIdLbl.setText(N_A);
        this.m_subsiteIdLbl.setText(N_A);
        this.m_labRxFrequencyValue.setText(N_A);
        this.m_labTxFrequencyValue.setText(N_A);
        this.m_stationNameLbl.setText(N_A);
        this.m_powerSupplyLbl.setText(N_A);
        this.m_rxSynthesizerLbl.setText(N_A);
        this.m_controlLbl.setText(N_A);
        this.m_externalRefLbl.setText(N_A);
        this.m_integratedRefALbl.setText(N_A);
        this.m_integratedRefBLbl.setText(N_A);
        this.m_powerAmplifierLbl.setText(N_A);
        this.m_txSynthesizerLbl.setText(N_A);
        this.m_exciterLbl.setText(N_A);
        this.m_receiverLbl.setText(N_A);
        this.m_lan1Lbl.setText(N_A);
        this.m_lan2Lbl.setText(N_A);
        this.m_infraLinkLbl.setText(N_A);
        this.m_labInternalFreqRefVal.setText(N_A);
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        LOG.exit("initialize");
    }

    public void updateScreenSubSiteId(int n, Integer[] integerArray) {
        LOG.enter("updateScreenSubSiteId", new Object[]{n, integerArray});
        try {
            if (n == 0) {
                this.m_subsiteIdLbl.setText(integerArray[0].toString());
            } else {
                this.m_subsiteIdLbl.setText(N_A);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"updateScreenSubSiteId - Field not supported", (Throwable)exception);
        }
        LOG.exit("enclosing_method");
    }

    public void updateStationStatus(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, String[] stringArray2, Integer[] integerArray3, Integer[] integerArray4) {
        LOG.enter("updateStationStatus", new Object[]{n, integerArray, integerArray2, stringArray, stringArray2, integerArray3, integerArray4});
        if (n == 0) {
            if (!this.m_statusPanelScreen.isConvBrApplication()) {
                String string;
                double d;
                if (integerArray3.length != 0) {
                    d = (double)integerArray3[0].intValue() / 1000000.0;
                    string = new Double(d).toString();
                    this.m_labTxFrequencyValue.setText(string);
                } else {
                    LOG.warn((Object)"Array length is 0");
                    this.m_statusPanelScreen.popupError("Unable to Get Transmitter Frequency ");
                }
                if (integerArray4.length != 0) {
                    d = (double)integerArray4[0].intValue() / 1000000.0;
                    string = new Double(d).toString();
                    this.m_labRxFrequencyValue.setText(string);
                } else {
                    LOG.warn((Object)"Array length is 0");
                    this.m_statusPanelScreen.popupError("Unable to Get Receiver Frequency ");
                }
            }
            if (integerArray.length != 0) {
                this.m_siteIdLbl.setText(integerArray[0].toString());
            } else {
                LOG.warn((Object)"Array length is 0");
                this.m_statusPanelScreen.popupError("Unable to Get Site ID ");
            }
            if (integerArray2.length != 0) {
                String string = System.getProperty("css.core.deviceandhwtype", UNKNOWN);
                if (string.indexOf("CONVBR") < 0) {
                    this.m_systemIdLbl.setText(IntegerFormat.addLeadingZeros((String)Integer.toHexString(integerArray2[0]), (int)5));
                } else {
                    this.m_systemIdLbl.setText(N_A);
                }
            } else {
                LOG.warn((Object)"Array length is 0");
                this.m_statusPanelScreen.popupError("Unable to Get System ID ");
            }
            this.m_stationNameLbl.setText(stringArray[0]);
            this.m_siteNameLbl.setText(stringArray2[0]);
        } else {
            LOG.warn((Object)("updateStationStatus - error occured: " + n));
            this.m_statusPanelScreen.popupError(-262182);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("enclosing_method");
    }

    public void updateHardwareConfiguration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, byte[] byArray, byte[] byArray2, int n15) {
        LOG.enter("updateHardwareConfiguration", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, byArray, byArray2, n15});
        this.updateExciter(n);
        this.updateTxSynthesizer(n2);
        this.updatePowerAmplifier(n3);
        this.updateExternalRef(n4);
        this.updateIntegratedRefA(n5);
        this.updateIntegratedRefB(n6);
        this.updateLan1(n7);
        this.updateLan2(n8);
        this.updateControlModule(n9);
        this.updateReceiverState(n10);
        this.updateRxSynthesizer(n11);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            this.updatePowerSupplyNew(n15);
        } else {
            this.updatePowerSupply(n12);
        }
        this.updateInfrastructureInterface(n13);
        this.updateSacFrequencyReference(n14);
        this.updateTXFreq(byArray);
        this.updateRXFreq(byArray2);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateHardwareConfiguration");
    }

    public boolean updateRealTimeData(Object object) {
        boolean bl = true;
        String string = null;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        LOG.enter("updateRealTimeData", new Object[]{object});
        try {
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase("Exciter")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateExciter(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TxSynthesizer")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTxSynthesizer(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("PowerAmplifier")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerAmplifier(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ExternalReference")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateExternalRef(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("IntegratedRefA")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateIntegratedRefA(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("IntegratedRefB")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateIntegratedRefB(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("CurrentTXFreq")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTXFreq(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("CurrentRXFreq")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRXFreq(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("Lan1")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateLan1(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("Lan2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateLan2(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ControlModule")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateControlModule(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RxSynthesizer")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxSynthesizer(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("PowerSupply")) {
                    if (this.m_statusPanelScreen.isConvBrApplication()) continue;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerSupply(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("GetPowerSupplyStateNew")) {
                    if (!this.m_statusPanelScreen.isConvBrApplication()) continue;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerSupplyNew(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("InfrastructureInterface")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateInfrastructureInterface(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("SacFrequencyReference")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateSacFrequencyReference(Convert.toInteger((byte[])byArray));
                    continue;
                }
                bl = false;
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateRealTimeData - Name not found", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData");
        return bl;
    }

    public void updateTXFreq(byte[] byArray) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            Integer n = Convert.toInteger((byte[])byArray);
            Double d = (double)n.intValue() / 1000000.0;
            String string = Double.toString(d);
            this.m_labTxFrequencyValue.setText(string + " MHz");
        }
    }

    public void updateRXFreq(byte[] byArray) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            Integer n = Convert.toInteger((byte[])byArray);
            Double d = (double)n.intValue() / 1000000.0;
            String string = Double.toString(d);
            this.m_labRxFrequencyValue.setText(string + " MHz");
        }
    }

    private void updateExciter(int n) {
        LOG.enter("updateExciter", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_exciterLbl.setText(OPERATIONAL);
                break;
            }
            case 0: {
                this.m_exciterLbl.setText(FAILED);
                break;
            }
            case 15: {
                this.m_exciterLbl.setText(NOT_AVAILABLE);
                break;
            }
            case 16: {
                this.m_exciterLbl.setText(TXT_NOT_APPLICABLE);
                break;
            }
            default: {
                this.m_exciterLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Exciter = : " + this.m_exciterLbl.getText() + "\n");
        LOG.exit("updateExciter");
    }

    private void updateTxSynthesizer(int n) {
        LOG.enter("updateTxSynthesizer", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_txSynthesizerLbl.setText(LOCKED);
                break;
            }
            case 2: {
                this.m_txSynthesizerLbl.setText(UNLOCKED);
                break;
            }
            case 16: {
                this.m_txSynthesizerLbl.setText(NOT_APPLICABLE);
                break;
            }
            default: {
                this.m_txSynthesizerLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Tx Synthesizer = : " + this.m_txSynthesizerLbl.getText() + "\n");
        LOG.exit("updateTxSynthesizer");
    }

    private void updatePowerAmplifier(int n) {
        LOG.enter("updatePowerAmplifier", new Object[]{n});
        switch (n) {
            case 0: {
                this.m_powerAmplifierLbl.setText(FAILED);
                break;
            }
            case 1: {
                this.m_powerAmplifierLbl.setText(OPERATIONAL);
                break;
            }
            case 4: {
                this.m_powerAmplifierLbl.setText("ACTIVE");
                break;
            }
            case 15: {
                this.m_powerAmplifierLbl.setText(NOT_AVAILABLE);
                break;
            }
            case 16: {
                this.m_powerAmplifierLbl.setText(TXT_NOT_APPLICABLE);
                break;
            }
            default: {
                this.m_powerAmplifierLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Amplifier = : " + this.m_powerAmplifierLbl.getText() + "\n");
        LOG.exit("updatePowerAmplifier");
    }

    private void updateExternalRef(int n) {
        LOG.enter("updateExternalRef", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_externalRefLbl.setText(OPERATIONAL);
                break;
            }
            case 0: {
                this.m_externalRefLbl.setText(FAILED);
                break;
            }
            case 15: {
                this.m_externalRefLbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_externalRefLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("External Reference = " + this.m_externalRefLbl.getText() + "\n");
        LOG.exit("updateExternalRef");
    }

    private void updateIntegratedRefA(int n) {
        LOG.enter("updateIntegratedRefA", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_integratedRefALbl.setText(OPERATIONAL);
                break;
            }
            case 2: {
                this.m_integratedRefALbl.setText("ACTIVE");
                break;
            }
            case 3: {
                this.m_integratedRefALbl.setText(DISABLED);
                break;
            }
            case 0: {
                this.m_integratedRefALbl.setText(FAILED);
                break;
            }
            case 15: {
                this.m_integratedRefALbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_integratedRefALbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Integrated Reference A = " + this.m_integratedRefALbl.getText() + "\n");
        LOG.exit("updateIntegratedRefA");
    }

    private void updateIntegratedRefB(int n) {
        LOG.enter("updateIntegratedRefB", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_integratedRefBLbl.setText(OPERATIONAL);
                break;
            }
            case 2: {
                this.m_integratedRefBLbl.setText("ACTIVE");
                break;
            }
            case 3: {
                this.m_integratedRefBLbl.setText(DISABLED);
                break;
            }
            case 0: {
                this.m_integratedRefBLbl.setText(FAILED);
                break;
            }
            case 15: {
                this.m_integratedRefBLbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_integratedRefBLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Integrated Reference B = " + this.m_integratedRefBLbl.getText() + "\n");
        LOG.exit("updateIntegratedRefB");
    }

    private void updateLan1(int n) {
        LOG.enter("updateLan1", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_lan1Lbl.setText(OPERATIONAL);
                break;
            }
            case 0: {
                this.m_lan1Lbl.setText(FAILED);
                break;
            }
            case 2: {
                this.m_lan1Lbl.setText("ACTIVE");
                break;
            }
            case 3: {
                this.m_lan1Lbl.setText(DISABLED);
                break;
            }
            case 15: {
                this.m_lan1Lbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_lan1Lbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Lan 1 = " + this.m_lan1Lbl.getText() + "\n");
        LOG.exit("updateLan1");
    }

    private void updateLan2(int n) {
        LOG.enter("updateLan2", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_lan2Lbl.setText(OPERATIONAL);
                break;
            }
            case 0: {
                this.m_lan2Lbl.setText(FAILED);
                break;
            }
            case 2: {
                this.m_lan2Lbl.setText("ACTIVE");
                break;
            }
            case 3: {
                this.m_lan2Lbl.setText(DISABLED);
                break;
            }
            case 15: {
                this.m_lan2Lbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_lan2Lbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Lan 2 = " + this.m_lan2Lbl.getText() + "\n");
        LOG.exit("updateLan2");
    }

    private void updateControlModule(int n) {
        LOG.enter("updateControlModule", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_controlLbl.setText(OPERATIONAL);
                break;
            }
            case 0: {
                this.m_controlLbl.setText(FAILED);
                break;
            }
            case 15: {
                this.m_controlLbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_controlLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Control = : " + this.m_controlLbl.getText() + "\n");
        LOG.exit("updateControlModule");
    }

    private void updateReceiverState(int n) {
        LOG.enter("updateReceiverState", new Object[]{n});
        switch (n) {
            case 0: {
                this.m_receiverLbl.setText(FAILED);
                break;
            }
            case 1: {
                this.m_receiverLbl.setText(OPERATIONAL);
                break;
            }
            case 15: {
                this.m_receiverLbl.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                this.m_receiverLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver = : " + this.m_receiverLbl.getText() + "\n");
        LOG.exit("updateReceiverState");
    }

    private void updateRxSynthesizer(int n) {
        LOG.enter("updateRxSynthesizer", new Object[]{n});
        switch (n) {
            case 1: {
                this.m_rxSynthesizerLbl.setText(LOCKED);
                break;
            }
            case 2: {
                this.m_rxSynthesizerLbl.setText(UNLOCKED);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Synthesizer = : " + this.m_rxSynthesizerLbl.getText() + "\n");
        LOG.exit("updateRxSynthesizer");
    }

    private void updatePowerSupplyNew(int n) {
        LOG.enter("updatePowerSupply", new Object[]{n});
        switch (n) {
            case 0: {
                this.m_powerSupplyLbl.setText(AC_POWER);
                break;
            }
            case 1: {
                this.m_powerSupplyLbl.setText(DC_POWER);
                break;
            }
            case 2: {
                this.m_powerSupplyLbl.setText(PS_FAILED);
                break;
            }
            default: {
                this.m_powerSupplyLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Supply = : " + this.m_powerSupplyLbl.getText() + "\n");
        LOG.exit("updatePowerSupply");
    }

    private void updatePowerSupply(int n) {
        LOG.enter("updatePowerSupply", new Object[]{n});
        switch (n) {
            case 0: {
                this.m_powerSupplyLbl.setText(FAILED);
                break;
            }
            case 1: {
                this.m_powerSupplyLbl.setText(OPERATIONAL);
                break;
            }
            case 2: {
                this.m_powerSupplyLbl.setText(N_A);
                break;
            }
            default: {
                this.m_powerSupplyLbl.setText(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Supply = : " + this.m_powerSupplyLbl.getText() + "\n");
        LOG.exit("updatePowerSupply");
    }

    private void updateInfrastructureInterface(int n) {
        LOG.enter("updateInfrastructureInterface", new Object[]{n});
        if (this.m_statusPanelScreen.isServiceMode() && (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication())) {
            this.m_infraLinkLbl.setText(EMPTY);
        } else {
            switch (n) {
                case 0: {
                    this.m_infraLinkLbl.setText(FAILED);
                    break;
                }
                case 1: {
                    this.m_infraLinkLbl.setText(OPERATIONAL);
                    break;
                }
                case 15: {
                    this.m_infraLinkLbl.setText(NOT_CONFIGURED);
                    break;
                }
                default: {
                    LOG.warn((Object)("Default condition, state is " + n));
                    this.m_infraLinkLbl.setText(UNKNOWN);
                }
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Infrastructure Link = : " + this.m_infraLinkLbl.getText() + "\n");
        LOG.exit("updateInfrastructureInterface");
    }

    private void updateSacFrequencyReference(int n) {
        LOG.enter("updateSacFrequencyReference", new Object[]{n});
        switch (n) {
            case 0: {
                this.m_labInternalFreqRefVal.setText(FAILED);
                break;
            }
            case 1: {
                this.m_labInternalFreqRefVal.setText(OPERATIONAL);
                break;
            }
            case 2: {
                this.m_labInternalFreqRefVal.setText(WARMING_UP);
                break;
            }
            case 15: {
                this.m_labInternalFreqRefVal.setText(NOT_AVAILABLE);
                break;
            }
            default: {
                LOG.warn((Object)("Default condition, state is " + n));
                this.m_labInternalFreqRefVal.setText(UNKNOWN);
            }
        }
        LOG.exit("updateSacFrequencyReference");
    }

    public void writeInitialDataToFile() {
        LOG.enter("writeInitialDataToFile");
        String string = "=================================================================================\n";
        string = string + "            STATION INFORMATION :       " + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "System Id : " + this.m_systemIdLbl.getText() + "\n";
        string = string + "Site ID: " + this.m_siteIdLbl.getText() + "\n";
        string = string + "Subsite ID: " + this.m_subsiteIdLbl.getText() + "\n";
        string = string + "Receiver Frequency: " + this.m_labRxFrequencyValue.getText() + "\n";
        string = string + "Transmitter Frequency: " + this.m_labTxFrequencyValue.getText() + "\n";
        string = string + "Station Name     : " + this.m_stationNameLbl.getText() + "\n";
        string = string + "Site Name     : " + this.m_stationNameLbl.getText() + "\n";
        string = string + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "            INITIAL HARDWARE STATUS AT LOG TIME :    " + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "Infrastructure Link : " + this.m_infraLinkLbl.getText() + "\n";
        string = string + "Power Suply : " + this.m_powerSupplyLbl.getText() + "\n";
        string = string + "Receiver Synthesizer : " + this.m_rxSynthesizerLbl.getText() + "\n";
        string = string + "Control : " + this.m_controlLbl.getText() + "\n";
        string = string + "External Reference : " + this.m_externalRefLbl.getText() + "\n";
        string = string + "Integrated Reference A : " + this.m_integratedRefALbl.getText() + "\n";
        string = string + "Integrated Reference B : " + this.m_integratedRefBLbl.getText() + "\n";
        string = string + "Power Amplifier : " + this.m_powerAmplifierLbl.getText() + "\n";
        string = string + "Transmitter Synthesizer : " + this.m_txSynthesizerLbl.getText() + "\n";
        string = string + "Exciter : " + this.m_exciterLbl.getText() + "\n";
        string = string + "Receiver : " + this.m_receiverLbl.getText() + "\n";
        string = string + "LAN 1 : " + this.m_lan1Lbl.getText() + "\n";
        string = string + "LAN 2 : " + this.m_lan2Lbl.getText() + "\n";
        string = string + this.c_sInternalFreqRef + " : " + this.m_labInternalFreqRefVal.getText() + "\n";
        string = string + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "\n";
        this.m_statusPanelScreen.appendString(string);
        LOG.exit("writeInitialDataToFile");
    }

    public void updateHardwareConfiguration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray, byte[] byArray2, int n10) {
        LOG.enter("updateHardwareConfiguration", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, byArray, byArray2, n10});
        this.updateExciter(n);
        this.updateTxSynthesizer(n2);
        this.updatePowerAmplifier(n3);
        this.updateExternalRef(n4);
        this.updateControlModule(n5);
        this.updateReceiverState(n6);
        this.updateRxSynthesizer(n7);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            this.updatePowerSupplyNew(n10);
        } else {
            this.updatePowerSupply(n8);
        }
        this.updateInfrastructureInterface(n9);
        this.updateTXFreq(byArray);
        this.updateRXFreq(byArray2);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateHardwareConfiguration");
    }
}

