/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.DateAndTimeConversion;
import css.core.util.GridBagAdder;
import css.core.util.component.CSSJComboBox;
import css.core.util.component.CSSJSpinner;
import css.core.util.component.CSSJTextField;
import css.core.util.component.GenericListener;
import css.core.util.popup.WarningPopup;
import css.core.util.timesuspender.Ticker;
import css.core.util.timesuspender.TickerFactory;
import css.core.util.timesuspender.TimeSuspendedJLabel;
import css.device.common.util.DeviceErrorCodes;
import css.device.common.util.ErrorLogUtility;
import css.device.platform.common.screens.statuspanel.BrStatusPanelScreen;
import css.device.platform.common.screens.statuspanel.StationCommandTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pnm.ui.UIInternalFrame;
import pnm.util.IntegerFormat;

public class BrStationStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrStationStatusPanel.class);
    private static final long serialVersionUID = -1L;
    private static final String m_transmitterDisableLblStr = "Transmitter Inhibit";
    private static final String m_transmitterEnableLblStr = "Transmitter Enable";
    private static final String m_receiverEnableLblStr = "Receiver Enable";
    private static final String m_receiverDisableLblStr = "Receiver Inhibit";
    private static final String FAILED = "FAILED";
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";
    private static final String REPEATER_SET_UP = "Repeater Set Up";
    private static final String REPEATER_KNOCKDOWN = "Repeater Knockdown";
    private static final String IDLE = "IDLE";
    private static final String VOICE = "VOICE";
    private static final String VOICE_DIGITAL = "VOICE (Digital)";
    private static final String VOICE_ANALOG = "VOICE (Analog)";
    private static final String DATA = "DATA";
    private static final String CONSOLE_PRIORITY = "Console priority";
    private static final String ACTIVE_PRIORITY = "Active";
    private static final String LOWER_PRIORITY = "Lower Priority";
    private static final String TSBK = "TSBK";
    private static final String ANALOG_TEST_PATTERN = "Analog Test Pattern";
    private static final String IDLE_PACKET = "Idle Packets";
    private static final String IDLE_CARRIER = "Idle Carrier";
    private static final String TXT_NOT_APPLICABLE = "NOT_APPLICABLE";
    private static final String FALLBACK_REPEAT = "Fall Back Repeat";
    private static final int CONVBR_MIN_CHANNEL_PERSONALITY = 1;
    private static final int CONVBR_MAX_CHANNEL_PERSONALITY = 16;
    private static final String ERROR_CHANNEL_PERSONALITY = "Invalid channel number. Valid range is: 1-16.";
    private static final int SPEAKER_VOLUME_MIN = 0;
    private static final int SPEAKER_VOLUME_MAX = 20;
    private static final int TSBK_ONSCREEN_TIMEOUT = 1000;
    private static final String INHIBIT = "INHIBIT";
    private static final String N_A = "N/A";
    private static final String EMPTY = "";
    private static final String STATION_OPERATION_MODE = "Station Operation Mode";
    private static final String TRANSMITTER = "Transmitter";
    private static final String P2_TRANSMITTER_SLOT1 = "TA - FDMA/TDMA logical channel 0";
    private static final String P2_TRANSMITTER_SLOT2 = "TA - TDMA logical channel 1";
    private static final String TRANSMITTER_ACTIVITY = "Transmitter Activity";
    private static final String TX_NETWORK_ACCESS_CODE = "Tx Network Access Code (hex)";
    private static final String TX_COLOR_CODE = "Tx Color Code (hex)";
    private static final String STATION_USAGE = "Station Usage";
    private static final String RECEIVER = "Receiver";
    private static final String RECEIVER_ACTIVITY = "Receiver Activity";
    private static final String P2_RECEIVER_SLOT1 = "RA - FDMA/TDMA logical channel 0";
    private static final String P2_RECEIVER_SLOT2 = "RA - TDMA logical channel 1";
    private static final String RX_NETWORK_ACCESS_CODE = "Rx Network Access Code (hex)";
    private static final String RX_COLOR_CODE = "Rx Color Code (hex)";
    private static final String STATION_TIME = "Station Time";
    private static final String STATION_DATE = "Station Date";
    private ErrorLogUtility m_errorLogUtility = new ErrorLogUtility();
    private static final String CONVENTIONAL = "CONVENTIONAL";
    private static final int TRANSMITTER_FIELD = 0;
    private static final int TA_FDMA_TDMA_SLOT_1 = 1;
    private static final int TA_TDMA_SLOT_2 = 2;
    private static final int RECEIVER_FIELD = 0;
    private static final int RA_FDMA_TDMA_SLOT_1 = 1;
    private static final int RA_TDMA_SLOT_2 = 2;
    private static final int F2_TDMA = 1;
    private static final int P2_TDMA = 2;
    protected static final HashMap<Integer, String> STATIONOPERATIONALMODE = new HashMap();
    private static final HashMap<Integer, String> TRANSMITTEROPERATIONALSTATE;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT1MSBR;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT2;
    private static final HashMap<Integer, String> STATIONUSAGE;
    private static final HashMap<Integer, String> RECEIVERACTIVITYSLOT1;
    private static final HashMap<Integer, String> RECEIVERACTIVITYSLOT2;
    private static final HashMap<Integer, String> RECEIVEROPERATIONALSTATE;
    private static final int STATIONUSAGEVOICETDMA = 8;
    private static final int SS_REPEATER_STATE_SETUP = 2;
    private static final int SS_REPEATER_STATE_KNOCKDOWN = 3;
    private static final HashMap<Integer, String> REPEATERSTATE;
    private static final HashMap<Integer, String> REPEATERACTIVITYSTATE;
    private static final int PL_BLANK = 0;
    private static final int PL_CSQ = 1;
    private static final int PL_PL = 2;
    private static final int PL_DPL = 3;
    private static final HashMap<Integer, String> PL_DPL_TYPES;
    private static final HashMap<String, String> PL_TYPES;
    private static final int ACTIVITY_IDLE = 0;
    private static int m_nTdmaMode;
    private static final int REPEATER_ACTIVITY_TSBK = 12;
    private static final int RECEIVER_ACTIVITY_TSBK = 12;
    private static final int TRANSMITTER_ACTIVITY_TSBK = 12;
    private static final int SCAN_STATE_DISABLED = 0;
    private static final int SCAN_STATE_SCAN_OFF = 1;
    private static final int SCAN_STATE_SCAN_ON = 2;
    private static final int SCAN_STATE_ON_CHANNEL = 3;
    private static final int SCAN_STATE_SUSPENDED = 4;
    private static final HashMap<Integer, String> SCAN_STATES;
    private static final int TRANSMIT_IDLE = 0;
    private static final int TRANSMIT_INFRASTRUCTURE = 1;
    private static final int TRANSMIT_PHONE_PATCH = 2;
    private static final int TRANSMIT_MICROPHONE = 3;
    private static final int TRANSMIT_REPEATER = 4;
    private static final int TRANSMIT_INTERNAL = 5;
    private static final int TRANSMIT_NA = 6;
    private static final HashMap<Integer, String> TRANSMIT_SOURCE;
    private static final int MS_DISABLED = 0;
    private static final int MS_MAIN = 1;
    private static final int MS_STANDBY = 2;
    private static final HashMap<Integer, String> MAIN_STANDBY;
    private static final int OVERVOLTAGE_ALARM_ALARM = 0;
    private static final int OVERVOLTAGE_ALARM_NO_ALARM = 1;
    private static final HashMap<Integer, String> OVERVOLTAGE_ALARM;
    private static final int STATION_ALARM_ENABLED = 1;
    private static final int STATION_ALARM_DISABLED = 2;
    private static final HashMap<Integer, String> STATION_ALARM;
    private static final int ANALOG_INFRASTRUCTURE_STATE_FAILED = 0;
    private static final int ANALOG_INFRASTRUCTURE_STATE_OPERATIONAL = 1;
    private static final int ANALOG_INFRASTRUCTURE_STATE_DISABLED = 2;
    private static final int ANALOG_INFRASTRUCTURE_STATE_NOTCONFIGURED = 15;
    private static final HashMap<Integer, String> ANALOG_INFRASTRUCTURE_STATE;
    private static final int RXPL_STATE_OFF = 0;
    private static final int RXPL_STATE_ON = 1;
    private static final HashMap<Integer, String> RXPL_STATE;
    private static final int TXPL_STATE_OFF = 0;
    private static final int TXPL_STATE_ON = 1;
    private static final HashMap<Integer, String> TXPL_STATE;
    private static final int SELECTIVE_ALARM_OFF = 0;
    private static final int SELECTIVE_ALARM_ON = 1;
    private static final HashMap<Integer, String> SELECTIVE_ALARM;
    private static final HashMap<Integer, String> RX_QUALIFIERS;
    private long nLastRepeaterActivitySetTime;
    private long nLastReceiverActivitySetTime;
    private long nLastTransmitterActivitySetTime;
    private UIInternalFrame m_window;
    protected JLabel m_stationOperationModeLbl;
    private JLabel m_txNetworkAccessCodeLbl;
    private JLabel m_stationUsageLbl;
    private JLabel m_rxNetworkAccessCodeLbl;
    private JLabel m_stationTimeLbl;
    private JLabel m_stationDateLbl;
    private JLabel m_stationRepeaterStateLbl;
    private JLabel m_stationRepeaterStateValueLbl;
    private JLabel m_stationRepeaterActStateLbl;
    private JLabel m_stationRepeaterActStateValueLbl;
    private JLabel m_labScanActivityValue;
    private JLabel m_labScanChannelValue;
    private JLabel m_labTransmitSourceValue;
    private JLabel m_labMainStandbyValue;
    private JLabel m_labOverVoltageAlarmValue;
    private JLabel m_labStationAlarmValue;
    private JLabel m_labAnalogInfrastructureStateValue;
    private JLabel m_subscriberID;
    JLabel m_transmitterNetworkAccessCodeColorCodeLabel;
    JLabel m_receiverNetworkAccessCodeColorCodeLabel;
    public JButton m_transmitterDisableBtn;
    public JButton m_receiverDisableBtn;
    private JTable m_statusTable;
    private JTable m_transmitterOperationTable;
    private JTable m_receiverOperationTable;
    private BrStatusPanelScreen m_statusPanelScreen;
    private StationCommandTab m_StationCommandTab;
    private DefaultTableModel m_model;
    private DefaultTableModel m_transmitterOperationModel;
    private DefaultTableModel m_receiverOperationModel;
    private static final String TEXT_TX_PL_DPL = "Tx PL/DPL";
    private JLabel m_labTxPlDpl;
    private JLabel m_labTxPlDplCode;
    private static final String TEXT_RX_PL_DPL = "Rx PL/DPL";
    private JLabel m_labRxPlDpl;
    private JLabel m_labRxPlDplCode;
    private static final String TEXT_CURRENT_PERSONALITY = "Current Channel: ";
    private JLabel m_labCurrentPersonality;
    private JLabel m_labCurrentPersonalityValue;
    private static final String TEXT_SET_PERSONALITY = "Set Channel";
    private JLabel m_labSetPersonality;
    public CSSJTextField m_txtSetPersonality;
    public JButton m_btnSetPersonality;
    private SpinnerNumberModel m_labSpinModel;
    private static final String TEXT_SET_SPEAKER_VOLUME = "Local Speaker Volume:";
    private JLabel m_labSetSpeakerVolume;
    public CSSJSpinner m_spinSpeakerVolume;
    public JCheckBox m_chkIntercom;
    public CSSJComboBox m_comboRxQualifier;
    private static Integer m_nEnabledPersonality;
    private GenericListener m_oSetChannelTimerListener;

    public BrStationStatusPanel(BrStatusPanelScreen brStatusPanelScreen) {
        SCAN_STATES.put(0, "Disabled");
        SCAN_STATES.put(1, "Scan Off");
        SCAN_STATES.put(2, "Scan On");
        SCAN_STATES.put(3, "On Channel");
        SCAN_STATES.put(4, "Suspended");
        TRANSMIT_SOURCE.put(0, IDLE);
        TRANSMIT_SOURCE.put(1, "Infrastructure");
        TRANSMIT_SOURCE.put(2, "Phone Patch");
        TRANSMIT_SOURCE.put(3, "Microphone");
        TRANSMIT_SOURCE.put(4, "Repeater");
        TRANSMIT_SOURCE.put(5, "Internal");
        TRANSMIT_SOURCE.put(6, TXT_NOT_APPLICABLE);
        MAIN_STANDBY.put(0, "Disabled");
        MAIN_STANDBY.put(1, "MAIN");
        MAIN_STANDBY.put(2, "STANDBY");
        OVERVOLTAGE_ALARM.put(0, "Alarm");
        OVERVOLTAGE_ALARM.put(1, "No Alarm");
        STATION_ALARM.put(1, "Enabled");
        STATION_ALARM.put(2, "Disabled");
        ANALOG_INFRASTRUCTURE_STATE.put(0, "Failed");
        ANALOG_INFRASTRUCTURE_STATE.put(1, "Operational");
        ANALOG_INFRASTRUCTURE_STATE.put(2, "Link Check Disabled");
        ANALOG_INFRASTRUCTURE_STATE.put(15, "NOT CONFIGURED");
        this.nLastRepeaterActivitySetTime = 0L;
        this.nLastReceiverActivitySetTime = 0L;
        this.nLastTransmitterActivitySetTime = 0L;
        this.m_transmitterDisableBtn = new JButton(m_transmitterDisableLblStr);
        this.m_receiverDisableBtn = new JButton(m_receiverDisableLblStr);
        this.m_oSetChannelTimerListener = new GenericListener();
        LOG.enter("BrStationStatusPanel", new Object[]{brStatusPanelScreen});
        this.m_statusPanelScreen = brStatusPanelScreen;
        LOG.exit("BrStationStatusPanel");
    }

    public void setStationCommandTab(StationCommandTab stationCommandTab) {
        this.m_StationCommandTab = stationCommandTab;
    }

    public GenericListener getSetChannelTimerListener() {
        return this.m_oSetChannelTimerListener;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        Serializable serializable;
        JComponent jComponent4;
        Serializable serializable2;
        JComponent jComponent5;
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        int n = 165;
        int n2 = 15;
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Station Configuration");
        jPanel.setBorder(titledBorder);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)4, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Status Message");
        jPanel3.setBorder(titledBorder2);
        GridBagAdder.add((Container)this, (Component)jPanel3, (int)0, (int)5, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagAdder.add((Container)jPanel, (Component)jPanel4, (int)0, (int)5, (double)2.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)0, (int)0);
        Ticker ticker = TickerFactory.getServiceTicker();
        JLabel jLabel = new JLabel();
        jLabel.setText(STATION_OPERATION_MODE);
        jLabel.setToolTipText("Current state of the operation mode of the station.");
        jLabel.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_stationOperationModeLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationOperationModeLbl.setText(N_A);
        this.m_stationOperationModeLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationOperationModeLbl, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(STATION_USAGE);
        jLabel2.setToolTipText("Current state of the usage of the station.");
        jLabel2.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel2, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_stationUsageLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationUsageLbl.setText(N_A);
        this.m_stationUsageLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationUsageLbl, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(STATION_TIME);
        jLabel3.setToolTipText("Time stored in the station.");
        jLabel3.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel3, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_stationTimeLbl = new JLabel("00:00:00");
        this.m_stationTimeLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationTimeLbl, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(STATION_DATE);
        jLabel4.setToolTipText("Date stored in the station.");
        jLabel4.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel4, (int)0, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)0, (int)0);
        this.m_stationDateLbl = new JLabel("1970-01-01");
        this.m_stationDateLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationDateLbl, (int)1, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        this.m_stationRepeaterStateLbl = new JLabel("Repeater State ");
        this.m_stationRepeaterStateLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterStateLbl, (int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        this.m_stationRepeaterStateLbl.setToolTipText("Current repeater state of the station.");
        this.m_stationRepeaterStateValueLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationRepeaterStateValueLbl.setText(N_A);
        this.m_stationRepeaterStateValueLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterStateValueLbl, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)0, (int)0);
        this.m_stationRepeaterActStateLbl = new JLabel("Repeater Activity State ");
        this.m_stationRepeaterActStateValueLbl = new JLabel(N_A);
        if (this.m_statusPanelScreen.isHpdOrConvBrApplication()) {
            this.m_stationRepeaterActStateLbl.setPreferredSize(new Dimension(n, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterActStateLbl, (int)2, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            this.m_stationRepeaterActStateLbl.setToolTipText("Current repeater activity state of the station.");
            this.m_stationRepeaterActStateValueLbl.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterActStateValueLbl, (int)3, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        }
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jComponent5 = new JLabel("Scan Activity");
            jComponent5.setToolTipText("Current scan activity state of the station.");
            jComponent5.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)jComponent5, (int)2, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            this.m_labScanActivityValue = new JLabel(N_A);
            this.m_labScanActivityValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labScanActivityValue, (int)3, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            serializable2 = new JLabel("Scan Channel");
            ((JComponent)serializable2).setToolTipText("Current scan channel of the station.");
            ((JComponent)serializable2).setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)serializable2, (int)2, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            this.m_labScanChannelValue = new JLabel(N_A);
            this.m_labScanChannelValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labScanChannelValue, (int)3, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            jComponent4 = new JLabel("Main/Standby");
            jComponent4.setToolTipText("Current Main/Standby state.");
            jComponent4.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)jComponent4, (int)0, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)5, (int)0);
            this.m_labMainStandbyValue = new JLabel(N_A);
            this.m_labMainStandbyValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labMainStandbyValue, (int)1, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            serializable = new JLabel("Over Voltage Alarm");
            ((JComponent)serializable).setToolTipText("Current Over Voltage Alarm state.");
            ((JComponent)serializable).setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)serializable, (int)0, (int)5, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)5, (int)0);
            this.m_labOverVoltageAlarmValue = new JLabel(N_A);
            this.m_labOverVoltageAlarmValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labOverVoltageAlarmValue, (int)1, (int)5, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            jComponent3 = new JLabel("Station Alarms");
            jComponent3.setToolTipText("Current Station Alarms state.");
            jComponent3.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)jComponent3, (int)0, (int)6, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)5, (int)0);
            this.m_labStationAlarmValue = new JLabel(N_A);
            this.m_labStationAlarmValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labStationAlarmValue, (int)1, (int)6, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        }
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jComponent5 = new JLabel("Analog Link State");
            jComponent5.setToolTipText("Current Analog Link state.");
            jComponent5.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)jComponent5, (int)2, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
            this.m_labAnalogInfrastructureStateValue = new JLabel(N_A);
            this.m_labAnalogInfrastructureStateValue.setPreferredSize(new Dimension(n / 3, n2));
            GridBagAdder.add((Container)jPanel4, (Component)this.m_labAnalogInfrastructureStateValue, (int)3, (int)4, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        }
        jComponent5 = new JPanel();
        jComponent5.setLayout(new GridBagLayout());
        serializable2 = BorderFactory.createTitledBorder("Channel");
        jComponent5.setBorder((Border)((Object)serializable2));
        this.m_labCurrentPersonality = new JLabel(TEXT_CURRENT_PERSONALITY);
        GridBagAdder.add((Container)jComponent5, (Component)this.m_labCurrentPersonality, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)10, (int)2, (int)5, (int)0);
        this.m_labCurrentPersonalityValue = new JLabel(N_A);
        GridBagAdder.add((Container)jComponent5, (Component)this.m_labCurrentPersonalityValue, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        this.m_labSetPersonality = new JLabel(TEXT_SET_PERSONALITY);
        GridBagAdder.add((Container)jComponent5, (Component)this.m_labSetPersonality, (int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        this.m_labSetPersonality.setToolTipText(TEXT_SET_PERSONALITY);
        this.m_txtSetPersonality = new CSSJTextField(EMPTY);
        this.m_txtSetPersonality.setColumns(10);
        GridBagAdder.add((Container)jComponent5, (Component)this.m_txtSetPersonality, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            GridBagAdder.add((Container)this, (Component)jComponent5, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        }
        jComponent4 = new JPanel();
        jComponent4.setLayout(new GridBagLayout());
        serializable = BorderFactory.createTitledBorder("Analog Rx Qualifier");
        jComponent4.setBorder((Border)((Object)serializable));
        this.m_comboRxQualifier = new CSSJComboBox();
        this.m_comboRxQualifier.setModel(new DefaultComboBoxModel<Object>(RX_QUALIFIERS.values().toArray()));
        this.m_comboRxQualifier.setToolTipText("Set the state of the Rx Qualifiers in the station");
        jComponent4.add((Component)this.m_comboRxQualifier);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            GridBagAdder.add((Container)this, (Component)jComponent4, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        }
        jComponent3 = new JPanel();
        jComponent3.setLayout(new GridBagLayout());
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Local Speaker Control");
        jComponent3.setBorder(titledBorder3);
        this.m_labSetSpeakerVolume = new JLabel(TEXT_SET_SPEAKER_VOLUME);
        GridBagAdder.add((Container)jComponent3, (Component)this.m_labSetSpeakerVolume, (int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        this.m_spinSpeakerVolume = new CSSJSpinner();
        this.m_labSpinModel = new SpinnerNumberModel();
        this.m_labSpinModel.setMinimum(new Integer(0));
        this.m_labSpinModel.setMaximum(new Integer(20));
        this.m_labSpinModel.setStepSize(1);
        this.updateSpeakerLevel(10);
        this.m_spinSpeakerVolume.setModel((SpinnerModel)this.m_labSpinModel);
        this.m_labSetSpeakerVolume.setToolTipText("Set Speaker Volume");
        GridBagAdder.add((Container)jComponent3, (Component)this.m_spinSpeakerVolume, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)2, (int)3, (int)2, (int)5, (int)0);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            GridBagAdder.add((Container)this, (Component)jComponent3, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Intercom State");
        jPanel5.setBorder(titledBorder4);
        this.m_chkIntercom = new JCheckBox();
        this.m_chkIntercom.setText("Intercom State");
        this.m_chkIntercom.setToolTipText("Intercom State");
        jPanel5.add(this.m_chkIntercom);
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            GridBagAdder.add((Container)this, (Component)jPanel5, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)3, (int)10, (int)3, (int)10, (int)0);
        }
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        TitledBorder titledBorder5 = BorderFactory.createTitledBorder("Transmitter Operation");
        jPanel6.setBorder(titledBorder5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        Object[][] objectArray = this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isConvBrApplication() ? new Object[][]{{TRANSMITTER, N_A}, {TRANSMITTER_ACTIVITY, N_A}} : new Object[][]{{TRANSMITTER, N_A}, {P2_TRANSMITTER_SLOT1, N_A}, {P2_TRANSMITTER_SLOT2, N_A}};
        Object[] objectArray2 = new String[]{"Object Name", "State"};
        this.m_transmitterOperationModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_transmitterOperationTable = new JTable(this.m_transmitterOperationModel);
        this.m_transmitterOperationTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.m_transmitterOperationTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(170);
        tableColumn.setCellRenderer(new InsetsFormatCellRenderer());
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setPreferredWidth(130);
        tableColumn2.setCellRenderer(new InsetsFormatCellRenderer());
        this.m_transmitterOperationTable.setEnabled(false);
        this.m_transmitterOperationTable.setShowHorizontalLines(true);
        this.m_transmitterOperationTable.setShowVerticalLines(true);
        JTableHeader jTableHeader = this.m_transmitterOperationTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        int n3 = this.m_transmitterOperationTable.getRowCount();
        for (int i = 0; i < n3; ++i) {
            JTextField jTextField = (JTextField)this.m_transmitterOperationTable.getCellEditor(i, 0).getTableCellEditorComponent(this.m_transmitterOperationTable, null, true, i, 0);
            jTextField.setEnabled(false);
            jTextField = (JTextField)this.m_transmitterOperationTable.getCellEditor(i, 1).getTableCellEditorComponent(this.m_transmitterOperationTable, null, true, i, 1);
            jTextField.setEnabled(false);
        }
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Object Name.");
        }
        if ((tableCellRenderer = tableColumn2.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("State.");
        }
        this.m_transmitterOperationTable.setBorder(BorderFactory.createBevelBorder(1));
        this.m_transmitterOperationTable.repaint();
        JScrollPane jScrollPane = new JScrollPane(this.m_transmitterOperationTable);
        jScrollPane.setPreferredSize(new Dimension(320, 90));
        jPanel7.add(jScrollPane);
        jPanel7.setEnabled(false);
        JPanel jPanel8 = null;
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jPanel8 = new JPanel();
            jPanel8.setLayout(new GridLayout(1, 2, 10, 10));
            jComponent2 = new JLabel("Transmit Source");
            jComponent2.setToolTipText("Current transmit source of the station.");
            jPanel8.add(jComponent2);
            this.m_labTransmitSourceValue = new JLabel(N_A);
            jPanel8.add(this.m_labTransmitSourceValue);
        }
        jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_transmitterNetworkAccessCodeColorCodeLabel = new TimeSuspendedJLabel(ticker);
        this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
        this.m_transmitterNetworkAccessCodeColorCodeLabel.setToolTipText("Network access code or Color Code of the transmitter.");
        jComponent2.add(this.m_transmitterNetworkAccessCodeColorCodeLabel);
        this.m_txNetworkAccessCodeLbl = new TimeSuspendedJLabel(ticker);
        this.m_txNetworkAccessCodeLbl.setText(N_A);
        jComponent2.add(this.m_txNetworkAccessCodeLbl);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_labTxPlDpl = new JLabel(TEXT_TX_PL_DPL);
        this.m_labTxPlDpl.setToolTipText("Transmitter PL/DPL");
        this.m_labTxPlDpl.setText(TEXT_TX_PL_DPL);
        jPanel9.add(this.m_labTxPlDpl);
        this.m_labTxPlDplCode = new JLabel(N_A);
        jPanel9.add(this.m_labTxPlDplCode);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        this.m_transmitterDisableBtn.setToolTipText("Enables or disables the transmitter.");
        this.m_transmitterDisableBtn.setPreferredSize(new Dimension(145, 20));
        jPanel10.add(this.m_transmitterDisableBtn);
        if (this.m_statusPanelScreen.isHPDApplication() || CSSUtilities.isApplicationRxOnly()) {
            this.m_transmitterDisableBtn.setEnabled(false);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 0);
        gridBagConstraints.anchor = 18;
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel6.add((Component)jComponent2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jPanel6.add((Component)jPanel9, gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (jPanel8 != null) {
                jPanel6.add((Component)jPanel8, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
        }
        jPanel6.add((Component)jPanel10, gridBagConstraints);
        jPanel6.repaint();
        jPanel2.add(jPanel6);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        TitledBorder titledBorder6 = BorderFactory.createTitledBorder("Receiver Operation");
        jPanel11.setBorder(titledBorder6);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        Object[][] objectArray3 = this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isConvBrApplication() ? new Object[][]{{RECEIVER, N_A}, {RECEIVER_ACTIVITY, N_A}} : new Object[][]{{RECEIVER, N_A}, {P2_RECEIVER_SLOT1, N_A}, {P2_RECEIVER_SLOT2, N_A}};
        Object[] objectArray4 = new String[]{"Object Name", "State"};
        this.m_receiverOperationModel = new DefaultTableModel(objectArray3, objectArray4);
        this.m_receiverOperationTable = new JTable(this.m_receiverOperationModel);
        this.m_receiverOperationTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel2 = this.m_receiverOperationTable.getColumnModel();
        TableColumn tableColumn3 = tableColumnModel2.getColumn(0);
        tableColumn3.setPreferredWidth(170);
        tableColumn3.setCellRenderer(new InsetsFormatCellRenderer());
        TableColumn tableColumn4 = tableColumnModel2.getColumn(1);
        tableColumn4.setPreferredWidth(130);
        tableColumn4.setCellRenderer(new InsetsFormatCellRenderer());
        this.m_receiverOperationTable.setEnabled(false);
        this.m_receiverOperationTable.setShowHorizontalLines(true);
        this.m_receiverOperationTable.setShowVerticalLines(true);
        JTableHeader jTableHeader2 = this.m_receiverOperationTable.getTableHeader();
        jTableHeader2.setReorderingAllowed(false);
        int n4 = this.m_receiverOperationTable.getRowCount();
        for (int i = 0; i < n4; ++i) {
            JTextField jTextField = (JTextField)this.m_receiverOperationTable.getCellEditor(i, 0).getTableCellEditorComponent(this.m_receiverOperationTable, null, true, i, 0);
            jTextField.setEnabled(false);
            jTextField = (JTextField)this.m_receiverOperationTable.getCellEditor(i, 1).getTableCellEditorComponent(this.m_receiverOperationTable, null, true, i, 1);
            jTextField.setEnabled(false);
        }
        TableCellRenderer tableCellRenderer2 = tableColumn3.getHeaderRenderer();
        if (tableCellRenderer2 instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer2).setToolTipText("Object Name.");
        }
        if ((tableCellRenderer2 = tableColumn4.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer2).setToolTipText("State.");
        }
        this.m_receiverOperationTable.setBorder(BorderFactory.createBevelBorder(1));
        this.m_receiverOperationTable.repaint();
        JScrollPane jScrollPane2 = new JScrollPane(this.m_receiverOperationTable);
        jScrollPane2.setPreferredSize(new Dimension(320, 90));
        jPanel12.add(jScrollPane2);
        jPanel12.setEnabled(false);
        JPanel jPanel13 = null;
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jPanel13 = new JPanel();
            jPanel13.setLayout(new GridLayout(1, 2, 10, 10));
            jComponent = new JLabel("Subscriber ID");
            jComponent.setToolTipText("Current Subscriber ID.");
            jPanel13.add(jComponent);
            this.m_subscriberID = new JLabel(N_A);
            this.m_subscriberID.setPreferredSize(new Dimension(n / 3, n2));
            jPanel13.add(this.m_subscriberID);
        }
        jComponent = new JPanel();
        jComponent.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_receiverNetworkAccessCodeColorCodeLabel = new TimeSuspendedJLabel(ticker);
        this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
        this.m_receiverNetworkAccessCodeColorCodeLabel.setToolTipText("Network access code or Color Code of the receiver.");
        jComponent.add(this.m_receiverNetworkAccessCodeColorCodeLabel);
        this.m_rxNetworkAccessCodeLbl = new TimeSuspendedJLabel(ticker);
        this.m_rxNetworkAccessCodeLbl.setText(N_A);
        jComponent.add(this.m_rxNetworkAccessCodeLbl);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_labRxPlDpl = new JLabel(TEXT_RX_PL_DPL);
        this.m_labRxPlDpl.setText(TEXT_RX_PL_DPL);
        this.m_labRxPlDpl.setToolTipText("Receiver PL/DPL");
        jPanel14.add(this.m_labRxPlDpl);
        this.m_labRxPlDplCode = new JLabel(N_A);
        jPanel14.add(this.m_labRxPlDplCode);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        this.m_receiverDisableBtn.setToolTipText("Enables or disables the receiver.");
        this.m_receiverDisableBtn.setPreferredSize(new Dimension(145, 20));
        jPanel15.add(this.m_receiverDisableBtn);
        if (this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isRptrBrApplication()) {
            this.m_receiverDisableBtn.setEnabled(false);
        }
        gridBagConstraints.gridy = 0;
        jPanel11.add((Component)jPanel12, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel11.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            jPanel11.add((Component)jPanel14, gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (jPanel13 != null) {
                jPanel11.add((Component)jPanel13, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
        }
        jPanel11.add((Component)jPanel15, gridBagConstraints);
        jPanel11.repaint();
        jPanel2.add(jPanel11);
        Object[][] objectArray5 = new Object[][]{{EMPTY, EMPTY}};
        Object[] objectArray6 = new String[]{"Time", "Message"};
        this.m_model = new DefaultTableModel(objectArray5, objectArray6);
        this.m_statusTable = new JTable(this.m_model);
        this.m_statusTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel3 = this.m_statusTable.getColumnModel();
        TableColumn tableColumn5 = tableColumnModel3.getColumn(0);
        tableColumn5.setPreferredWidth(130);
        TableColumn tableColumn6 = tableColumnModel3.getColumn(1);
        tableColumn6.setPreferredWidth(480);
        this.m_statusTable.setShowHorizontalLines(true);
        this.m_statusTable.setShowVerticalLines(true);
        JTableHeader jTableHeader3 = this.m_statusTable.getTableHeader();
        jTableHeader3.setReorderingAllowed(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.m_statusTable);
        jScrollPane3.setPreferredSize(new Dimension(620, 100));
        jPanel3.add(jScrollPane3);
        JTextField jTextField = (JTextField)this.m_statusTable.getCellEditor(0, 0).getTableCellEditorComponent(this.m_statusTable, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_statusTable.getCellEditor(0, 0).getTableCellEditorComponent(this.m_statusTable, null, true, 0, 1);
        jTextField.setEnabled(false);
        tableColumn5 = this.m_statusTable.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer3 = tableColumn5.getHeaderRenderer();
        if (tableCellRenderer3 instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer3).setToolTipText("Time.");
        }
        if ((tableCellRenderer3 = (tableColumn6 = this.m_statusTable.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer3).setToolTipText("Message.");
        }
        statusBarListener.registerComponent((Component)this.m_receiverDisableBtn, "Click this button to enable/disable the Receiver.");
        statusBarListener.registerComponent((Component)this.m_transmitterDisableBtn, "Click this button to enable/disable the Transmitter.");
        statusBarListener.registerComponent((Component)this.m_txtSetPersonality, "Set Channel, RANGE: 1 - 16.");
        statusBarListener.registerComponent((Component)((JSpinner.NumberEditor)this.m_spinSpeakerVolume.getEditor()).getTextField(), "Set Speaker Volume Level, RANGE: 0 - 20 dB.");
        statusBarListener.registerComponent((Component)this.m_chkIntercom, "Set Intercom On/Off");
        this.initialize();
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        this.m_stationOperationModeLbl.setText(N_A);
        this.setTransmitterTableValue(N_A, 0);
        this.setTransmitterTableValue(N_A, 1);
        this.setReceiverTableValue(N_A, 0);
        this.setReceiverTableValue(N_A, 1);
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            this.setTransmitterTableValue(N_A, 2);
            this.setReceiverTableValue(N_A, 2);
        }
        this.m_stationUsageLbl.setText(N_A);
        this.m_rxNetworkAccessCodeLbl.setText(N_A);
        this.m_txNetworkAccessCodeLbl.setText(N_A);
        this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
        this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
        this.m_stationTimeLbl.setText(N_A);
        this.m_stationDateLbl.setText(N_A);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        this.m_stationRepeaterStateValueLbl.setText(N_A);
        this.m_stationRepeaterActStateValueLbl.setText(N_A);
        LOG.exit("initialize");
    }

    public ErrorLogUtility getErrorLogUtility() {
        LOG.enter("getErrorLogUtility");
        LOG.exit("getErrorLogUtility");
        return this.m_errorLogUtility;
    }

    public void updateTransmitterEnable(int n) {
        LOG.enter("updateTransmitterEnable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_transmitterDisableBtn.setText(m_transmitterDisableLblStr);
            this.setTransmitterTableValue(ENABLED, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Transmitter = : " + this.getTransmitterTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateTransmitterEnable - Error on updating the transmitter state");
            this.m_statusPanelScreen.popupError(-327730);
        }
        LOG.exit("updateTransmitterEnable");
    }

    public void updateTransmitterDisable(int n) {
        LOG.enter("updateTransmitterDisable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
            this.setTransmitterTableValue(INHIBIT, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Transmitter = : " + this.getTransmitterTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateTransmitterDisable - Error on updating the transmitter state");
            this.m_statusPanelScreen.popupError(-327730);
        }
        LOG.exit("updateTransmitterDisable");
    }

    public void updateReceiverEnable(int n) {
        LOG.enter("updateReceiverEnable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_receiverDisableBtn.setText(m_receiverDisableLblStr);
            this.setReceiverTableValue(ENABLED, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Receiver = : " + this.getReceiverTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateReceiverEnable - Error on updating the receiver state");
            this.m_statusPanelScreen.popupError(-327731);
        }
        LOG.exit("updateReceiverEnable");
    }

    public void updateReceiverDisable(int n) {
        LOG.enter("updateReceiverDisable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
            this.setReceiverTableValue(INHIBIT, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Receiver = : " + this.getReceiverTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateReceiverDisable - Error on updating the receiver state");
            this.m_statusPanelScreen.popupError(-327731);
        }
        LOG.exit("updateReceiverDisable");
    }

    public void updateStationConfiguration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray, byte[] byArray2, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, byte[] byArray3) {
        LOG.enter("updateStationConfiguration", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byArray, byArray2});
        this.updateStationOperationalMode(n);
        this.updateStationUsage(n2);
        this.updateTransmitterOperationalState(n3);
        this.updateReceiverOperationalState(n4);
        this.updateTransmitterActivity(n5, 1);
        this.updateReceiverActivity(n6, 1);
        this.updateTxNetworkAccessCode(n7);
        this.updateRepeaterState(n8);
        this.updateRepeaterActivity(n9);
        this.updateRxNetworkAccessCode(n10);
        this.updateRxPlDpl(byArray2);
        this.updateTxPlDpl(byArray);
        this.updateChannelPersonality(n11);
        this.updateScanState(n12);
        this.updateScanChannel(n13);
        this.updateTransmitSource(n14);
        this.updateMainStandby(n15);
        this.updateSpeakerLevel(n16);
        this.setIntercomState(n17 == 1);
        this.updateOverVoltageAlarm(n18);
        this.updateStationAlarm(n19);
        this.updateAnalogInfrastructureState(n20);
        this.updateSubscriberID(byArray3);
        this.updateRxQualifiers(n21);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateStationConfiguration");
    }

    public void updateTdmaStationConfiguration(int n, int n2) {
        LOG.enter("updateTdmaStationConfiguration", new Object[]{n, n2});
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            this.updateTransmitterActivity(n, 2);
            this.updateReceiverActivity(n2, 2);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateTdmaStationConfiguration");
    }

    public boolean isTransmitterEnable() {
        LOG.enter("isTransmitterEnable");
        boolean bl = false;
        String string = this.m_transmitterDisableBtn.getText();
        if (string.equalsIgnoreCase(m_transmitterDisableLblStr)) {
            bl = true;
        }
        LOG.exit("isTransmitterEnable", (Object)bl);
        return bl;
    }

    public boolean isReceiverEnable() {
        LOG.enter("isReceiverEnable");
        boolean bl = false;
        String string = this.m_receiverDisableBtn.getText();
        if (string.equalsIgnoreCase(m_receiverDisableLblStr)) {
            bl = true;
        }
        LOG.exit("isReceiverEnable", (Object)bl);
        return bl;
    }

    public void writeInitialDataToFile() {
        LOG.enter("writeInitialDataToFile");
        String string = "            INITIAL STATION STATUS AT LOG TIME:         \n";
        string = string + "=================================================================================" + "\n";
        string = string + "Station Operational Mode: " + this.m_stationOperationModeLbl.getText() + "\n";
        string = string + "Transmitter State: " + this.getTransmitterTableValue(0) + "\n";
        string = this.m_statusPanelScreen.isConvBrApplication() ? string + "Transmitter Activity: " : string + "TA - FDMA/TDMA logical channel 0: ";
        string = string + this.getTransmitterTableValue(1) + "\n";
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            string = string + "TA - TDMA logical channel 1: " + this.getTransmitterTableValue(2) + "\n";
        }
        string = string + "Transmitter Network Access Code: " + this.m_txNetworkAccessCodeLbl.getText() + "\n";
        string = string + "Station Usage: " + this.m_stationUsageLbl.getText() + "\n";
        string = string + "Receiver State: " + this.getReceiverTableValue(0) + "\n";
        string = this.m_statusPanelScreen.isConvBrApplication() ? string + "Receiver Activity: " : string + "RA - FDMA/TDMA logical channel 0: ";
        string = string + this.getReceiverTableValue(1) + "\n";
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            string = string + "RA - TDMA logical channel 1: " + this.getTransmitterTableValue(2) + "\n";
        }
        string = string + "Receiver Network Access Code: " + this.m_rxNetworkAccessCodeLbl.getText() + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "\n" + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "            REAL TIME UPDATE :         " + "\n";
        string = string + "=================================================================================" + "\n";
        this.m_statusPanelScreen.appendString(string);
        LOG.exit("writeInitialDataToFile");
    }

    public boolean updateRealTimeData(Object object) {
        LOG.enter("updateRealTimeData", new Object[]{object});
        boolean bl = true;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        String string = null;
        byte[] byArray = new byte[4];
        int n = 0;
        Integer n2 = null;
        int n3 = 0;
        try {
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase("ExciterState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationOperationalMode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("StationOperationalMode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationOperationalMode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterOperationalState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterOperationalState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterActivity")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterActivity(Convert.toInteger((byte[])byArray), 1);
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterActivitySlot2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterActivity(Convert.toInteger((byte[])byArray), 2);
                    continue;
                }
                if (string.equalsIgnoreCase("NetworkAccessCode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTxNetworkAccessCode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("StationUsage")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationUsage(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverOperationalState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverOperationalState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverActivity")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverActivity(Convert.toInteger((byte[])byArray), 1);
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverActivitySlot2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverActivity(Convert.toInteger((byte[])byArray), 2);
                    continue;
                }
                if (string.equalsIgnoreCase("RepeaterState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRepeaterState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RepeaterActivityState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRepeaterActivity(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RxAccessCode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxNetworkAccessCode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("FaultMessage")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n2 = Convert.toInteger((byte[])byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("EpochTime")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n3 = Convert.toInteger((byte[])byArray);
                    this.updateStationTime(n3);
                    continue;
                }
                if (string.equalsIgnoreCase("NumOfBytes")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n = Convert.toInteger((byte[])byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("TxPlDpl")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTxPlDpl(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("RxPlDpl")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxPlDpl(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("OverVoltageAlarm")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateOverVoltageAlarm(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("StationAlarm")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationAlarm(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("GetSubscriberID")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateSubscriberID(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("AnalogInfrastructureState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateAnalogInfrastructureState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("AnalogRXQualifiers")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxQualifiers(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("X")) {
                    int[] nArray = null;
                    if (n != 0) {
                        nArray = new int[n];
                        byte[] byArray2 = new byte[n * 4];
                        byte[] byArray3 = new byte[4];
                        int n4 = 0;
                        int n5 = 0;
                        byArray2 = (byte[])realTimeDataObject.getValue(string);
                        while (n4 < byArray2.length) {
                            for (int j = 0; j < 4; ++j) {
                                byArray3[j] = byArray2[n4];
                                ++n4;
                            }
                            nArray[n5] = Convert.toInteger((byte[])byArray3);
                            ++n5;
                        }
                    }
                    this.updateStatusPanelTable(n2, n3, n, nArray);
                    continue;
                }
                if (string.equalsIgnoreCase("sGetChannelPersonality")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateChannelPersonality(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetScanState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateScanState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetScanChannel")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateScanChannel(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetTransmitSource")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitSource(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetMainStandby")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateMainStandby(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetSpeakerLevel")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateSpeakerLevel(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetIntercomState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.setIntercomState(Convert.toInteger((byte[])byArray) == 1);
                    continue;
                }
                if (string.equalsIgnoreCase("sGetOverVoltageAlarm")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateOverVoltageAlarm(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetStationAlarm")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationAlarm(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("sGetAnalogInfrastructureState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateAnalogInfrastructureState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                bl = false;
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateRealTimeData - exception ", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData", (Object)bl);
        return bl;
    }

    private void updateStationTime(int n) {
        LOG.enter("updateStationTime", new Object[]{n});
        String string = null;
        String string2 = null;
        string2 = DateAndTimeConversion.getTime((int)n);
        string = DateAndTimeConversion.getDate((int)n);
        this.m_stationTimeLbl.setText(string2);
        this.m_stationDateLbl.setText(string);
        LOG.exit("updateStationTime");
    }

    private void updateStationOperationalMode(int n) {
        LOG.enter("updateStationOperationalMode", new Object[]{n});
        String string = STATIONOPERATIONALMODE.get(new Integer(n));
        if (null != string) {
            this.m_stationOperationModeLbl.setText(string);
        } else {
            this.m_stationOperationModeLbl.setText("UNKNOWN");
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
        this.m_statusPanelScreen.appendString("StationOperationalMode = : " + this.m_stationOperationModeLbl.getText() + "\n");
        LOG.exit("updateStationOperationalMode");
    }

    private void updateTransmitterOperationalState(int n) {
        LOG.enter("updateTransmitterOperationalState", new Object[]{n});
        String string = TRANSMITTEROPERATIONALSTATE.get(new Integer(n));
        if (null != string) {
            this.setTransmitterTableValue(string, 0);
            if (string.equalsIgnoreCase(INHIBIT)) {
                this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
            } else {
                this.m_transmitterDisableBtn.setText(m_transmitterDisableLblStr);
            }
        } else {
            this.setTransmitterTableValue("UNKNOWN", 0);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Operational State = : " + this.getTransmitterTableValue(0) + "\n");
        LOG.exit("updateTransmitterOperationalState");
    }

    private void updateTransmitterActivity(int n, int n2) {
        long l;
        LOG.enter("updateTransmitterActivity", new Object[]{n, n2});
        HashMap<Integer, String> hashMap = n2 == 1 ? (this.m_statusPanelScreen.isMsbrApplication() ? TRANSMITTERACTIVITYSLOT1MSBR : TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR) : TRANSMITTERACTIVITYSLOT2;
        String string = hashMap.get(new Integer(n));
        if (n == 0 && this.getTransmitterTableValue(1).equalsIgnoreCase(TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.get(12)) && (l = System.currentTimeMillis() - this.nLastTransmitterActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.getTransmitterTableValue(1).equalsIgnoreCase((String)TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.get(12))) {
                        BrStationStatusPanel.this.setTransmitterTableValue(BrStationStatusPanel.IDLE, 1);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("Transmitter Activity = : " + BrStationStatusPanel.this.getTransmitterTableValue(1) + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateTransmitterActivity with timer running");
            return;
        }
        if (null != string) {
            this.setTransmitterTableValue(string, n2);
        } else {
            this.setTransmitterTableValue("UNKNOWN", n2);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Activity = : " + this.getTransmitterTableValue(n2) + "\n");
        this.nLastTransmitterActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateTransmitterActivity");
    }

    private void updateStationUsage(int n) {
        LOG.enter("updateStationUsage", new Object[]{n});
        String string = STATIONUSAGE.get(new Integer(n));
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            string = CONVENTIONAL;
        }
        if (null != string) {
            this.m_stationUsageLbl.setText(string);
        } else {
            this.m_stationUsageLbl.setText("UNKNOWN");
            LOG.warn((Object)("Unknown value: " + n));
        }
        if (8 == n) {
            if (2 == m_nTdmaMode) {
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
                this.m_rxNetworkAccessCodeLbl.setText(N_A);
                this.m_rxNetworkAccessCodeLbl.setEnabled(false);
                this.m_txNetworkAccessCodeLbl.setText(N_A);
                this.m_txNetworkAccessCodeLbl.setEnabled(false);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(false);
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(false);
            } else {
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_COLOR_CODE);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_COLOR_CODE);
                this.m_rxNetworkAccessCodeLbl.setEnabled(true);
                this.m_txNetworkAccessCodeLbl.setEnabled(true);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(true);
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(true);
            }
        } else {
            this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
            this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
            this.m_rxNetworkAccessCodeLbl.setEnabled(true);
            this.m_txNetworkAccessCodeLbl.setEnabled(true);
            this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(true);
            this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(true);
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("StationUsage = : " + this.m_stationUsageLbl.getText() + "\n");
        LOG.exit("updateStationUsage");
    }

    private void updateReceiverOperationalState(int n) {
        LOG.enter("updateReceiverOperationalState", new Object[]{n});
        String string = RECEIVEROPERATIONALSTATE.get(new Integer(n));
        if (null != string) {
            this.setReceiverTableValue(string, 0);
            if (string.equalsIgnoreCase(INHIBIT)) {
                this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
            } else {
                this.m_receiverDisableBtn.setText(m_receiverDisableLblStr);
            }
        } else {
            this.setReceiverTableValue("UNKNOWN", 0);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Operational State = : " + this.getReceiverTableValue(0) + "\n");
        LOG.exit("updateReceiverOperationalState");
    }

    private void updateReceiverActivity(int n, int n2) {
        long l;
        LOG.enter("updateReceiverActivity", new Object[]{n, n2});
        HashMap<Integer, String> hashMap = n2 == 1 ? RECEIVERACTIVITYSLOT1 : RECEIVERACTIVITYSLOT2;
        String string = hashMap.get(new Integer(n));
        if (n == 0 && this.getReceiverTableValue(1).equalsIgnoreCase(RECEIVERACTIVITYSLOT1.get(12)) && (l = System.currentTimeMillis() - this.nLastReceiverActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.getReceiverTableValue(1).equalsIgnoreCase((String)REPEATERACTIVITYSTATE.get(12))) {
                        BrStationStatusPanel.this.setReceiverTableValue(BrStationStatusPanel.IDLE, 1);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("ReceiverActivity = : " + BrStationStatusPanel.this.getReceiverTableValue(1) + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateReceiverActivity with timer running");
            return;
        }
        if (null != string) {
            this.setReceiverTableValue(string, n2);
        } else {
            this.setReceiverTableValue("UNKNOWN", n2);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("ReceiverActivity = : " + this.getReceiverTableValue(n2) + "\n");
        this.nLastReceiverActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateReceiverActivity");
    }

    public void updateRepeaterState(int n) {
        LOG.enter("updateRepeaterState", new Object[]{n});
        String string = null;
        if (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isHPDApplication()) {
            string = DISABLED;
        } else if (this.m_statusPanelScreen.isRptrBrApplication()) {
            string = REPEATER_SET_UP;
        } else {
            if (this.m_StationCommandTab != null) {
                string = REPEATERSTATE.get(n);
                switch (n) {
                    case 3: {
                        this.m_StationCommandTab.getClass();
                        this.m_StationCommandTab.setRepeatMode(0);
                        break;
                    }
                    case 2: {
                        this.m_StationCommandTab.getClass();
                        this.m_StationCommandTab.setRepeatMode(1);
                    }
                }
            }
            if (null == string) {
                string = N_A;
            }
        }
        if (this.m_statusPanelScreen.isServiceMode() && (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication())) {
            string = EMPTY;
        }
        this.m_stationRepeaterStateValueLbl.setText(string);
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Repeater State = : " + this.m_stationRepeaterStateValueLbl.getText() + "\n");
        LOG.exit("updateRepeaterState");
    }

    private void updateRepeaterActivity(int n) {
        long l;
        LOG.enter("updateRepeaterActivity", new Object[]{n});
        String string = REPEATERACTIVITYSTATE.get(n);
        if (n == 0 && this.m_stationRepeaterActStateValueLbl.getText().equalsIgnoreCase(REPEATERACTIVITYSTATE.get(12)) && (l = System.currentTimeMillis() - this.nLastRepeaterActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.getText().equalsIgnoreCase((String)REPEATERACTIVITYSTATE.get(12))) {
                        BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.setText(BrStationStatusPanel.IDLE);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("Repeater Activity State = : " + BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.getText() + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateRepeaterActivity with timer running");
            return;
        }
        if (null == string) {
            string = N_A;
        }
        if (this.m_statusPanelScreen.isServiceMode() && (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication())) {
            this.m_stationRepeaterActStateValueLbl.setText(EMPTY);
        } else {
            this.m_stationRepeaterActStateValueLbl.setText(string);
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Repeater Activity State = : " + this.m_stationRepeaterActStateValueLbl.getText() + "\n");
        this.nLastRepeaterActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateRepeaterActivity");
    }

    private void updateTxNetworkAccessCode(int n) {
        LOG.enter("updateTxNetworkAccessCode", new Object[]{n});
        if (this.m_statusPanelScreen.isServiceMode() && (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication())) {
            this.m_txNetworkAccessCodeLbl.setText(EMPTY);
        } else {
            this.m_txNetworkAccessCodeLbl.setText(IntegerFormat.addLeadingZeros((String)Integer.toHexString(n), (int)3));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Network Access Code = : " + this.m_txNetworkAccessCodeLbl.getText() + "\n");
        LOG.exit("updateTxNetworkAccessCode");
    }

    private void updateRxNetworkAccessCode(int n) {
        LOG.enter("updateRxNetworkAccessCode", new Object[]{n});
        if (this.m_statusPanelScreen.isServiceMode() && (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.isRptrBrApplication())) {
            this.m_rxNetworkAccessCodeLbl.setText(EMPTY);
        } else {
            this.m_rxNetworkAccessCodeLbl.setText(IntegerFormat.addLeadingZeros((String)Integer.toHexString(n), (int)3));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Network Access Code = : " + this.m_rxNetworkAccessCodeLbl.getText() + "\n");
        LOG.exit("updateRxNetworkAccessCode");
    }

    private void updateStatusPanelTable(Integer n, int n2, int n3, int[] nArray) {
        LOG.enter("updateStatusPanelTable", new Object[]{n, n2, n3, nArray});
        String string = EMPTY;
        String string2 = EMPTY;
        String string3 = EMPTY;
        String string4 = this.m_errorLogUtility.getErrorCode(n.toString());
        string = DateAndTimeConversion.getTime((int)n2);
        string2 = DateAndTimeConversion.getDate((int)n2);
        String string5 = string2 + " " + string;
        String string6 = EMPTY;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "_");
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            string3 = string3 + string6 + " ";
        }
        if (n3 != 0) {
            string3 = string3 + "Values = " + " ";
            for (int i = 0; i < nArray.length; ++i) {
                string3 = string3 + String.valueOf(nArray[i]) + " ";
            }
        }
        if (((String)this.m_statusTable.getValueAt(0, 0)).equals(EMPTY)) {
            this.m_model.setValueAt(string5, 0, 0);
            this.m_model.setValueAt(string3, 0, 1);
        } else {
            this.m_model.addRow(new Object[]{string5, string3});
            this.m_statusTable.setModel(this.m_model);
        }
        String string7 = string5 + "\t" + string3 + "\n";
        this.m_statusPanelScreen.appendString(string7);
        LOG.exit("updateStatusPanelTable");
    }

    public String getDateAndTime() {
        LOG.enter("getDateAndTime");
        LOG.exit("getDateAndTime");
        return this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText();
    }

    private void setTransmitterTableValue(String string, int n) {
        LOG.enter("setTransmitterTableValue", new Object[]{string, n});
        this.m_transmitterOperationTable.setValueAt(string, n, 1);
        LOG.exit("setTransmitterTableValue");
    }

    private String getTransmitterTableValue(int n) {
        LOG.enter("getTransmitterTableValue", new Object[]{n});
        LOG.exit("getTransmitterTableValue");
        Object object = this.m_transmitterOperationTable.getValueAt(n, 1);
        return object.toString();
    }

    private void setReceiverTableValue(String string, int n) {
        LOG.enter("setReceiverTableValue", new Object[]{string, n});
        this.m_receiverOperationTable.setValueAt(string, n, 1);
        LOG.exit("setReceiverTableValue");
    }

    private String getReceiverTableValue(int n) {
        LOG.enter("getReceiverTableValue", new Object[]{n});
        Object object = this.m_receiverOperationTable.getValueAt(n, 1);
        LOG.exit("getReceiverTableValue");
        return object.toString();
    }

    public void handleTdmaMode(int n, Integer[] integerArray) {
        LOG.enter("handleTdmaMode", new Object[]{n, integerArray});
        if (n == 0) {
            try {
                m_nTdmaMode = integerArray[0];
            }
            catch (Exception exception) {
                LOG.error((Object)"updateObjectNames - TDMA Mode not in range", (Throwable)exception);
            }
        } else {
            LOG.warn((Object)"Unable to read TDMA Mode");
            this.m_statusPanelScreen.popupError(-327863);
        }
        LOG.exit("handleTdmaMode");
    }

    public void updateTxPlDpl(byte[] byArray) {
        if (this.m_statusPanelScreen.isServiceMode() && this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_labTxPlDplCode.setText(EMPTY);
        } else {
            this.m_labTxPlDplCode.setText(BrStationStatusPanel.createPlDplLabel(byArray));
        }
    }

    public void updateRxPlDpl(byte[] byArray) {
        if (this.m_statusPanelScreen.isServiceMode() && this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_labRxPlDplCode.setText(EMPTY);
        } else {
            this.m_labRxPlDplCode.setText(BrStationStatusPanel.createPlDplLabel(byArray));
        }
    }

    protected static String insertDecimalSeparator(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() == 1) {
            stringBuffer.insert(0, "0.");
        } else if (string.length() > 1) {
            stringBuffer.insert(string.length() - 1, '.');
        }
        return stringBuffer.toString();
    }

    protected static String createPlDplLabel(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(EMPTY);
        if (null != byArray && 3 == byArray.length) {
            stringBuffer.append(PL_DPL_TYPES.get(new Integer(byArray[0])));
            byte[] byArray2 = new byte[]{byArray[1], byArray[2]};
            Integer n = Convert.toInteger((byte[])byArray2);
            String string = Integer.toString(n);
            switch (byArray[0]) {
                case 2: {
                    String string2 = BrStationStatusPanel.insertDecimalSeparator(string);
                    String string3 = PL_TYPES.get(string2);
                    if (null != string3) {
                        stringBuffer.append(" " + string2 + PL_TYPES.get(string2));
                        break;
                    }
                    stringBuffer = new StringBuffer(N_A);
                    break;
                }
                case 3: {
                    String string4 = String.format("%03o", n);
                    stringBuffer.append(" " + string4);
                    break;
                }
                default: {
                    String string5 = BrStationStatusPanel.insertDecimalSeparator(string);
                    stringBuffer.append(" " + string5 + " Hz");
                    break;
                }
            }
        } else {
            stringBuffer.append(N_A);
            LOG.error((Object)"createPlDplLabel - invalid packet size");
        }
        return stringBuffer.toString();
    }

    private void updateChannelPersonality(int n) {
        this.m_labCurrentPersonalityValue.setText(Integer.toString(n));
    }

    private void updateScanState(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (this.m_statusPanelScreen.isServiceMode()) {
                this.m_labScanActivityValue.setText(SCAN_STATES.get(0));
            } else {
                this.m_labScanActivityValue.setText(SCAN_STATES.get(n));
            }
        }
    }

    private void updateScanChannel(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (n > 0) {
                if (this.m_statusPanelScreen.isServiceMode()) {
                    this.m_labScanChannelValue.setText(EMPTY);
                } else {
                    this.m_labScanChannelValue.setText(Integer.toString(n));
                }
            } else {
                this.m_labScanChannelValue.setText(EMPTY);
            }
        }
    }

    private void updateTransmitSource(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_labTransmitSourceValue.setText(TRANSMIT_SOURCE.get(n));
        }
    }

    private void updateMainStandby(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (this.m_statusPanelScreen.isServiceMode()) {
                this.m_labMainStandbyValue.setText(MAIN_STANDBY.get(0));
            } else {
                this.m_labMainStandbyValue.setText(MAIN_STANDBY.get(n));
            }
        }
    }

    private void updateOverVoltageAlarm(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_labOverVoltageAlarmValue.setText(OVERVOLTAGE_ALARM.get(n));
        }
    }

    private void updateStationAlarm(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_labStationAlarmValue.setText(STATION_ALARM.get(n));
        }
    }

    private void updateAnalogInfrastructureState(int n) {
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (this.m_statusPanelScreen.isServiceMode()) {
                this.m_labAnalogInfrastructureStateValue.setText(EMPTY);
            } else {
                this.m_labAnalogInfrastructureStateValue.setText(ANALOG_INFRASTRUCTURE_STATE.get(new Integer(n)));
            }
        }
    }

    private void updateSubscriberID(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (this.m_statusPanelScreen.isServiceMode()) {
                this.m_subscriberID.setText(EMPTY);
            } else {
                for (int i = 0; i < 3; ++i) {
                    byArray2[i] = byArray[i];
                }
                Integer n = Convert.toInteger((byte[])byArray2);
                String string = n != 0 ? n.toString() : EMPTY;
                this.m_subscriberID.setText(string);
            }
        }
    }

    private void updateRxQualifiers(int n) {
        String string = RX_QUALIFIERS.get(n);
        if (null != string) {
            this.m_comboRxQualifier.setSelectedItemSilent(string);
        } else {
            LOG.error((Object)"updateRxQualifiers - got unsupported value from device!");
        }
    }

    public Integer getSpeakerVolumeValue() {
        int n = 0;
        int n2 = (Integer)this.m_spinSpeakerVolume.getValue();
        if (n2 <= 20 && n2 >= 0) {
            n = 20 - n2;
        }
        return n;
    }

    private void updateSpeakerLevel(int n) {
        int n2 = 0;
        if (n <= 20 && n >= 0) {
            n2 = 20 - n;
        }
        this.m_labSpinModel.setValue(n2);
    }

    private Integer getChannelPersonality() {
        Integer n = new Integer(-1);
        String string = this.m_txtSetPersonality.getStoredValue();
        try {
            n = Integer.parseInt(this.m_txtSetPersonality.getText());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_txtSetPersonality.setText(string);
            this.m_txtSetPersonality.setCurrentValue(string);
            return null;
        }
    }

    public boolean getIntercomState() {
        return this.m_chkIntercom.isSelected();
    }

    public void setIntercomState(boolean bl) {
        if (this.m_statusPanelScreen.isServiceMode() && this.m_statusPanelScreen.isConvBrApplication()) {
            this.m_chkIntercom.setEnabled(false);
            this.m_chkIntercom.setSelected(false);
        } else {
            this.m_chkIntercom.setEnabled(true);
            this.m_chkIntercom.setSelected(bl);
        }
    }

    static {
        STATIONOPERATIONALMODE.put(new Integer(2), "NORMAL");
        STATIONOPERATIONALMODE.put(new Integer(4), "CONFIGURATION");
        STATIONOPERATIONALMODE.put(new Integer(5), "SERVICE");
        STATIONOPERATIONALMODE.put(new Integer(8), "INITIALIZATION");
        TRANSMITTEROPERATIONALSTATE = new HashMap();
        TRANSMITTEROPERATIONALSTATE.put(new Integer(1), ENABLED);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(2), INHIBIT);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(3), FAILED);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(16), TXT_NOT_APPLICABLE);
        TRANSMITTERACTIVITYSLOT1MSBR = new HashMap();
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(1), VOICE_DIGITAL);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(2), "CONTROL");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(3), "FAILSOFT");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(5), "V.52");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(6), "P25 SYMBOL");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(7), "P25 TEST TONE");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(8), "P25 ASTRO");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(9), "SIMULCAST TEST PATTERN");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(10), "BSI");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(11), "P25 LOW DEVIATION");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(13), DATA);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(14), "F2 1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(15), "P2 1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR = new HashMap();
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(1), VOICE_DIGITAL);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(2), "CONTROL");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(3), "FAILSOFT");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(5), "V.52");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(6), "P25 SYMBOL");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(7), "P25 TEST TONE");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(8), "P25 C4FM MOD FID");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(9), "SIMULCAST TEST PATTERN");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(10), "BSI");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(11), "P25 LOW DEVIATION");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(12), TSBK);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(13), DATA);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(14), "F2 1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(15), "P2 1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(16), TXT_NOT_APPLICABLE);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(17), VOICE_ANALOG);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(18), ANALOG_TEST_PATTERN);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(19), IDLE_PACKET);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(20), IDLE_CARRIER);
        TRANSMITTERACTIVITYSLOT2 = new HashMap();
        TRANSMITTERACTIVITYSLOT2.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT2.put(new Integer(1), VOICE);
        TRANSMITTERACTIVITYSLOT2.put(new Integer(2), "Silence AMBE");
        TRANSMITTERACTIVITYSLOT2.put(new Integer(3), "1031 Hz test tone");
        STATIONUSAGE = new HashMap();
        STATIONUSAGE.put(new Integer(0), "VOICE - FDMA");
        STATIONUSAGE.put(new Integer(1), "CONTROL");
        STATIONUSAGE.put(new Integer(2), "FAILSOFT");
        STATIONUSAGE.put(new Integer(3), "SERVICE");
        STATIONUSAGE.put(new Integer(4), IDLE);
        STATIONUSAGE.put(new Integer(5), DATA);
        STATIONUSAGE.put(new Integer(6), "BSI");
        STATIONUSAGE.put(new Integer(7), "TX TEST");
        STATIONUSAGE.put(new Integer(8), "VOICE - TDMA");
        STATIONUSAGE.put(new Integer(9), "ACTIVE");
        STATIONUSAGE.put(new Integer(10), "LOCAL FAILSOFT");
        RECEIVERACTIVITYSLOT1 = new HashMap();
        RECEIVERACTIVITYSLOT1.put(new Integer(0), IDLE);
        RECEIVERACTIVITYSLOT1.put(new Integer(1), VOICE_DIGITAL);
        RECEIVERACTIVITYSLOT1.put(new Integer(2), "CONTROL");
        RECEIVERACTIVITYSLOT1.put(new Integer(3), "FAILSOFT");
        RECEIVERACTIVITYSLOT1.put(new Integer(4), "INVALID NAC");
        RECEIVERACTIVITYSLOT1.put(new Integer(5), "V_52");
        RECEIVERACTIVITYSLOT1.put(new Integer(6), "RF Channel Interference");
        RECEIVERACTIVITYSLOT1.put(new Integer(7), "P25 TEST TONE");
        RECEIVERACTIVITYSLOT1.put(new Integer(8), "F2 1031 Hz test tone");
        RECEIVERACTIVITYSLOT1.put(new Integer(12), TSBK);
        RECEIVERACTIVITYSLOT1.put(new Integer(14), "1031 Hz test tone");
        RECEIVERACTIVITYSLOT1.put(new Integer(13), DATA);
        RECEIVERACTIVITYSLOT1.put(new Integer(14), "P2 1031 Hz tone");
        RECEIVERACTIVITYSLOT1.put(new Integer(17), VOICE_ANALOG);
        RECEIVERACTIVITYSLOT1.put(new Integer(19), IDLE_PACKET);
        RECEIVERACTIVITYSLOT2 = new HashMap();
        RECEIVERACTIVITYSLOT2.put(new Integer(0), IDLE);
        RECEIVERACTIVITYSLOT2.put(new Integer(1), VOICE);
        RECEIVERACTIVITYSLOT2.put(new Integer(2), "P2 1031 Hz test tone");
        RECEIVEROPERATIONALSTATE = new HashMap();
        RECEIVEROPERATIONALSTATE.put(new Integer(1), ENABLED);
        RECEIVEROPERATIONALSTATE.put(new Integer(2), INHIBIT);
        RECEIVEROPERATIONALSTATE.put(new Integer(3), FAILED);
        REPEATERSTATE = new HashMap();
        REPEATERSTATE.put(new Integer(1), DISABLED);
        REPEATERSTATE.put(new Integer(2), REPEATER_SET_UP);
        REPEATERSTATE.put(new Integer(3), REPEATER_KNOCKDOWN);
        REPEATERSTATE.put(new Integer(4), FALLBACK_REPEAT);
        REPEATERSTATE.put(new Integer(16), TXT_NOT_APPLICABLE);
        REPEATERACTIVITYSTATE = new HashMap();
        REPEATERACTIVITYSTATE.put(new Integer(0), IDLE);
        REPEATERACTIVITYSTATE.put(new Integer(1), VOICE);
        REPEATERACTIVITYSTATE.put(new Integer(12), TSBK);
        REPEATERACTIVITYSTATE.put(new Integer(4), ACTIVE_PRIORITY);
        REPEATERACTIVITYSTATE.put(new Integer(5), LOWER_PRIORITY);
        REPEATERACTIVITYSTATE.put(new Integer(12), TSBK);
        REPEATERACTIVITYSTATE.put(new Integer(13), DATA);
        REPEATERACTIVITYSTATE.put(new Integer(16), TXT_NOT_APPLICABLE);
        PL_DPL_TYPES = new HashMap();
        PL_DPL_TYPES.put(new Integer(0), EMPTY);
        PL_DPL_TYPES.put(new Integer(1), "CSQ");
        PL_DPL_TYPES.put(new Integer(2), "PL");
        PL_DPL_TYPES.put(new Integer(3), "DPL");
        PL_TYPES = new HashMap();
        PL_TYPES.put("67.0", "(XZ)");
        PL_TYPES.put("69.3", "(WZ)");
        PL_TYPES.put("71.9", "(XA)");
        PL_TYPES.put("74.4", "(WA)");
        PL_TYPES.put("77.0", "(XB)");
        PL_TYPES.put("79.7", "(WB)");
        PL_TYPES.put("82.5", "(YZ)");
        PL_TYPES.put("85.4", "(YA)");
        PL_TYPES.put("88.5", "(YB)");
        PL_TYPES.put("91.5", "(ZZ)");
        PL_TYPES.put("94.8", "(ZA)");
        PL_TYPES.put("97.4", "(ZB)");
        PL_TYPES.put("100.0", "(1Z)");
        PL_TYPES.put("103.5", "(1A)");
        PL_TYPES.put("107.2", "(1B)");
        PL_TYPES.put("110.9", "(2Z)");
        PL_TYPES.put("114.8", "(2A)");
        PL_TYPES.put("118.8", "(2B)");
        PL_TYPES.put("123.0", "(3Z)");
        PL_TYPES.put("127.3", "(3A)");
        PL_TYPES.put("131.8", "(3B)");
        PL_TYPES.put("136.5", "(4Z)");
        PL_TYPES.put("141.3", "(4A)");
        PL_TYPES.put("146.2", "(4B)");
        PL_TYPES.put("151.4", "(5Z)");
        PL_TYPES.put("156.7", "(5A)");
        PL_TYPES.put("162.2", "(5B)");
        PL_TYPES.put("167.9", "(6Z)");
        PL_TYPES.put("173.8", "(6A)");
        PL_TYPES.put("179.9", "(6B)");
        PL_TYPES.put("186.2", "(7Z)");
        PL_TYPES.put("192.8", "(7A)");
        PL_TYPES.put("203.5", "(M1)");
        PL_TYPES.put("206.5", "(8Z)");
        PL_TYPES.put("210.7", "(M2)");
        PL_TYPES.put("218.1", "(M3)");
        PL_TYPES.put("225.7", "(M4)");
        PL_TYPES.put("229.1", "(9Z)");
        PL_TYPES.put("233.6", "(M5)");
        PL_TYPES.put("241.8", "(M6)");
        PL_TYPES.put("250.3", "(M7)");
        m_nTdmaMode = 1;
        SCAN_STATES = new HashMap();
        TRANSMIT_SOURCE = new HashMap();
        MAIN_STANDBY = new HashMap();
        OVERVOLTAGE_ALARM = new HashMap();
        STATION_ALARM = new HashMap();
        ANALOG_INFRASTRUCTURE_STATE = new HashMap();
        RXPL_STATE = new HashMap();
        RXPL_STATE.put(0, "TURN OFF RX QUALIFIERS");
        RXPL_STATE.put(1, "TURN ON RX QUALIFIERS");
        TXPL_STATE = new HashMap();
        TXPL_STATE.put(0, "OFF");
        TXPL_STATE.put(1, "ON");
        SELECTIVE_ALARM = new HashMap();
        SELECTIVE_ALARM.put(0, "OFF");
        SELECTIVE_ALARM.put(1, "ON");
        RX_QUALIFIERS = new HashMap();
        RX_QUALIFIERS.put(0, "CSQ");
        RX_QUALIFIERS.put(1, "Rx Qualifiers");
        RX_QUALIFIERS.put(2, "Open Rx");
        m_nEnabledPersonality = -1;
    }

    private static class InsetsFormatCellRenderer
    extends JTextField
    implements TableCellRenderer {
        private static final CssLogger LOG = CssLogger.getCssLogger(InsetsFormatCellRenderer.class);
        private static final long serialVersionUID = 1L;

        private InsetsFormatCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            LOG.enter("getTableCellRendererComponent", new Object[]{jTable, object, Boolean.toString(bl), Boolean.toString(bl2), Integer.toString(n), Integer.toString(n2)});
            this.setText(" " + object + " ");
            this.setBorder(BorderFactory.createEmptyBorder());
            LOG.exit("getTableCellRendererComponent");
            return this;
        }
    }

    public class SetRxQualifier_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            switch (BrStationStatusPanel.this.m_comboRxQualifier.getSelectedIndex()) {
                case 0: {
                    message.setProtocolKey(5218);
                    break;
                }
                case 1: {
                    message.setProtocolKey(5219);
                    break;
                }
                case 2: {
                    message.setProtocolKey(5220);
                    break;
                }
            }
            LOG.exit("getMessage");
            return message;
        }
    }

    public class SetIntercomState_Rule
    extends Rule {
        private final String sSetIntercomState = "sSetIntercomState";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sSetIntercomState", Byte.class, (Object)(BrStationStatusPanel.this.getIntercomState() ? 1 : 0));
            message.setProtocolKey(5216);
            LOG.exit("getMessage");
            return message;
        }
    }

    public class SetSpeakerLevel_Rule
    extends Rule {
        private final String sSetSpeakerVolume = "sSetSpeakerLevelRtl";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sSetSpeakerLevelRtl", Byte.class, (Object)BrStationStatusPanel.this.getSpeakerVolumeValue());
            message.setProtocolKey(5212);
            LOG.exit("getMessage");
            return message;
        }
    }

    public class SetPersonality_Rule
    extends Rule {
        private final String sSetChannelPersonality = "sSetChannelPersonality";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            Integer n = m_nEnabledPersonality;
            synchronized (n) {
                if (-1 != m_nEnabledPersonality) {
                    message = new Message();
                    message.addParameter("sSetChannelPersonality", Byte.class, (Object)m_nEnabledPersonality.byteValue());
                    message.setProtocolKey(5403);
                } else {
                    LOG.error((Object)"getMessage - invalid channel personality number");
                    WarningPopup warningPopup = new WarningPopup();
                    warningPopup.display("This channel number is not enabled.");
                }
            }
            LOG.exit("getMessage: ", (Object)message);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error setting Channel Personality");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetEnabledPersonality_Rule
    extends Rule {
        String sRequestedPersonality = null;
        private static final String STR_OID_NAME_PREFIX = "sPersonalityEnabled_";
        private Integer nRequestedPersonality;

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            this.nRequestedPersonality = BrStationStatusPanel.this.getChannelPersonality();
            if (null != this.nRequestedPersonality) {
                if (this.nRequestedPersonality < 1 || this.nRequestedPersonality > 16) {
                    String string = BrStationStatusPanel.this.m_txtSetPersonality.getStoredValue();
                    WarningPopup warningPopup = new WarningPopup();
                    warningPopup.display(BrStationStatusPanel.ERROR_CHANNEL_PERSONALITY);
                    BrStationStatusPanel.this.m_txtSetPersonality.setText(string);
                    BrStationStatusPanel.this.m_txtSetPersonality.setCurrentValue(string);
                } else {
                    this.sRequestedPersonality = new String(STR_OID_NAME_PREFIX + this.nRequestedPersonality);
                    message = new Message();
                    message.addParameter(this.sRequestedPersonality, Integer.class);
                    message.setProtocolKey(1004);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            Integer n2 = m_nEnabledPersonality;
            synchronized (n2) {
                if (0 == n) {
                    Integer n3 = (Integer)messageIfc.getParameterValue(this.sRequestedPersonality);
                    m_nEnabledPersonality = n3.equals(1) ? this.nRequestedPersonality : -1;
                    String string = BrStationStatusPanel.this.m_txtSetPersonality.getCurrentValue();
                    BrStationStatusPanel.this.m_txtSetPersonality.setText(string);
                    BrStationStatusPanel.this.m_txtSetPersonality.setStoredValue(string);
                    BrStationStatusPanel.this.getSetChannelTimerListener().notifyGuiListener();
                } else {
                    WarningPopup warningPopup = new WarningPopup();
                    warningPopup.display("Error while setting channel - cannot retrieve channel information from device.");
                }
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }

    public class GetPersonality_Rule
    extends Rule {
        private final String sGetChannelPersonality = "sGetChannelPersonality";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            message = new Message();
            message.setProtocolKey(5402);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            Byte by;
            LOG.enter("update");
            if (n != 0) {
                LOG.error((Object)"update - GetPersonalityRule failed");
            } else if (null != messageIfc && null != (by = (Byte)messageIfc.getParameterValue("sGetChannelPersonality"))) {
                BrStationStatusPanel.this.updateChannelPersonality(by.intValue());
            }
            LOG.exit("update");
            return true;
        }
    }
}

