/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.testandmeasurement;

import css.core.screens.tools.StatusBarListener;
import css.core.service.ConversionFailureException;
import css.core.service.Convert;
import css.core.service.ConvertTypes;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.CSSJComboBox;
import css.core.util.component.GenericListener;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pnm.ui.UIInternalFrame;

public class BrFanHoldoverPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes,
DeviceConstants {
    private static final long serialVersionUID = 1L;
    public GenericListener m_oGenericListener = new GenericListener();
    public JLabel m_fanHoldoverValueLbl;
    public CSSJComboBox m_selectedFanHoldoverRequested;
    private static final String LONG_TEXT = "Long";
    private static final String SHORT_TEXT = "Short";
    private GenericScreen m_testMeasurement;
    String[] m_sFanHoldoverRequested = new String[]{"Long", "Short"};
    private static final CssLogger LOG = CssLogger.getCssLogger(BrFanHoldoverPanel.class);
    public static final String FAN_HOLDOVER_GET_ERROR = "Unable to get Fan Holdover value from the device.";
    public static final String FAN_HOLDOVER_SET_ERROR = "Unable to set Fan Holdover value.";
    public static final short LONG = 300;
    public static final short SHORT = 45;

    public BrFanHoldoverPanel(GenericScreen genericScreen) {
        this.m_testMeasurement = genericScreen;
    }

    public int buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Actual");
        GridBagAdder.add((Container)jPanel, (Component)jLabel, (int)1, (int)0, (double)50.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)30, (int)1, (int)30, (int)0);
        GridBagAdder.add((Container)jPanel, (Component)new JLabel("Requested"), (int)2, (int)0, (double)50.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)30, (int)1, (int)30, (int)0);
        this.m_fanHoldoverValueLbl = new JLabel("N/A");
        GridBagAdder.add((Container)jPanel, (Component)this.m_fanHoldoverValueLbl, (int)1, (int)1, (double)10.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)30, (int)1, (int)10, (int)0);
        JLabel jLabel2 = new JLabel("Fan Holdover Time (FHT)");
        GridBagAdder.add((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (double)50.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)30, (int)1, (int)3, (int)0);
        String string = "<html>This setting controls the duration that the station fan continues to operate after the completion of a call.<br>The \"Long\" setting is optimized to maximize fan reliability and is the prefferred setting when operating from conventional energy sources.<br>The \"Short\" setting is optimized to minimize energy consumption when operating from alternative energy sources.</html>";
        jLabel.setToolTipText(string);
        jLabel2.setToolTipText(string);
        this.m_fanHoldoverValueLbl.setToolTipText(string);
        this.m_selectedFanHoldoverRequested = new CSSJComboBox();
        for (int i = 0; i < this.m_sFanHoldoverRequested.length; ++i) {
            this.m_selectedFanHoldoverRequested.addItem((Object)this.m_sFanHoldoverRequested[i]);
        }
        this.m_selectedFanHoldoverRequested.setEnabled(true);
        GridBagAdder.add((Container)jPanel, (Component)this.m_selectedFanHoldoverRequested, (int)2, (int)1, (double)70.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)30, (int)1, (int)10, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)3, (int)1, (int)10, (int)0);
        statusBarListener.registerComponent((Component)this.m_selectedFanHoldoverRequested, "Choose Fan Holdover Requested value.");
        LOG.exit("buildScreen");
        return 1;
    }

    public void initialize() {
        LOG.enter("initialize");
        LOG.exit("initialize");
    }

    public void updateFanHoldover(FspRealTimeDataObject fspRealTimeDataObject) {
        LOG.enter("updateFanHoldover", new Object[]{fspRealTimeDataObject});
        try {
            int n = Convert.toInteger((byte[])((byte[])fspRealTimeDataObject.getValue("sGetFanHoldover")));
            this.displayFanHoldover(n);
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateFanHoldover", (Throwable)notFoundException);
        }
        LOG.exit("updateFanHoldover");
    }

    public void setFanHoldover(String string) {
        this.m_fanHoldoverValueLbl.setText(string);
    }

    private void displayFanHoldover(int n) {
        if (n == 45) {
            this.setFanHoldover(SHORT_TEXT);
            this.m_selectedFanHoldoverRequested.setSelectedItem((Object)SHORT_TEXT);
        } else if (n == 300) {
            this.setFanHoldover(LONG_TEXT);
            this.m_selectedFanHoldoverRequested.setSelectedItem((Object)LONG_TEXT);
        } else {
            LOG.error((Object)("displayFanHoldover - Fan Holdover value other than Short/Long: " + n));
        }
    }

    public class SetFanHoldover
    extends Rule {
        private final String sSetFanHoldover = "sSetFanHoldover";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            String string = BrFanHoldoverPanel.this.m_selectedFanHoldoverRequested.getSelectedItem().toString();
            short s = 300;
            if (string.equals(BrFanHoldoverPanel.SHORT_TEXT)) {
                s = 45;
            }
            message.addParameter("sSetFanHoldover", Short.TYPE, (Object)s);
            message.setProtocolKey(5434);
            LOG.exit("getMessage: ", (Object)message);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                BrFanHoldoverPanel.this.m_testMeasurement.popupError(BrFanHoldoverPanel.FAN_HOLDOVER_SET_ERROR);
                LOG.error((Object)"update - error setting Fan Holdover");
            } else {
                String string = BrFanHoldoverPanel.this.m_selectedFanHoldoverRequested.getSelectedItem().toString();
                BrFanHoldoverPanel.this.setFanHoldover(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetFanHoldover
    extends Rule {
        private final String sGetFanHoldover = "sGetFanHoldover";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sGetFanHoldover", byte[].class);
            message.setProtocolKey(5433);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            block7: {
                LOG.enter("update");
                if (n != 0) {
                    LOG.warn((Object)"update - error getting Fan Holdover");
                    BrFanHoldoverPanel.this.m_testMeasurement.popupError(BrFanHoldoverPanel.FAN_HOLDOVER_GET_ERROR);
                } else if (null != messageIfc) {
                    byte[] byArray = (byte[])messageIfc.getParameterValue("sGetFanHoldover");
                    try {
                        int n2 = ConvertTypes.toInteger((Object)byArray);
                        if (n2 == 45 || n2 == 300) {
                            BrFanHoldoverPanel.this.displayFanHoldover(n2);
                            break block7;
                        }
                        String string = "Fan Holdover value " + n2 + " cannot be mapped into Short nor Long.\n" + "Reverting this value to " + 300 + " (" + BrFanHoldoverPanel.LONG_TEXT + ").";
                        LOG.warn((Object)("update - " + string));
                        BrFanHoldoverPanel.this.m_testMeasurement.popupInfo(string);
                        BrFanHoldoverPanel.this.m_selectedFanHoldoverRequested.setSelectedItem((Object)BrFanHoldoverPanel.LONG_TEXT);
                        SetFanHoldover setFanHoldover = new SetFanHoldover();
                        setFanHoldover.process(sessionIfc);
                    }
                    catch (ConversionFailureException conversionFailureException) {
                        LOG.error((Object)"update - invalid Fan Holdover value, conversion exception");
                        BrFanHoldoverPanel.this.m_testMeasurement.popupError(BrFanHoldoverPanel.FAN_HOLDOVER_GET_ERROR);
                    }
                } else {
                    LOG.error((Object)"update - null message from FSP packet");
                }
            }
            LOG.exit("update");
            return true;
        }
    }
}

