/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit;

import css.core.service.DataObject;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.core.util.popup.PopupProperties;
import css.device.common.service.ServiceMaker;
import css.device.common.util.DeviceConstants;
import css.device.platform.common.tables.BrCommonOidTable;
import css.device.platform.summit.tables.SummitOidTable;
import pnm.util.EngineUtilities;

public class SummitServiceMaker
extends ServiceMaker
implements CssErrorCodes,
CssConstants,
SummitOidTable,
DeviceConstants,
BrCommonOidTable {
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitServiceMaker.class);

    public SummitServiceMaker() {
        LOG.enter("SummitServiceMaker");
        LOG.exit("SummitServiceMaker");
    }

    @Override
    public int initiateService() {
        LOG.enter("initiateService");
        DataObject dataObject = null;
        dataObject = CSSUtilities.addOID((Object[][])BRCOMMON_OID_TABLE, (String)"Common Service Initialization");
        if (dataObject.getError() != 0) {
            LOG.error((Object)"initiateService - Trouble adding the common BR OIDs to SNMP Interface");
        }
        int n = 0;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (!string.equals("UNKNOWN")) {
            if (string.indexOf("STR 3000 Simulcast Radio") >= 0) {
                m_deviceType = "STR 3000 Simulcast Radio";
            } else if (string.indexOf("ISR") >= 0) {
                m_deviceType = "ISR";
            } else if (string.indexOf("HPDBR") >= 0) {
                m_deviceType = "HPDBR";
            } else if (string.indexOf("CONVBR") >= 0) {
                m_deviceType = "CONVBR";
            } else {
                n = -1;
            }
        } else {
            n = -1;
        }
        if (n == 0) {
            DataObject dataObject2 = null;
            dataObject2 = CSSUtilities.addOID((Object[][])SUMMIT_OID_TABLE, (String)"Summit Service Initialization");
            n = dataObject2.getError();
            if (n == 0) {
                n = PopupProperties.addMessages((String)BR_SERVICE_ERROR_MESSAGES_FILE);
            } else {
                LOG.error((Object)"initiateService - Unable to add error messages.");
            }
        }
        LOG.exit("initiateService", (Object)n);
        return n;
    }

    @Override
    public void handleMenuItemDependencies(String string) {
        LOG.enter("handleMenuItemDependencies", new Object[]{string});
        if (string.equalsIgnoreCase("Alignment Screens")) {
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Test_And_Measurement_Screen");
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Metering_Screen");
        } else if (string.equalsIgnoreCase("Metering Screen")) {
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Alignment_Screen");
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Test_And_Measurement_Screen");
        } else if (string.equalsIgnoreCase("Test And Measurement Screen")) {
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Alignment_Screen");
            EngineUtilities.getMainApplicationWindow().enableMenuItem("Metering_Screen");
        }
        LOG.exit("handleMenuItemDependencies");
    }
}

